/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.expr.functions.dataiku;

import com.dataiku.dip.utils.ExceptionUtils;
import com.google.refine.expr.EvalError;
import com.google.refine.expr.ExpressionUtils;
import com.google.refine.expr.functions.dataiku.DKUFormulaUtils;
import com.google.refine.grel.Documentation;
import com.google.refine.grel.Example;
import com.google.refine.grel.Function;
import com.google.refine.grel.GrelControlFunctionRegistry;
import java.math.BigDecimal;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.json.JSONException;

public class ArrayIndexOf
implements Function {
    private static final Logger logger = Logger.getLogger((String)"dku.formula.arrayIndexOf");

    private boolean compare(List<?> arr, Object val, int index) throws Exception {
        try {
            Object item;
            Object arrValue = arr.get(index);
            if (val instanceof Boolean) {
                item = arrValue;
            } else {
                if (val instanceof Number) {
                    BigDecimal arrayValBigDecimal;
                    BigDecimal valBigDecimal = new BigDecimal(((Number)val).doubleValue());
                    return valBigDecimal.compareTo(arrayValBigDecimal = new BigDecimal(((Number)arrValue).doubleValue())) == 0;
                }
                if (val instanceof String) {
                    item = arrValue == null ? null : arrValue.toString();
                } else {
                    throw new Exception("type not found(" + String.valueOf(val.getClass()) + ")");
                }
            }
            return val.equals(item);
        }
        catch (JSONException e) {
            return false;
        }
    }

    @Override
    public Object call(Properties bindings, Object[] args) {
        if (args.length < 2 || args[0] == null || args[1] == null) {
            return new EvalError(GrelControlFunctionRegistry.getInstance().getFunctionName(this) + " expects two arguments");
        }
        Object v = args[0];
        if (ExpressionUtils.isError(v)) {
            return v;
        }
        List<?> inputArray = DKUFormulaUtils.asList(v);
        int index = -1;
        try {
            for (int i = 0; i < inputArray.size(); ++i) {
                if (!this.compare(inputArray, args[1], i)) continue;
                index = i;
                break;
            }
        }
        catch (Exception e) {
            logger.warn((Object)("arrayIndexOf fail:" + ExceptionUtils.getMessageWithCauses((Throwable)e)));
            return new EvalError(GrelControlFunctionRegistry.getInstance().getFunctionName(this) + " failed: " + ExceptionUtils.getMessageWithCauses((Throwable)e));
        }
        return index;
    }

    @Override
    public Documentation getDocumentation() {
        return new Documentation("GREL.FUNCTION.ArrayIndexOf.DOCUMENTATION", "Returns the index (starting from 0) of <code>item</code> in <code>a</code>, or -1 if the item is not found in the array.").withParams("array a", "item").withReturns("int").withCategory("GREL.FUNCTIONS.CATEGORY.ARRAY", "Array functions").withExample(Example.with("[1,0]", "2").returns("-1"));
    }
}

