/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.grel.ast;

import com.google.refine.expr.ArgsEvaluable;
import com.google.refine.expr.EvalError;
import com.google.refine.expr.Evaluable;
import com.google.refine.expr.ExpressionUtils;
import com.google.refine.expr.functions.aggregations.AggregationInvalidStateException;
import com.google.refine.grel.Function;
import com.google.refine.udaf.UdafUtils;
import java.util.Properties;

public class FunctionCallExpr
extends ArgsEvaluable {
    public final Function _function;
    public UdafUtils.GetValueForRow getValueForRow;

    public FunctionCallExpr(Evaluable[] args, Function f) {
        this._args = args;
        this._function = f;
    }

    @Override
    public Object evaluate(Properties bindings) {
        if (bindings != null && bindings.containsKey("UDAF_BINDING_KEY") && UdafUtils.isUdafAggregation(this) && this.getValueForRow != null) {
            int index = (Integer)bindings.get("UDAF_BINDING_KEY");
            return this.getValueForRow.apply(index);
        }
        Object[] args = new Object[this._args.length];
        for (int i = 0; i < this._args.length; ++i) {
            Object v = this._args[i].evaluate(bindings);
            if (ExpressionUtils.isError(v)) {
                return v;
            }
            args[i] = v;
        }
        try {
            return this._function.call(bindings, args);
        }
        catch (AggregationInvalidStateException e) {
            throw e;
        }
        catch (Exception e) {
            return new EvalError(e.toString());
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Evaluable ev : this._args) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(ev.toString());
        }
        return this._function.getClass().getSimpleName() + "(" + sb.toString() + ")";
    }
}

