/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.identity.spi;

import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import software.amazon.awssdk.utils.Pair;
import software.amazon.awssdk.utils.ToString;

public final class IdentityProperty<T> {
    private static final ConcurrentMap<Pair<String, String>, IdentityProperty<?>> NAME_HISTORY = new ConcurrentHashMap();
    private final String namespace;
    private final String name;

    private IdentityProperty(String namespace, String name) {
        this.namespace = namespace;
        this.name = name;
        this.ensureUnique();
    }

    public static <T> IdentityProperty<T> create(Class<?> namespace, String name) {
        return new IdentityProperty<T>(namespace.getName(), name);
    }

    private void ensureUnique() {
    }

    public String toString() {
        return ToString.builder("IdentityProperty").add("namespace", this.namespace).add("name", this.name).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IdentityProperty that = (IdentityProperty)o;
        return Objects.equals(this.namespace, that.namespace) && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.namespace);
        hashCode = 31 * hashCode + Objects.hashCode(this.name);
        return hashCode;
    }
}

