/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.hbc.core.processor;

import com.twitter.hbc.core.processor.HosebirdMessageProcessor;
import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public abstract class AbstractProcessor<T>
implements HosebirdMessageProcessor {
    public static final long DEFAULT_OFFER_TIMEOUT_MILLIS = 500L;
    protected final BlockingQueue<T> queue;
    protected final long offerTimeoutMillis;

    public AbstractProcessor(BlockingQueue<T> queue) {
        this(queue, 500L);
    }

    public AbstractProcessor(BlockingQueue<T> queue, long offerTimeoutMillis) {
        this.queue = queue;
        this.offerTimeoutMillis = offerTimeoutMillis;
    }

    @Override
    public boolean process() throws IOException, InterruptedException {
        T msg = this.processNextMessage();
        while (msg == null) {
            msg = this.processNextMessage();
        }
        return this.queue.offer(msg, this.offerTimeoutMillis, TimeUnit.MILLISECONDS);
    }

    @Nullable
    protected abstract T processNextMessage() throws IOException;
}

