/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.graph;

import java.awt.BasicStroke;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.time.Instant;
import java.time.temporal.TemporalAmount;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import javax.imageio.ImageIO;
import org.rrd4j.ConsolFun;
import org.rrd4j.core.DataHolder;
import org.rrd4j.core.FetchData;
import org.rrd4j.core.RrdBackendFactory;
import org.rrd4j.core.RrdDbPool;
import org.rrd4j.core.Util;
import org.rrd4j.data.IPlottable;
import org.rrd4j.data.Variable;
import org.rrd4j.graph.Area;
import org.rrd4j.graph.CDef;
import org.rrd4j.graph.CommentText;
import org.rrd4j.graph.ConstantArea;
import org.rrd4j.graph.ConstantLine;
import org.rrd4j.graph.Def;
import org.rrd4j.graph.DownSampler;
import org.rrd4j.graph.ElementsNames;
import org.rrd4j.graph.HRule;
import org.rrd4j.graph.HSpan;
import org.rrd4j.graph.LegendText;
import org.rrd4j.graph.Line;
import org.rrd4j.graph.PDef;
import org.rrd4j.graph.PlotElement;
import org.rrd4j.graph.PrintText;
import org.rrd4j.graph.RrdGraphConstants;
import org.rrd4j.graph.SimpleTimeLabelFormat;
import org.rrd4j.graph.Source;
import org.rrd4j.graph.SourcedPlotElement;
import org.rrd4j.graph.Stack;
import org.rrd4j.graph.TDef;
import org.rrd4j.graph.TimeAxisSetting;
import org.rrd4j.graph.TimeLabelFormat;
import org.rrd4j.graph.VDef;
import org.rrd4j.graph.VRule;
import org.rrd4j.graph.VSpan;
import org.rrd4j.graph.ValueAxisSetting;

public class RrdGraphDef
implements RrdGraphConstants,
DataHolder {
    boolean poolUsed = false;
    private RrdDbPool pool = null;
    boolean antiAliasing = false;
    boolean textAntiAliasing = false;
    String filename = "-";
    long startTime;
    long endTime;
    TimeAxisSetting timeAxisSetting = null;
    TimeLabelFormat timeLabelFormat = null;
    ValueAxisSetting valueAxisSetting = null;
    boolean altYGrid = false;
    boolean noMinorGrid = false;
    boolean altYMrtg = false;
    boolean altAutoscale = false;
    boolean altAutoscaleMin = false;
    boolean altAutoscaleMax = false;
    int unitsExponent = Integer.MAX_VALUE;
    int unitsLength = 9;
    String verticalLabel = null;
    int width = 400;
    int height = 100;
    boolean interlaced = false;
    String imageInfo = null;
    String imageFormat = "gif";
    float imageQuality = 0.8f;
    ImageSource backgroundImage = null;
    ImageSource canvasImage = null;
    ImageSource overlayImage = null;
    String unit = null;
    boolean lazy = false;
    double minValue = Double.NaN;
    double maxValue = Double.NaN;
    boolean rigid = false;
    double base = 1000.0;
    boolean logarithmic = false;
    private final Paint[] colors = new Paint[]{DEFAULT_CANVAS_COLOR, DEFAULT_BACK_COLOR, DEFAULT_SHADEA_COLOR, DEFAULT_SHADEB_COLOR, DEFAULT_GRID_COLOR, DEFAULT_MGRID_COLOR, DEFAULT_FONT_COLOR, DEFAULT_FRAME_COLOR, DEFAULT_ARROW_COLOR, DEFAULT_XAXIS_COLOR, DEFAULT_YAXIS_COLOR};
    boolean noLegend = false;
    boolean onlyGraph = false;
    boolean forceRulesLegend = false;
    String title = null;
    long step = 0L;
    Font[] fonts = new Font[]{DEFAULT_SMALL_FONT, DEFAULT_LARGE_FONT, DEFAULT_SMALL_FONT, DEFAULT_SMALL_FONT, DEFAULT_SMALL_FONT, GATOR_FONT};
    boolean drawXGrid = true;
    boolean drawYGrid = true;
    int firstDayOfWeek = FIRST_DAY_OF_WEEK;
    Locale locale = Locale.getDefault();
    TimeZone tz = TimeZone.getDefault();
    String signature = "Generated by RRD4J";
    boolean showSignature = true;
    Stroke gridStroke = GRID_STROKE;
    Stroke tickStroke = TICK_STROKE;
    DownSampler downsampler = null;
    final List<Source> sources = new ArrayList<Source>();
    final List<CommentText> comments = new ArrayList<CommentText>();
    final List<PlotElement> plotElements = new ArrayList<PlotElement>();

    @Deprecated
    public RrdGraphDef() {
        this.setTimeSpan(Util.getTimestamps("end-1d", "now"));
    }

    public RrdGraphDef(long t1, long t2) {
        if (!(t1 < t2 && t1 > 0L && t2 > 0L || t1 > 0L && t2 == 0L)) {
            throw new IllegalArgumentException("Invalid timestamps specified: " + t1 + ", " + t2);
        }
        this.startTime = t1;
        this.endTime = t2;
    }

    public RrdGraphDef(TemporalAmount d) {
        Instant now = Instant.now();
        this.endTime = now.getEpochSecond();
        this.startTime = now.minus(d).getEpochSecond();
    }

    @Override
    public void setStartTime(long time) {
        this.startTime = time;
        if (time <= 0L) {
            this.startTime += Util.getTime();
        }
    }

    @Override
    public void setEndTime(long time) {
        this.endTime = time;
        if (time <= 0L) {
            this.endTime += Util.getTime();
        }
    }

    @Override
    public void setTimeSpan(long startTime, long endTime) {
        this.setStartTime(startTime);
        this.setEndTime(endTime);
    }

    public void setTimeSpan(long[] timestamps) {
        this.setTimeSpan(timestamps[0], timestamps[timestamps.length - 1]);
    }

    @Override
    public void setPoolUsed(boolean poolUsed) {
        this.poolUsed = poolUsed;
    }

    @Override
    public boolean isPoolUsed() {
        return this.poolUsed;
    }

    @Override
    public RrdDbPool getPool() {
        return this.pool;
    }

    @Override
    public void setPool(RrdDbPool pool) {
        this.poolUsed = true;
        this.pool = pool;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public void setTimeAxis(int minorUnit, int minorUnitCount, int majorUnit, int majorUnitCount, int labelUnit, int labelUnitCount, int labelSpan, String simpleDateFormat) {
        this.timeAxisSetting = new TimeAxisSetting(minorUnit, minorUnitCount, majorUnit, majorUnitCount, labelUnit, labelUnitCount, labelSpan, new SimpleTimeLabelFormat(simpleDateFormat));
    }

    public void setTimeAxis(int minorUnit, int minorUnitCount, int majorUnit, int majorUnitCount, int labelUnit, int labelUnitCount, int labelSpan, TimeLabelFormat format) {
        this.timeAxisSetting = new TimeAxisSetting(minorUnit, minorUnitCount, majorUnit, majorUnitCount, labelUnit, labelUnitCount, labelSpan, format);
    }

    public void setTimeLabelFormat(TimeLabelFormat format) {
        this.timeLabelFormat = format;
    }

    public void setValueAxis(double gridStep, int labelFactor) {
        this.valueAxisSetting = new ValueAxisSetting(gridStep, labelFactor);
    }

    public void setAltYGrid(boolean altYGrid) {
        this.altYGrid = altYGrid;
    }

    public void setNoMinorGrid(boolean noMinorGrid) {
        this.noMinorGrid = noMinorGrid;
    }

    public void setAltYMrtg(boolean altYMrtg) {
        this.altYMrtg = altYMrtg;
    }

    public void setAltAutoscale(boolean altAutoscale) {
        this.altAutoscale = altAutoscale;
    }

    public void setAltAutoscaleMin(boolean altAutoscaleMin) {
        this.altAutoscaleMin = altAutoscaleMin;
    }

    public void setAltAutoscaleMax(boolean altAutoscaleMax) {
        this.altAutoscaleMax = altAutoscaleMax;
    }

    public void setUnitsExponent(int unitsExponent) {
        this.unitsExponent = unitsExponent;
    }

    public void setUnitsLength(int unitsLength) {
        this.unitsLength = unitsLength;
    }

    public void setVerticalLabel(String verticalLabel) {
        this.verticalLabel = verticalLabel;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setInterlaced(boolean interlaced) {
        this.interlaced = interlaced;
    }

    public void setImageInfo(String imageInfo) {
        this.imageInfo = imageInfo;
    }

    public void setImageFormat(String imageFormat) {
        this.imageFormat = imageFormat;
    }

    public void setBackgroundImage(String backgroundImage) {
        this.backgroundImage = new FileImageSource(backgroundImage);
    }

    public void setBackgroundImage(URL backgroundImageUrl) {
        this.backgroundImage = new UrlImageSource(backgroundImageUrl);
    }

    public void setBackgroundImage(ImageSource backgroundImage) {
        this.backgroundImage = backgroundImage;
    }

    public void setCanvasImage(String canvasImage) {
        this.canvasImage = new FileImageSource(canvasImage);
    }

    public void setCanvasImage(URL canvasUrl) {
        this.canvasImage = new UrlImageSource(canvasUrl);
    }

    public void setCanvasImage(ImageSource canvasImageSource) {
        this.canvasImage = canvasImageSource;
    }

    public void setOverlayImage(String overlayImage) {
        this.overlayImage = new FileImageSource(overlayImage);
    }

    public void setOverlayImage(URL overlayImage) {
        this.overlayImage = new UrlImageSource(overlayImage);
    }

    public void setOverlayImage(ImageSource overlayImageSource) {
        this.overlayImage = overlayImageSource;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public void setLazy(boolean lazy) {
        this.lazy = lazy;
    }

    public void setMinValue(double minValue) {
        this.minValue = minValue;
    }

    public void setMaxValue(double maxValue) {
        this.maxValue = maxValue;
    }

    public void setRigid(boolean rigid) {
        this.rigid = rigid;
    }

    public void setBase(double base) {
        this.base = base;
    }

    public void setLogarithmic(boolean logarithmic) {
        this.logarithmic = logarithmic;
    }

    @Deprecated
    public void setColor(int colorTag, Paint color) {
        if (colorTag < 0 || colorTag >= this.colors.length) {
            throw new IllegalArgumentException("Invalid color index specified: " + colorTag);
        }
        this.colors[colorTag] = color;
    }

    public void setColor(ElementsNames colorTag, Paint color) {
        this.colors[colorTag.ordinal()] = color;
    }

    @Deprecated
    public void setColor(String colorName, Paint color) {
        this.setColor(ElementsNames.valueOf(colorName.toLowerCase(Locale.ENGLISH)).ordinal(), color);
    }

    public void setNoLegend(boolean noLegend) {
        this.noLegend = noLegend;
    }

    public void setOnlyGraph(boolean onlyGraph) {
        this.onlyGraph = onlyGraph;
    }

    public void setForceRulesLegend(boolean forceRulesLegend) {
        this.forceRulesLegend = forceRulesLegend;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public void setStep(long step) {
        this.step = step;
    }

    public void setFontSet(boolean rrdtool) {
        if (rrdtool) {
            float rrdtoolfactor = 1.3333334f;
            this.fonts = new Font[]{DEFAULT_SMALL_FONT.deriveFont(8.0f * rrdtoolfactor), DEFAULT_SMALL_FONT.deriveFont(9.0f * rrdtoolfactor), DEFAULT_SMALL_FONT.deriveFont(7.0f * rrdtoolfactor), DEFAULT_SMALL_FONT.deriveFont(8.0f * rrdtoolfactor), DEFAULT_SMALL_FONT.deriveFont(8.0f * rrdtoolfactor), DEFAULT_SMALL_FONT.deriveFont(5.5f * rrdtoolfactor)};
        } else {
            this.fonts = new Font[]{DEFAULT_SMALL_FONT, DEFAULT_LARGE_FONT, DEFAULT_SMALL_FONT, DEFAULT_SMALL_FONT, DEFAULT_SMALL_FONT, GATOR_FONT};
        }
    }

    @Deprecated
    public void setSmallFont(Font smallFont) {
        this.setFont(RrdGraphConstants.FontTag.DEFAULT, smallFont);
    }

    @Deprecated
    public void setLargeFont(Font largeFont) {
        this.setFont(RrdGraphConstants.FontTag.TITLE, largeFont);
    }

    public void setFont(RrdGraphConstants.FontTag fontTag, Font font) {
        this.setFont(fontTag, font, false);
    }

    public void setFont(RrdGraphConstants.FontTag fontTag, Font font, boolean setAll) {
        this.setFont(fontTag, font, setAll, false);
    }

    public void setFont(RrdGraphConstants.FontTag fontTag, Font font, boolean setAll, boolean keepSizes) {
        if (fontTag == RrdGraphConstants.FontTag.DEFAULT && setAll) {
            if (keepSizes) {
                this.fonts[RrdGraphDef.FONTTAG_DEFAULT.ordinal()] = font.deriveFont(this.fonts[FONTTAG_DEFAULT.ordinal()].getSize());
                this.fonts[RrdGraphDef.FONTTAG_TITLE.ordinal()] = font.deriveFont(this.fonts[FONTTAG_TITLE.ordinal()].getSize());
                this.fonts[RrdGraphDef.FONTTAG_AXIS.ordinal()] = font.deriveFont(this.fonts[FONTTAG_AXIS.ordinal()].getSize());
                this.fonts[RrdGraphDef.FONTTAG_UNIT.ordinal()] = font.deriveFont(this.fonts[FONTTAG_UNIT.ordinal()].getSize());
                this.fonts[RrdGraphDef.FONTTAG_LEGEND.ordinal()] = font.deriveFont(this.fonts[FONTTAG_LEGEND.ordinal()].getSize());
                this.fonts[RrdGraphDef.FONTTAG_WATERMARK.ordinal()] = font.deriveFont(this.fonts[FONTTAG_WATERMARK.ordinal()].getSize());
            } else {
                this.fonts[RrdGraphDef.FONTTAG_DEFAULT.ordinal()] = font;
                this.fonts[RrdGraphDef.FONTTAG_TITLE.ordinal()] = null;
                this.fonts[RrdGraphDef.FONTTAG_AXIS.ordinal()] = null;
                this.fonts[RrdGraphDef.FONTTAG_UNIT.ordinal()] = null;
                this.fonts[RrdGraphDef.FONTTAG_LEGEND.ordinal()] = null;
                this.fonts[RrdGraphDef.FONTTAG_WATERMARK.ordinal()] = null;
            }
        } else {
            this.fonts[fontTag.ordinal()] = font;
        }
    }

    public void setFont(String fontTag, Font font) {
        this.setFont(RrdGraphConstants.FontTag.valueOf(fontTag), font);
    }

    public void setFont(String fontTag, Font font, boolean setAll) {
        this.setFont(RrdGraphConstants.FontTag.valueOf(fontTag), font, setAll);
    }

    public void setFont(String fontTag, Font font, boolean setAll, boolean keepSizes) {
        this.setFont(RrdGraphConstants.FontTag.valueOf(fontTag), font, setAll, keepSizes);
    }

    public Font getFont(RrdGraphConstants.FontTag tag) {
        return this.fonts[tag.ordinal()] == null ? this.fonts[FONTTAG_DEFAULT.ordinal()] : this.fonts[tag.ordinal()];
    }

    @Override
    public void datasource(String name, String rrdPath, String dsName, ConsolFun consolFun) {
        RrdBackendFactory factory = RrdBackendFactory.getDefaultFactory();
        this.sources.add(new Def(name, factory.getUri(rrdPath), dsName, consolFun, factory));
    }

    @Override
    public void datasource(String name, URI rrdUri, String dsName, ConsolFun consolFun) {
        this.sources.add(new Def(name, rrdUri, dsName, consolFun, RrdBackendFactory.findFactory(rrdUri)));
    }

    @Deprecated
    public void datasource(String name, String rrdPath, String dsName, ConsolFun consolFun, String backend) {
        RrdBackendFactory factory = RrdBackendFactory.getFactory(backend);
        this.sources.add(new Def(name, factory.getUri(rrdPath), dsName, consolFun, factory));
    }

    @Override
    public void datasource(String name, String rrdPath, String dsName, ConsolFun consolFun, RrdBackendFactory backend) {
        this.sources.add(new Def(name, backend.getUri(rrdPath), dsName, consolFun, backend));
    }

    @Override
    public void datasource(String name, URI rrdUri, String dsName, ConsolFun consolFun, RrdBackendFactory backend) {
        this.sources.add(new Def(name, rrdUri, dsName, consolFun, backend));
    }

    @Override
    public void datasource(String name, String rpnExpression) {
        this.sources.add(new CDef(name, rpnExpression));
    }

    @Deprecated
    public void datasource(String name, String defName, ConsolFun consolFun) {
        this.datasource(name, defName, consolFun.getVariable());
    }

    @Override
    public void datasource(String name, String defName, Variable var) {
        this.sources.add(new VDef(name, defName, var));
    }

    @Override
    public void datasource(String name, IPlottable plottable) {
        this.sources.add(new PDef(name, plottable));
    }

    @Override
    public void datasource(String name, FetchData fetchData) {
        this.sources.add(new TDef(name, name, fetchData));
    }

    @Override
    public void datasource(String name, String dsName, FetchData fetchData) {
        this.sources.add(new TDef(name, dsName, fetchData));
    }

    @Deprecated
    public void percentile(String name, String defName) {
        this.percentile(name, defName, 95.0);
    }

    @Deprecated
    public void percentile(String name, String defName, double percent) {
        this.datasource(name, defName, new Variable.PERCENTILE(percent));
    }

    @Deprecated
    public void print(String srcName, ConsolFun consolFun, String format) {
        Variable var = consolFun.getVariable();
        String tempName = srcName + "_" + var.hashCode();
        this.datasource(tempName, srcName, var);
        this.comments.add(new PrintText(tempName, format, false, false));
    }

    public void print(String srcName, String format) {
        this.print(srcName, format, false);
    }

    public void print(String srcName, String format, boolean strftime) {
        this.comments.add(new PrintText(srcName, format, false, strftime));
    }

    @Deprecated
    public void gprint(String srcName, ConsolFun consolFun, String format) {
        Variable var = consolFun.getVariable();
        String tempName = srcName + "_" + var.hashCode();
        this.datasource(tempName, srcName, var);
        this.comments.add(new PrintText(tempName, format, true, false));
    }

    public void gprint(String srcName, String format) {
        this.gprint(srcName, format, false);
    }

    public void gprint(String srcName, String format, boolean strftime) {
        this.comments.add(new PrintText(srcName, format, true, strftime));
    }

    public void comment(String text) {
        this.comments.add(new CommentText(text));
    }

    public void hrule(double value, Paint color) {
        this.hrule(value, color, null, 1.0f);
    }

    public void hrule(double value, Paint color, String legend) {
        this.hrule(value, color, legend, 1.0f);
    }

    public void hrule(double value, Paint color, String legend, float width) {
        this.hrule(value, color, legend, new BasicStroke(width));
    }

    public void hrule(double value, Paint color, String legend, BasicStroke stroke) {
        LegendText legendText = new LegendText(color, legend);
        this.comments.add(legendText);
        this.plotElements.add(new HRule(value, color, legendText, stroke));
    }

    public void vrule(long timestamp, Paint color) {
        this.vrule(timestamp, color, null, 1.0f);
    }

    public void vrule(long timestamp, Paint color, String legend) {
        this.vrule(timestamp, color, legend, 1.0f);
    }

    public void vrule(long timestamp, Paint color, String legend, float width) {
        this.vrule(timestamp, color, legend, new BasicStroke(width));
    }

    public void vrule(long timestamp, Paint color, String legend, BasicStroke stroke) {
        LegendText legendText = new LegendText(color, legend);
        this.comments.add(legendText);
        this.plotElements.add(new VRule(timestamp, color, legendText, stroke));
    }

    public void hspan(double start, double end, Paint color) {
        this.hspan(start, end, color, null);
    }

    public void hspan(double start, double end, Paint color, String legend) {
        LegendText legendText = new LegendText(color, legend);
        this.comments.add(legendText);
        this.plotElements.add(new HSpan(start, end, color, legendText));
    }

    public void vspan(long start, long end, Paint color) {
        this.vspan(start, end, color, null);
    }

    public void vspan(long start, long end, Paint color, String legend) {
        LegendText legendText = new LegendText(color, legend);
        this.comments.add(legendText);
        this.plotElements.add(new VSpan(start, end, color, legendText));
    }

    public void line(String srcName, Paint color) {
        this.line(srcName, color, null, 1.0f, false);
    }

    public void line(String srcName, Paint color, String legend) {
        this.line(srcName, color, legend, 1.0f, false);
    }

    public void line(String srcName, Paint color, float width) {
        this.line(srcName, color, null, width, false);
    }

    public void line(String srcName, Paint color, String legend, float width) {
        this.line(srcName, color, legend, width, false);
    }

    public void line(String srcName, Paint color, String legend, float width, boolean stack) {
        if (legend != null) {
            this.comments.add(new LegendText(color, legend));
        }
        SourcedPlotElement parent = stack ? this.findParent() : null;
        this.plotElements.add(new Line(srcName, color, new BasicStroke(width), parent));
    }

    public void line(String srcName, Paint color, String legend, BasicStroke stroke, boolean stack) {
        if (legend != null) {
            this.comments.add(new LegendText(color, legend));
        }
        SourcedPlotElement parent = stack ? this.findParent() : null;
        this.plotElements.add(new Line(srcName, color, stroke, parent));
    }

    public void line(double value, Paint color, float width, boolean stack) {
        SourcedPlotElement parent = stack ? this.findParent() : null;
        this.plotElements.add(new ConstantLine(value, color, new BasicStroke(width), parent));
    }

    public void line(double value, Paint color, BasicStroke stroke, boolean stack) {
        SourcedPlotElement parent = stack ? this.findParent() : null;
        this.plotElements.add(new ConstantLine(value, color, stroke, parent));
    }

    public void area(String srcName, Paint color) {
        this.area(srcName, color, null, false);
    }

    public void area(String srcName, Paint color, String legend) {
        this.area(srcName, color, legend, false);
    }

    public void area(String srcName, Paint color, String legend, boolean stack) {
        if (legend != null) {
            this.comments.add(new LegendText(color, legend));
        }
        SourcedPlotElement parent = stack ? this.findParent() : null;
        this.plotElements.add(new Area(srcName, color, parent));
    }

    public void area(double value, Paint color, boolean stack) {
        SourcedPlotElement parent = stack ? this.findParent() : null;
        this.plotElements.add(new ConstantArea(value, color, parent));
    }

    public void stack(String srcName, Paint color) {
        this.stack(srcName, color, null);
    }

    public void stack(String srcName, Paint color, String legend) {
        SourcedPlotElement parent = this.findParent();
        if (legend != null) {
            this.comments.add(new LegendText(color, legend));
        }
        this.plotElements.add(new Stack(parent, srcName, color));
    }

    private SourcedPlotElement findParent() {
        SourcedPlotElement parent = null;
        for (int i = this.plotElements.size() - 1; i >= 0; --i) {
            PlotElement plotElement = this.plotElements.get(i);
            if (!(plotElement instanceof SourcedPlotElement)) continue;
            parent = (SourcedPlotElement)plotElement;
            break;
        }
        if (parent == null) {
            throw new IllegalArgumentException("You have to stack graph onto something (line or area)");
        }
        return parent;
    }

    public void setDrawXGrid(boolean drawXGrid) {
        this.drawXGrid = drawXGrid;
    }

    public void setDrawYGrid(boolean drawYGrid) {
        this.drawYGrid = drawYGrid;
    }

    public void setImageQuality(float imageQuality) {
        this.imageQuality = imageQuality;
    }

    public void setAntiAliasing(boolean antiAliasing) {
        this.antiAliasing = antiAliasing;
    }

    public void setTextAntiAliasing(boolean textAntiAliasing) {
        this.textAntiAliasing = textAntiAliasing;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public String getSignature() {
        return this.signature;
    }

    public void setShowSignature(boolean showSignature) {
        this.showSignature = showSignature;
    }

    public void setFirstDayOfWeek(int firstDayOfWeek) {
        this.firstDayOfWeek = firstDayOfWeek;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
        this.firstDayOfWeek = Calendar.getInstance(Locale.getDefault()).getFirstDayOfWeek();
    }

    @Override
    public void setTimeZone(TimeZone tz) {
        this.tz = tz;
    }

    @Override
    public TimeZone getTimeZone() {
        return this.tz;
    }

    public void setGridStroke(Stroke gridStroke) {
        this.gridStroke = gridStroke;
    }

    public void setTickStroke(Stroke tickStroke) {
        this.tickStroke = tickStroke;
    }

    public void setDownsampler(DownSampler downsampler) {
        this.downsampler = downsampler;
    }

    int printStatementCount() {
        int count = 0;
        for (CommentText comment : this.comments) {
            if (!(comment instanceof PrintText) || !comment.isPrint()) continue;
            ++count;
        }
        return count;
    }

    boolean shouldPlot() {
        if (this.plotElements.size() > 0) {
            return true;
        }
        for (CommentText comment : this.comments) {
            if (!comment.isValidGraphElement()) continue;
            return true;
        }
        return false;
    }

    Paint getColor(ElementsNames element) {
        return this.colors[element.ordinal()];
    }

    @Override
    public long getEndTime() {
        return this.endTime;
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public long getStep() {
        return this.step;
    }

    public static interface ImageSource {
        public BufferedImage apply(int var1, int var2) throws IOException;
    }

    private static class FileImageSource
    implements ImageSource {
        private final File imagesource;

        FileImageSource(String imagesource) {
            this.imagesource = new File(imagesource);
        }

        @Override
        public BufferedImage apply(int w, int h) throws IOException {
            return ImageIO.read(this.imagesource);
        }
    }

    private static class UrlImageSource
    implements ImageSource {
        private final URL imagesource;

        private UrlImageSource(URL imagesource) {
            this.imagesource = imagesource;
        }

        @Override
        public BufferedImage apply(int w, int h) throws IOException {
            return ImageIO.read(this.imagesource);
        }
    }
}

