(function() {
    "use strict";

    /**
     * <drawer-button/>
     */
    const drawerButton = {
        templateUrl: "/static/dataiku/widgets/topbar-drawers/drawer-button/drawer-button.component.html",
        bindings: {
            onClick: '&',
            icon: '<',
            label: '<?',
            onButtonInit: '&?',
            classModifier: '<?',
            tooltipPlacement: '<?',
        },
        controller: function drawerButtonController($timeout, $element) {
            const ctrl = this;

            ctrl.$onInit = function() {
                if (ctrl.onButtonInit) {
                    $timeout(() => {
                        ctrl.onButtonInit({elem: $element});
                    });
                }
            };
        }
    };

    angular.module("dataiku.widgets").component("drawerButton", drawerButton);
})();
