"""
Forked from https://github.com/santiagobasulto/ipython-gpt/ v0.0.6
(commit eb17d13d7e5b8443a684d6b0cd3ffdf7fbbf20a4)
"""

from IPython.core.magic import Magics, cell_magic, line_magic, line_cell_magic, magics_class
from IPython.display import Markdown, display
from .subcommands import ChatCommand, AnalyzeCommand

HELP_STR="""
##### Ask Code Assistant for code help (response in output of the cell)

Use:
```
%%aiask
Your question
```

or

```
%aiask your question
```

To make AI assistant aware of the pandas dataframes that exist, use
```
%%aiask -df
Your question
```

Use `%aiask --help` for help on advanced options

##### Ask Code Assistant for code help (create a new cell with the generated code)

Use:
```
%%aiwrite
Your question
```

or

```
%aiwrite your question
```

To make AI assistant aware of the pandas dataframes that exist, use 
```
%%aiwrite -df
Your question
```

Use `%aiwrite --help` for help on advanced options

##### Ask Code Assistant to explain code

Use:
```
%%aiexplain
Your existing Python code
```

Code Assistant responds with an explanation of the code in the output of the cell.

Use `%aiexplain --help` for help on advanced options
"""

def md_display(results):
    display(Markdown(results))

@magics_class
class AICodeAssistant(Magics):
    def __init__(self, *args, **kwargs):
        super(AICodeAssistant, self).__init__(*args, **kwargs)

        self._context = {
            "chat_message_history": [],
            "shell": self.shell,
        }

    @line_cell_magic
    def aiask(self, line='', cell=None):
        cmd = ChatCommand("aiask", self._context)
        result = cmd.execute(line, cell)
        md_display(result)

    @line_cell_magic
    def aiexplain(self, line='', cell=None):
        cmd = AnalyzeCommand("aiexplain", self._context)
        result = cmd.execute(line, cell)
        md_display(result)

    @line_cell_magic
    def aiwrite(self, line='', cell=None):
        cmd = ChatCommand("aiwrite", self._context)
        cmd.split_non_code_output = True
        result = cmd.execute(line, cell)
        self.shell.set_next_input(result)

    @line_cell_magic
    def aihelp(self, line='', cell=None):
        md_display(HELP_STR)

name = "ai_code_assistant"

def load_ipython_extension(ipython):
    ipython.register_magics(AICodeAssistant)
    md_display("""AI Code Assistant loaded. Use %aihelp to get help on Code Assistant commands""")