<!-- html:true -->
<html lang="en">
<head>
    <meta charset="utf-8"> <!-- utf-8 works for most cases -->
    <meta name="viewport" content="width=device-width"> <!-- Forcing initial-scale shouldn't be necessary -->
    <meta http-equiv="X-UA-Compatible" content="IE=edge"> <!-- Use the latest (edge) version of IE rendering engine -->
    <title>${title}</title> <!-- the <title> tag shows on email notifications on Android 4.4. -->
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Source+Sans+3:ital,wght@0,200..900;1,200..900&display=swap');
    </style>
    <style type="text/css">
        /* ensure that clients don't add any padding or spaces around the email design and allow us to style emails for the entire width of the preview pane */
        body,
        #bodyTable {
            height: 100% !important;
            width: 100% !important;
            margin: 0;
            padding: 0;
            font-family: "Source Sans 3", Arial, sans-serif;
            background-color: #e0f7f6;
        }

        /* Ensures Webkit- and Windows-based clients don't automatically resize the email text. */
        body,
        table,
        td,
        p,
        a,
        li,
        blockquote {
            -ms-text-size-adjust: 100%;
            -webkit-text-size-adjust: 100%;
        }

        /* Resolves webkit padding issue. */
        table {
            border-spacing: 0;
        }

        /* Resolves the Outlook 2007, 2010, and Gmail td padding issue, and removes spacing around tables that Outlook adds. */
        table,
        td {
            border-collapse: collapse;
            mso-table-lspace: 0pt;
            mso-table-rspace: 0pt;
        }

        /* Corrects the way Internet Explorer renders resized images in emails. */
        img {
            -ms-interpolation-mode: bicubic;
        }

        /* Ensures images don't have borders or text-decorations applied to them by default. */
        img,
        a img {
            border: 0;
            outline: none;
            text-decoration: none;
        }

        /* Styles Yahoo's auto-sensing link color and border */
        .yshortcuts a {
            border-bottom: none !important;
        }

        /* Apple Mail doesn't support max-width, so we use media queries to constrain the email container width. */
        @media only screen and (min-width: 801px) {
            .email-container {
                width: 800px !important;
            }
        }

        /* Custom styles for content */
        ul {
            line-height: 1.6;
        }

        a {
            color: #00B2A9;
        }

        .logo-header {
            text-align: left;
            margin-bottom: 20px;
        }

        .logo {
            max-width: 120px;
            margin-bottom: 4px;
        }

        .container {
            background-color: #ffffff;
            padding: 16px 32px 24px 32px;
            border: 1px solid #00B2A9;
            border-radius: 8px;
        }

        .content {
            color: #333333;
            line-height: 1.5;
        }

        .footer {
            text-align: center;
            color: #888888;
            font-size: 12px;
            padding: 40px 0;
        }

        .info-table th {
            text-align: left;
            padding: 10px;
        }

        .quota-footer {
            font-weight: lighter;
            font-size: smaller;
        }

    </style>
</head>

<table id="bodyTable" border="0" cellpadding="0" cellspacing="0" width="100%">
    <tr>
        <td align="center" valign="top">
            <!-- Email wrapper -->
            <table align="center" border="0" cellpadding="0" cellspacing="0" class="email-container"
                   style="max-width: 600px;">
                <tr>
                    <td height="20" style="font-size: 0; line-height: 0;">&nbsp;</td>
                </tr>
                <tr>
                    <td>
                        <!-- Logo -->
                        <div class="logo-header">
                            <a href="https://www.dataiku.com">
                                <img src="https://dku-assets.s3.amazonaws.com/img/emailing/DataikuLogoTeal_2025.png" alt="Dataiku Logo" class="logo">
                            </a>
                        </div>
                    </td>
                </tr>
                <tr>
                    <td>
                        <!-- Content Box -->
                        <div class="container">
                            <div class="content">
                                
                                <h1>${title}</h1>
                                <p>${message}</p>
                                
                            </div>
                        </div>
                    </td>
                </tr>
                <!-- Footer : BEGIN -->
                <tr>
                    <td class="footer">
                        &copy; ${currentYear} Dataiku | All rights reserved.<br>902 Broadway, New York City, New York 10010,
                        United States
                    </td>
                </tr>
                <tr>
                    <td>
                        <div style="width: fit-content; margin: auto; padding-bottom: 20px;">
                            <a href="https://www.facebook.com/dataiku" ><img style="padding: 10px" src="https://dku-assets.s3.amazonaws.com/img/emailing/icons/facebook.png" /></a>
                            <a href="https://www.linkedin.com/company/dataiku" ><img style="padding: 10px" src="https://dku-assets.s3.amazonaws.com/img/emailing/icons/linkedin.png" /></a>
                            <a href="https://twitter.com/dataiku" ><img style="padding: 10px" src="https://dku-assets.s3.amazonaws.com/img/emailing/icons/twitter.png" /></a>
                            <a href="https://www.instagram.com/dataiku" ><img style="padding: 10px" src="https://dku-assets.s3.amazonaws.com/img/emailing/icons/instagram.png" /></a>
                        </div>
                    </td>
                </tr>
                <!-- Footer : END -->
            </table>
        </td>
    </tr>
</table>

</html>