#!/bin/bash -e
# Create a new Python virtual environment

MYDIR=$(cd "$(dirname "$0")" && pwd -P)

if [ $# -lt 1 ]; then
	echo >&2 "Usage: $0 PYTHONBIN [-p TARGET_PYTHONBIN] VIRTUALENV_ARG ..."
	exit 1
fi
pythonBin="$1"
shift

pythonVersion=$("$pythonBin" -c "import sysconfig;print(sysconfig.get_python_version())")

if [ $# -ge 2 -a "$1" = "-p" ]; then
	targetPython="$2"
	targetVersion=$("$targetPython" -c "import sysconfig;print(sysconfig.get_python_version())")
else
	targetVersion="$pythonVersion"
fi

if [[ "$targetVersion" == "2.7" || "$targetVersion" == 3.[56] ]]; then
	# Latest version supporting the creation of Python 2.7-3.6 environments
	virtualenv="$MYDIR"/virtualenv-20.21.pyz
elif [[ "$targetVersion" == "3.7" ]]; then
	# Latest version supporting the creation of Python 3.7 environments
	virtualenv="$MYDIR"/virtualenv-20.26.pyz
else
	virtualenv="$MYDIR"/virtualenv.pyz
fi

exec "$pythonBin" "$virtualenv" "$@"
