dkuSetRemoteDSS <- function(url, api_key, no_check_certificate=FALSE){
    x <- list(auth_mode= "API_KEY", api_key=api_key, has_a_jek=FALSE, backend_url=url, no_check_certificate=no_check_certificate)
    x$custom_cert = FALSE

    if (no_check_certificate) {
        httr::set_config(config(ssl_verifypeer = 0L))
    }

    assign("dku_intercom__cached_location_data", x, envir = .GlobalEnv)
}

dkuGetCurrentProjectKey <- function(projectKey) {
    pkey = dku_remoterun__get_env_var("DKU_CURRENT_PROJECT_KEY", unset=NA)
    if (is.na(pkey)) {
        stop("No default project key defined (no DKU_CURRENT_PROJECT_KEY variable set). Set environment variable or call dkuSetCurrentProjectKey")
    }
    pkey
}

dkuSetCurrentProjectKey <- function(projectKey) {
  Sys.setenv(DKU_CURRENT_PROJECT_KEY=projectKey)
}
