/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.hproxy.sandbox.hive.executor;

import com.dataiku.hproxy.model.hive.ColumnSchema;
import com.dataiku.hproxy.model.hive.ExecutionQuery;
import com.dataiku.hproxy.model.hive.ExecutionResults;
import com.dataiku.hproxy.model.hive.ResultCount;
import com.dataiku.hproxy.sandbox.hive.common.HiveColumnsUnprefixer;
import com.dataiku.hproxy.sandbox.hive.common.HiveSession;
import com.dataiku.hproxy.sandbox.hive.common.HiveSessionImpl;
import com.dataiku.hproxy.sandbox.hive.common.ReflectedHiveCallCache;
import com.dataiku.hproxy.sandbox.hive.executor.ExplainPlanResultFetcher;
import com.dataiku.hproxy.sandbox.hive.executor.IResultFetcher;
import com.dataiku.hproxy.sandbox.hive.executor.ResultFetcher;
import com.dataiku.hproxy.server.hive.executor.IHiveExecutorImpl;
import com.dataiku.hproxy.server.hive.executor.IHiveSession;
import com.dataiku.hproxy.server.hive.executor.WrappedHiveException;
import com.dataiku.hproxy.utils.HiveUtils;
import com.dataiku.hproxy.utils.Reflector;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Schema;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.QueryPlan;
import org.apache.hadoop.hive.ql.exec.ExplainTask;
import org.apache.hadoop.hive.ql.exec.FetchTask;
import org.apache.hadoop.hive.ql.processors.CommandProcessor;
import org.apache.hadoop.hive.ql.processors.CommandProcessorFactory;
import org.apache.hadoop.hive.ql.processors.CommandProcessorResponse;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.log4j.Logger;

public class HiveExecutorImpl
implements IHiveExecutorImpl {
    private static final int fetcherLimit = 5;
    private Driver driver;
    FetchTask fetchTaskFromDriver;
    private ExecutionQuery query;
    private static Logger logger = Logger.getLogger(HiveExecutorImpl.class);
    private List<IResultFetcher> fetchers = new ArrayList<IResultFetcher>();
    private Schema schema;
    private LazySimpleSerDe serde;
    private HiveSession session;
    private volatile boolean driverDestroyed = false;
    private ArrayList<String> explainPlan;
    private ReflectedHiveCallCache reflect;

    public void initialize(IHiveSession session, ExecutionQuery query) {
        this.reflect = new ReflectedHiveCallCache(this.getClass().getClassLoader());
        logger.info((Object)"Initialization:");
        for (String q : query.initQueries) {
            logger.info((Object)("Init query = " + q));
        }
        logger.info((Object)("User query = " + query.userQuery));
        this.query = query;
        this.session = ((HiveSessionImpl)session).getSession();
    }

    private void runInitQueries() throws WrappedHiveException {
        this.injectLogMessage("======= Initialization =======\n");
        logger.info((Object)"Run initialization queries... ");
        for (String cmd : this.query.initQueries) {
            CommandProcessor p;
            this.session.getSessionState().setCommandType(null);
            cmd = HiveUtils.removeTrailingSemicolons((String)cmd);
            cmd = this.reflect.createVariableSubstitution().substitute(this.session.getConf(), cmd);
            logger.info((Object)("Exec init query : " + cmd));
            String cmd_trimmed = cmd.trim();
            String[] tokens = cmd_trimmed.split("\\s+");
            String cmd1 = cmd_trimmed.substring(tokens[0].length()).trim();
            try {
                p = CommandProcessorFactory.get((String)tokens[0]);
            }
            catch (SQLException t) {
                logger.warn((Object)"Caught hive error (exception) : ", (Throwable)t);
                throw new WrappedHiveException(t.getMessage(), (Throwable)t);
            }
            int res = -1;
            try {
                if (p instanceof Driver) {
                    res = p.run(cmd).getResponseCode();
                    ((Driver)p).close();
                    ((Driver)p).destroy();
                } else {
                    res = p.run(cmd1).getResponseCode();
                }
            }
            catch (Exception t) {
                logger.warn((Object)"Caught hive error (exception) : ", (Throwable)t);
                throw new WrappedHiveException(t.getMessage(), (Throwable)t);
            }
            if (res == 0) continue;
            String err = this.session.getErrorStreamAsString();
            logger.info((Object)("Caught hive error (output) : " + err));
            throw new WrappedHiveException(err, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean runUserQuery() throws WrappedHiveException {
        CommandProcessorResponse response;
        boolean canBeFetched;
        block33: {
            this.injectLogMessage("======= Query execution =======\n");
            logger.info((Object)"Run user query");
            this.session.getSessionState().setCommandType(null);
            this.driver = this.session.newDriver();
            this.schema = null;
            canBeFetched = false;
            try {
                Object cmd = this.query.userQuery;
                cmd = HiveUtils.removeTrailingSemicolons((String)cmd);
                cmd = this.reflect.createVariableSubstitution().substitute(this.session.getConf(), (String)cmd);
                String cmd_trimmed = ((String)cmd).trim();
                String[] tokens = cmd_trimmed.split("\\s+");
                String cmd1 = cmd_trimmed.substring(tokens[0].length()).trim();
                CommandProcessor p = CommandProcessorFactory.get((String)tokens[0]);
                if (p instanceof Driver) {
                    response = this.driver.run((String)cmd);
                    QueryPlan plan = this.driver.getPlan();
                    if (plan != null) {
                        FetchTask ft = plan.getFetchTask();
                        if (ft != null) {
                            canBeFetched = true;
                            this.schema = this.driver.getSchema();
                            this.getSerde();
                        } else if (plan.getRootTasks().size() == 1 && plan.getRootTasks().get(0) instanceof ExplainTask) {
                            this.explainPlan = new ArrayList();
                            while (this.reflectedGetResultsFromDriver(this.explainPlan)) {
                            }
                            if (this.explainPlan.size() > 0) {
                                canBeFetched = true;
                                this.schema = this.driver.getSchema();
                            }
                        }
                        break block33;
                    }
                    logger.info((Object)"No query plan in driver after run, Hive probably (partially) >=2.0");
                    try {
                        this.fetchTaskFromDriver = (FetchTask)new Reflector().getAttribute((Object)this.driver, "fetchTask");
                        if (this.fetchTaskFromDriver != null) {
                            canBeFetched = true;
                            this.schema = this.driver.getSchema();
                            this.getSerde();
                        }
                    }
                    catch (Exception ex) {
                        logger.info((Object)"No query plan and no fetch task");
                    }
                    if (this.fetchTaskFromDriver != null) break block33;
                    Reflector reflect = new Reflector();
                    try {
                        String explainPlanStr;
                        Object queryDisplay = reflect.call((Object)this.driver, "getQueryDisplay", new Object[0]);
                        if (queryDisplay != null && StringUtils.isNotBlank((String)(explainPlanStr = (String)reflect.call(queryDisplay, "getExplainPlan", new Object[0])))) {
                            logger.info((Object)("Found an explain plan : " + explainPlanStr));
                            boolean hasTokExplain = false;
                            for (String line : explainPlanStr.split("\n")) {
                                if (!line.trim().equals("TOK_EXPLAIN")) continue;
                                hasTokExplain = true;
                            }
                            if (hasTokExplain) {
                                logger.info((Object)"Query itself is an explain plan");
                                this.explainPlan = Lists.newArrayList();
                                while (this.reflectedGetResultsFromDriver(this.explainPlan)) {
                                }
                                canBeFetched = true;
                                this.schema = this.driver.getSchema();
                            }
                        }
                    }
                    catch (Exception ex) {
                        logger.info((Object)"No query plan, no fetch task and no explain plan");
                    }
                    if (this.schema != null) break block33;
                    try {
                        Object ctx = reflect.getAttribute((Object)this.driver, "ctx");
                        if (ctx != null && ((Boolean)reflect.call(ctx, "getExplain", new Object[0])).booleanValue()) {
                            this.explainPlan = Lists.newArrayList();
                            while (this.driver.getResults(this.explainPlan)) {
                            }
                            canBeFetched = true;
                            this.schema = this.driver.getSchema();
                        }
                        break block33;
                    }
                    catch (Exception ex) {
                        logger.info((Object)"No query plan, no fetch task, no explain plan, even in the Context");
                    }
                    break block33;
                }
                response = p.run(cmd1);
            }
            catch (Exception e) {
                String outputErr = this.session.getErrorStreamAsString();
                logger.info((Object)("Caught Hive error (exception caught). Stderr says : " + outputErr), (Throwable)e);
                throw new WrappedHiveException(e.getMessage() + " / " + outputErr, (Throwable)e);
            }
            finally {
                HiveExecutorImpl hiveExecutorImpl = this;
                synchronized (hiveExecutorImpl) {
                    if (!this.driverDestroyed) {
                        logger.info((Object)"Destroy Hive driver (should close ZooKeeper connection)");
                        this.driverDestroyed = true;
                        this.driver.destroy();
                    }
                }
            }
        }
        if (response.getResponseCode() != 0) {
            logger.info((Object)("Caught Hive error (bad response code). Error message : " + response.getErrorMessage()), null);
            throw new WrappedHiveException(response.getErrorMessage(), null);
        }
        return canBeFetched;
    }

    private boolean reflectedGetResultsFromDriver(ArrayList<String> res) {
        Reflector r = new Reflector(this.getClass().getClassLoader());
        try {
            return (Boolean)r.call((Object)this.driver, "getResults", new Object[]{res});
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException e) {
            logger.error((Object)("Could not getResults() from the driver, incompatible Hive version? " + e.getMessage()));
            return false;
        }
    }

    Object getSerde() {
        if (this.serde == null) {
            try {
                List fieldSchemas = this.schema.getFieldSchemas();
                ArrayList<String> columnNames = new ArrayList<String>();
                ArrayList<String> columnTypes = new ArrayList<String>();
                StringBuilder namesSb = new StringBuilder();
                StringBuilder typesSb = new StringBuilder();
                if (fieldSchemas != null && !fieldSchemas.isEmpty()) {
                    for (int pos = 0; pos < fieldSchemas.size(); ++pos) {
                        if (pos != 0) {
                            namesSb.append(",");
                            typesSb.append(",");
                        }
                        columnNames.add(((FieldSchema)fieldSchemas.get(pos)).getName());
                        columnTypes.add(((FieldSchema)fieldSchemas.get(pos)).getType());
                        namesSb.append(((FieldSchema)fieldSchemas.get(pos)).getName());
                        typesSb.append(((FieldSchema)fieldSchemas.get(pos)).getType());
                    }
                }
                String names = namesSb.toString();
                String types = typesSb.toString();
                this.serde = new LazySimpleSerDe();
                Properties props = new Properties();
                if (names.length() > 0) {
                    props.setProperty("columns", names);
                }
                if (types.length() > 0) {
                    props.setProperty("columns.types", types);
                }
                this.serde.initialize((Configuration)new HiveConf(), props);
            }
            catch (Exception e) {
                throw new WrappedHiveException(e.getMessage(), (Throwable)e);
            }
        }
        return this.serde;
    }

    public boolean executeQuery() {
        this.runInitQueries();
        return this.runUserQuery();
    }

    public String getLogOutput() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void kill() {
        logger.info((Object)"Close fetchers");
        for (IResultFetcher fetcher : this.fetchers) {
            fetcher.close();
        }
        this.fetchers.clear();
        logger.info((Object)"Kill running jobs");
        if (this.session != null) {
            this.session.killMRJobs();
            this.session.triggerInterruptions();
        }
        logger.info((Object)"Close Hive driver");
        if (this.driver != null) {
            this.driver.close();
            HiveExecutorImpl hiveExecutorImpl = this;
            synchronized (hiveExecutorImpl) {
                if (!this.driverDestroyed) {
                    this.driverDestroyed = true;
                    logger.info((Object)"Destroy Hive driver (should close ZooKeeper connection)");
                    this.driver.destroy();
                }
            }
        }
    }

    public void release() {
    }

    private void killOneFetcher() {
        if (this.fetchers.size() == 0) {
            return;
        }
        for (int i = 0; i < this.fetchers.size(); ++i) {
            for (int j = 0; j < this.fetchers.size(); ++j) {
                if (i >= j) continue;
                IResultFetcher f1 = this.fetchers.get(i);
                IResultFetcher f2 = this.fetchers.get(j);
                if (f1.getCurrentRowIndex() != f2.getCurrentRowIndex()) continue;
                f1.close();
                this.fetchers.remove(f1);
                return;
            }
        }
        this.fetchers.remove(0);
    }

    private IResultFetcher findAppropriateFetcher(long offset) {
        logger.info((Object)("Find a fetcher at offset=" + offset));
        IResultFetcher out = null;
        for (IResultFetcher rf : this.fetchers) {
            if ((long)rf.getCurrentRowIndex() != offset) continue;
            out = rf;
            break;
        }
        if (out == null) {
            logger.info((Object)"No appropriate fetcher found, create a new one");
            out = this.explainPlan != null ? new ExplainPlanResultFetcher(this.explainPlan) : new ResultFetcher(this);
            out.skip(offset);
            this.fetchers.add(out);
            if (this.fetchers.size() > 5) {
                logger.info((Object)"Removed one fetcher from pool");
                this.killOneFetcher();
            }
        } else {
            this.fetchers.remove(out);
            this.fetchers.add(out);
        }
        logger.info((Object)("Fetcher pool size = " + this.fetchers.size()));
        return out;
    }

    public ExecutionResults fetchResults(long offset, long limit) {
        IResultFetcher fetcher = this.findAppropriateFetcher(offset);
        return fetcher.fetch(limit);
    }

    public ResultCount countResults(long limit) {
        IResultFetcher mostAdvancedFetcher = this.getMostAdvancedFetcher();
        long mostAdvancedPosition = mostAdvancedFetcher.getCurrentRowIndex();
        if (mostAdvancedPosition > limit) {
            return new ResultCount(limit, true);
        }
        long remaining = limit - mostAdvancedPosition;
        mostAdvancedFetcher.skip(remaining + 1L);
        mostAdvancedPosition = mostAdvancedFetcher.getCurrentRowIndex();
        if (mostAdvancedPosition > limit) {
            return new ResultCount(limit, true);
        }
        return new ResultCount(mostAdvancedPosition);
    }

    private IResultFetcher getMostAdvancedFetcher() {
        if (this.fetchers.size() == 0) {
            logger.info((Object)"No appropriate fetcher found, create a new one");
            IResultFetcher fetcher = this.explainPlan != null ? new ExplainPlanResultFetcher(this.explainPlan) : new ResultFetcher(this);
            this.fetchers.add(fetcher);
            logger.info((Object)("Fetcher pool size = " + this.fetchers.size()));
        }
        long mostAdvancedPosition = -1L;
        IResultFetcher mostAdvancedFetcher = null;
        for (IResultFetcher fetcher : this.fetchers) {
            long pos = fetcher.getCurrentRowIndex();
            if (pos <= mostAdvancedPosition) continue;
            mostAdvancedPosition = pos;
            mostAdvancedFetcher = fetcher;
        }
        return mostAdvancedFetcher;
    }

    public long getMostAdvancedFetcherPosition() {
        return this.getMostAdvancedFetcher().getCurrentRowIndex();
    }

    public List<ColumnSchema> getSchema() {
        if (this.schema != null) {
            ArrayList<ColumnSchema> outSchema = new ArrayList<ColumnSchema>();
            for (FieldSchema col : this.schema.getFieldSchemas()) {
                ColumnSchema cs = new ColumnSchema();
                cs.name = col.getName();
                cs.type = col.getType();
                cs.comment = col.getComment();
                outSchema.add(cs);
            }
            HiveColumnsUnprefixer.unprefix(outSchema);
            return outSchema;
        }
        return null;
    }

    Driver getDriver() {
        return this.driver;
    }

    FetchTask getFetchTask() {
        if (this.fetchTaskFromDriver != null) {
            return this.fetchTaskFromDriver;
        }
        return this.driver.getPlan().getFetchTask();
    }

    HiveConf getConf() {
        return this.session.getConf();
    }

    public String getLogTail() {
        if (this.session != null) {
            return this.session.getLogTail();
        }
        return "";
    }

    public void injectLogMessage(String msg) {
        try {
            this.session.injectLogMessage(msg);
        }
        catch (IOException e) {
            logger.error((Object)"Unable to inject message into Hive log stream", (Throwable)e);
        }
    }
}

