/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.util;

import org.apache.directory.api.i18n.I18n;

public final class Base64 {
    private static final char[] ALPHABET;
    private static final byte[] CODES;

    private Base64() {
    }

    public static char[] encode(byte[] data) {
        char[] out = new char[(data.length + 2) / 3 * 4];
        int i = 0;
        int index = 0;
        while (i < data.length) {
            boolean isQuadrupel = false;
            boolean isTripel = false;
            int val = 0xFF & data[i];
            val <<= 8;
            if (i + 1 < data.length) {
                val |= 0xFF & data[i + 1];
                isTripel = true;
            }
            val <<= 8;
            if (i + 2 < data.length) {
                val |= 0xFF & data[i + 2];
                isQuadrupel = true;
            }
            out[index + 3] = ALPHABET[isQuadrupel ? val & 0x3F : 64];
            out[index + 2] = ALPHABET[isTripel ? (val >>= 6) & 0x3F : 64];
            out[index + 1] = ALPHABET[(val >>= 6) & 0x3F];
            out[index + 0] = ALPHABET[(val >>= 6) & 0x3F];
            i += 3;
            index += 4;
        }
        return out;
    }

    public static byte[] decode(char[] data) {
        int tempLen = data.length;
        for (char c : data) {
            if (c <= '\u00ff' && CODES[c] >= 0) continue;
            --tempLen;
        }
        int len = tempLen / 4 * 3;
        if (tempLen % 4 == 3) {
            len += 2;
        }
        if (tempLen % 4 == 2) {
            ++len;
        }
        byte[] out = new byte[len];
        int shift = 0;
        int accum = 0;
        int index = 0;
        for (char c : data) {
            int value;
            int n = value = c > '\u00ff' ? -1 : CODES[c];
            if (value < 0) continue;
            accum <<= 6;
            accum |= value;
            if ((shift += 6) < 8) continue;
            out[index++] = (byte)(accum >> (shift -= 8) & 0xFF);
        }
        if (index != out.length) {
            throw new Error(I18n.err(I18n.ERR_17027_WRONG_DATA_LENGTH, index, out.length));
        }
        return out;
    }

    static {
        int ii;
        ALPHABET = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=".toCharArray();
        CODES = new byte[256];
        for (ii = 0; ii < 256; ++ii) {
            Base64.CODES[ii] = -1;
        }
        for (ii = 65; ii <= 90; ++ii) {
            Base64.CODES[ii] = (byte)(ii - 65);
        }
        for (ii = 97; ii <= 122; ++ii) {
            Base64.CODES[ii] = (byte)(26 + ii - 97);
        }
        for (ii = 48; ii <= 57; ++ii) {
            Base64.CODES[ii] = (byte)(52 + ii - 48);
        }
        Base64.CODES[43] = 62;
        Base64.CODES[47] = 63;
    }
}

