/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.agents.tools.mcp;

import com.dataiku.dip.agents.tools.AgentTool;
import com.dataiku.dip.agents.tools.AgentToolMeta;
import com.dataiku.dip.agents.tools.AgentToolParams;
import com.dataiku.dip.agents.tools.AgentToolRunner;
import com.dataiku.dip.agents.tools.mcp.GenericStdioMCPClientToolRunner;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.code.CodeEnvSelection;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.containers.exec.ContainerExecSelection;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.utils.JSON;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class GenericStdioMCPClientTool {
    public static final AgentToolMeta META = new AgentToolMeta(false){

        @Override
        public String getType() {
            return "GenericStdioMCPClient";
        }

        @Override
        public Class<? extends AgentToolParams> paramsClass() {
            return Params.class;
        }

        @Override
        public List<SavedModel.AgentDependency> getDependencies(AgentTool tool) {
            return new ArrayList<SavedModel.AgentDependency>();
        }

        public List<CodeEnvModel.CodeEnvUsage> collectCodeEnvUsage(TaggableObjectsService.TaggableObject object) {
            ArrayList<CodeEnvModel.CodeEnvUsage> usages = new ArrayList<CodeEnvModel.CodeEnvUsage>();
            Params p = ((AgentTool)object).getParamsCopyAs(Params.class);
            if (p.codeEnvSelection.envMode == CodeEnvSelection.EnvMode.EXPLICIT_ENV) {
                usages.add(new CodeEnvModel.CodeEnvUsage(CodeEnvModel.EnvLang.PYTHON, p.codeEnvSelection.envName, CodeEnvModel.EnvUsage.AGENT_TOOL, object.getProjectKey(), object.getId()));
            }
            return usages;
        }

        @Override
        public void encryptPasswords(AgentTool tool, PasswordEncryptionService passwordEncryptionService) {
            super.encryptPasswords(tool, passwordEncryptionService);
            Params p = tool.getParamsCopyAs(Params.class);
            if (p.env != null) {
                for (AbstractSQLConnection.CustomDatabaseProperty cdp : p.env) {
                    if (!cdp.secret || !StringUtils.isNotBlank((String)cdp.value)) continue;
                    cdp.value = passwordEncryptionService.encryptIfNotEncryptedOrEmpty(cdp.value);
                }
            }
            tool.params = JSON.toJsonObject((Object)p);
        }

        @Override
        public AgentToolMeta.ToolDescriptor getResultingDescriptor(AuthCtx authCtx, String projectKey, AgentTool tool) throws Exception {
            TransactionContext.assertNoAttachedTransaction();
            try (GenericStdioMCPClientToolRunner runner = new GenericStdioMCPClientToolRunner((DSSAuthCtx)authCtx, tool, false, false);){
                AgentToolMeta.ToolDescriptor descriptor = runner.getResultingDescriptor(tool);
                Params params = tool.getParamsCopyAs(Params.class);
                descriptor.subtools.forEach(subtool -> {
                    subtool.enabled = params.subtoolsEnabledByDefault || params.subtoolsStateOverride.getOrDefault(subtool.name, false) != false;
                });
                AgentToolMeta.ToolDescriptor toolDescriptor = descriptor;
                return toolDescriptor;
            }
        }

        @Override
        public AgentToolRunner buildRunner(AuthCtx authCtx, String projectKey, AgentTool tool, boolean devKernel) throws Exception {
            com.dataiku.dip.utils.Params dkuParams = AbstractSQLConnection.CustomDatabaseProperty.toParams(tool.dkuProperties);
            boolean devMode = dkuParams.getBoolParam("dku.agents.tool.python.devMode", false);
            return new GenericStdioMCPClientToolRunner((DSSAuthCtx)authCtx, tool, devKernel, devMode);
        }
    };

    public static class Params
    implements AgentToolParams {
        CodeEnvSelection codeEnvSelection = CodeEnvSelection.inherit();
        ContainerExecSelection containerExecSelection = new ContainerExecSelection();
        public boolean useCodeEnvPythonAsCommand;
        public String command;
        public List<String> args = new ArrayList<String>();
        public List<AbstractSQLConnection.CustomDatabaseProperty> env = new ArrayList<AbstractSQLConnection.CustomDatabaseProperty>();
        public boolean subtoolsEnabledByDefault = true;
        public HashMap<String, Boolean> subtoolsStateOverride = new HashMap();
        public int initTimeout = 300;
        public int requestTimeout = 3600;
    }
}

