/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.ml.llm;

import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.connections.HuggingFaceLocalConnection;
import com.dataiku.dip.llm.LLMStructuredRef;
import com.dataiku.dip.recipes.nlp.finetuning.FineTuningRecipePayloadParams;
import java.util.Map;

public class LLMSavedModelInfo {
    public LLMStructuredRef.LLMType llmType;
    public String trainingDataset;
    public String validationDataset;
    public String promptColumn;
    public String completionColumn;
    public String userMessageColumn;
    public String assistantMessageColumn;
    public String systemMessageColumn;
    public String staticSystemMessage;
    public String originalLLMId;
    public Boolean originalLLMIsUnreferenced;
    public String inputLLMId;
    public String inputLLMName;
    public String connection;
    public Boolean handlesSystemMessage;
    public Integer embeddingSize;
    public Integer maxTokensLimit;
    public String remoteModelId;
    public String remoteJobId;
    public String remoteModelName;
    public String remoteJobName;
    public HuggingFaceLocalConnection.HuggingFaceHandlingMode huggingFaceHandlingMode;
    public Integer loraRank;
    public Integer loraAlpha;
    public Double loraDropout;
    public Double neftuneNoiseAlpha;
    public Double initialLearningRate;
    public HuggingFaceLocalConnection.HuggingFaceLocalConnectionParams.QuantizationMode quantizationMode;
    public FineTuningRecipePayloadParams.FineTuningHyperparameters.LocalHuggingFaceHyperparameters.CheckpointMode checkpointMode;
    public CodeEnvModel.UsedCodeEnvRef codeEnv;
    public boolean wasFinetunedUsingPythonRecipe;
    public Integer totalSteps;
    public Integer batchSize;
    public Integer nbEpochs;
    public Float learningRateMultiplier;

    public boolean remapConnections(Map<String, String> replacements) {
        boolean remappedConnections = false;
        LLMStructuredRef originalLLMIdRef = LLMStructuredRef.decodeId(this.originalLLMId);
        if (replacements.containsKey(originalLLMIdRef.connection)) {
            String newConnection = replacements.get(originalLLMIdRef.connection);
            this.originalLLMId = originalLLMIdRef.withOtherConnection(newConnection).encodeToId();
            remappedConnections = true;
        }
        LLMStructuredRef inputLLMIdRef = LLMStructuredRef.decodeId(this.inputLLMId);
        if (replacements.containsKey(inputLLMIdRef.connection)) {
            String newConnection = replacements.get(inputLLMIdRef.connection);
            this.inputLLMId = inputLLMIdRef.withOtherConnection(newConnection).encodeToId();
            remappedConnections = true;
        }
        if (replacements.containsKey(this.connection)) {
            this.connection = replacements.get(this.connection);
        }
        return remappedConnections;
    }
}

