/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.model;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.utils.ErrorContext;
import java.util.ArrayList;
import java.util.List;

public class ParameterChecks {
    private List<InfoMessage> messages = new ArrayList<InfoMessage>();

    public List<InfoMessage> getMessages() {
        return this.messages;
    }

    public void addWarning(String title, String details) {
        this.messages.add(InfoMessage.warning((String)title, (String)details));
    }

    public void addError(String title, String details) {
        this.messages.add(InfoMessage.fatal((String)title, (String)details));
    }

    public void checkAllPositive(int[] arr, String msg) {
        ErrorContext.checkNotEmpty((int[])arr, (String)msg);
        for (int e : arr) {
            ErrorContext.check((e > 0 ? 1 : 0) != 0, (String)msg);
        }
    }

    public void checkAllPositive(float[] arr, String msg) {
        ErrorContext.checkNotEmpty((float[])arr, (String)msg);
        for (float e : arr) {
            ErrorContext.check((e > 0.0f ? 1 : 0) != 0, (String)msg);
        }
    }

    public void checkAllStrictlyBetween(double[] arr, double min, double max, String msg) {
        ErrorContext.checkNotEmpty((double[])arr, (String)msg);
        for (double e : arr) {
            this.checkStrictlyBetween(e, min, max, msg);
        }
    }

    public void checkPositive(double x, String msg) {
        ErrorContext.check((x > 0.0 ? 1 : 0) != 0, (String)msg);
    }

    public void checkNonNegative(double x, String msg) {
        ErrorContext.check((x >= 0.0 ? 1 : 0) != 0, (String)msg);
    }

    public void checkBetween(double x, double min, double max, String msg) {
        ErrorContext.check((x >= min && x <= max ? 1 : 0) != 0, (String)msg);
    }

    public void checkStrictlyBetween(double x, double min, double max, String msg) {
        ErrorContext.check((x > min && x < max ? 1 : 0) != 0, (String)msg);
    }

    public void checkEquals(int x, int value, String msg) {
        ErrorContext.check((x == value ? 1 : 0) != 0, (String)msg);
    }

    public void check(boolean cond, String msg) {
        ErrorContext.check((boolean)cond, (String)msg);
    }
}

