/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.model.core;

import com.dataiku.dip.analysis.model.clustering.ResolvedClusteringPreprocessingParams;
import com.dataiku.dip.analysis.model.prediction.ResolvedCausalPredictionPreprocessingParams;
import com.dataiku.dip.analysis.model.prediction.ResolvedClassicalPredictionPreprocessingParams;
import com.dataiku.dip.analysis.model.prediction.ResolvedPredictionPreprocessingParams;
import com.dataiku.dip.analysis.model.prediction.ResolvedTimeseriesForecastingPreprocessingParams;
import com.dataiku.dip.analysis.model.preprocessing.FeatureGenerationParams;
import com.dataiku.dip.analysis.model.preprocessing.FeaturePreprocessingParams;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class ResolvedPreprocessingParams {
    public boolean skipPreprocessing = false;
    public Map<String, FeaturePreprocessingParams> per_feature;
    public ReductionParams reduce;
    public FeatureGenerationParams feature_generation = new FeatureGenerationParams();

    public abstract List<FeaturePreprocessingParams.Role> skippableRolesForScoring();

    public Set<String> getUsedConnections() {
        return this.per_feature.values().stream().map(FeaturePreprocessingParams::getUsedConnection).flatMap(Optional::stream).collect(Collectors.toSet());
    }

    public boolean remapConnections(Map<String, String> replacements) {
        boolean remappedConnections = false;
        for (FeaturePreprocessingParams featurePreprocessingParams : this.per_feature.values()) {
            if (!featurePreprocessingParams.replaceConnections(replacements)) continue;
            remappedConnections = true;
        }
        return remappedConnections;
    }

    static {
        JSON.registerAdapter(ResolvedPreprocessingParams.class, (Object)new JSON.Adapter<ResolvedPreprocessingParams>(){

            public ResolvedPreprocessingParams deserialize(JsonElement jsonElement, Type scriptType, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
                JsonObject jsonObj = jsonElement.getAsJsonObject();
                if (jsonObj.has("target_remapping")) {
                    if (jsonObj.has("timeseriesSampling")) {
                        return (ResolvedPreprocessingParams)jsonDeserializationContext.deserialize(jsonElement, ResolvedTimeseriesForecastingPreprocessingParams.class);
                    }
                    if (jsonObj.has("treatment_variable")) {
                        return (ResolvedPreprocessingParams)jsonDeserializationContext.deserialize(jsonElement, ResolvedCausalPredictionPreprocessingParams.class);
                    }
                    if (jsonObj.has("feature_selection_params")) {
                        return (ResolvedPreprocessingParams)jsonDeserializationContext.deserialize(jsonElement, ResolvedClassicalPredictionPreprocessingParams.class);
                    }
                    return (ResolvedPreprocessingParams)jsonDeserializationContext.deserialize(jsonElement, ResolvedPredictionPreprocessingParams.class);
                }
                return (ResolvedPreprocessingParams)jsonDeserializationContext.deserialize(jsonElement, ResolvedClusteringPreprocessingParams.class);
            }

            public JsonElement serialize(ResolvedPreprocessingParams params, Type type, JsonSerializationContext ctx) {
                return ctx.serialize((Object)params);
            }
        });
    }

    public static class ReductionParams {
        public boolean enabled;
        public float kept_variance;
    }
}

