/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.model.prediction.algorithms.python;

import com.dataiku.dip.analysis.model.ModelTrainInfo;
import com.dataiku.dip.analysis.model.core.WorkSet;
import com.dataiku.dip.analysis.model.prediction.CategoricalHyperparameterDimension;
import com.dataiku.dip.analysis.model.prediction.PostTrainPredictionModelingParams;
import com.dataiku.dip.analysis.model.prediction.PreTrainPredictionModelingParams;
import com.dataiku.dip.analysis.model.prediction.PredictionMLTask;
import com.dataiku.dip.analysis.model.prediction.PredictionModelingParams;
import com.dataiku.dip.analysis.model.prediction.PredictionParameterChecks;
import com.dataiku.dip.analysis.model.prediction.algorithms.python.PyMemoryAlgorithmMeta;
import java.util.Collections;
import java.util.List;

public class GluonTSTorchDeepARMeta
extends PyMemoryAlgorithmMeta {
    @Override
    public String generateName(PreTrainPredictionModelingParams usedToTrain) {
        return "DeepAR - Torch";
    }

    @Override
    public ModelTrainInfo.PreSearchDescription generatePreTrainDescription(PreTrainPredictionModelingParams rpmp) {
        PredictionModelingParams.GluonTSTorchDeepARSpace space = rpmp.gluonts_torch_deepar_timeseries_grid;
        ModelTrainInfo.PreSearchDescription description = new ModelTrainInfo.PreSearchDescription(rpmp).withGridLength(this.getSearchSize(rpmp.grid_search_params, space)).withMVParam("Learning rate", space.learning_rate).withMVParam("Nb. RNN layers", space.num_layers).withMVParam("Nb. cells per layer", space.num_cells).withMVParam("Weight decay", space.weight_decay).withMVParam("Dropout rate", space.dropout_rate);
        if (!space.full_context) {
            description = description.withMVParam("Context length", space.context_length);
        }
        return description;
    }

    @Override
    public ModelTrainInfo.PostSearchDescription generatePostTrainDescription(ModelTrainInfo.PreSearchDescription descBefore, PreTrainPredictionModelingParams before, PostTrainPredictionModelingParams after) {
        PredictionModelingParams.GluonTSTorchDeepARSpace space = before.gluonts_torch_deepar_timeseries_grid;
        PostTrainPredictionModelingParams.GluonTSTorchDeepARParams params = after.gluonts_torch_deepar_timeseries_params;
        ModelTrainInfo.PostSearchDescription description = new ModelTrainInfo.PostSearchDescription().withSVParam("Learning rate", params.learning_rate).withSVParam("Nb. RNN layers", params.num_layers).withSVParam("Nb. cells per layer", params.num_cells).withSVParam("Dropout rate", params.dropout_rate).withSVParam("Weight decay", params.weight_decay).withSVParam("Epochs", params.epochs);
        if (!space.full_context) {
            description = description.withSVParam("Context length", params.context_length);
        }
        return description;
    }

    @Override
    public void validateParameters(PredictionModelingParams pmp, PredictionMLTask.TabularPredictionMLTask task, PredictionParameterChecks checks) {
        PredictionModelingParams.GluonTSTorchDeepARSpace space = pmp.gluonts_torch_deepar_timeseries;
        if (space == null || !space.enabled) {
            return;
        }
        checks.checkPositive(space.patience, "Patience must be positive (DeepAR)");
        if (!space.full_context) {
            checks.checkNumericalDimension(space.context_length, "Context length (DeepAR)");
        }
        checks.checkNumericalDimension(space.learning_rate, "Learning rate (DeepAR)");
        checks.checkNumericalDimension(space.num_layers, "Number of RNN layers (DeepAR)");
        checks.checkNumericalDimension(space.num_cells, "Number of RNN cells for each layer (DeepAR)");
        checks.checkNumericalDimension(space.dropout_rate, "Dropout regularization parameter (DeepAR)");
        checks.checkNumericalDimension(space.weight_decay, "Weight Decay (DeepAR)");
    }

    @Override
    public List<WorkSet.ModelingSet> expandModeling(PredictionModelingParams pmp, PredictionMLTask.TabularPredictionMLTask task, int gsFolds) {
        PredictionModelingParams.GluonTSTorchDeepARSpace space = pmp.gluonts_torch_deepar_timeseries;
        if (space == null || !space.enabled) {
            return Collections.emptyList();
        }
        PreTrainPredictionModelingParams preTrainParams = new PreTrainPredictionModelingParams(PreTrainPredictionModelingParams.Algorithm.GLUONTS_TORCH_DEEPAR, pmp);
        preTrainParams.gluonts_torch_deepar_timeseries_grid = space;
        preTrainParams.gridLength = this.getSearchSize(preTrainParams.grid_search_params, space);
        WorkSet.ModelingSet modelingSet = new WorkSet.ModelingSet(preTrainParams);
        if (preTrainParams.gridLength > 1) {
            modelingSet.estimatedTrains = preTrainParams.gridLength * gsFolds + 1;
        }
        return Collections.singletonList(modelingSet);
    }

    @Override
    public PreTrainPredictionModelingParams regridifyToPreTrain(PostTrainPredictionModelingParams optimized, PreTrainPredictionModelingParams usedToTrain) {
        PostTrainPredictionModelingParams.GluonTSTorchDeepARParams optimizedParameters = optimized.gluonts_torch_deepar_timeseries_params;
        PreTrainPredictionModelingParams preTrainParams = this.getCopyWithGridStrategy(usedToTrain);
        PredictionModelingParams.GluonTSTorchDeepARSpace space = preTrainParams.gluonts_torch_deepar_timeseries_grid;
        if (!preTrainParams.gluonts_torch_deepar_timeseries_grid.full_context) {
            space.context_length.setToSingleValueGrid(optimizedParameters.context_length);
        }
        space.learning_rate.setToSingleValueGrid(optimizedParameters.learning_rate);
        space.distr_output = CategoricalHyperparameterDimension.create(optimizedParameters.distr_output, "StudentTOutput");
        space.num_layers.setToSingleValueGrid(optimizedParameters.num_layers);
        space.num_cells.setToSingleValueGrid(optimizedParameters.num_cells);
        space.dropout_rate.setToSingleValueGrid(optimizedParameters.dropout_rate);
        space.weight_decay.setToSingleValueGrid(optimizedParameters.weight_decay);
        return preTrainParams;
    }

    @Override
    public void regridifyToMLTask(PredictionModelingParams target, PostTrainPredictionModelingParams optimized, PreTrainPredictionModelingParams usedToTrain) {
        PreTrainPredictionModelingParams preTrainParams = this.regridifyToPreTrain(optimized, usedToTrain);
        target.gluonts_torch_deepar_timeseries = preTrainParams.gluonts_torch_deepar_timeseries_grid;
        target.gluonts_torch_deepar_timeseries.enabled = true;
    }

    @Override
    public void refreshMLTask(PredictionModelingParams target, PreTrainPredictionModelingParams usedToTrain) {
        target.gluonts_torch_deepar_timeseries = usedToTrain.gluonts_torch_deepar_timeseries_grid;
        target.gluonts_torch_deepar_timeseries.enabled = true;
    }

    @Override
    public boolean hasProbabilities(PreTrainPredictionModelingParams usedToTrain) {
        return true;
    }

    @Override
    protected int getGridLength(PredictionModelingParams.HyperparametersSpace space) {
        PredictionModelingParams.GluonTSTorchDeepARSpace gluonTSTorchDeepARSpace = (PredictionModelingParams.GluonTSTorchDeepARSpace)space;
        int gridLength = gluonTSTorchDeepARSpace.num_layers.getLength() * gluonTSTorchDeepARSpace.learning_rate.getLength() * gluonTSTorchDeepARSpace.distr_output.getLength() * gluonTSTorchDeepARSpace.num_layers.getLength() * gluonTSTorchDeepARSpace.num_cells.getLength() * gluonTSTorchDeepARSpace.dropout_rate.getLength() * gluonTSTorchDeepARSpace.weight_decay.getLength();
        if (!gluonTSTorchDeepARSpace.full_context) {
            gridLength *= gluonTSTorchDeepARSpace.context_length.getLength();
        }
        return gridLength;
    }
}

