/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.model.preprocessing;

import com.dataiku.dip.analysis.model.ParameterChecks;
import com.dataiku.dip.analysis.model.prediction.PredictionMLTask;
import com.dataiku.dip.analysis.model.preprocessing.FeaturePreprocessingParams;
import com.dataiku.dip.analysis.model.preprocessing.NumFeaturePreprocessingParams;
import com.dataiku.dip.analysis.model.preprocessing.PreprocessingParams;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;

public class FeatureGenerationParams {
    public PairwiseLinearCombinations pairwise_linear = new PairwiseLinearCombinations();
    public PolynomialCombinations polynomial_combinations = new PolynomialCombinations();
    public ManualPairwiseInteractions manual_interactions = new ManualPairwiseInteractions();
    public NumericalsClusteringGenerator numericals_clustering = new NumericalsClusteringGenerator();
    public CategoricalsCountTransformerGenerator categoricals_count_transformer = new CategoricalsCountTransformerGenerator();
    public Map<String, FeatureShiftsParams> shifts = new HashMap<String, FeatureShiftsParams>();
    public static final Set<WindowOperation> DEFAULT_OPERATIONS = EnumSet.of(WindowOperation.MEAN, WindowOperation.STD);
    public List<RollingWindowsParams> windows = new ArrayList<RollingWindowsParams>();

    public static ArrayList<WindowOperationParam> createWindowOperationParams(boolean withDefaultValues) {
        ArrayList<WindowOperationParam> operationList = new ArrayList<WindowOperationParam>();
        for (WindowOperation operation : WindowOperation.values()) {
            operationList.add(new WindowOperationParam(operation, withDefaultValues && DEFAULT_OPERATIONS.contains((Object)operation)));
        }
        return operationList;
    }

    public void validate(ParameterChecks checks, PreprocessingParams params) {
        this.validateInteractions(checks, params);
        this.validateNumericalCombinations(checks, params);
    }

    public void validateWindows(ParameterChecks checks, List<String> warnings, PreprocessingParams params, PredictionMLTask.TimeseriesForecastingMLTask task) {
        if (null == params.feature_generation.windows || params.feature_generation.windows.isEmpty()) {
            return;
        }
        Set<String> selectedWindowableFeatures = this.getWindowableFeatures(params);
        List<RollingWindowsParams> windows = params.feature_generation.windows;
        for (int windowIndex = 0; windowIndex < windows.size(); ++windowIndex) {
            RollingWindowsParams window = windows.get(windowIndex);
            String windowName = String.format("Window %d", windowIndex + 1);
            checks.checkPositive(window.length - 1, String.format("%s - Length must be at least 2 timesteps.", windowName));
            if (window.is_from_forecast) {
                FeatureGenerationParams.checkForecastShift(warnings, String.format("%s - Window end", windowName), window.shift);
            } else {
                boolean allKnownInAdvance = true;
                for (String featureName : window.operations_map.keySet()) {
                    if (params.per_feature.get((Object)featureName).role == FeaturePreprocessingParams.Role.INPUT || !window.operations_map.get(featureName).stream().anyMatch(x -> x.enabled)) continue;
                    allKnownInAdvance = false;
                    break;
                }
                FeatureGenerationParams.checkHorizonShift(warnings, String.format("%s - Window end", windowName), allKnownInAdvance ? FeaturePreprocessingParams.Role.INPUT : FeaturePreprocessingParams.Role.INPUT_PAST_ONLY, window.shift, task.predictionLength);
            }
            if (FeatureGenerationParams.windowHasOperationEnabled(window, selectedWindowableFeatures)) continue;
            warnings.add(String.format("%s - Does not perform any operations.", windowName));
        }
    }

    public void validateShifts(List<String> warnings, PreprocessingParams params, PredictionMLTask.TimeseriesForecastingMLTask task) {
        if (null == params.feature_generation.shifts || params.feature_generation.shifts.isEmpty()) {
            return;
        }
        Set<String> selectedShiftableFeatures = this.getShiftableFeatures(params);
        for (Map.Entry<String, FeatureShiftsParams> shiftEntry : params.feature_generation.shifts.entrySet()) {
            String featureName = shiftEntry.getKey();
            FeatureShiftsParams shifts = shiftEntry.getValue();
            FeaturePreprocessingParams.Role role = params.per_feature.get((Object)featureName).role;
            if (!selectedShiftableFeatures.contains(featureName)) continue;
            for (Integer forecastShift : shifts.from_forecast) {
                FeatureGenerationParams.checkForecastShift(warnings, String.format("%s - Shift %s", featureName, forecastShift), forecastShift);
            }
            for (Integer horizonShift : shifts.from_horizon) {
                FeatureGenerationParams.checkHorizonShift(warnings, String.format("%s - Shift %s", featureName, horizonShift), role, horizonShift, task.predictionLength);
            }
        }
    }

    public void checkAtLeastOneWindowOrShift(List<String> warnings, PreprocessingParams params) {
        Set<String> selectedWindowableFeatures = this.getWindowableFeatures(params);
        boolean atLeastOneGeneratedFeature = params.feature_generation.windows.stream().anyMatch(window -> FeatureGenerationParams.windowHasOperationEnabled(window, selectedWindowableFeatures));
        Set<String> selectedShiftableFeatures = this.getShiftableFeatures(params);
        if (!atLeastOneGeneratedFeature) {
            for (Map.Entry<String, FeatureShiftsParams> shiftsEntry : params.feature_generation.shifts.entrySet()) {
                boolean hasShiftConfigured;
                String feature = shiftsEntry.getKey();
                boolean bl = hasShiftConfigured = !shiftsEntry.getValue().from_forecast.isEmpty() || !shiftsEntry.getValue().from_horizon.isEmpty();
                if (!selectedShiftableFeatures.contains(feature) || !hasShiftConfigured) continue;
                atLeastOneGeneratedFeature = true;
                break;
            }
        }
        if (!atLeastOneGeneratedFeature) {
            warnings.add("One of the selected algorithms require at least one generated feature (shift or window).");
        }
    }

    private static void checkForecastShift(List<String> warnings, String featureString, int forecastShift) {
        if (forecastShift > 0) {
            warnings.add(String.format("%s from forecast origin must not be in the future.", featureString));
        }
    }

    private static void checkHorizonShift(List<String> warnings, String featureString, FeaturePreprocessingParams.Role role, Integer horizonShift, long predictionLength) {
        if (role == FeaturePreprocessingParams.Role.INPUT_PAST_ONLY || role == FeaturePreprocessingParams.Role.TARGET) {
            if ((long)horizonShift.intValue() > -predictionLength) {
                warnings.add(String.format("%s from forecasted point must be smaller or equal to -%s (prediction length).", featureString, predictionLength));
            }
        } else if (role == FeaturePreprocessingParams.Role.INPUT && horizonShift > 0) {
            warnings.add(String.format("%s from forecast origin must be negative or zero.", featureString));
        }
    }

    private static boolean windowHasOperationEnabled(RollingWindowsParams window, Set<String> selectedShiftAndWindowsFeatures) {
        return window.operations_map.entrySet().stream().filter(windowEntry -> selectedShiftAndWindowsFeatures.contains(windowEntry.getKey())).anyMatch(windowEntry -> ((List)windowEntry.getValue()).stream().anyMatch(windowOperationParam -> windowOperationParam.enabled));
    }

    public Set<String> getShiftableFeatures(PreprocessingParams params) {
        if (params.per_feature == null) {
            return Collections.emptySet();
        }
        return params.per_feature.entrySet().stream().filter(entry -> FeatureGenerationParams.isShiftCompatible((FeaturePreprocessingParams)entry.getValue())).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    public Set<String> getWindowableFeatures(PreprocessingParams params) {
        if (params.per_feature == null) {
            return Collections.emptySet();
        }
        return params.per_feature.entrySet().stream().filter(entry -> FeatureGenerationParams.isWindowCompatible((FeaturePreprocessingParams)entry.getValue())).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    private static boolean isWindowCompatible(FeaturePreprocessingParams featureParams) {
        return FeatureGenerationParams.isShiftCompatible(featureParams) && FeatureGenerationParams.isNumericalWithoutHandling(featureParams);
    }

    private static boolean isShiftCompatible(FeaturePreprocessingParams featureParams) {
        return featureParams.role != null && FeatureGenerationParams.isInputOrTarget(featureParams);
    }

    private static boolean isInputOrTarget(FeaturePreprocessingParams featureParams) {
        return featureParams.role.isInput() || featureParams.role == FeaturePreprocessingParams.Role.TARGET;
    }

    private static boolean isNumericalWithoutHandling(FeaturePreprocessingParams featureParams) {
        if (featureParams.type == FeaturePreprocessingParams.FeatureType.NUMERIC && featureParams instanceof NumFeaturePreprocessingParams) {
            NumFeaturePreprocessingParams numFeatureParams = (NumFeaturePreprocessingParams)featureParams;
            return numFeatureParams.numerical_handling == null || numFeatureParams.numerical_handling == NumFeaturePreprocessingParams.NumericalHandlingMethod.REGULAR;
        }
        return false;
    }

    private void validateNumericalCombinations(ParameterChecks checks, PreprocessingParams params) {
        long genNumComb = 0L;
        if (this.pairwise_linear.behavior == GeneratorBehavior.ENABLED_MANUAL || this.polynomial_combinations.behavior == GeneratorBehavior.ENABLED_MANUAL) {
            long n = 0L;
            for (FeaturePreprocessingParams fpp : params.per_feature.values()) {
                if (!fpp.type.equals((Object)FeaturePreprocessingParams.FeatureType.NUMERIC)) continue;
                ++n;
            }
            if (n >= 2L) {
                n = n * (n - 1L) / 2L;
                if (this.pairwise_linear.behavior == GeneratorBehavior.ENABLED_MANUAL) {
                    genNumComb += n * 2L;
                }
                if (this.polynomial_combinations.behavior == GeneratorBehavior.ENABLED_MANUAL) {
                    genNumComb += n;
                }
                if (genNumComb > 1000L) {
                    checks.addWarning("Generated many features", "You have enabled feature generation that adds " + genNumComb + " features.");
                }
            }
        }
    }

    private void validateInteractions(ParameterChecks checks, PreprocessingParams params) {
        HashSet<CallSite> dupset = new HashSet<CallSite>();
        for (FeatureInteraction fi : this.manual_interactions.interactions) {
            Logger.getLogger(this.getClass()).info((Object)("Analyzing interaction : " + fi.column_1 + " " + fi.column_2));
            if (fi.column_1 == null || fi.column_2 == null) {
                checks.addError("Missing column name in feature interaction", "Missing column name in feature interaction");
                continue;
            }
            if (params.per_feature.get((Object)fi.column_1).role == FeaturePreprocessingParams.Role.REJECT || params.per_feature.get((Object)fi.column_2).role == FeaturePreprocessingParams.Role.REJECT) {
                checks.addError("Invalid interaction", "Cannot use a rejected feature in an interaction");
            }
            if (fi.column_1.equals(fi.column_2)) {
                checks.addError("Invalid interaction", "Cannot use the same feature twice in an interaction.");
            }
            String a = fi.column_1 + "__join__" + fi.column_2;
            String b = fi.column_2 + "__join__" + fi.column_1;
            if (dupset.contains(a) || dupset.contains(b)) {
                checks.addError("Redundant interaction", "Interaction between " + fi.column_1 + " and " + fi.column_2 + " is defined twice.");
            }
            dupset.add((CallSite)((Object)a));
            dupset.add((CallSite)((Object)b));
        }
    }

    public static class PairwiseLinearCombinations
    extends AutomatizableFeatureGenerator {
    }

    public static class PolynomialCombinations
    extends AutomatizableFeatureGenerator {
    }

    public static class ManualPairwiseInteractions {
        public List<FeatureInteraction> interactions = new ArrayList<FeatureInteraction>();
    }

    public static class NumericalsClusteringGenerator
    extends AutomatizableFeatureGenerator {
        public int k;
        public TransformationMode transformation_mode;
        public boolean all_features;
        public List<String> input_features = new ArrayList<String>();

        public static enum TransformationMode {
            REPLACE_BY_DISTANCE,
            IMPACT_CODE_CLUSTERID,
            DUMMIFY_CLUSTERID;

        }
    }

    public static class CategoricalsCountTransformerGenerator
    extends AutomatizableFeatureGenerator {
        public boolean all_features;
        public List<String> input_features = new ArrayList<String>();
    }

    public static enum WindowOperation {
        MEAN,
        MEDIAN,
        STD,
        MIN,
        MAX;

    }

    public static class WindowOperationParam {
        WindowOperation operation;
        boolean enabled;

        public WindowOperationParam(WindowOperation operation, boolean enabled) {
            this.operation = operation;
            this.enabled = enabled;
        }
    }

    public static class RollingWindowsParams {
        public int length;
        public int shift;
        public boolean is_from_forecast;
        public Map<String, List<WindowOperationParam>> operations_map = new HashMap<String, List<WindowOperationParam>>();
    }

    public static class FeatureShiftsParams {
        public List<Integer> from_forecast = new ArrayList<Integer>();
        public List<Integer> from_horizon = new ArrayList<Integer>();
    }

    public static enum GeneratorBehavior {
        DISABLED,
        ENABLED_AUTOMATIC,
        ENABLED_MANUAL;

    }

    public static class FeatureInteraction {
        public String column_1;
        public String column_2;
        public int max_features;
        public boolean rescale;
    }

    public static class AutomatizableFeatureGenerator {
        public GeneratorBehavior behavior = GeneratorBehavior.DISABLED;
    }
}

