/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.cli;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.cli.CLICommandWithInvalidateCommonFilesCache;
import com.dataiku.dip.cli.CLISetup;
import com.dataiku.dip.cli.DKU;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.logging.MainLoggingConfigurator;
import com.dataiku.dip.security.model.GlobalScopePublicAPIKey;
import com.dataiku.dip.security.model.PersonalPublicAPIKey;
import com.dataiku.dip.security.model.ProjectScopePublicAPIKey;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.util.HashUtils;
import com.dataiku.dip.util.JsonUtils;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.lambda.model.serverconfig.LambdaServerConfig;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.cli.Options;
import org.apache.commons.lang.StringUtils;

public class EnableHashedApiKeysCommand
extends CLICommandWithInvalidateCommonFilesCache {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.cli.enableHashedApiKeys");

    @Override
    public String usageString() {
        return "enable-hashed-api-keys";
    }

    @Override
    public String description() {
        return "Enables the hashing of API keys and hashes any API keys that are not already hashed";
    }

    @Override
    public Options opts() {
        Options options = new Options();
        DKU.addGlobalOptions(options);
        return options;
    }

    @Override
    public int execute(String[] args) throws Exception {
        this.parseAndMiniSetup(args, this.usageString(), true);
        ApplicationConfigurator.setProcessType((MainLoggingConfigurator.ProcessType)MainLoggingConfigurator.ProcessType.DKU);
        CLISetup.doSpringUtilsAndCoreServicesSetupForTestsAndCLI();
        if (ApplicationConfigurator.getNodeType() == ApplicationConfigurator.DSSNodeType.API) {
            try {
                File apiNodeRootDir = new File(ApplicationConfigurator.getBaseFolder());
                File configFile = DKUFileUtils.getWithin((File)apiNodeRootDir, (String[])new String[]{"config", "server.json"});
                if (configFile.exists()) {
                    LambdaServerConfig config = (LambdaServerConfig)JSON.parseFile((File)configFile, LambdaServerConfig.class);
                    if (!config.hashApiKeys) {
                        logger.info((Object)"Enabling hashed admin API keys");
                        config.hashApiKeys = true;
                        JSON.prettyToFile((Object)config, (File)configFile);
                    } else {
                        logger.info((Object)"Hashed admin API keys already enabled");
                    }
                } else {
                    logger.warn((Object)"Unable to find config/server.json");
                }
                logger.info((Object)"Hashing admin API keys");
                File keysFile = DKUFileUtils.getWithin((File)apiNodeRootDir, (String[])new String[]{"config", "adminkeys.json"});
                if (keysFile.exists()) {
                    JsonObject keysJson = (JsonObject)JSON.parseFile((File)keysFile, JsonObject.class);
                    for (JsonElement keyElement : JsonUtils.getOrEmptyArr(keysJson, "keys")) {
                        String keyString;
                        JsonObject key = keyElement.getAsJsonObject();
                        JsonElement jsonElement = key.get("key");
                        if (jsonElement == null || !StringUtils.isNotBlank((String)(keyString = jsonElement.getAsString()))) continue;
                        key.addProperty("key", this.hashIfNotHashed(keyString));
                    }
                    JSON.prettyToFile((Object)keysJson, (File)keysFile);
                }
            }
            catch (Exception e) {
                logger.warn((Object)"Unable to read and hash API node admin keys", (Throwable)e);
            }
        } else {
            TransactionService transactionService = (TransactionService)SpringUtils.getBean(TransactionService.class);
            try (RWTransaction rwt = transactionService.beginWriteAsDSS();){
                String keyBefore;
                Object list;
                boolean didSomething = false;
                GeneralSettingsDAO.GeneralSettings gs = (GeneralSettingsDAO.GeneralSettings)rwt.readObject("general-settings.json", GeneralSettingsDAO.GeneralSettings.class);
                if (!gs.security.hashApiKeys) {
                    logger.info((Object)"Enabling hashed public API keys");
                    gs.security.hashApiKeys = true;
                    rwt.writeObject("general-settings.json", (Object)gs);
                    didSomething = true;
                } else {
                    logger.info((Object)"Hashed public API keys already enabled");
                }
                logger.info((Object)"Hashing public API keys");
                try {
                    RelFile globalFile = RelFile.global((String)"public-apikeys.json");
                    if (rwt.exists(globalFile)) {
                        list = (GlobalScopePublicAPIKey.KeyList)rwt.readObject(globalFile, GlobalScopePublicAPIKey.KeyList.class);
                        Iterator<Object> key = ((ArrayList)list).iterator();
                        while (key.hasNext()) {
                            GlobalScopePublicAPIKey globalScopePublicAPIKey = (GlobalScopePublicAPIKey)((Object)key.next());
                            keyBefore = globalScopePublicAPIKey.key;
                            globalScopePublicAPIKey.key = this.hashIfNotHashed(keyBefore);
                            if (keyBefore == null || keyBefore.equals(globalScopePublicAPIKey.key)) continue;
                            didSomething = true;
                        }
                        rwt.writeObject(globalFile, list);
                    }
                }
                catch (Exception e) {
                    logger.warn((Object)"Unable to read and hash global API keys", (Throwable)e);
                }
                try {
                    RelFile personalFile = RelFile.global((String)"personal-apikeys.json");
                    if (rwt.exists(personalFile)) {
                        list = (PersonalPublicAPIKey.ListFile)rwt.readObject(personalFile, PersonalPublicAPIKey.ListFile.class);
                        for (PersonalPublicAPIKey personalPublicAPIKey : ((PersonalPublicAPIKey.ListFile)list).keys) {
                            keyBefore = personalPublicAPIKey.key;
                            personalPublicAPIKey.key = this.hashIfNotHashed(keyBefore);
                            if (keyBefore == null || keyBefore.equals(personalPublicAPIKey.key)) continue;
                            didSomething = true;
                        }
                        rwt.writeObject(personalFile, list);
                    }
                }
                catch (Exception e) {
                    logger.warn((Object)"Unable to read and hash personal API keys", (Throwable)e);
                }
                for (String projectKey : CLISetup.listProjectKeys()) {
                    try {
                        RelFile projectFile = new RelFile(new String[]{"projects", projectKey, "apikeys.json"});
                        if (!rwt.isFile(projectFile)) continue;
                        ProjectScopePublicAPIKey.KeyList keyList = (ProjectScopePublicAPIKey.KeyList)rwt.readObject(projectFile, ProjectScopePublicAPIKey.KeyList.class);
                        for (ProjectScopePublicAPIKey key : keyList) {
                            String keyBefore2 = key.key;
                            key.key = this.hashIfNotHashed(keyBefore2);
                            if (keyBefore2 == null || keyBefore2.equals(key.key)) continue;
                            didSomething = true;
                        }
                        rwt.writeObject(projectFile, (Object)keyList);
                    }
                    catch (Exception e) {
                        logger.warn((Object)("Failed to read and hash project keys for " + projectKey), (Throwable)e);
                    }
                }
                if (didSomething) {
                    rwt.commit("Hash public API keys");
                }
            }
        }
        logger.info((Object)"Done hashing public API keys");
        return 0;
    }

    private String hashIfNotHashed(String key) {
        if (StringUtils.isNotBlank((String)key) && !key.startsWith("sha256:")) {
            return HashUtils.sha256WithSalt((String)key);
        }
        return key;
    }

    @Override
    protected boolean warnIfCacheInvalidationFails() {
        return false;
    }

    @Override
    void onPostExecute() {
        if (ApplicationConfigurator.getNodeType() != ApplicationConfigurator.DSSNodeType.API) {
            super.onPostExecute();
        }
    }
}

