/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.cli.internalcmd;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.cli.CLICommand;
import com.dataiku.dip.cli.CLISetup;
import com.dataiku.dip.cli.DKU;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.FsConnection;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dao.UsersDAO;
import com.dataiku.dip.dao.impl.FilesBasedUsersDAO;
import com.dataiku.dip.security.ConfigFileSymmetricKeyBasedPasswordEncryptionProvider;
import com.dataiku.dip.security.RegularPasswordEncryptionService;
import com.dataiku.dip.security.audit.model.Log4JTargetSettings;
import com.dataiku.dip.security.auth.UserSourceType;
import com.dataiku.dip.security.model.GlobalScopePublicAPIKey;
import com.dataiku.dip.server.SharedSecretUtils;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.utils.DKUFileUtils;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.cli.Options;

public class InitialSetupHome
extends CLICommand {
    @Override
    public String usageString() {
        return "__initial-setup-home";
    }

    @Override
    public String description() {
        return "populate a default DIP_HOME repository";
    }

    @Override
    public Options opts() {
        Options options = new Options();
        DKU.addGlobalOptions(options);
        return options;
    }

    @Override
    public int execute(String[] args) throws Exception {
        String[] subdirs;
        this.parseAndMiniSetup(args, "__initial-setup-home", false);
        ApplicationConfigurator.autoconfigure();
        CLISetup.doSpringUtilsAndCoreServicesSetupForTestsAndCLI();
        for (String s : subdirs = new String[]{"analysis-data", "caches", "config/projects", "config/ipython_notebooks", "databases", "data-catalog", "exports/data", "exports/jupyter-notebooks", "exports/rmarkdown-reports", "html-apps", "jobs", "jupyter-run/jupyter/runtime", "jupyter-run/dku-workdirs", "lib", "local", "managed_datasets", "managed_folders", "notebook_results", "plugins", "privtmp", "run", "saved_models", "model_evaluation_stores", "timelines", "tmp", "uploads", "workload-folders", "R.lib"}) {
            File f = ApplicationConfigurator.getFile((String)s);
            DKUFileUtils.mkdirs((File)f);
        }
        File f = new File(ApplicationConfigurator.getBaseFolderF(), "config/license.json");
        boolean alreadyHasALicense = f.isFile();
        TransactionService ts = (TransactionService)SpringUtils.getBean(TransactionService.class);
        try (RWTransaction t = ts.beginWriteAsDSS();){
            GeneralSettingsDAO.GeneralSettings gs = new GeneralSettingsDAO.GeneralSettings();
            Log4JTargetSettings l4t = new Log4JTargetSettings();
            l4t.appendTopicToLogger = true;
            gs.auditTrailSettings.targets.add(l4t);
            t.writeObject("general-settings.json", (Object)gs);
            t.writeObject("public-apikeys.json", (Object)new GlobalScopePublicAPIKey.KeyList());
            HashMap<String, DSSConnection> connections = new HashMap<String, DSSConnection>();
            FsConnection root = new FsConnection();
            root.name = "filesystem_root";
            root.params.root = "/";
            root.allowManagedDatasets = false;
            root.allowWrite = false;
            connections.put("filesystem_root", root);
            FsConnection managed = new FsConnection();
            managed.name = "filesystem_managed";
            managed.params.root = "${dip.home}/managed_datasets";
            managed.allowManagedFolders = false;
            connections.put("filesystem_managed", managed);
            FsConnection folders = new FsConnection();
            folders.name = "filesystem_folders";
            folders.params.root = "${dip.home}/managed_folders";
            folders.allowManagedDatasets = false;
            connections.put("filesystem_folders", folders);
            ConnectionsDAO connectionsDAO = ConnectionsDAO.get();
            connectionsDAO.writeList(connections);
            ConfigFileSymmetricKeyBasedPasswordEncryptionProvider.generateDefaultKey();
            RegularPasswordEncryptionService symetricCryptoService = (RegularPasswordEncryptionService)SpringUtils.getBean(RegularPasswordEncryptionService.class);
            symetricCryptoService.reinit();
            FilesBasedUsersDAO ud = new FilesBasedUsersDAO();
            UsersDAO.Group administrators = ud.getDefaultAdminGroup(true);
            UsersDAO.Group dataScientists = ud.addGroup("data_team", UserSourceType.LOCAL);
            dataScientists.setMayWriteUnsafeCode(true);
            dataScientists.setMayWriteSafeCode(true);
            dataScientists.description = "Default group for read/write access to projects";
            ud.saveGroup(dataScientists);
            UsersDAO.Group viewers = ud.addGroup("readers", UserSourceType.LOCAL);
            viewers.description = "Default group for dashboard-only access";
            ud.saveGroup(viewers);
            String defaultProfile = System.getenv("DKU_INITIAL_SETUP_USER_PROFILE");
            if (defaultProfile == null) {
                defaultProfile = "DATA_SCIENTIST";
            }
            UsersDAO.User adminUser = ud.addUser("admin", "admin");
            adminUser.displayName = "Administrator";
            adminUser.userProfile = defaultProfile;
            adminUser.groups.add(administrators.name);
            ud.saveUser(adminUser);
            if (alreadyHasALicense) {
                UsersDAO.User viewerUser = ud.addUser("viewer", "viewer");
                viewerUser.displayName = "Sample business user";
                viewerUser.userProfile = defaultProfile;
                viewerUser.groups.add("readers");
                ud.saveUser(viewerUser);
            }
            GeneralSettingsDAO gsd = (GeneralSettingsDAO)SpringUtils.getBean(GeneralSettingsDAO.class);
            gs = gsd.read();
            GeneralSettingsDAO.GitEnforcedConfigurationRule rule = new GeneralSettingsDAO.GitEnforcedConfigurationRule();
            rule.withRemoteWhitelist(Sets.newHashSet((Object[])new String[]{"^(?:git|ssh|https?|git@[-\\w.]+):(\\/\\/)?(.*?)(\\.git)?(\\/?|\\#[-\\d\\w._]+?)$"}));
            gs.git.enforcedConfigurationRules.add(rule);
            gs.projectStatusList = new ArrayList<GeneralSettingsDAO.ProjectStatus>();
            gs.projectStatusList.add(GeneralSettingsDAO.DEFAULT_PROJECT_STATUS.SANDBOX.projectStatus);
            gs.projectStatusList.add(GeneralSettingsDAO.DEFAULT_PROJECT_STATUS.DRAFT.projectStatus);
            gs.projectStatusList.add(GeneralSettingsDAO.DEFAULT_PROJECT_STATUS.INUSE.projectStatus);
            gs.projectStatusList.add(GeneralSettingsDAO.DEFAULT_PROJECT_STATUS.INNPROD.projectStatus);
            gs.projectStatusList.add(GeneralSettingsDAO.DEFAULT_PROJECT_STATUS.ARCHIVED.projectStatus);
            gs.limits.memSampleBytes.soft = 0x6400000L;
            gs.limits.memSampleBytes.hard = 524288000L;
            gs.limits.shakerMemTableBytes.hard = 524288000L;
            gs.limits.sqlNotebookResultSetBytes.hard = 524288000L;
            gs.limits.sqlScenarioResultSetBytes.hard = 524288000L;
            if (ApplicationConfigurator.getNodeType() == ApplicationConfigurator.DSSNodeType.AUTOMATION) {
                gs.themeId = "dark";
                gs.nodeName = "Automation Node";
            }
            if ("false".equals(ApplicationConfigurator.getIniValue((String)"modules", (String)"projects"))) {
                gs.nodeName = "Deployer";
            }
            gsd.save(gs);
            t.commit("Welcome to DSS!");
            SharedSecretUtils.getSharedSecret((boolean)true);
            int n = 0;
            return n;
        }
    }
}

