/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.code;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.code.PythonCodeEnvPackagesUtils;
import com.dataiku.dip.utils.DKUtils;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public final class StandardPythonInterpreter
extends Enum<StandardPythonInterpreter> {
    public static final /* enum */ StandardPythonInterpreter PYTHON27 = new StandardPythonInterpreter(2, 7, 8);
    public static final /* enum */ StandardPythonInterpreter PYTHON34 = new StandardPythonInterpreter(3, 4, 9);
    public static final /* enum */ StandardPythonInterpreter PYTHON35 = new StandardPythonInterpreter(3, 5, 10);
    public static final /* enum */ StandardPythonInterpreter PYTHON36 = new StandardPythonInterpreter(3, 6, 6);
    public static final /* enum */ StandardPythonInterpreter PYTHON37 = new StandardPythonInterpreter(3, 7, 5);
    public static final /* enum */ StandardPythonInterpreter PYTHON38 = new StandardPythonInterpreter(3, 8, 4);
    public static final /* enum */ StandardPythonInterpreter PYTHON39 = new StandardPythonInterpreter(3, 9, 2);
    public static final /* enum */ StandardPythonInterpreter PYTHON310 = new StandardPythonInterpreter(3, 10, 3);
    public static final /* enum */ StandardPythonInterpreter PYTHON311 = new StandardPythonInterpreter(3, 11, 1);
    public static final /* enum */ StandardPythonInterpreter PYTHON312 = new StandardPythonInterpreter(3, 12, 7);
    public static final /* enum */ StandardPythonInterpreter PYTHON313 = new StandardPythonInterpreter(3, 13, 11);
    public static final /* enum */ StandardPythonInterpreter CUSTOM = new StandardPythonInterpreter(3, 11, 12);
    private final int major;
    private final int minor;
    @VisibleForTesting
    final int preferenceOrder;
    public final String prophetRequirement = "prophet>=1.1.1,<1.2";
    public final String cmdstanpyRequirement = "cmdstanpy<1.3";
    public final String itsdangerousRequirement = "itsdangerous<2.1.0";
    public final String werkzeugRequirement = "Werkzeug<3.1";
    public final String timmRequirement = "timm>=0.9,<0.10";
    public final String torchLinkRequirement = "--find-links https://download.pytorch.org/whl/torch_stable.html";
    public final String cpuTorchLinkRequirement = "--extra-index-url https://download.pytorch.org/whl/cpu";
    private static final /* synthetic */ StandardPythonInterpreter[] $VALUES;

    public static StandardPythonInterpreter[] values() {
        return (StandardPythonInterpreter[])$VALUES.clone();
    }

    public static StandardPythonInterpreter valueOf(String name) {
        return Enum.valueOf(StandardPythonInterpreter.class, name);
    }

    private StandardPythonInterpreter(int major, int minor, int preferenceOrder) {
        this.major = major;
        this.minor = minor;
        this.preferenceOrder = preferenceOrder;
    }

    public boolean isVersionLowerOrEqual(StandardPythonInterpreter otherInterpreter) {
        return this.major < otherInterpreter.major || this.major == otherInterpreter.major && this.minor <= otherInterpreter.minor;
    }

    public boolean isVersionGreaterOrEqual(StandardPythonInterpreter otherInterpreter) {
        return this.major > otherInterpreter.major || this.major == otherInterpreter.major && this.minor >= otherInterpreter.minor;
    }

    public boolean isInRange(StandardPythonInterpreter minBoundaryInclusive, StandardPythonInterpreter maxBoundaryExclusive) {
        return this.isVersionGreaterOrEqual(minBoundaryInclusive) && !this.isVersionGreaterOrEqual(maxBoundaryExclusive);
    }

    public String updateRequirement(String currentlyInstalledPackage) {
        String installedPackageName;
        if (currentlyInstalledPackage == null) {
            return "";
        }
        switch (installedPackageName = StringUtils.trim((String)currentlyInstalledPackage.split("[~<=>]")[0])) {
            case "h5py": {
                return this.h5pyRequirement();
            }
            case "lightgbm": {
                return this.lightGbmRequirement();
            }
            case "pillow": {
                return this.pillowRequirement();
            }
            case "statsmodels": {
                return this.statsmodelsRequirement();
            }
            case "tensorflow": {
                return this.tensorflowRequirement();
            }
        }
        return currentlyInstalledPackage;
    }

    public PythonCodeEnvPackagesUtils.PythonPackageVersion minSupportedVersion(String packageName) {
        return this.minSupportedVersionFromRequirement(this.getRequirement(packageName));
    }

    public PythonCodeEnvPackagesUtils.PythonPackageVersion minUnsupportedVersion(String packageName) {
        return this.minUnsupportedVersionFromRequirement(this.getRequirement(packageName));
    }

    private String getRequirement(String packageName) {
        switch (packageName) {
            case "cloudpickle": {
                return this.cloudpickleRequirement();
            }
            case "econml": {
                return this.econmlRequirement();
            }
            case "flask": {
                return this.flaskRequirement();
            }
            case "gluonts": {
                return this.gluontsRequirement();
            }
            case "h5py": {
                return this.h5pyRequirement();
            }
            case "itsdangerous": {
                return "itsdangerous<2.1.0";
            }
            case "Jinja2": {
                return this.jinja2Requirement();
            }
            case "lightgbm": {
                return this.lightGbmRequirement();
            }
            case "MarkupSafe": {
                return this.markupSafeRequirement();
            }
            case "mxnet": {
                return this.mxnetRequirement();
            }
            case "pillow": {
                return this.pillowRequirement();
            }
            case "pmdarima": {
                return this.pmdarimaRequirement();
            }
            case "prophet": {
                return "prophet>=1.1.1,<1.2";
            }
            case "sentence-transformers": {
                return this.sentenceTransformersRequirement();
            }
            case "skorch": {
                return this.skorchRequirement();
            }
            case "scipy": {
                return this.scipyRequirement();
            }
            case "statsmodels": {
                return this.statsmodelsRequirement();
            }
            case "scikit-learn": {
                return this.scikitLearnRequirement();
            }
            case "scikit-optimize": {
                return this.scikitOptRequirement();
            }
            case "tdigest": {
                return this.tdigestRequirement();
            }
            case "tensorflow": {
                return this.tensorflowRequirement();
            }
            case "timm": {
                return "timm>=0.9,<0.10";
            }
            case "torch": {
                return this.gpuTorchRequirement();
            }
            case "Werkzeug": {
                return "Werkzeug<3.1";
            }
            case "xgboost": {
                return this.xgboostRequirement();
            }
        }
        return null;
    }

    private PythonCodeEnvPackagesUtils.PythonPackageVersion minSupportedVersionFromRequirement(String packageRequirement) {
        if (packageRequirement == null) {
            return null;
        }
        Matcher packageVersionMatcher = Pattern.compile(">=\\s*([A-Za-z0-9][A-Za-z0-9_.*+!-]*)").matcher(packageRequirement);
        if (packageVersionMatcher.find()) {
            return PythonCodeEnvPackagesUtils.PythonPackageVersion.fromString(packageVersionMatcher.group(1));
        }
        packageVersionMatcher = Pattern.compile("==\\s*([A-Za-z0-9][A-Za-z0-9_.*+!-]*)").matcher(packageRequirement);
        if (packageVersionMatcher.find()) {
            return PythonCodeEnvPackagesUtils.PythonPackageVersion.fromString(packageVersionMatcher.group(1));
        }
        return null;
    }

    private PythonCodeEnvPackagesUtils.PythonPackageVersion minUnsupportedVersionFromRequirement(String packageRequirement) {
        if (packageRequirement == null) {
            return null;
        }
        Matcher packageVersionMatcher = Pattern.compile("<\\s*([A-Za-z0-9][A-Za-z0-9_.*+!-]*)").matcher(packageRequirement);
        if (packageVersionMatcher.find()) {
            return PythonCodeEnvPackagesUtils.PythonPackageVersion.fromString(packageVersionMatcher.group(1));
        }
        packageVersionMatcher = Pattern.compile("==\\s*([A-Za-z0-9][A-Za-z0-9_.*+!-]*)").matcher(packageRequirement);
        if (packageVersionMatcher.find()) {
            return this.nextNonBugfixVersion(PythonCodeEnvPackagesUtils.PythonPackageVersion.fromString(packageVersionMatcher.group(1)));
        }
        return null;
    }

    private PythonCodeEnvPackagesUtils.PythonPackageVersion nextNonBugfixVersion(PythonCodeEnvPackagesUtils.PythonPackageVersion version) {
        if (version.components.size() >= 2 && StringUtils.isNumeric((String)version.components.get(1))) {
            return PythonCodeEnvPackagesUtils.PythonPackageVersion.fromString(String.format("%s.%s", version.components.get(0), Integer.valueOf(version.components.get(1)) + 1));
        }
        if (version.components.size() == 1 && StringUtils.isNumeric((String)version.components.get(0))) {
            return PythonCodeEnvPackagesUtils.PythonPackageVersion.fromString(String.valueOf(Integer.valueOf(version.components.get(0)) + 1));
        }
        return null;
    }

    public String h5pyRequirement() {
        switch (this) {
            case PYTHON27: {
                return "h5py==2.10.0";
            }
            case PYTHON39: 
            case PYTHON310: 
            case PYTHON311: 
            case PYTHON312: 
            case PYTHON313: {
                return "h5py>=3.7,<3.14";
            }
        }
        return "h5py==3.1.0";
    }

    public String lightGbmRequirement() {
        if (this == PYTHON27) {
            return "lightgbm>=3.0,<3.1";
        }
        if (this.isVersionGreaterOrEqual(PYTHON37)) {
            return "lightgbm>=4.6,<4.7";
        }
        return "lightgbm>=3.2,<3.3";
    }

    public List<String> tensorflowSupportRequirements() {
        ArrayList<String> tensorflowRequirements = new ArrayList<String>();
        if (DKUtils.isOnMacSilicon()) {
            if (this.isVersionGreaterOrEqual(PYTHON39) && Boolean.parseBoolean(DKUApp.getProperty((String)"dku.codeenv.arm.supported", (String)"false"))) {
                tensorflowRequirements.add(this.tensorflowRequirement());
                tensorflowRequirements.add("tensorflow-metal<1.3");
            } else {
                tensorflowRequirements.add("tensorflow-macos>=2.12,<2.13");
                tensorflowRequirements.add("tensorflow-metal==1.0.0");
            }
        } else {
            tensorflowRequirements.add(this.tensorflowRequirement());
            if (this == PYTHON27) {
                tensorflowRequirements.add("keras==2.3.1");
                tensorflowRequirements.add("grpcio==1.20.1");
                tensorflowRequirements.add("protobuf==3.17");
            }
        }
        return tensorflowRequirements;
    }

    public String gluontsRequirement() {
        String torchAddition;
        String string = torchAddition = this.isVersionGreaterOrEqual(PYTHON37) ? "[torch]" : "";
        if (this.isVersionGreaterOrEqual(PYTHON39)) {
            return "gluonts" + torchAddition + ">=0.8.1,<0.17";
        }
        return "gluonts" + torchAddition + ">=0.8.1,<0.14";
    }

    public String pmdarimaRequirement() {
        switch (this) {
            case PYTHON27: 
            case PYTHON34: 
            case PYTHON35: {
                return "pmdarima==1.2.1";
            }
            case PYTHON310: 
            case PYTHON311: 
            case PYTHON312: 
            case PYTHON313: {
                return "pmdarima>=1.8.5,<2.1";
            }
        }
        return "pmdarima>=1.2.1,<2.1";
    }

    public final String scikitOptRequirement() {
        switch (this) {
            case PYTHON27: 
            case PYTHON34: 
            case PYTHON35: {
                return "scikit-optimize>=0.7,<0.9";
            }
            case PYTHON36: 
            case PYTHON37: {
                return "scikit-optimize>=0.7,<0.10";
            }
        }
        return "scikit-optimize>=0.7,<=0.10.2";
    }

    public final String econmlRequirement() {
        if (DKUtils.isOsMacOS()) {
            return "econml>=0.13,<0.15; platform_machine==\"x86_64\"\neconml>=0.13,<0.17; platform_machine!=\"x86_64\"";
        }
        return "econml>=0.13,<0.17";
    }

    public final String tdigestRequirement() {
        if (this.isVersionGreaterOrEqual(PYTHON37)) {
            return "fastdigest>=0.8,<0.9";
        }
        return "tdigest>=0.5,<0.6";
    }

    public final String flaskRequirement() {
        if (this.isVersionGreaterOrEqual(PYTHON37)) {
            return "flask>=1.0,<2.3";
        }
        return "flask>=1.0,<1.1";
    }

    public final String jinja2Requirement() {
        if (this.isVersionGreaterOrEqual(PYTHON37)) {
            return "Jinja2>=2.11,<3.2";
        }
        return "Jinja2>=2.11,<2.12";
    }

    public final String skorchRequirement() {
        if (this.isVersionGreaterOrEqual(PYTHON39)) {
            return "skorch>=1.2,<1.3";
        }
        return "skorch>=0.11.0,<0.12.0";
    }

    public final String sentenceTransformersRequirement() {
        if (!this.isVersionGreaterOrEqual(PYTHON38)) {
            return "sentence-transformers>=2.2,<2.3";
        }
        return "sentence-transformers>=2.3,<2.4";
    }

    public final String cloudpickleRequirement() {
        if (this.isVersionGreaterOrEqual(PYTHON311)) {
            return "cloudpickle>=3,<4";
        }
        return "cloudpickle>=1.3,<1.6";
    }

    public final String markupSafeRequirement() {
        if (this.isVersionGreaterOrEqual(PYTHON39)) {
            return "MarkupSafe<3.1.0";
        }
        if (this.isVersionGreaterOrEqual(PYTHON37)) {
            return "MarkupSafe<2.2.0";
        }
        return "MarkupSafe<2.1.0";
    }

    public String xgboostRequirement() {
        switch (this) {
            case PYTHON27: 
            case PYTHON34: 
            case PYTHON35: {
                return "xgboost==0.82";
            }
            case PYTHON36: {
                return "xgboost>=1.3.3,<2";
            }
            case PYTHON37: {
                return "xgboost>=1.5.1,<2";
            }
        }
        return "xgboost>=2.1,<2.2";
    }

    public String scipyRequirement() {
        switch (this) {
            case PYTHON311: 
            case PYTHON312: 
            case PYTHON313: {
                return "scipy>=1.16,<1.17";
            }
            case PYTHON310: {
                return "scipy>=1.15,<1.16";
            }
            case PYTHON39: {
                return "scipy>=1.13,<1.14";
            }
            case PYTHON38: {
                return "scipy>=1.5,<1.11";
            }
            case PYTHON36: 
            case PYTHON37: {
                return "scipy>=1.5,<1.6";
            }
        }
        return "scipy>=1.2,<1.3";
    }

    public String mxnetRequirement() {
        String deprecatedMessage = "  # Mxnet is deprecated. It will be retired in the next major DSS version.";
        if (DKUtils.isOsWindows()) {
            return "mxnet==1.2.0" + deprecatedMessage;
        }
        if (this == PYTHON36 && DKUtils.isOsMacOS()) {
            return "mxnet==1.7.0.post2" + deprecatedMessage;
        }
        if (this.isVersionGreaterOrEqual(PYTHON310) && DKUtils.isOsMacOS()) {
            return "mxnet==1.9.1" + deprecatedMessage;
        }
        return "mxnet>=1.8.0.post0,<1.10" + deprecatedMessage;
    }

    public String numpy1Requirement() {
        assert (!this.isVersionGreaterOrEqual(PYTHON313));
        return "numpy<1.27";
    }

    public String tokenizersRequirement() {
        switch (this) {
            case PYTHON312: 
            case PYTHON313: {
                return "tokenizers==0.20.2";
            }
            case PYTHON36: {
                return "tokenizers==0.10.3";
            }
        }
        return "tokenizers==0.13.2";
    }

    public String torchRequirement() {
        if (this.isVersionGreaterOrEqual(PYTHON39)) {
            return "torch>=2,<2.8";
        }
        if (DKUtils.isOsMacOS()) {
            return "torch==1.9.1";
        }
        return "torch==1.9.1+cpu";
    }

    public String gpuTorchRequirement() {
        if (DKUtils.isOsMacOS()) {
            return this.torchRequirement();
        }
        if (this.isVersionGreaterOrEqual(PYTHON38)) {
            return "torch>=2,<2.9";
        }
        return "torch==1.9.1+cu111";
    }

    public String ragasRequirement() {
        if (this.isVersionGreaterOrEqual(PYTHON39)) {
            return "ragas==0.2.12";
        }
        return "ragas==0.1.10";
    }

    public String pydanticRequirement() {
        if (this.isVersionGreaterOrEqual(PYTHON39)) {
            return "pydantic==2.9.2";
        }
        return "pydantic<2";
    }

    public String langchainRequirement() {
        if (this.isVersionGreaterOrEqual(PYTHON39)) {
            return "langchain==0.3.27";
        }
        return "langchain==0.2.15";
    }

    public Collection<String> gpuTorchWithLinkRequirement() {
        if (this.equals((Object)PYTHON27)) {
            return Collections.emptyList();
        }
        return Arrays.asList(this.gpuTorchRequirement(), "--find-links https://download.pytorch.org/whl/torch_stable.html");
    }

    public Collection<String> cpuTorchWithLinkRequirement() {
        if (this.equals((Object)PYTHON27)) {
            return Collections.emptyList();
        }
        return Arrays.asList(this.torchRequirement(), "--extra-index-url https://download.pytorch.org/whl/cpu");
    }

    public String scikitLearnRequirement() {
        switch (this) {
            case PYTHON27: 
            case PYTHON34: 
            case PYTHON35: {
                return "scikit-learn>=0.20,<0.21";
            }
            case PYTHON36: {
                return "scikit-learn>=0.20,<1.0";
            }
            case PYTHON37: {
                return "scikit-learn>=1.0,<1.1";
            }
            case PYTHON38: {
                return "scikit-learn>=1.0,<1.4";
            }
            case PYTHON39: 
            case PYTHON310: {
                return "scikit-learn>=1.0,<1.7";
            }
            case PYTHON311: 
            case PYTHON312: 
            case PYTHON313: {
                return "scikit-learn>=1.1,<1.7";
            }
        }
        return "scikit-learn>=0.20,<1.1";
    }

    public String pillowRequirement() {
        switch (this) {
            case PYTHON27: 
            case PYTHON34: 
            case PYTHON35: {
                return "pillow==6.2.2";
            }
            case PYTHON36: {
                return "pillow==8.4.0";
            }
            case PYTHON37: {
                return "pillow>=9,<10";
            }
        }
        return "pillow>=10.3,<11";
    }

    public String statsmodelsRequirement() {
        switch (this) {
            case PYTHON27: 
            case PYTHON34: 
            case PYTHON35: {
                return "statsmodels>=0.10,<0.11";
            }
            case PYTHON312: 
            case PYTHON313: {
                return "statsmodels>=0.14,<0.15";
            }
        }
        return "statsmodels>=0.12.2,<0.15";
    }

    public String tensorflowRequirement() {
        switch (this) {
            case PYTHON27: {
                return "tensorflow>=1.15,<2.0";
            }
            case PYTHON34: 
            case PYTHON35: 
            case PYTHON36: {
                return "tensorflow>=2.6.2,<3.0";
            }
            case PYTHON37: 
            case PYTHON38: 
            case CUSTOM: {
                return "tensorflow>=2.8.0,<2.11";
            }
        }
        String pkgName = "tensorflow[and-cuda]";
        if (DKUtils.isOsMacOS()) {
            pkgName = "tensorflow";
        }
        return pkgName + ">=2.19,<2.21";
    }

    public Optional<String> pyamlPackage() {
        switch (this) {
            case PYTHON27: 
            case PYTHON34: 
            case PYTHON35: {
                return Optional.of("pyaml==21.10.1");
            }
        }
        return Optional.empty();
    }

    public boolean isDeprecated() {
        switch (this) {
            case PYTHON27: 
            case PYTHON34: 
            case PYTHON35: {
                return true;
            }
        }
        return false;
    }

    public int getMajor() {
        if (this == CUSTOM) {
            throw new IllegalArgumentException("Cannot get version of CUSTOM interpreter");
        }
        return this.major;
    }

    public int getMinor() {
        if (this == CUSTOM) {
            throw new IllegalArgumentException("Cannot get version of CUSTOM interpreter");
        }
        return this.minor;
    }

    public String getPythonCommandString() {
        if (this == CUSTOM) {
            throw new IllegalArgumentException("Unknown python command for CUSTOM interpreter");
        }
        return String.format("python%d.%d", this.getMajor(), this.getMinor());
    }

    public static Collection<StandardPythonInterpreter> getAcceptedPythonInterpreters() {
        return Arrays.stream(StandardPythonInterpreter.values()).filter(pythonInterpreter -> pythonInterpreter != CUSTOM && pythonInterpreter.isVersionGreaterOrEqual(PYTHON36)).toList();
    }

    public static String getPythonVersion(StandardPythonInterpreter interpreter) {
        switch (interpreter) {
            case PYTHON27: {
                return "2.7";
            }
            case PYTHON34: {
                return "3.4";
            }
            case PYTHON35: {
                return "3.5";
            }
            case PYTHON36: {
                return "3.6";
            }
            case PYTHON37: {
                return "3.7";
            }
            case PYTHON38: {
                return "3.8";
            }
            case PYTHON39: {
                return "3.9";
            }
            case PYTHON310: {
                return "3.10";
            }
            case PYTHON311: {
                return "3.11";
            }
            case PYTHON312: {
                return "3.12";
            }
            case PYTHON313: {
                return "3.13";
            }
            case CUSTOM: {
                throw new IllegalArgumentException("Can't use custom Python interpreter");
            }
        }
        throw new IllegalArgumentException("Unsupported interpreter: " + String.valueOf((Object)interpreter));
    }

    public static StandardPythonInterpreter getPreferredInIntersectionOrNull(@Nullable List<StandardPythonInterpreter> interpreters, @Nullable List<StandardPythonInterpreter> otherInterpreters) {
        if (interpreters == null || interpreters.isEmpty() || otherInterpreters == null || otherInterpreters.isEmpty()) {
            return null;
        }
        StandardPythonInterpreter preferredVersion = null;
        for (StandardPythonInterpreter interpreter : interpreters) {
            if (!otherInterpreters.contains((Object)interpreter) || preferredVersion != null && interpreter.preferenceOrder >= preferredVersion.preferenceOrder) continue;
            preferredVersion = interpreter;
        }
        return preferredVersion;
    }

    public static StandardPythonInterpreter getPreferredOrNull(Collection<StandardPythonInterpreter> interpreters) {
        return interpreters.stream().min(Comparator.comparing(i -> i.preferenceOrder)).orElse(null);
    }

    static StandardPythonInterpreter getInterpreter(int major, int minor) {
        for (StandardPythonInterpreter interpreter : StandardPythonInterpreter.values()) {
            if (major != interpreter.major || minor != interpreter.minor) continue;
            return interpreter;
        }
        throw new IllegalArgumentException(String.format("No interpreter exists for this version: %d.%d", major, minor));
    }

    private static /* synthetic */ StandardPythonInterpreter[] $values() {
        return new StandardPythonInterpreter[]{PYTHON27, PYTHON34, PYTHON35, PYTHON36, PYTHON37, PYTHON38, PYTHON39, PYTHON310, PYTHON311, PYTHON312, PYTHON313, CUSTOM};
    }

    static {
        $VALUES = StandardPythonInterpreter.$values();
    }
}

