/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.codestudio.runtime;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.DSSTempUtils;
import com.dataiku.dip.cluster.Cluster;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.codestudio.CodeStudioMeta;
import com.dataiku.dip.codestudio.CodeStudioRegistry;
import com.dataiku.dip.codestudio.blocks.AddCodeEnvCodeStudioBlockMeta;
import com.dataiku.dip.codestudio.blocks.BlockBasedCodeStudioTemplateParams;
import com.dataiku.dip.codestudio.blocks.CodeStudioBlock;
import com.dataiku.dip.codestudio.blocks.component.PythonPluginCodeStudioBlockParams;
import com.dataiku.dip.codestudio.object.CodeStudioObject;
import com.dataiku.dip.codestudio.runtime.CodeStudioLibsProvider;
import com.dataiku.dip.codestudio.runtime.CodeStudioSyncZones;
import com.dataiku.dip.codestudio.template.CodeStudioTemplate;
import com.dataiku.dip.codestudio.template.CodeStudioTemplateImagesHandler;
import com.dataiku.dip.codestudio.template.CodeStudioTemplateParams;
import com.dataiku.dip.codestudio.template.CodeStudioTemplatesService;
import com.dataiku.dip.containers.exec.ContainerExecConfigSelector;
import com.dataiku.dip.containers.exec.ContainerExecRuntimeConfig;
import com.dataiku.dip.containers.exec.DeploymentMonitorThread;
import com.dataiku.dip.containers.exec.KubernetesExecUtils;
import com.dataiku.dip.containers.exec.KubernetesNamespacesService;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.dao.ClustersDAO;
import com.dataiku.dip.dao.RecipesDAO;
import com.dataiku.dip.dataflow.exec.EnvironmentStash;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.ProcessDiedException;
import com.dataiku.dip.export.ZipUnzipDir;
import com.dataiku.dip.exposition.AbstractExposedEndpointCollector;
import com.dataiku.dip.exposition.Exposables;
import com.dataiku.dip.exposition.ExposedEndpointConsumer;
import com.dataiku.dip.exposition.Exposition;
import com.dataiku.dip.exposition.ExpositionHandler;
import com.dataiku.dip.exposition.ExpositionMeta;
import com.dataiku.dip.exposition.ExpositionRegistry;
import com.dataiku.dip.exposition.PortForwardToServiceExposition;
import com.dataiku.dip.fs.FSPath;
import com.dataiku.dip.fs.FSPathOrDirectory;
import com.dataiku.dip.fs.FSPathUtils;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.IStateLabelAggregator;
import com.dataiku.dip.futures.SimpleFutureThread;
import com.dataiku.dip.futures.StateLabelAggregator;
import com.dataiku.dip.io.SocketBlockLinkInteraction;
import com.dataiku.dip.io.SocketBlockLinkKernelException;
import com.dataiku.dip.plugins.dev.FolderEditorService;
import com.dataiku.dip.remoterun.RemoteRunEnvDef;
import com.dataiku.dip.remoterun.RemoteRunsRegistry;
import com.dataiku.dip.resourceusage.ComputeResourceUsageContext;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.security.impersonation.IImpersonationResolverService;
import com.dataiku.dip.security.process.RegularProcess;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.security.tickets.BackendAPITicketService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.recipes.RecipeSaveService;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.JupyterService;
import com.dataiku.dip.server.services.JupyterUtils;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.fs.NativeFS;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.fs.ifaces.ReadOnlyFS;
import com.dataiku.dip.transactions.fs.ifaces.ReadWriteFS;
import com.dataiku.dip.transactions.fs.utils.FSUtils;
import com.dataiku.dip.transactions.fs.utils.FileFilter;
import com.dataiku.dip.transactions.fs.utils.RelFileFilter;
import com.dataiku.dip.transactions.git.DSSGitModel;
import com.dataiku.dip.transactions.git.GitModel;
import com.dataiku.dip.transactions.git.jgit.GlobalObjectsJGitService;
import com.dataiku.dip.transactions.git.jgit.ProjectsJGitService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.AutoCloseableLock;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.NamedLock;
import com.dataiku.dip.utils.PathUtils;
import com.dataiku.dip.utils.SmartLogTail;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dip.variables.VariablesService;
import com.dataiku.dip.webapps.WebAppSecurityInfo;
import com.dataiku.dip.webapps.backend.NginxUtils;
import com.dataiku.dip.webapps.backend.WebAppBackend;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import jakarta.servlet.http.HttpServletResponse;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.text.StrSubstitutor;
import org.apache.log4j.Level;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.multipart.MultipartFile;

public class CodeStudioRuntime
extends SimpleFutureThread<Void>
implements DeploymentMonitorThread.RunningProcessList,
CodeStudioLibsProvider {
    public static final String COMMITID_HIDDEN_FILE_NAME = ".dku_current_commit_id";
    public static final String CHANGES_HIDDEN_FILE_NAME = ".dku_changes_lists";
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private APITicketService apiTicketService;
    @Autowired
    private CodeStudioTemplatesService codeStudioTemplatesService;
    @Autowired
    private FolderEditorService folderEditorService;
    @Autowired
    private FutureService futureService;
    @Autowired
    private ProjectsJGitService projectsJGitService;
    @Autowired
    private GlobalObjectsJGitService globalObjectsJGitService;
    @Autowired
    private ClustersDAO clustersDAO;
    @Autowired
    private RecipesDAO recipesDAO;
    @Autowired
    private RecipeSaveService recipeSaveService;
    @Autowired
    private JupyterService jupyterService;
    @Autowired
    private VariablesService variablesService;
    @Autowired
    private IImpersonationResolverService impersonationService;
    private final CodeStudioObject codeStudio;
    private final File workingDir;
    private CodeStudioPersistedState persistedState;
    private ContainerExecRuntimeConfig containerConfig;
    private CodeStudioStateLabelAggregator stateLabelAggregator = new CodeStudioStateLabelAggregator();
    private List<RegularProcess> running = Lists.newArrayList();
    private DeploymentMonitorThread monitorThread;
    private List<AbstractCodeStudioExposable> exposables = Lists.newArrayList();
    private List<CodeStudioMeta.CodeStudioCustomCommand> customCommands = Lists.newArrayList();
    private List<CodeStudioMeta.SyncZoneInstance> syncedZones = Lists.newArrayList();
    DKUtils.SmartLogTailBuilder smartLogTailBuilder = new DKUtils.SmartLogTailBuilder();
    private volatile int commandNo = 0;
    private BlockingQueue<CodeStudioCommand> commandQueue = new LinkedBlockingQueue<CodeStudioCommand>();
    private ConcurrentHashMap<Integer, CodeStudioResponse> responses = new ConcurrentHashMap();
    private String globalHeadCommitIdAtStart = null;
    private String projectHeadCommitIdAtStart = null;
    private boolean allowAutoReset = true;
    private volatile boolean hasStarted = false;
    private volatile boolean hasFinished = false;
    private static DKULogger logger = DKULogger.getLogger((String)"dip.codestudio.runtime");

    public CodeStudioRuntime(AuthCtx authCtx, CodeStudioObject codeStudio) throws IOException {
        super(authCtx);
        this.codeStudio = codeStudio;
        this.workingDir = CodeStudioRuntime.getWorkingDir(codeStudio);
        DKUFileUtils.mkdirs((File)this.workingDir);
        SpringUtils.getInstance().autowire((Object)this);
    }

    public boolean hasRun() {
        return this.hasStarted && this.hasFinished;
    }

    public String getProjectKey() {
        return this.codeStudio.getProjectKey();
    }

    public TaggableObjectsService.TaggableObjectRef getProjectTor() {
        return new TaggableObjectsService.TaggableObjectRef(this.codeStudio.projectKey, ITaggingService.TaggableType.PROJECT, null);
    }

    public void loadFromPersistedState(CodeStudioPersistedState persistedState) {
        this.persistedState = (CodeStudioPersistedState)JSON.deepCopy((Object)persistedState);
    }

    public String getCodeStudioNginxBaseUrl() {
        return "/code-studios/" + this.codeStudio.projectKey + "/" + this.codeStudio.id;
    }

    public String getCodeStudioNginxExposedUrl(int exposedPort) {
        return this.getCodeStudioNginxBaseUrl() + "/" + exposedPort + "/";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int enqueueCommand(String type, JsonObject params) throws InterruptedException {
        CodeStudioCommand command = new CodeStudioCommand();
        CodeStudioRuntime codeStudioRuntime = this;
        synchronized (codeStudioRuntime) {
            command.no = this.commandNo++;
        }
        command.type = type;
        command.params = params;
        this.commandQueue.put(command);
        logger.info((Object)("Pushing" + JSON.json((Object)command) + " in queue of size " + this.commandQueue.size()));
        return command.no;
    }

    public List<CodeStudioCommand> dequeueCommands() throws InterruptedException {
        ArrayList ret = Lists.newArrayList();
        CodeStudioCommand command = this.commandQueue.poll(30L, TimeUnit.SECONDS);
        logger.info((Object)("Still " + this.commandQueue.size() + " in queue"));
        if (command != null) {
            ret.add(command);
        }
        this.commandQueue.drainTo(ret);
        logger.info((Object)("Sending " + JSON.pretty((Object)ret)));
        return ret;
    }

    public void answerCommand(int no, byte[] data) {
        CodeStudioResponse response = new CodeStudioResponse();
        response.data = data;
        response.received = System.currentTimeMillis();
        this.responses.put(no, response);
        long minReceived = response.received - 60000L;
        ArrayList toRemove = Lists.newArrayList();
        for (Map.Entry<Integer, CodeStudioResponse> e : this.responses.entrySet()) {
            if (e.getValue().received >= minReceived) continue;
            toRemove.add(e.getKey());
        }
        for (Integer old : toRemove) {
            this.responses.remove(old);
        }
    }

    public byte[] pollAnswer(int no) {
        CodeStudioResponse response = this.responses.get(no);
        return response == null ? null : response.data;
    }

    public FutureResponse<CommandResult> enqueueCommandAndWait(AuthCtx authCtx, String type, JsonObject params) throws Exception {
        int commandNum = this.enqueueCommand(type, params);
        WaitCommandResultThread ft = new WaitCommandResultThread(authCtx, commandNum);
        return this.futureService.runFuture(ft, 100L, new TypeToken<FutureResponse<CommandResult>>(){});
    }

    public List<String> buildNginxConf(ExposedEndpointConsumer.ExposedEndpoint exposedEndpoint, String proxiedUrlSuffix, String proxyPrefixHeaderName, int exposedPort) {
        ArrayList nginxLocations = Lists.newArrayList();
        ArrayList fullLocations = Lists.newArrayList();
        String backendUrl = this.getCodeStudioNginxExposedUrl(exposedPort);
        String baseBackendUrlLT = PathUtils.slashes((String)com.dataiku.dip.utils.NginxUtils.ensureSafe((String)backendUrl), (Boolean)true, (Boolean)true, (boolean)true, (String)"/");
        Object extraProxyLocationCommands = exposedEndpoint.getProxiedHeaders().entrySet().stream().map(e -> String.format("  proxy_set_header %s \"%s\";\n", e.getKey(), e.getValue())).collect(Collectors.joining());
        if (StringUtils.isNotBlank((String)proxyPrefixHeaderName) && baseBackendUrlLT.length() > 1) {
            extraProxyLocationCommands = (String)extraProxyLocationCommands + String.format("\n  proxy_set_header %s \"%s\";\n", proxyPrefixHeaderName, baseBackendUrlLT.substring(0, baseBackendUrlLT.length() - 1));
        }
        if (((String)extraProxyLocationCommands).contains("proxy_set_header")) {
            extraProxyLocationCommands = (String)extraProxyLocationCommands + "  proxy_http_version 1.1; \n  proxy_set_header Upgrade $http_upgrade; \n  proxy_set_header Connection \"upgrade\"; \n";
        }
        HashMap replacements = Maps.newHashMap();
        replacements.put("projectKey", this.codeStudio.projectKey);
        replacements.put("codeStudioId", this.codeStudio.id);
        replacements.put("backendUrl", backendUrl);
        StrSubstitutor subst = new StrSubstitutor((Map)replacements, "${", "}");
        Object proxiedUrl = exposedEndpoint.getUrl();
        String codeStudioProxiedUrlPart = subst.replace(StringUtils.defaultIfBlank((String)proxiedUrlSuffix, (String)"")).replaceAll("//", "/");
        if (StringUtils.isBlank((String)codeStudioProxiedUrlPart)) {
            if (!((String)proxiedUrl).endsWith("/")) {
                proxiedUrl = (String)proxiedUrl + "/";
            }
        } else {
            while (((String)proxiedUrl).endsWith("/")) {
                proxiedUrl = ((String)proxiedUrl).substring(0, ((String)proxiedUrl).length() - 1);
            }
            proxiedUrl = (String)proxiedUrl + codeStudioProxiedUrlPart;
        }
        String baseLocation = "location ^~ " + baseBackendUrlLT + " {\n  resolver 127.0.0.1;\n  proxy_pass " + (String)proxiedUrl + ";\n  proxy_next_upstream off; # Don't retry\n  proxy_read_timeout 3600; # We have long queries\n  error_page 502 /code-studio-error-502.html;\n" + (String)extraProxyLocationCommands;
        nginxLocations.add(baseLocation);
        fullLocations.addAll(WebAppBackend.addCorsHeadersAndClose(nginxLocations));
        return fullLocations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRunning(RegularProcess toClose) {
        List<RegularProcess> list = this.running;
        synchronized (list) {
            this.running.add(toClose);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRunning(RegularProcess toClose) {
        List<RegularProcess> list = this.running;
        synchronized (list) {
            this.running.remove((Object)toClose);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<RegularProcess> getRunning() {
        List<RegularProcess> list = this.running;
        synchronized (list) {
            return Lists.newArrayList(this.running);
        }
    }

    @Override
    public void killRunningProcesses() {
        for (RegularProcess p : this.getRunning()) {
            try {
                p.evilKill();
            }
            catch (IOException e) {
                logger.error((Object)("Could not stop process " + String.valueOf((Object)p)), (Throwable)e);
            }
        }
    }

    public static File getWorkingDirBase() {
        return ApplicationConfigurator.getFile((String[])new String[]{"code_studios", "exec"});
    }

    public static File getWorkingDir(CodeStudioObject codeStudio) {
        return CodeStudioRuntime.getWorkingDir(codeStudio.projectKey, codeStudio.id);
    }

    public static File getWorkingDir(String projectKey, String id) {
        return DKUFileUtils.getWithin((File)CodeStudioRuntime.getWorkingDirBase(), (String[])new String[]{projectKey, id});
    }

    private static File getPersistedStateFile(File workingDir) {
        return new File(workingDir, "state.json");
    }

    public CodeStudioPersistedState getPersistedState() throws IOException, InterruptedException {
        return CodeStudioRuntime.getPersistedState(this.workingDir, this.codeStudio);
    }

    public static CodeStudioPersistedState getPersistedState(CodeStudioObject codeStudio) throws IOException, InterruptedException {
        return CodeStudioRuntime.getPersistedState(CodeStudioRuntime.getWorkingDir(codeStudio), codeStudio);
    }

    public static CodeStudioPersistedState getPersistedState(String projectKey, String id) throws IOException, InterruptedException {
        return CodeStudioRuntime.getPersistedState(CodeStudioRuntime.getWorkingDir(projectKey, id), projectKey, id);
    }

    private static CodeStudioPersistedState getPersistedState(File workingDir, CodeStudioObject codeStudio) throws IOException, InterruptedException {
        return CodeStudioRuntime.getPersistedState(workingDir, codeStudio.projectKey, codeStudio.id);
    }

    public static CodeStudioPersistedState getPersistedState(File workingDir, String projectKey, String codeStudioId) throws IOException, InterruptedException {
        String lockName = "code_studio." + projectKey + "." + codeStudioId;
        try (AutoCloseableLock lock = NamedLock.acquireInterruptibly((String)lockName);){
            File stateFile = CodeStudioRuntime.getPersistedStateFile(workingDir);
            if (stateFile.exists()) {
                CodeStudioPersistedState codeStudioPersistedState = (CodeStudioPersistedState)JSON.parseFile((File)stateFile, CodeStudioPersistedState.class);
                return codeStudioPersistedState;
            }
            CodeStudioPersistedState codeStudioPersistedState = new CodeStudioPersistedState();
            return codeStudioPersistedState;
        }
    }

    public void setPersistedState(CodeStudioPersistedState persistedState) throws IOException, InterruptedException {
        CodeStudioRuntime.setPersistedState(this.workingDir, this.codeStudio, persistedState);
    }

    public static void setPersistedState(CodeStudioObject codeStudio, CodeStudioPersistedState persistedState) throws IOException, InterruptedException {
        CodeStudioRuntime.setPersistedState(CodeStudioRuntime.getWorkingDir(codeStudio), codeStudio, persistedState);
    }

    private static void setPersistedState(File workingDir, CodeStudioObject codeStudio, CodeStudioPersistedState persistedState) throws IOException, InterruptedException {
        persistedState.lastStateChange = System.currentTimeMillis();
        String lockName = "code_studio." + codeStudio.projectKey + "." + codeStudio.id;
        try (AutoCloseableLock lock = NamedLock.acquireInterruptibly((String)lockName);){
            JSON.prettyToFile((Object)persistedState, (File)CodeStudioRuntime.getPersistedStateFile(workingDir));
        }
    }

    public CodeStudioMeta.CodeStudioCustomCommand getCustomCommand(String name) {
        for (CodeStudioMeta.CodeStudioCustomCommand command : this.customCommands) {
            if (!StringUtils.equals((String)name, (String)command.name)) continue;
            return command;
        }
        return null;
    }

    public CodeStudioUIState getUIState() throws IOException, InterruptedException {
        CodeStudioUIState uiState = new CodeStudioUIState(this.persistedState, this.getOwnerIdentifier());
        uiState.exposableCount = this.exposables.size();
        this.exposables.stream().forEach(e -> uiState.exposed.addAll(e.getExposed()));
        uiState.customCommands = Lists.newArrayList(this.customCommands);
        uiState.syncedZones = this.syncedZones;
        if (uiState.state == CodeStudioRuntimeState.RUNNING) {
            long lastTemplateBuilt;
            uiState.lastTemplateBuilt = lastTemplateBuilt = this.codeStudioTemplatesService.getLastBuilt(this.codeStudio.templateId);
        }
        return uiState;
    }

    public PythonPluginCodeStudioBlockParams getBlockConfig(int port) throws Exception {
        CodeStudioTemplateParams templateParams;
        try (Transaction t = this.transactionService.retrieveOrBeginRead();){
            templateParams = this.codeStudioTemplatesService.getMandatoryUnsafe((String)this.codeStudio.templateId).params;
        }
        if (templateParams instanceof BlockBasedCodeStudioTemplateParams) {
            return ((BlockBasedCodeStudioTemplateParams)templateParams).blocks.stream().filter(block -> block.params instanceof PythonPluginCodeStudioBlockParams).map(block -> (PythonPluginCodeStudioBlockParams)block.params).filter(params -> params.config.has("port") && params.config.get("port").getAsInt() == port).findFirst().orElse(null);
        }
        return null;
    }

    public List<CodeStudioMeta.SyncZoneInstance> getSyncedZones() {
        return Lists.newArrayList(this.syncedZones);
    }

    public SmartLogTail getLog() {
        return this.smartLogTailBuilder.get();
    }

    public CodeStudioRunInfo getRunInfo() {
        CodeStudioRunInfo runInfo = new CodeStudioRunInfo(this.persistedState, this.getOwnerIdentifier());
        runInfo.exposableCount = this.exposables.size();
        this.exposables.stream().forEach(e -> runInfo.exposed.addAll(e.getExposed()));
        runInfo.customCommands = Lists.newArrayList(this.customCommands);
        runInfo.syncedZones = this.syncedZones;
        runInfo.logTail = this.getLog();
        if (this.monitorThread != null) {
            runInfo.kubectlDescribes = this.monitorThread.getKubectlDescribes();
        }
        return runInfo;
    }

    /*
     * Exception decompiling
     */
    @Override
    protected Void compute() throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private APITicketService.ExpirableTicket createApiTicket() {
        if (this.persistedState.state == CodeStudioRuntimeState.RUNNING && StringUtils.isNotBlank((String)this.persistedState.apiTicket)) {
            PasswordEncryptionService cryptoService = (PasswordEncryptionService)SpringUtils.getBean(PasswordEncryptionService.class);
            String ticketSecret = cryptoService.decryptIfEncrypted(this.persistedState.apiTicket);
            return ((BackendAPITicketService)this.apiTicketService).createExpirableTicketWithKnownSecret((AuthCtx)this.owner, "Code Studio " + this.codeStudio.getFullId(), (Object)this.codeStudio, ticketSecret);
        }
        return this.apiTicketService.createExpiringTicket((AuthCtx)this.owner, "Code Studio " + this.codeStudio.getFullId(), (Object)this.codeStudio);
    }

    private void createK8SObjects(APITicketService.ExpirableTicket ticket, DKUtils.RotatingLoggingSubscription mainLog) throws Exception {
        String executionId;
        CodeStudioTemplate template;
        try (Transaction t = this.transactionService.beginRead();){
            template = this.codeStudioTemplatesService.getMandatoryUnsafe(this.codeStudio.templateId);
            this.globalHeadCommitIdAtStart = this.globalObjectsJGitService.getHashOf("HEAD");
            this.projectHeadCommitIdAtStart = this.projectsJGitService.getHashOf(this.codeStudio.projectKey, "HEAD");
        }
        String suffix = "-" + SecretKeyGenerator.generate((int)8);
        this.persistedState.executionId = executionId = (KubernetesExecUtils.getNormalizedId("kub-" + this.codeStudio.id, 63 - suffix.length()) + suffix).toLowerCase();
        this.persistedState.jobId = this.jobId;
        this.persistedState.authCtx = this.owner;
        this.persistedState.globalHeadCommitIdAtStart = this.globalHeadCommitIdAtStart;
        this.persistedState.projectHeadCommitIdAtStart = this.projectHeadCommitIdAtStart;
        if (template.reattachOnRestart) {
            PasswordEncryptionService cryptoService = (PasswordEncryptionService)SpringUtils.getBean(PasswordEncryptionService.class);
            this.persistedState.apiTicket = cryptoService.encrypt(ticket.getSecret());
        }
        this.persistedState.codeStudio = (CodeStudioObject)JSON.deepCopy((Object)this.codeStudio);
        this.persistedState.state = CodeStudioRuntimeState.STARTING;
        this.setPersistedState(this.persistedState);
        this.containerConfig = new ContainerExecConfigSelector().selectForCodeStudio_autoTXN(this.owner, this.codeStudio.projectKey, template.defaultContainerConf, template.allowContainerConfOverride);
        if (this.containerConfig == null) {
            throw new IllegalStateException("No container config to run Code Studio on");
        }
        logger.info((Object)("Will run Code Studio on " + this.containerConfig.name));
        if (this.containerConfig.type == ContainerExecRuntimeConfig.Container.KUBERNETES && StringUtils.isNotBlank((String)this.containerConfig.overridenFromK8SClusterId)) {
            Cluster cluster = null;
            try (Transaction t = this.transactionService.beginRead();){
                cluster = this.clustersDAO.getOrNull(this.containerConfig.overridenFromK8SClusterId);
            }
            if (cluster == null) {
                logger.warn((Object)"The cluster used by the container config isn't found");
            } else if (cluster.state != Cluster.ClusterState.RUNNING && !cluster.type.equals("manual")) {
                throw new IllegalStateException("The cluster " + this.containerConfig.overridenFromK8SClusterId + " used by this Code Studio isn't running");
            }
        }
        this.containerConfig = (ContainerExecRuntimeConfig)JSON.deepCopy((Object)this.containerConfig);
        this.containerConfig.kubernetesNamespace = KubernetesNamespacesService.getOrCreateNamespace(this.owner, this.codeStudio.projectKey, this.containerConfig);
        KubernetesExecUtils.LabelsAndAnnotations laa = KubernetesExecUtils.getIdentifiersBasedOnCRUContext(this.owner, executionId, this.containerConfig);
        CodeStudioMeta meta = CodeStudioRegistry.getMeta(template);
        CodeStudioMeta.CodeStudioLaunchEnv launchEnv = new CodeStudioMeta.CodeStudioLaunchEnv();
        launchEnv.projectKey = this.codeStudio.projectKey;
        launchEnv.apiTicket = ticket.getSecret();
        launchEnv.workingDir = this.workingDir.getAbsolutePath();
        launchEnv.executionId = executionId;
        launchEnv.containerConfig = this.containerConfig;
        launchEnv.baseUrlLNT = PathUtils.makeLeadingNoTrailing((String)this.getCodeStudioNginxBaseUrl());
        launchEnv.baseUrlLNTPerPort = "${baseUrl}/${exposedPort}";
        launchEnv.labels = laa.getLabels();
        launchEnv.annotations = laa.annotations;
        launchEnv.launchedFrom = CodeStudioMeta.CodeStudioLaunchedFrom.CODE_STUDIO;
        CodeStudioTemplatesService.CodeStudioTemplateImageBuilt imageBuilt = CodeStudioTemplatesService.getLatest(template, this.containerConfig.name);
        if (imageBuilt == null) {
            throw new IllegalArgumentException("No image build recorded for this Code Studio template");
        }
        String dssVersionTag = DKUApp.getDSSVersionTag();
        if (!dssVersionTag.equals(imageBuilt.dssVersion)) {
            throw new IllegalStateException("The code studio template must be rebuilt");
        }
        launchEnv.templateImage = CodeStudioTemplateImagesHandler.getCodeStudioImageName(template) + ":dss-" + dssVersionTag + "-" + imageBuilt.buildId;
        CodeStudioMeta.CodeStudioLaunchSpec launchSpec = meta.getLaunchSpec(this.owner, template, launchEnv);
        logger.info((Object)("Got launchSpec\n" + JSON.pretty((Object)launchSpec)));
        logger.info((Object)("Got yaml\n" + launchSpec.yaml));
        File yamlFile = new File(this.workingDir, "code_studio.yaml");
        FileUtils.writeStringToFile((File)yamlFile, (String)launchSpec.yaml, (Charset)StandardCharsets.UTF_8);
        this.persistedState.deploymentStartFiles = Lists.newArrayList((Object[])new String[]{"-f", yamlFile.getAbsolutePath()});
        this.persistedState.containerConfig = this.containerConfig;
        this.persistedState.launchSpec = launchSpec;
        this.setPersistedState(this.persistedState);
        if (launchSpec.entrypoints.isEmpty()) {
            throw new IllegalStateException("The Code Studio template must define at least one entrypoint");
        }
        CodeStudioRunDefinition codeStudioDefinition = new CodeStudioRunDefinition();
        codeStudioDefinition.entrypoints = launchSpec.entrypoints;
        codeStudioDefinition.projectKey = this.codeStudio.projectKey;
        codeStudioDefinition.codeStudioId = this.codeStudio.id;
        codeStudioDefinition.baseUrl = launchEnv.baseUrlLNT;
        codeStudioDefinition.syncedZones = launchSpec.syncedZones.stream().map(JSON::deepCopy).collect(Collectors.toList());
        if (StringUtils.isNotBlank((String)launchSpec.readinessProbeUrl)) {
            KubernetesExecUtils.HttpGetActionParts probeParts = KubernetesExecUtils.getProbeParts(launchSpec.readinessProbeUrl);
            if (StringUtils.isNotBlank((String)probeParts.path) && !"/".equals(probeParts.path)) {
                codeStudioDefinition.readinessProbeUrl = probeParts.path;
            }
            codeStudioDefinition.tcpProbePort = launchSpec.useTcpReadiness ? probeParts.port : 0;
        }
        for (CodeStudioMeta.SyncZoneInstance syncZoneInstance : codeStudioDefinition.syncedZones) {
            syncZoneInstance.id = syncZoneInstance.zone + "_" + SecretKeyGenerator.generate((int)6);
        }
        codeStudioDefinition.excludedFromSync = launchSpec.excludedFromSync;
        codeStudioDefinition.fileAdjustmentScript = launchSpec.fileAdjustmentScript;
        codeStudioDefinition.reattachOnRestart = template.reattachOnRestart;
        if (launchSpec.exposedPorts.stream().anyMatch(ep -> ep.containerPort == null)) {
            throw new IllegalArgumentException("The field containerPort cannot be undefined, for nginx will use it");
        }
        codeStudioDefinition.ports = launchSpec.exposedPorts.stream().map(ep -> new ContainerForwardedPort(ep.port, ep.containerPort)).collect(Collectors.toList());
        ArrayList<CodeEnvModel.EnvFullRef> codeEnvs = new ArrayList<CodeEnvModel.EnvFullRef>();
        if ("block_based".equals(template.type)) {
            for (CodeStudioBlock block : template.getParamsAs(BlockBasedCodeStudioTemplateParams.class).blocks) {
                if (!"add_codeenv".equals(block.type)) continue;
                AddCodeEnvCodeStudioBlockMeta.AddCodeEnvCodeStudioBlockParams params = block.getParamsAs(AddCodeEnvCodeStudioBlockMeta.AddCodeEnvCodeStudioBlockParams.class);
                CodeEnvModel.EnvFullRef envRef = new CodeEnvModel.EnvFullRef(params.envLang, params.envName, params.versionId);
                codeEnvs.add(envRef);
            }
        }
        this.persistedState.codeStudioDefinition = (CodeStudioRunDefinition)JSON.deepCopy((Object)codeStudioDefinition);
        this.persistedState.codeEnvs = (List)JSON.deepCopy(codeEnvs);
        this.setPersistedState(this.persistedState);
        RemoteRunsRegistry.add(executionId, this.owner, this.codeStudio.projectKey, this.workingDir.getAbsolutePath(), this.workingDir.getAbsolutePath(), RemoteRunsRegistry.ExecutionType.CODE_STUDIO, JSON.json((Object)codeStudioDefinition), "", Collections.emptyList(), Collections.emptyList(), codeEnvs);
        RemoteRunEnvDef remoteRunEnvDef = new RemoteRunEnvDef();
        remoteRunEnvDef.runsRemotely = false;
        remoteRunEnvDef.cwd = this.workingDir.getAbsolutePath();
        EnvironmentStash envStash = new EnvironmentStash();
        envStash.fillDefaultForRemote();
        envStash.fillCommunicationVars();
        envStash.apiTicket = ticket.getSecret();
        envStash.projectKey = this.codeStudio.projectKey;
        envStash.copyToRemoteRunEnvDef(remoteRunEnvDef, false, false, false);
        remoteRunEnvDef.jobId = executionId;
        RemoteRunsRegistry.get((String)executionId).envResource = remoteRunEnvDef;
        this.customCommands = launchSpec.customCommands;
        this.syncedZones = codeStudioDefinition.syncedZones;
        this.exposables = Stream.concat(launchSpec.exposedPorts.stream().map(ep -> new CodeStudioPodExposable(executionId, (CodeStudioMeta.ExposedCodeStudioPort)ep, launchSpec.selector)), launchSpec.exposedServices.stream().map(es -> new CodeStudioServiceExposable(executionId, (CodeStudioMeta.ExposedCodeStudioService)es, launchSpec.selector))).collect(Collectors.toList());
        this.exposables.stream().forEach(e -> e.init(mainLog, this.smartLogTailBuilder));
        logger.info((Object)"Start Code Studio");
        int codeStudioStart = new DKUtils.ExecBuilder().withCwd(this.workingDir).withEnv(KubernetesExecUtils.getKubeCtlEnv(this.containerConfig)).withArgs(KubernetesExecUtils.getKubeCtlApplyCommand(this.owner, this.codeStudio.projectKey, this.containerConfig, this.persistedState.deploymentStartFiles.toArray(new String[0]))).withErrorConsumer((DKUtils.ExecSubscription)new DKUtils.TailerLineSubscription(this.smartLogTailBuilder)).withOutputConsumer((DKUtils.ExecSubscription)new DKUtils.TailerLineSubscription(this.smartLogTailBuilder)).withOutputConsumer((DKUtils.ExecSubscription)mainLog.getSubSubscription("[kub] ")).withErrorConsumer((DKUtils.ExecSubscription)mainLog.getSubSubscription("[kub] ")).exec();
        if (codeStudioStart != 0) {
            throw ProcessDiedException.getExceptionOnProcessDeath((String)"Failed to start Code Studio backend", null, null, (boolean)false, (Integer)codeStudioStart, (DKUtils.SmartLogTailBuilder)this.smartLogTailBuilder);
        }
        logger.info((Object)"Start rollout");
        String deploymentName = launchSpec.k8sHeadObjectName;
        this.monitorThread = new DeploymentMonitorThread(this.owner, this.codeStudio.projectKey, deploymentName, this.containerConfig, executionId, this.stateLabelAggregator, 1, this.workingDir, (DKUtils.LineSubscriptionAttacher)mainLog, this.smartLogTailBuilder, this);
        this.monitorThread.doRollout();
        this.persistedState.state = CodeStudioRuntimeState.RUNNING;
        this.setPersistedState(this.persistedState);
    }

    private void attachK8SObjects(APITicketService.ExpirableTicket ticket, DKUtils.RotatingLoggingSubscription mainLog) throws Exception {
        String executionId = this.persistedState.executionId;
        this.globalHeadCommitIdAtStart = this.persistedState.globalHeadCommitIdAtStart;
        this.projectHeadCommitIdAtStart = this.persistedState.projectHeadCommitIdAtStart;
        this.persistedState.jobId = this.jobId;
        this.persistedState.authCtx = this.owner;
        this.setPersistedState(this.persistedState);
        this.containerConfig = (ContainerExecRuntimeConfig)JSON.deepCopy((Object)this.persistedState.containerConfig);
        logger.info((Object)("Will run Code Studio on " + this.containerConfig.name));
        CodeStudioRunDefinition codeStudioDefinition = this.persistedState.codeStudioDefinition;
        List<CodeEnvModel.EnvFullRef> codeEnvs = this.persistedState.codeEnvs;
        RemoteRunsRegistry.add(executionId, this.owner, this.codeStudio.projectKey, this.workingDir.getAbsolutePath(), this.workingDir.getAbsolutePath(), RemoteRunsRegistry.ExecutionType.CODE_STUDIO, JSON.json((Object)codeStudioDefinition), "", Collections.emptyList(), Collections.emptyList(), codeEnvs);
        RemoteRunEnvDef envResource = new RemoteRunEnvDef();
        envResource.runsRemotely = false;
        envResource.cwd = this.workingDir.getAbsolutePath();
        EnvironmentStash envStash = new EnvironmentStash();
        envStash.fillDefaultForRemote();
        envStash.fillCommunicationVars();
        envStash.apiTicket = ticket.getSecret();
        envStash.projectKey = this.codeStudio.projectKey;
        envStash.copyToRemoteRunEnvDef(envResource, false, false, false);
        envResource.jobId = executionId;
        RemoteRunsRegistry.get((String)executionId).envResource = envResource;
        CodeStudioMeta.CodeStudioLaunchSpec launchSpec = this.persistedState.launchSpec;
        this.customCommands = launchSpec.customCommands;
        this.syncedZones = codeStudioDefinition.syncedZones;
        this.exposables = Stream.concat(launchSpec.exposedPorts.stream().map(ep -> new CodeStudioPodExposable(executionId, (CodeStudioMeta.ExposedCodeStudioPort)ep, launchSpec.selector)), launchSpec.exposedServices.stream().map(es -> new CodeStudioServiceExposable(executionId, (CodeStudioMeta.ExposedCodeStudioService)es, launchSpec.selector))).collect(Collectors.toList());
        this.exposables.stream().forEach(e -> e.init(mainLog, this.smartLogTailBuilder));
        logger.info((Object)"Reattach to deployment");
        String deploymentName = launchSpec.k8sHeadObjectName;
        this.monitorThread = new DeploymentMonitorThread(this.owner, this.codeStudio.projectKey, deploymentName, this.containerConfig, executionId, this.stateLabelAggregator, 1, this.workingDir, (DKUtils.LineSubscriptionAttacher)mainLog, this.smartLogTailBuilder, this);
    }

    public FuturePayload getPayload() {
        FuturePayload fp = FuturePayload.newSimple((String)"code_studio", (String)("Code Studio " + this.codeStudio.id + " in project " + this.codeStudio.projectKey));
        fp.targets.add(new FuturePayload.FuturePayloadTarget(this.codeStudio.projectKey, this.codeStudio.id, this.codeStudio.name, ITaggingService.TaggableType.CODE_STUDIO.name()));
        return fp;
    }

    public void stopCodeStudio(CodeStudioPersistedState persistedState) throws IOException, InterruptedException {
        if (persistedState.state == CodeStudioRuntimeState.RUNNING || persistedState.state == CodeStudioRuntimeState.STARTING) {
            persistedState.state = CodeStudioRuntimeState.STOPPING;
            this.setPersistedState(persistedState);
            this.kill();
        } else if (persistedState.state == CodeStudioRuntimeState.STOPPING) {
            // empty if block
        }
    }

    public void forceStopCodeStudio(CodeStudioPersistedState persistedState) throws IOException, InterruptedException {
        this.stopCodeStudio(persistedState);
        persistedState.state = CodeStudioRuntimeState.STOPPED;
        persistedState.executionId = null;
        persistedState.deploymentStartFiles = null;
        persistedState.jobId = null;
        this.setPersistedState(persistedState);
    }

    public boolean shouldReattach() throws Exception {
        if (this.persistedState.state != CodeStudioRuntimeState.RUNNING) {
            return false;
        }
        if (this.persistedState.launchSpec == null || StringUtils.isBlank((String)this.persistedState.launchSpec.k8sHeadObjectName) || StringUtils.isBlank((String)this.persistedState.launchSpec.k8sHeadObjectType)) {
            return false;
        }
        try (Transaction t = this.transactionService.beginRead();){
            CodeStudioTemplate template = this.codeStudioTemplatesService.getMandatoryUnsafe(this.codeStudio.templateId);
            if (!template.reattachOnRestart) {
                boolean bl = false;
                return bl;
            }
        }
        if (StringUtils.isBlank((String)this.persistedState.apiTicket)) {
            return false;
        }
        int codeStudioProbe = new DKUtils.ExecBuilder().withCwd(this.workingDir).withEnv(KubernetesExecUtils.getKubeCtlEnv(this.persistedState.containerConfig)).withArgs(KubernetesExecUtils.getKubeCtlCommand((AuthCtx)this.owner, this.codeStudio.projectKey, this.persistedState.containerConfig, false, "get", this.persistedState.launchSpec.k8sHeadObjectType, this.persistedState.launchSpec.k8sHeadObjectName)).withErrorConsumer((DKUtils.ExecSubscription)new DKUtils.LoggingLineSubscription(Level.INFO)).withOutputConsumer((DKUtils.ExecSubscription)new DKUtils.LoggingLineSubscription(Level.INFO)).exec();
        return codeStudioProbe == 0;
    }

    public void reattach() throws IOException {
    }

    public void kill() {
        this.persistedState.state = CodeStudioRuntimeState.STOPPING;
        logger.warn((Object)"Will kill Kubernetes deployment");
        this.killRunningProcesses();
        try {
            CodeStudioPersistedState currentPersistedState = this.getPersistedState();
            if (currentPersistedState.deploymentStartFiles != null && currentPersistedState.containerConfig != null) {
                KubernetesExecUtils.delete(this.owner, this.codeStudio.projectKey, currentPersistedState.containerConfig, true, this.persistedState.deploymentStartFiles.toArray(new String[0]));
            }
        }
        catch (IOException e) {
            logger.error((Object)"Could not stop Kubernetes deployment", (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.error((Object)"Interrupted while stopping Kubernetes deployment", (Throwable)e);
        }
        if (this.monitorThread != null) {
            this.monitorThread.kill();
        }
    }

    public static RelFile getVersionedCodeStudioFolder(CodeStudioObject codeStudio) {
        return new RelFile(new String[]{"projects", codeStudio.projectKey, "code_studios", codeStudio.id});
    }

    public static RelFile getProjectLibFolder(CodeStudioObject codeStudio) {
        return new RelFile(new String[]{"projects", codeStudio.projectKey, DSSGitModel.ProjectFilesFolders.LIB.value});
    }

    public static RelFile getRecipesFolder(CodeStudioObject codeStudio) {
        return new RelFile(new String[]{"projects", codeStudio.projectKey, DSSGitModel.ProjectFilesFolders.RECIPES.value});
    }

    public static File getResourcesCodeStudioFolder(CodeStudioObject codeStudio) {
        return ApplicationConfigurator.getFile((String[])new String[]{"lib", "code_studio", codeStudio.projectKey, codeStudio.libName});
    }

    @Override
    public void getCodeStudioBundle_NT(String zoneId, String fromCommitId, HttpServletResponse resp) throws Exception {
        CodeStudioMeta.SyncZoneInstance syncedZone = this.syncedZones.stream().filter(z -> zoneId.equals(z.id)).findFirst().orElseThrow(() -> new Exception("No zone " + zoneId));
        CodeStudioSyncZones.SyncZone zone = CodeStudioSyncZones.lookup(syncedZone.zone);
        if (zone instanceof CodeStudioSyncZones.NotebooksZone) {
            this.getNotebooksCodeStudioBundle_NT(zone, fromCommitId, resp);
        } else if (zone.isVersioned()) {
            this.getVersionedCodeStudioBundle_NT(zone, syncedZone.pathInZone, fromCommitId, resp);
        } else {
            this.getResourcesCodeStudioBundle(zone, syncedZone.pathInZone, fromCommitId, resp);
        }
    }

    private void getVersionedCodeStudioBundle_NT(CodeStudioSyncZones.SyncZone zone, String pathInZone, String fromCommitId, HttpServletResponse resp) throws IOException, GitAPIException, DKUSecurityException {
        block14: {
            pathInZone = PathUtils.makeNotLeadingNoTrailing((String)StringUtils.defaultIfBlank((String)pathInZone, (String)""));
            RelFile bundleFolder = zone.rootRelFile(this.owner, this.codeStudio).appendChildPath(pathInZone);
            try (Transaction t = this.transactionService.beginRead();){
                if (t.exists(bundleFolder)) {
                    boolean hasChanges;
                    DSSGitModel.ProjectFilesLog log = this.getLogOfLastChangeOrHead(zone, bundleFolder);
                    HashMap additionalEntries = Maps.newHashMap();
                    additionalEntries.put(COMMITID_HIDDEN_FILE_NAME, ((GitModel.DKULogEntry)log.logEntries.get((int)0)).commitId);
                    boolean bl = hasChanges = !((GitModel.DKULogEntry)log.logEntries.get((int)0)).commitId.equals(fromCommitId);
                    if (hasChanges) {
                        this.prepareResponse(resp);
                        this.folderEditorService.streamFolderContent(bundleFolder, "", zone.fileFilter(), (OutputStream)resp.getOutputStream(), t, additionalEntries);
                    } else {
                        resp.setStatus(204);
                    }
                    break block14;
                }
                this.prepareResponse(resp);
                try (ZipOutputStream zos = new ZipOutputStream((OutputStream)resp.getOutputStream());){
                    ZipEntry entry = new ZipEntry(COMMITID_HIDDEN_FILE_NAME);
                    zos.putNextEntry(entry);
                    IOUtils.write((String)this.getHeadCommitId(zone), (OutputStream)zos, (Charset)StandardCharsets.UTF_8);
                }
            }
        }
    }

    private void prepareResponse(HttpServletResponse resp) {
        resp.setStatus(200);
        resp.setContentType("application/octet-stream");
        resp.setHeader("Content-Disposition", "attachment; filename=\"code_studio_bundle.zip\"");
    }

    private String getHeadCommitId(CodeStudioSyncZones.SyncZone zone) throws IOException {
        if (zone.isGlobal()) {
            return this.globalObjectsJGitService.getHashOf("HEAD");
        }
        return this.projectsJGitService.getHashOf(this.codeStudio.projectKey, "HEAD");
    }

    private void getResourcesCodeStudioBundle(CodeStudioSyncZones.SyncZone zone, String pathInZone, String fromCommitId, HttpServletResponse resp) throws IOException, DKUSecurityException {
        String currentDssCommitId;
        File bundleFolder = zone.rootFile(this.owner, this.codeStudio);
        if (StringUtils.isNotBlank((String)(pathInZone = PathUtils.makeNotLeadingNoTrailing((String)StringUtils.defaultIfBlank((String)pathInZone, (String)""))))) {
            bundleFolder = DKUFileUtils.getWithin((File)bundleFolder, (String[])pathInZone.split("/"));
        }
        if (!bundleFolder.exists()) {
            DKUFileUtils.mkdirs((File)bundleFolder);
        }
        if ((currentDssCommitId = this.makeSnapshotAndFakeCommitId(bundleFolder)).equals(fromCommitId)) {
            resp.setStatus(204);
        } else {
            this.prepareResponse(resp);
            ZipUnzipDir.zipDirectoryToStream(bundleFolder, (OutputStream)resp.getOutputStream());
        }
    }

    private void getNotebooksCodeStudioBundle_NT(CodeStudioSyncZones.SyncZone zone, String fromCommitId, HttpServletResponse resp) throws IOException, GitAPIException, DKUSecurityException {
        block19: {
            RelFile ipythonNotebooksFolder = zone.rootRelFile(this.owner, this.codeStudio);
            File notebooksWithOutputsFolder = zone.rootFile(this.owner, this.codeStudio);
            try (Transaction t = this.transactionService.beginRead();){
                if (t.exists(ipythonNotebooksFolder)) {
                    boolean hasChanges;
                    DSSGitModel.ProjectFilesLog log = this.getLogOfLastChangeOrHead(zone, ipythonNotebooksFolder);
                    String lastCommitId = ((GitModel.DKULogEntry)log.logEntries.get((int)0)).commitId;
                    boolean bl = hasChanges = !lastCommitId.equals(fromCommitId);
                    if (hasChanges) {
                        RelFile notebooksFolder = this.jupyterService.getNotebooksDir(this.codeStudio.projectKey);
                        if (!t.exists(notebooksFolder)) {
                            logger.error((Object)("Notebook directory not found: " + notebooksFolder.getFullPath() + ". It will be missing in the Code Studio."));
                            return;
                        }
                        for (RelFile notebookFile : t.listFiles(notebooksFolder, (RelFileFilter)new FileFilter("ipynb"))) {
                            String notebookName = new PathUtils.FilenameInfo((String)notebookFile.getLeafName()).name;
                            try {
                                this.jupyterService.ensureNotebookWithOutputsIsUpToDate(this.codeStudio.projectKey, notebookName);
                            }
                            catch (IOException e) {
                                logger.error((Object)("Can't read notebook: " + notebookName + ". It will be missing or incomplete in the Code Studio."), (Throwable)e);
                            }
                        }
                        this.prepareResponse(resp);
                        FileUtils.writeStringToFile((File)new File(notebooksWithOutputsFolder, COMMITID_HIDDEN_FILE_NAME), (String)lastCommitId, (Charset)StandardCharsets.UTF_8);
                        ZipUnzipDir.zipDirectoryToStream(notebooksWithOutputsFolder, (OutputStream)resp.getOutputStream(), "", Pattern.compile(".*\\.ipynb_checkpoints"));
                    } else {
                        resp.setStatus(204);
                    }
                    break block19;
                }
                this.prepareResponse(resp);
                try (ZipOutputStream zos = new ZipOutputStream((OutputStream)resp.getOutputStream());){
                    ZipEntry entry = new ZipEntry(COMMITID_HIDDEN_FILE_NAME);
                    zos.putNextEntry(entry);
                    IOUtils.write((String)this.getHeadCommitId(zone), (OutputStream)zos, (Charset)StandardCharsets.UTF_8);
                }
            }
        }
    }

    private String makeSnapshotAndFakeCommitId(File bundleFolder) throws IOException {
        List<FSPathOrDirectory> contents = this.makeSnapshot(bundleFolder);
        File changeTrackingFile = new File(bundleFolder, CHANGES_HIDDEN_FILE_NAME);
        JSON.prettyToFile(contents, (File)changeTrackingFile);
        String commitId = Base64.encodeBase64String((byte[])JSON.sha256(contents));
        FileUtils.writeStringToFile((File)new File(bundleFolder, COMMITID_HIDDEN_FILE_NAME), (String)commitId, (Charset)StandardCharsets.UTF_8);
        return commitId;
    }

    private List<FSPathOrDirectory> makeSnapshot(File bundleFolder) throws IOException {
        String rootLNT = PathUtils.makeLeadingNoTrailing((String)bundleFolder.toPath().toRealPath(LinkOption.NOFOLLOW_LINKS).toString());
        List contents = FSPathUtils.recursiveRerootedList((String)rootLNT, (File)bundleFolder, (Set)Sets.newHashSet((Object[])new String[]{CHANGES_HIDDEN_FILE_NAME, COMMITID_HIDDEN_FILE_NAME}));
        Collections.sort(contents, (a, b) -> a.path().compareTo(b.path()));
        return contents;
    }

    private AutoDelete getUnzippedTempFolder(MultipartFile src) throws IOException {
        AutoDelete tmpDir = DSSTempUtils.getTempFolder((String)"code_studios", (String)this.codeStudio.getFullId());
        File zipFile = new File((File)tmpDir, "dku_send.zip");
        src.transferTo(zipFile);
        ZipUnzipDir.extractFolder(zipFile, (File)tmpDir);
        return tmpDir;
    }

    public DSSGitModel.CodeStudioPushZoneLog setCodeStudioBundle_NT(AuthCtx authCtx, MultipartFile src, String zoneId, int commandNo, String fromCommitId) throws Exception {
        if (commandNo >= 0) {
            logger.info((Object)"UI-sent command, send answer");
            this.answerCommand(commandNo, new byte[0]);
        }
        CodeStudioMeta.SyncZoneInstance syncedZone = this.syncedZones.stream().filter(z -> zoneId.equals(z.id)).findFirst().orElseThrow(() -> new Exception("No zone " + zoneId));
        CodeStudioSyncZones.SyncZone zone = CodeStudioSyncZones.lookup(syncedZone.zone);
        if (syncedZone.oneWay) {
            logger.info((Object)("Zone " + syncedZone.zone + " / " + StringUtils.defaultIfBlank((String)syncedZone.pathInZone, (String)"") + " is one-way, not syncing back"));
            return new DSSGitModel.CodeStudioPushZoneLog();
        }
        if (zone instanceof CodeStudioSyncZones.RecipesZone) {
            return this.setRecipesCodeStudioBundle_NT(authCtx, zone, src, fromCommitId);
        }
        if (zone instanceof CodeStudioSyncZones.NotebooksZone) {
            return this.setNotebooksCodeStudioBundle_NT(authCtx, zone, syncedZone.id, src, fromCommitId);
        }
        if (zone.isVersioned()) {
            return this.setVersionedCodeStudioBundle_NT(authCtx, src, zone, syncedZone.pathInZone, fromCommitId);
        }
        return this.setResourcesBundle_NT(zone, syncedZone.pathInZone, src, fromCommitId);
    }

    private DSSGitModel.CodeStudioPushZoneLog setVersionedCodeStudioBundle_NT(AuthCtx authCtx, MultipartFile src, CodeStudioSyncZones.SyncZone zone, String pathInZone, String fromCommitId) throws IllegalStateException, IOException, GitAPIException, DKUSecurityException {
        boolean needToCommit = false;
        pathInZone = PathUtils.makeNotLeadingNoTrailing((String)StringUtils.defaultIfBlank((String)pathInZone, (String)""));
        RelFile bundleFolder = zone.rootRelFile(this.owner, this.codeStudio).appendChildPath(pathInZone);
        try (AutoDelete tmpDir = this.getUnzippedTempFolder(src);){
            logger.info((Object)("Unzipped into " + tmpDir.getAbsolutePath()));
            NativeFS srcFolderFS = NativeFS.from((File)tmpDir).build();
            GitModel.DiffSummary changes = null;
            RelFile changesRelFile = new RelFile(new String[]{"dku_send", CHANGES_HIDDEN_FILE_NAME});
            if (srcFolderFS.exists(changesRelFile)) {
                changes = (GitModel.DiffSummary)JSON.parse((String)srcFolderFS.readStringUTF8(changesRelFile), GitModel.DiffSummary.class);
                logger.info((Object)("Found changes description : " + JSON.pretty((Object)changes)));
                srcFolderFS.deleteFile(changesRelFile);
            }
            try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
                if (changes == null) {
                    if (t.exists(bundleFolder)) {
                        t.deleteDirectory(bundleFolder);
                        needToCommit = true;
                    }
                } else {
                    for (String path : changes.deleted) {
                        if (path == null || ".".equals(path)) {
                            logger.warn((Object)"Can't delete the bundle folder entirely, ignoring");
                            continue;
                        }
                        RelFile file2 = bundleFolder.appendChildPath(path);
                        if (!t.exists(file2)) continue;
                        if (t.isFile(file2)) {
                            t.deleteFile(file2);
                        } else {
                            t.deleteDirectory(file2);
                        }
                        needToCommit = true;
                    }
                }
                RelFileFilter zoneFilter = zone.fileFilter();
                FSUtils.CopyStats copyStats = FSUtils.newRecursiveCopy().from((ReadOnlyFS)srcFolderFS, new RelFile(new String[]{"dku_send"})).to((ReadWriteFS)t, bundleFolder).filter((fs, file) -> !file.getLeafName().equals(COMMITID_HIDDEN_FILE_NAME) && zoneFilter.accept(fs, file)).run();
                if (copyStats.nbFilesCopied > 0) {
                    needToCommit = true;
                }
                if (needToCommit) {
                    t.commit("Update " + zone.codeStudioName() + " bundle of " + this.codeStudio.getDisplayName() + " in " + this.codeStudio.getProjectKey());
                }
            }
        }
        return this.getPushZoneLog(zone, fromCommitId, bundleFolder, needToCommit);
    }

    private DSSGitModel.CodeStudioPushZoneLog getPushZoneLog(CodeStudioSyncZones.SyncZone zone, String fromCommitId, RelFile bundleFolder, boolean isCommited) throws IOException, GitAPIException, DKUSecurityException {
        if (StringUtils.isBlank((String)fromCommitId)) {
            return new DSSGitModel.CodeStudioPushZoneLog(this.getLogOfLastChangeOrHead(zone, bundleFolder), isCommited);
        }
        DSSGitModel.ProjectFilesLog log = zone.isGlobal() ? this.globalObjectsJGitService.getLogFor(zone.objectId(this.owner, this.codeStudio), bundleFolder, fromCommitId, "HEAD") : this.projectsJGitService.getLogFor(zone.tor(this.owner, this.codeStudio), bundleFolder, fromCommitId, "HEAD");
        if (log.logEntries.isEmpty()) {
            log = this.getLogOfLastChangeOrHead(zone, bundleFolder);
        }
        return new DSSGitModel.CodeStudioPushZoneLog(log, isCommited);
    }

    private DSSGitModel.ProjectFilesLog getLogOfLastChangeOrHead(CodeStudioSyncZones.SyncZone zone, RelFile bundleFolder) throws IOException, GitAPIException, DKUSecurityException {
        DSSGitModel.ProjectFilesLog log;
        if (zone.isGlobal()) {
            logger.info((Object)("Get commit id of last change to " + zone.codeStudioName() + ", from " + this.globalHeadCommitIdAtStart));
            log = this.globalObjectsJGitService.getLogFor(zone.objectId(this.owner, this.codeStudio), bundleFolder, this.globalHeadCommitIdAtStart, "HEAD");
        } else {
            logger.info((Object)("Get commit id of last change to " + zone.codeStudioName() + ", from " + this.projectHeadCommitIdAtStart));
            log = this.projectsJGitService.getLogFor(zone.tor(this.owner, this.codeStudio), bundleFolder, this.projectHeadCommitIdAtStart, "HEAD");
        }
        if (log.logEntries.isEmpty()) {
            GitModel.DKULogEntry logEntry = new GitModel.DKULogEntry();
            logEntry.commitId = zone.isGlobal() ? this.globalHeadCommitIdAtStart : this.projectHeadCommitIdAtStart;
            log.logEntries.add(logEntry);
        } else if (log.logEntries.size() > 1) {
            log.logEntries = Lists.newArrayList((Object[])new GitModel.DKULogEntry[]{(GitModel.DKULogEntry)log.logEntries.get(0)});
        }
        logger.info((Object)("found " + ((GitModel.DKULogEntry)log.logEntries.get((int)0)).commitId));
        return log;
    }

    private DSSGitModel.CodeStudioPushZoneLog setRecipesCodeStudioBundle_NT(AuthCtx authCtx, CodeStudioSyncZones.SyncZone zone, MultipartFile src, String fromCommitId) throws Exception {
        boolean needToCommit = false;
        try (AutoDelete tmpDir = this.getUnzippedTempFolder(src);){
            logger.info((Object)("Unzipped into " + tmpDir.getAbsolutePath()));
            NativeFS srcFolderFS = NativeFS.from((File)tmpDir).build();
            GitModel.DiffSummary changes = null;
            RelFile changesRelFile = new RelFile(new String[]{"dku_send", CHANGES_HIDDEN_FILE_NAME});
            if (srcFolderFS.exists(changesRelFile)) {
                changes = (GitModel.DiffSummary)JSON.parse((String)srcFolderFS.readStringUTF8(changesRelFile), GitModel.DiffSummary.class);
                logger.info((Object)("Found changes description : " + JSON.pretty((Object)changes)));
                srcFolderFS.deleteFile(changesRelFile);
            }
            try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
                if (changes != null) {
                    for (String path : changes.deleted) {
                        logger.warn((Object)("Can't directly delete a recipe, ignoring : " + path));
                    }
                    for (String path : changes.added) {
                        logger.warn((Object)("Can't directly add a recipe, ignoring : " + path));
                    }
                    for (String path : changes.modified) {
                        if (path == null || ".".equals(path)) continue;
                        if (!path.matches(".*\\.(py|r|sql|scala|shell|hive|impala|pig)")) {
                            logger.warn((Object)("Can't edit non-code recipe, ignoring : " + path));
                            continue;
                        }
                        PathUtils.FilenameInfo recipeName = new PathUtils.FilenameInfo(path.substring(2));
                        String payload = srcFolderFS.readStringUTF8("dku_send/" + path);
                        SerializedRecipe preExisting = (SerializedRecipe)this.recipesDAO.getOrNullUnsafe(this.codeStudio.projectKey, recipeName.name);
                        if (preExisting == null) {
                            logger.warn((Object)("Can't add a recipe that's not present in DSS, ignoring: " + path));
                            continue;
                        }
                        this.recipeSaveService.save(this.codeStudio.projectKey, preExisting, payload);
                        needToCommit = true;
                    }
                }
                if (needToCommit) {
                    t.commit("Update recipes of " + this.codeStudio.getProjectKey());
                }
            }
        }
        return this.getPushZoneLog(zone, fromCommitId, zone.rootRelFile(this.owner, this.codeStudio), needToCommit);
    }

    private DSSGitModel.CodeStudioPushZoneLog setNotebooksCodeStudioBundle_NT(AuthCtx authCtx, CodeStudioSyncZones.SyncZone zone, String zoneId, MultipartFile src, String fromCommitId) throws Exception {
        boolean needToCommit = false;
        try (AutoDelete tmpDir = this.getUnzippedTempFolder(src);){
            logger.info((Object)("Unzipped into " + tmpDir.getAbsolutePath()));
            NativeFS srcFolderFS = NativeFS.from((File)tmpDir).build();
            GitModel.DiffSummary changes = null;
            RelFile changesRelFile = new RelFile(new String[]{"dku_send", CHANGES_HIDDEN_FILE_NAME});
            if (srcFolderFS.exists(changesRelFile)) {
                changes = (GitModel.DiffSummary)JSON.parse((String)srcFolderFS.readStringUTF8(changesRelFile), GitModel.DiffSummary.class);
                logger.info((Object)("Found changes description : " + JSON.pretty((Object)changes)));
                srcFolderFS.deleteFile(changesRelFile);
            }
            boolean needsResync = false;
            try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
                if (changes != null) {
                    JupyterUtils.NotebookSafeForWritingNew notebook;
                    String payload;
                    String notebookName;
                    for (String path : changes.deleted) {
                        if (path == null || ".".equals(path)) continue;
                        if (!path.matches("\\./[^/]*\\.ipynb")) {
                            logger.warn((Object)("Can only delete notebooks at the root of the notebook folder, ignoring: " + path));
                            continue;
                        }
                        notebookName = new PathUtils.FilenameInfo((String)path.substring((int)2)).name;
                        JupyterUtils.JupyterNotebookListEntry notebookListEntry = this.jupyterService.getOrNull(this.codeStudio.projectKey, notebookName);
                        if (notebookListEntry == null) {
                            logger.warn((Object)("Notebook doesn't exist anymore, can't delete it: " + notebookName));
                            continue;
                        }
                        if (notebookListEntry.associatedRecipe != null) {
                            logger.warn((Object)("Can't delete notebook associated with recipes, ignoring: " + notebookName));
                            continue;
                        }
                        this.jupyterService.unloadNotebookSessionsBeforeDeletion(authCtx, this.codeStudio.projectKey, notebookName);
                        this.jupyterService.delete(this.codeStudio.projectKey, notebookName, authCtx);
                        needToCommit = true;
                    }
                    for (String path : changes.added) {
                        if (path == null || ".".equals(path)) continue;
                        if (!path.matches("\\./[^/]*\\.ipynb")) {
                            logger.warn((Object)("Can only add notebooks at the root of the notebook folder, ignoring: " + path));
                            this.allowAutoReset = false;
                            continue;
                        }
                        notebookName = new PathUtils.FilenameInfo((String)path.substring((int)2)).name;
                        payload = srcFolderFS.readStringUTF8("dku_send/" + path);
                        notebook = (JupyterUtils.NotebookSafeForWritingNew)JSON.parse((String)payload, JupyterUtils.NotebookSafeForWritingNew.class);
                        this.jupyterService.installNotebookFromFile(authCtx, this.codeStudio.projectKey, notebookName, null, notebook);
                        needsResync = true;
                        needToCommit = true;
                    }
                    for (String path : changes.modified) {
                        if (path == null || ".".equals(path)) continue;
                        if (!path.matches("\\./[^/]*\\.ipynb")) {
                            logger.warn((Object)("Can only edit notebooks at the root of the notebook folder, ignoring: " + path));
                            continue;
                        }
                        notebookName = new PathUtils.FilenameInfo((String)path.substring((int)2)).name;
                        payload = srcFolderFS.readStringUTF8("dku_send/" + path);
                        notebook = (JupyterUtils.NotebookSafeForWritingNew)JSON.parse((String)payload, JupyterUtils.NotebookSafeForWritingNew.class);
                        if (this.jupyterService.exists(this.codeStudio.projectKey, notebookName)) {
                            notebook.metadata = this.jupyterService.getJupyterMetadata(this.codeStudio.projectKey, notebookName);
                            notebook.metadata.addProperty("modifiedBy", authCtx.getIdentifier());
                            this.jupyterService.updateNotebookFromFile(authCtx, this.codeStudio.projectKey, notebookName, notebook, null);
                        } else {
                            this.jupyterService.installNotebookFromFile(authCtx, this.codeStudio.projectKey, notebookName, null, notebook);
                            needsResync = true;
                        }
                        needToCommit = true;
                    }
                }
                if (needToCommit) {
                    t.commit("Update notebooks of " + this.codeStudio.getProjectKey());
                }
            }
            if (needsResync && this.allowAutoReset) {
                JsonObject params = new JsonObject();
                params.addProperty("zone", zoneId);
                this.enqueueCommand("push_bundle_to_code_studio", params);
            }
        }
        return this.getPushZoneLog(zone, fromCommitId, zone.rootRelFile(this.owner, this.codeStudio), needToCommit);
    }

    private DSSGitModel.CodeStudioPushZoneLog setResourcesBundle_NT(CodeStudioSyncZones.SyncZone zone, String pathInZone, MultipartFile src, String commitId) throws IllegalStateException, IOException, DKUSecurityException {
        File bundleFolder = zone.rootFile(this.owner, this.codeStudio);
        if (StringUtils.isNotBlank((String)(pathInZone = PathUtils.makeNotLeadingNoTrailing((String)StringUtils.defaultIfBlank((String)pathInZone, (String)""))))) {
            bundleFolder = DKUFileUtils.getWithin((File)bundleFolder, (String[])pathInZone.split("/"));
        }
        String currentDssCommitId = this.makeSnapshotAndFakeCommitId(bundleFolder);
        try (AutoDelete tmpDir = this.getUnzippedTempFolder(src);){
            logger.info((Object)("Unzipped into " + tmpDir.getAbsolutePath()));
            NativeFS srcFolderFS = NativeFS.from((File)tmpDir).build();
            GitModel.DiffSummary changes = null;
            RelFile changesRelFile = new RelFile(new String[]{"dku_send", CHANGES_HIDDEN_FILE_NAME});
            if (srcFolderFS.exists(changesRelFile)) {
                changes = (GitModel.DiffSummary)JSON.parse((String)srcFolderFS.readStringUTF8(changesRelFile), GitModel.DiffSummary.class);
                logger.info((Object)("Found changes description : " + JSON.pretty((Object)changes)));
                srcFolderFS.deleteFile(changesRelFile);
            }
            if (changes == null) {
                File unzippedLibFolder = new File((File)tmpDir, "dku_send");
                File stashedLibCodeStudioFolder = new File(bundleFolder.getParent(), "__" + bundleFolder.getName() + ".bak");
                if (stashedLibCodeStudioFolder.exists()) {
                    logger.warn((Object)"Cleanup target location for stashed folder");
                    DKUFileUtils.forceDelete((File)stashedLibCodeStudioFolder);
                }
                if (bundleFolder.renameTo(stashedLibCodeStudioFolder)) {
                    if (unzippedLibFolder.renameTo(bundleFolder)) {
                        DKUFileUtils.forceDelete((File)stashedLibCodeStudioFolder);
                    } else {
                        logger.error((Object)"Failed to update Code Studio non-versionned files, putting stashed version back");
                        if (stashedLibCodeStudioFolder.renameTo(bundleFolder)) {
                            logger.error((Object)"Unable to put reinstate libs backup");
                        }
                    }
                } else {
                    logger.error((Object)"Failed to stash Code Studio libs away, not updating");
                }
            } else {
                NativeFS t = NativeFS.from((File)bundleFolder).build();
                RelFile libCodeStudioFolderPath = new RelFile(new String[0]);
                for (String path : changes.deleted) {
                    if (path == null || ".".equals(path)) {
                        logger.warn((Object)"Can't delete the lib folder entirely, ignoring");
                        continue;
                    }
                    RelFile file2 = libCodeStudioFolderPath.appendChildPath(path);
                    if (!t.exists(file2)) continue;
                    if (t.isFile(file2)) {
                        t.deleteFile(file2);
                        continue;
                    }
                    t.deleteDirectory(file2);
                }
                FSUtils.newRecursiveCopy().from((ReadOnlyFS)srcFolderFS, new RelFile(new String[]{"dku_send"})).to((ReadWriteFS)t, libCodeStudioFolderPath).filter((fs, file) -> !file.getLeafName().equals(COMMITID_HIDDEN_FILE_NAME)).run();
            }
        }
        String newCommitId = this.makeSnapshotAndFakeCommitId(bundleFolder);
        DSSGitModel.ProjectFilesLog fakeLog = new DSSGitModel.ProjectFilesLog();
        fakeLog.logEntries = Lists.newArrayList();
        fakeLog.logEntries.add(GitModel.DKULogEntry.fakeCommit((String)newCommitId));
        if (!StringUtils.equals((String)commitId, (String)currentDssCommitId)) {
            fakeLog.logEntries.add(GitModel.DKULogEntry.fakeCommit((String)currentDssCommitId));
        }
        return new DSSGitModel.CodeStudioPushZoneLog(fakeLog, true);
    }

    public GitModel.MultiCommitDiffSummary checkConflicts(String zoneId, String commitId, GitModel.DiffSummary changes) throws Exception {
        CodeStudioMeta.SyncZoneInstance syncedZone = this.syncedZones.stream().filter(z -> zoneId.equals(z.id)).findFirst().orElseThrow(() -> new Exception("No zone " + zoneId));
        CodeStudioSyncZones.SyncZone zone = CodeStudioSyncZones.lookup(syncedZone.zone);
        if (syncedZone.oneWay) {
            logger.info((Object)("Zone " + syncedZone.zone + " / " + StringUtils.defaultIfBlank((String)syncedZone.pathInZone, (String)"") + " is one-way, not checking conflicts"));
            return new GitModel.MultiCommitDiffSummary();
        }
        if (zone instanceof CodeStudioSyncZones.NotebooksZone) {
            return this.checkNotebookConflicts(zone, commitId, changes);
        }
        if (zone.isVersioned()) {
            return this.checkVersionedConflicts(zone, syncedZone.pathInZone, commitId, changes);
        }
        return this.checkNonVersionedConflicts(zone, syncedZone.pathInZone, changes);
    }

    private GitModel.MultiCommitDiffSummary checkVersionedConflicts(CodeStudioSyncZones.SyncZone zone, String pathInZone, String commitId, GitModel.DiffSummary changes) throws IOException, GitAPIException, DKUSecurityException {
        pathInZone = PathUtils.makeNotLeadingNoTrailing((String)StringUtils.defaultIfBlank((String)pathInZone, (String)""));
        RelFile bundleFolder = zone.rootRelFile(this.owner, this.codeStudio).appendChildPath(pathInZone);
        DSSGitModel.ProjectFilesDiff objectDiff = zone.isGlobal() ? this.globalObjectsJGitService.getDiffFor(zone.objectId(this.owner, this.codeStudio), bundleFolder, commitId, "HEAD") : this.projectsJGitService.getDiffFor(zone.tor(this.owner, this.codeStudio), bundleFolder, commitId, "HEAD");
        GitModel.MultiCommitDiffSummary diff = objectDiff.summarize();
        if (diff.commitFrom != null && diff.commitTo != null && !StringUtils.equals((String)diff.commitFrom.commitId, (String)diff.commitTo.commitId)) {
            DSSGitModel.ProjectFilesLog log = zone.isGlobal() ? this.globalObjectsJGitService.getLogFor(zone.objectId(this.owner, this.codeStudio), bundleFolder, diff.commitFrom.commitId, diff.commitTo.commitId) : this.projectsJGitService.getLogFor(zone.tor(this.owner, this.codeStudio), bundleFolder, diff.commitFrom.commitId, diff.commitTo.commitId);
            for (GitModel.DKULogEntry e : log.logEntries) {
                diff.authors.add(e.author);
            }
        }
        diff.added = this.reRoot(diff.added, objectDiff.root, ".");
        diff.deleted = this.reRoot(diff.deleted, objectDiff.root, ".");
        diff.modified = this.reRoot(diff.modified, objectDiff.root, ".");
        logger.info((Object)("Got diff in local version " + JSON.pretty((Object)diff)));
        Sets.SetView localChanges = Sets.union((Set)Sets.union((Set)diff.added, (Set)diff.deleted), (Set)diff.modified);
        Sets.SetView remoteChanges = Sets.union((Set)Sets.union((Set)changes.added, (Set)changes.deleted), (Set)changes.modified);
        GitModel.MultiCommitDiffSummary ret = new GitModel.MultiCommitDiffSummary();
        ret.commitFrom = diff.commitFrom;
        ret.commitTo = diff.commitTo;
        if (!Sets.intersection((Set)localChanges, (Set)remoteChanges).isEmpty()) {
            ret.added = new HashSet(Sets.intersection((Set)localChanges, (Set)changes.added));
            ret.modified = new HashSet(Sets.intersection((Set)localChanges, (Set)changes.modified));
            ret.deleted = new HashSet(Sets.difference((Set)Sets.intersection((Set)localChanges, (Set)changes.deleted), (Set)Sets.intersection((Set)changes.deleted, (Set)diff.deleted)));
            ret.authors = diff.authors;
        }
        if (!zone.areNewFilesAccepted()) {
            ret.ignored = Sets.union((Set)Sets.difference((Set)changes.added, (Set)diff.added), (Set)Sets.difference((Set)changes.deleted, (Set)diff.deleted));
            ret.ignored = Sets.union((Set)ret.ignored, (Set)Sets.union((Set)Sets.intersection((Set)changes.added, (Set)diff.deleted), (Set)Sets.intersection((Set)changes.modified, (Set)diff.deleted)));
            ret.modified = Sets.difference((Set)ret.modified, (Set)ret.ignored);
        }
        return ret;
    }

    private GitModel.MultiCommitDiffSummary checkNonVersionedConflicts(CodeStudioSyncZones.SyncZone zone, String pathInZone, GitModel.DiffSummary changes) throws IOException, DKUSecurityException {
        File bundleFolder = zone.rootFile(this.owner, this.codeStudio);
        if (StringUtils.isNotBlank((String)(pathInZone = PathUtils.makeNotLeadingNoTrailing((String)StringUtils.defaultIfBlank((String)pathInZone, (String)""))))) {
            bundleFolder = DKUFileUtils.getWithin((File)bundleFolder, (String[])pathInZone.split("/"));
        }
        GitModel.MultiCommitDiffSummary ret = new GitModel.MultiCommitDiffSummary();
        List<FSPathOrDirectory> snapshot = this.makeSnapshot(bundleFolder);
        File changeTrackingFile = new File(bundleFolder, CHANGES_HIDDEN_FILE_NAME);
        if (changeTrackingFile.exists()) {
            List prevSnapshot = (List)JSON.parseFile((File)changeTrackingFile, (TypeToken)new TypeToken<List<FSPathOrDirectory>>(){});
            GitModel.MultiCommitDiffSummary diff = this.diffSnapshot(prevSnapshot, snapshot);
            diff.added = this.reRoot(diff.added, "/", "./");
            diff.deleted = this.reRoot(diff.deleted, "/", "./");
            diff.modified = this.reRoot(diff.modified, "/", "./");
            logger.info((Object)("Got diff in local version " + JSON.pretty((Object)diff)));
            Sets.SetView localChanges = Sets.union((Set)Sets.union((Set)diff.added, (Set)diff.deleted), (Set)diff.modified);
            Sets.SetView remoteChanges = Sets.union((Set)Sets.union((Set)changes.added, (Set)changes.deleted), (Set)changes.modified);
            ret.commitFrom = GitModel.DKULogEntry.fakeCommit((String)Base64.encodeBase64String((byte[])JSON.sha256((Object)prevSnapshot)));
            ret.commitTo = GitModel.DKULogEntry.fakeCommit((String)Base64.encodeBase64String((byte[])JSON.sha256(snapshot)));
            if (!Sets.intersection((Set)localChanges, (Set)remoteChanges).isEmpty()) {
                ret.added = Sets.intersection((Set)localChanges, (Set)changes.added);
                ret.modified = Sets.intersection((Set)localChanges, (Set)changes.modified);
                ret.deleted = Sets.intersection((Set)localChanges, (Set)changes.deleted);
                ret.authors = diff.authors;
            }
        } else {
            logger.warn((Object)"Missing snapshot of resources Code Studio folder => assuming no changes occurred");
        }
        return ret;
    }

    private GitModel.MultiCommitDiffSummary checkNotebookConflicts(CodeStudioSyncZones.SyncZone zone, String commitId, GitModel.DiffSummary changes) throws IOException, GitAPIException, DKUSecurityException {
        GitModel.MultiCommitDiffSummary conflicts = this.checkVersionedConflicts(zone, null, commitId, changes);
        Sets.SetView remoteChanges = Sets.union((Set)Sets.union((Set)changes.added, (Set)changes.deleted), (Set)changes.modified);
        List<JupyterUtils.ActiveSession> sessions = this.jupyterService.listActiveSessions();
        for (String path : remoteChanges) {
            if (!path.endsWith(".ipynb")) continue;
            String notebookName = new PathUtils.FilenameInfo((String)path.substring((int)2)).name;
            for (JupyterUtils.ActiveSession activeSession : sessions) {
                if (!activeSession.projectKey.equals(this.codeStudio.projectKey) || !activeSession.notebookName.equals(notebookName)) continue;
                conflicts.modified.add(path);
            }
        }
        for (String path : remoteChanges) {
            if (!path.endsWith(".ipynb") || path.contains(".ipynb_checkpoints/") || StringUtils.countMatches((String)path, (String)"/") < 2) continue;
            conflicts.ignored.add(path);
        }
        return conflicts;
    }

    private GitModel.MultiCommitDiffSummary diffSnapshot(List<FSPathOrDirectory> from, List<FSPathOrDirectory> to) {
        GitModel.MultiCommitDiffSummary ret = new GitModel.MultiCommitDiffSummary();
        Map<String, FSPathOrDirectory> fromPaths = from.stream().collect(Collectors.toMap(FSPath::path, p -> p));
        Map<String, FSPathOrDirectory> toPaths = to.stream().collect(Collectors.toMap(FSPath::path, p -> p));
        ret.added = Sets.difference(toPaths.keySet(), fromPaths.keySet());
        ret.deleted = Sets.difference(fromPaths.keySet(), toPaths.keySet());
        ret.modified = toPaths.keySet().stream().filter(fromPaths::containsKey).filter(p -> ((FSPathOrDirectory)toPaths.get(p)).getLastModified() != ((FSPathOrDirectory)fromPaths.get(p)).getLastModified() || ((FSPathOrDirectory)toPaths.get(p)).getSize() != ((FSPathOrDirectory)fromPaths.get(p)).getSize()).collect(Collectors.toSet());
        return ret;
    }

    private Set<String> reRoot(Set<String> paths, String oldRoot, String newRoot) {
        HashSet ret = Sets.newHashSet();
        for (String path : paths) {
            if (path.startsWith(oldRoot)) {
                ret.add(newRoot + path.substring(oldRoot.length()));
                continue;
            }
            ret.add(path);
        }
        return ret;
    }

    public class CodeStudioStateLabelAggregator
    implements IStateLabelAggregator {
        public StateLabelAggregator aggregator = new StateLabelAggregator();

        public Closeable startWaitingOn(String chunk) {
            return this.aggregator.startWaitingOn(chunk);
        }

        public String makeStateLabel() {
            return this.aggregator.makeStateLabel();
        }
    }

    public static class CodeStudioPersistedState {
        public String jobId;
        public CodeStudioRuntimeState state = CodeStudioRuntimeState.STOPPED;
        public long lastStateChange;
        public String executionId;
        public List<String> deploymentStartFiles;
        public ContainerExecRuntimeConfig containerConfig;
        public DSSAuthCtx authCtx;
        public String apiTicket;
        public CodeStudioObject codeStudio;
        public CodeStudioRunDefinition codeStudioDefinition;
        public List<CodeEnvModel.EnvFullRef> codeEnvs;
        public CodeStudioMeta.CodeStudioLaunchSpec launchSpec;
        public String globalHeadCommitIdAtStart;
        public String projectHeadCommitIdAtStart;
    }

    public class CodeStudioCommand {
        public int no;
        public String type;
        public JsonObject params;
    }

    public class CodeStudioResponse {
        public long received;
        public byte[] data;
    }

    private class WaitCommandResultThread
    extends SimpleFutureThread<CommandResult> {
        private final int commandNo;

        public WaitCommandResultThread(AuthCtx authCtx, int commandNo) {
            super(authCtx);
            this.commandNo = commandNo;
        }

        @Override
        protected CommandResult compute() throws Exception {
            logger.info((Object)"Start waiting for command response");
            long st2 = System.currentTimeMillis();
            long timeout = ApplicationConfigurator.getParams().getLongParam("dip.codestudio.command_timeout", 600000L);
            long sleepDuration = 100L;
            do {
                byte[] data;
                if ((data = CodeStudioRuntime.this.pollAnswer(this.commandNo)) != null) {
                    logger.info((Object)"Response received");
                    CommandResult resp = (CommandResult)JSON.parse((byte[])data, CommandResult.class);
                    if (resp.error != null) {
                        throw new SocketBlockLinkKernelException("Failed to run command", resp.error);
                    }
                    return resp;
                }
                Thread.sleep(sleepDuration);
                sleepDuration = Math.min(10000L, sleepDuration + 100L);
            } while (System.currentTimeMillis() < st2 + timeout);
            logger.info((Object)"Done waiting for command result, none received");
            throw new TimeoutException("Waiting for remote command result timeout");
        }

        public FuturePayload getPayload() {
            return FuturePayload.newSimple((String)"wait_command", (String)"Wait for command completion on Code Studio");
        }
    }

    public static class CodeStudioUIState {
        public CodeStudioRuntimeState state;
        public long lastStateChange;
        public long lastTemplateBuilt = -1L;
        public String jobId;
        public int exposableCount;
        public List<CodeStudioExposedState> exposed = Lists.newArrayList();
        public List<CodeStudioMeta.CodeStudioCustomCommand> customCommands;
        public List<CodeStudioMeta.SyncZoneInstance> syncedZones = Lists.newArrayList();
        public String runAsUser;

        public CodeStudioUIState(CodeStudioPersistedState persistedState, String runAsUser) {
            this.lastStateChange = persistedState.lastStateChange;
            this.state = persistedState.state;
            this.jobId = persistedState.jobId;
            this.runAsUser = runAsUser;
        }

        public CodeStudioUIState(CodeStudioPersistedState persistedState) {
            this(persistedState, null);
        }

        public CodeStudioUIState() {
        }

        public CodeStudioUIState withState(CodeStudioRuntimeState state) {
            this.state = state;
            return this;
        }
    }

    public static enum CodeStudioRuntimeState {
        STOPPED,
        STARTING,
        RUNNING,
        STOPPING;

    }

    public static class CodeStudioRunInfo
    extends CodeStudioUIState {
        public SmartLogTail logTail;
        public List<DeploymentMonitorThread.DeployedKubectlObject> kubectlDescribes = Lists.newArrayList();

        public CodeStudioRunInfo(CodeStudioPersistedState persistedState, String owner) {
            super(persistedState, owner);
        }

        public CodeStudioRunInfo(CodeStudioPersistedState persistedState) {
            super(persistedState);
        }

        public CodeStudioRunInfo() {
        }
    }

    public static class CodeStudioRunDefinition {
        public List<String> entrypoints;
        public String projectKey;
        public String codeStudioId;
        public String baseUrl;
        public List<CodeStudioMeta.SyncZoneInstance> syncedZones = Lists.newArrayList();
        public List<String> excludedFromSync = Lists.newArrayList();
        public String fileAdjustmentScript;
        public boolean handleCommands = true;
        public String webAppId;
        public List<ContainerForwardedPort> ports = Lists.newArrayList();
        public WebAppSecurityInfo securityInfo;
        public String readinessProbeUrl;
        public int tcpProbePort;
        public boolean reattachOnRestart;
    }

    public abstract class AbstractCodeStudioExposable
    extends Thread
    implements Exposables.KubernetesExposable {
        protected final String executionId;
        protected final List<String> selectors;
        protected ExpositionHandler expositionHandler;
        protected DKUtils.RotatingLoggingSubscription mainLog;
        protected DKUtils.SmartLogTailBuilder smartLogTailBuilder;
        protected final AbstractExposedEndpointCollector endpointsCollector;

        public AbstractCodeStudioExposable(String executionId, List<String> selectors, AbstractExposedEndpointCollector endpointsCollector) {
            this.executionId = executionId;
            this.selectors = selectors;
            this.endpointsCollector = endpointsCollector;
        }

        @Override
        public File getTmpDir() {
            return CodeStudioRuntime.this.workingDir;
        }

        @Override
        public String getExecutionId() {
            return this.executionId;
        }

        @Override
        public String getNamePrefix() {
            return "dku-code-studio";
        }

        @Override
        public Map<String, String> getLabels() {
            HashMap<String, String> labels = new HashMap<String, String>();
            labels.put("dataiku.com/dku-execution-id", this.executionId);
            return labels;
        }

        @Override
        public Map<String, String> getAnnotations() {
            HashMap<String, String> annotations = new HashMap<String, String>();
            annotations.put("dataiku.com/dku-execution-type", ComputeResourceUsageContext.ComputeResourceUsageContextType.CODE_STUDIO.name());
            annotations.put("dataiku.com/dku-exec-submitter", CodeStudioRuntime.this.codeStudio.owner);
            annotations.put("dataiku.com/dku-install-id", ApplicationConfigurator.getInstallId());
            annotations.put("dataiku.com/dku-project-key", CodeStudioRuntime.this.codeStudio.projectKey);
            annotations.put("dataiku.com/dku-codestudio-id", CodeStudioRuntime.this.codeStudio.id);
            return annotations;
        }

        @Override
        public Map<String, String> getSelectors() {
            HashMap<String, String> selectorMap = new HashMap<String, String>();
            for (String selector : this.selectors) {
                try {
                    if (selector.contains(":")) {
                        String[] splitLine = selector.split(":", 2);
                        selectorMap.put(splitLine[0].trim(), splitLine[1].trim());
                        continue;
                    }
                    logger.warnV("Unable to parse/add selector '%s'", new Object[]{selector});
                }
                catch (Exception e) {
                    logger.warnV((Throwable)e, "Unable to parse/add selector '%s'", new Object[]{selector});
                }
            }
            return selectorMap;
        }

        @Override
        public String getPropertiesPrefix() {
            return "codestudio";
        }

        @Override
        public List<SimpleKeyValue> getProperties() {
            return Lists.newArrayList();
        }

        public void init(DKUtils.RotatingLoggingSubscription mainLog, DKUtils.SmartLogTailBuilder smartLogTailBuilder) {
            this.mainLog = mainLog;
            this.smartLogTailBuilder = smartLogTailBuilder;
        }

        @Override
        public void run() {
            try {
                logger.info((Object)("Starting code studio exposition: " + this.expositionHandler.getClass().getCanonicalName()));
                this.expositionHandler.start((DKUtils.LineSubscriptionAttacher)this.mainLog, this.smartLogTailBuilder);
                logger.info((Object)"Waiting for code studio exposition to start");
                this.expositionHandler.waitReady((DKUtils.LineSubscriptionAttacher)this.mainLog, this.smartLogTailBuilder);
                logger.info((Object)"Code studio exposition has started, waiting for backend to be ready");
            }
            catch (Exception e) {
                logger.error((Object)"Failed to wait for exposition start", (Throwable)e);
            }
        }

        public void kill() {
            if (this.expositionHandler != null) {
                this.expositionHandler.cleanup();
                this.expositionHandler = null;
            }
        }

        public abstract List<CodeStudioExposedState> getExposed();
    }

    public class CodeStudioServiceExposable
    extends AbstractCodeStudioExposable {
        private final CodeStudioMeta.ExposedCodeStudioService exposedCodeStudioService;
        private String expandedServiceName;

        public CodeStudioServiceExposable(String executionId, CodeStudioMeta.ExposedCodeStudioService exposedCodeStudioService, List<String> selectors) {
            super(executionId, selectors, new CodeStudioServicesCollector(exposedCodeStudioService.label, exposedCodeStudioService.port));
            this.exposedCodeStudioService = exposedCodeStudioService;
        }

        @Override
        public int getContainerizedPort() {
            return this.exposedCodeStudioService.port;
        }

        @Override
        public String getExposedService() {
            return this.expandedServiceName;
        }

        @Override
        public void init(DKUtils.RotatingLoggingSubscription mainLog, DKUtils.SmartLogTailBuilder smartLogTailBuilder) {
            super.init(mainLog, smartLogTailBuilder);
            try {
                VariablesContext variablesContext = CodeStudioRuntime.this.variablesService.getForProject(CodeStudioRuntime.this.codeStudio.projectKey);
                this.expandedServiceName = variablesContext.expandAllowUnresolved(this.exposedCodeStudioService.service);
                Exposition exposition = this.exposedCodeStudioService.exposition;
                ExpositionMeta expositionMeta = ExpositionRegistry.getMeta(exposition);
                if (this.exposedCodeStudioService.localPort > 0 && expositionMeta == PortForwardToServiceExposition.META) {
                    exposition.getParamsAs(PortForwardToServiceExposition.PortForwardToServiceExpositionParams.class).fixedPort = this.exposedCodeStudioService.localPort;
                }
                expositionMeta.expandParametersInPlace(variablesContext, exposition);
                this.expositionHandler = expositionMeta.buildHandler(CodeStudioRuntime.this.owner, CodeStudioRuntime.this.codeStudio.projectKey, CodeStudioRuntime.this.containerConfig, exposition, this.endpointsCollector);
                this.expositionHandler.init(this, CodeStudioRuntime.this.stateLabelAggregator);
                this.start();
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to init exposition", e);
            }
        }

        @Override
        public List<CodeStudioExposedState> getExposed() {
            ArrayList ret = Lists.newArrayList();
            if (this.expositionHandler != null) {
                try {
                    ExpositionHandler.ExpositionStatus status = this.expositionHandler.getStatus((DKUtils.LineSubscriptionAttacher)this.mainLog, this.smartLogTailBuilder);
                    if (status != null && !status.endpoints.isEmpty()) {
                        CodeStudioExposedState exposedState = new CodeStudioExposedState();
                        exposedState.label = this.exposedCodeStudioService.label;
                        exposedState.exposeHtml = false;
                        exposedState.url = null;
                        exposedState.exposedPort = this.exposedCodeStudioService.port;
                        ret.add(exposedState);
                    }
                }
                catch (Exception e) {
                    logger.warn((Object)("Unable to get exposition status for port " + this.exposedCodeStudioService.label), (Throwable)e);
                }
            }
            return ret;
        }
    }

    public class CodeStudioPodExposable
    extends AbstractCodeStudioExposable {
        private final CodeStudioMeta.ExposedCodeStudioPort exposedCodeStudioPort;

        public CodeStudioPodExposable(String executionId, CodeStudioMeta.ExposedCodeStudioPort exposedCodeStudioPort, List<String> selectors) {
            super(executionId, selectors, new CodeStudioEndpointsCollector(exposedCodeStudioPort.label, exposedCodeStudioPort.proxiedUrlSuffix, exposedCodeStudioPort.port, exposedCodeStudioPort.proxyPrefixHeaderName));
            this.exposedCodeStudioPort = exposedCodeStudioPort;
        }

        @Override
        public int getContainerizedPort() {
            return this.exposedCodeStudioPort.containerPort == null ? this.exposedCodeStudioPort.port : this.exposedCodeStudioPort.containerPort;
        }

        @Override
        public String getExposedService() {
            return null;
        }

        @Override
        public void init(DKUtils.RotatingLoggingSubscription mainLog, DKUtils.SmartLogTailBuilder smartLogTailBuilder) {
            super.init(mainLog, smartLogTailBuilder);
            try {
                Exposition exposition = this.exposedCodeStudioPort.exposition;
                VariablesContext variablesContext = CodeStudioRuntime.this.variablesService.getForProject(CodeStudioRuntime.this.codeStudio.projectKey);
                ExpositionMeta expositionMeta = ExpositionRegistry.getMeta(exposition);
                expositionMeta.expandParametersInPlace(variablesContext, exposition);
                this.expositionHandler = expositionMeta.buildHandler(CodeStudioRuntime.this.owner, CodeStudioRuntime.this.codeStudio.projectKey, CodeStudioRuntime.this.containerConfig, exposition, this.endpointsCollector);
                this.expositionHandler.init(this, CodeStudioRuntime.this.stateLabelAggregator);
                this.start();
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to init exposition", e);
            }
        }

        @Override
        public List<CodeStudioExposedState> getExposed() {
            ArrayList ret = Lists.newArrayList();
            if (this.expositionHandler != null) {
                try {
                    ExpositionHandler.ExpositionStatus status = this.expositionHandler.getStatus((DKUtils.LineSubscriptionAttacher)this.mainLog, this.smartLogTailBuilder);
                    if (status != null && !status.endpoints.isEmpty()) {
                        CodeStudioExposedState exposedState = new CodeStudioExposedState();
                        exposedState.label = this.exposedCodeStudioPort.label;
                        exposedState.exposeHtml = this.exposedCodeStudioPort.exposeHtml;
                        exposedState.url = CodeStudioRuntime.this.getCodeStudioNginxExposedUrl(this.exposedCodeStudioPort.port);
                        exposedState.exposedPort = this.exposedCodeStudioPort.port;
                        ret.add(exposedState);
                    }
                }
                catch (Exception e) {
                    logger.warn((Object)("Unable to get exposition status for port " + this.exposedCodeStudioPort.label), (Throwable)e);
                }
            }
            return ret;
        }
    }

    public static class ContainerForwardedPort {
        public int insidePort;
        public int outsidePort;

        public ContainerForwardedPort(int insidePort, int outsidePort) {
            this.insidePort = insidePort;
            this.outsidePort = outsidePort;
        }

        public ContainerForwardedPort(int port) {
            this.insidePort = port;
            this.outsidePort = port;
        }
    }

    public static class CommandResult {
        public int rv;
        public String tailOut;
        public String tailErr;
        public SocketBlockLinkInteraction.SocketBlockLinkKernelError error;
    }

    public class CodeStudioServicesCollector
    extends AbstractExposedEndpointCollector {
        private final String label;
        private final int exposedPort;

        public CodeStudioServicesCollector(String label, int exposedPort) {
            this.label = label;
            this.exposedPort = exposedPort;
        }

        @Override
        protected void endpointsChanged(List<ExposedEndpointConsumer.ExposedEndpoint> endpoints) throws Exception {
            logger.info((Object)("Services endpoints changed, handing " + this.label + " for port " + this.exposedPort));
        }
    }

    public class CodeStudioEndpointsCollector
    extends AbstractExposedEndpointCollector {
        private final String label;
        private final String proxiedUrlSuffix;
        private final int exposedPort;
        private final String proxyPrefixHeaderName;

        public CodeStudioEndpointsCollector(String label, String proxiedUrlSuffix, int exposedPort, String proxyPrefixHeaderName) {
            this.label = label;
            this.proxiedUrlSuffix = proxiedUrlSuffix;
            this.exposedPort = exposedPort;
            this.proxyPrefixHeaderName = proxyPrefixHeaderName;
        }

        @Override
        protected void endpointsChanged(List<ExposedEndpointConsumer.ExposedEndpoint> endpoints) throws Exception {
            Object config = endpoints.stream().flatMap(e -> CodeStudioRuntime.this.buildNginxConf((ExposedEndpointConsumer.ExposedEndpoint)e, this.proxiedUrlSuffix, this.proxyPrefixHeaderName, this.exposedPort).stream()).collect(Collectors.joining("\n"));
            File configFile = ApplicationConfigurator.getFile((String)("install-support/backends.d/" + CodeStudioRuntime.this.codeStudio.projectKey + "/" + CodeStudioRuntime.this.codeStudio.id + "-" + this.exposedPort + ".conf"));
            DKUFileUtils.mkdirsParent((File)configFile);
            config = "# expose " + this.label + " of Code Studio\n\n" + (String)config;
            DKUFileUtils.writeFileUTF8((File)configFile, (String)config);
            NginxUtils.hupNginx();
        }
    }

    public static class CodeStudioExposedState {
        public String label;
        public String url;
        public boolean exposeHtml;
        public int exposedPort;
    }
}

