/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.codestudio.template;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.DSSTempUtils;
import com.dataiku.dip.code.AutomationNodeCodeEnvsAccessService;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.code.DesignNodeCodeEnvsAccessService;
import com.dataiku.dip.codestudio.CodeStudioCodes;
import com.dataiku.dip.codestudio.CodeStudioMeta;
import com.dataiku.dip.codestudio.CodeStudioRegistry;
import com.dataiku.dip.codestudio.blocks.BlockBasedCodeStudioMeta;
import com.dataiku.dip.codestudio.blocks.BlockBasedCodeStudioTemplateParams;
import com.dataiku.dip.codestudio.blocks.CodeStudioBlock;
import com.dataiku.dip.codestudio.blocks.CodeStudioBlockMeta;
import com.dataiku.dip.codestudio.blocks.CodeStudioBlockRegistry;
import com.dataiku.dip.codestudio.blocks.EntrypointCodeStudioBlockMeta;
import com.dataiku.dip.codestudio.blocks.component.PythonPluginCodeStudioBlockParams;
import com.dataiku.dip.codestudio.object.CodeStudioObject;
import com.dataiku.dip.codestudio.object.CodeStudioObjectsService;
import com.dataiku.dip.codestudio.runtime.CodeStudioRuntime;
import com.dataiku.dip.codestudio.runtime.CodeStudioRuntimeManager;
import com.dataiku.dip.codestudio.template.CodeStudioTemplate;
import com.dataiku.dip.codestudio.template.CodeStudioTemplateImagesHandler;
import com.dataiku.dip.codestudio.template.PerCodeStudioTemplateLoggingAppender;
import com.dataiku.dip.containers.exec.ContainerExecImagesHelper;
import com.dataiku.dip.containers.exec.ContainerExecRuntimeConfig;
import com.dataiku.dip.containers.exec.ContainerExecUtils;
import com.dataiku.dip.containers.exec.WorkloadType;
import com.dataiku.dip.coremodel.HeadWithVersioningInfo;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.VersionTag;
import com.dataiku.dip.dao.CodeStudioObjectsDAO;
import com.dataiku.dip.dao.CodeStudioTemplatesDAO;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.export.ZipUnzipDir;
import com.dataiku.dip.fs.FSPathOrDirectory;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.SimpleFutureThread;
import com.dataiku.dip.projects.importexport.ExportedProject;
import com.dataiku.dip.projects.importexport.model.ProjectRemappingSettings;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.UsersService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.ifaces.MinimalRWTransaction;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.utils.AutoCloseableLock;
import com.dataiku.dip.utils.DKUDateUtils;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.NamedLock;
import com.dataiku.dip.utils.PathUtils;
import com.dataiku.dip.utils.SmartLogTail;
import com.dataiku.dip.utils.StringTransmogrifier;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dip.variables.VariablesService;
import com.dataiku.dss.shadelib.com.google.api.client.util.Maps;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.dataiku.dss.shadelib.org.joda.time.DateTimeZone;
import com.dataiku.dss.shadelib.org.joda.time.format.DateTimeFormat;
import com.dataiku.dss.shadelib.org.joda.time.format.DateTimeFormatter;
import com.google.common.collect.Lists;
import com.google.gson.reflect.TypeToken;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Appender;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CodeStudioTemplatesService {
    @Autowired
    private CodeStudioTemplatesDAO dao;
    @Autowired
    private CodeStudioObjectsDAO codeStudioObjectsDAO;
    @Autowired
    private UsersService usersService;
    @Autowired
    private FutureService futureService;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private CodeStudioRuntimeManager runtimeManager;
    @Autowired
    private VariablesService variablesService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private CodeStudioObjectsService codeStudioObjectsService;
    public static final String CONTAINER_CONFIG_BASE_IMAGE_HOLDER = "__CONTAINER_CONFIG_BASE_IMAGE__";
    public static final String TEMPLATE_RESOURCES_HOLDER = "__TEMPLATE_RESOURCES__";
    public static final String TEMPLATE_RESOURCES_SUBDIR = "template-resources";
    public static final String IMPORTED_RESOURCES_SUBDIR = "imported-resources";
    private static PerCodeStudioTemplateLoggingAppender buildLogAppender = new PerCodeStudioTemplateLoggingAppender();
    private static DateTimeFormatter buildIdFormatter = DateTimeFormat.forPattern((String)"'build-'yyyy-MM-dd-HH-mm-ss-SSS").withZone(DateTimeZone.getDefault());
    private static Logger logger = Logger.getLogger((String)"dip.codestudio.template");

    private static long buildDateFromBuildId(String buildId) {
        return buildIdFormatter.parseMillis(buildId.replaceFirst("_[0-9]*", ""));
    }

    public List<CodeStudioTemplate> listUnsafe() throws Exception {
        return this.dao.listUnsafe();
    }

    public CodeStudioTemplate getMandatoryUnsafe(String templateId) throws Exception {
        return this.dao.getMandatoryUnsafe(templateId);
    }

    public CodeStudioTemplate getOrNullUnsafe(String templateId) throws Exception {
        return this.dao.getOrNullUnsafe(templateId);
    }

    public long getLastBuilt(String templateId) throws IOException {
        CodeStudioTemplateImageBuilt latest = CodeStudioTemplatesService.getLatest(templateId);
        return latest == null ? 0L : CodeStudioTemplatesService.buildDateFromBuildId(latest.buildId);
    }

    public List<CodeStudioTemplate.ListItem> listHeads() throws Exception {
        ArrayList<CodeStudioTemplate.ListItem> ret = new ArrayList<CodeStudioTemplate.ListItem>();
        for (CodeStudioTemplate codeStudioTemplate : this.listUnsafe()) {
            CodeStudioTemplate.ListItem listItem = new CodeStudioTemplate.ListItem(codeStudioTemplate);
            this.setEditionInfoFromTags(codeStudioTemplate, listItem);
            if (CodeStudioRegistry.hasMeta(codeStudioTemplate)) {
                listItem.desc = CodeStudioRegistry.getMeta(codeStudioTemplate).getTemplateType();
            }
            listItem.lastBuilt = this.getLastBuilt(codeStudioTemplate.id);
            listItem.buildFor = codeStudioTemplate.allContainerConfs ? Lists.newArrayList((Object[])new String[]{"*"}) : Lists.newArrayList(codeStudioTemplate.containerConfs);
            listItem.defaultConf = codeStudioTemplate.defaultContainerConf;
            ret.add(listItem);
        }
        return ret;
    }

    public void setEditionInfoFromTags(CodeStudioTemplate object, CodeStudioTemplate.ListItem head) {
        try {
            if (object.versionTag != null) {
                head.lastModifiedBy = this.usersService.getPublicUser(object.versionTag.getLastAuthor());
                head.lastModifiedOn = object.versionTag.getLastModifiedOn();
            } else {
                logger.trace((Object)("Code Studio tamplate " + object.id + " has no version tag"));
            }
            if (object.creationTag != null) {
                head.createdBy = this.usersService.getPublicUser(object.creationTag.getLastAuthor());
                head.createdOn = object.creationTag.getLastModifiedOn();
            } else {
                logger.trace((Object)("Code Studio tamplate " + object.id + " has no creation tag"));
            }
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to get edition info", (Throwable)e);
        }
    }

    public CodeStudioTemplateFullInfo getFullInfo(AuthCtx authCtx, String codeStudioTemplateId) throws IOException, DKUSecurityException {
        CodeStudioTemplate object = this.dao.getMandatoryUnsafe(codeStudioTemplateId);
        CodeStudioTemplateFullInfo info = new CodeStudioTemplateFullInfo();
        info.codeStudioTemplate = object;
        try {
            if (object.versionTag != null) {
                info.versioning.lastModifiedBy = this.usersService.getPublicUser(object.versionTag.getLastAuthor());
                info.versioning.lastModifiedOn = object.versionTag.getLastModifiedOn();
            } else {
                logger.trace((Object)("Code Studio tamplate " + object.id + " has no version tag"));
            }
            if (object.creationTag != null) {
                info.versioning.createdBy = this.usersService.getPublicUser(object.creationTag.getLastAuthor());
                info.versioning.createdOn = object.creationTag.getLastModifiedOn();
            } else {
                logger.trace((Object)("Code Studio tamplate " + object.id + " has no creation tag"));
            }
        }
        catch (Exception e) {
            logger.info((Object)"Failed to get template info", (Throwable)e);
        }
        if (CodeStudioRegistry.hasMeta(object)) {
            CodeStudioMeta meta = CodeStudioRegistry.getMeta(object);
            info.desc = meta.getTemplateType();
            if (meta instanceof BlockBasedCodeStudioMeta) {
                BlockBasedCodeStudioTemplateParams params = object.getParamsAs(BlockBasedCodeStudioTemplateParams.class);
                for (CodeStudioBlock b : params.blocks) {
                    if ("entrypoint".equals(b.type)) {
                        EntrypointCodeStudioBlockMeta.EntrypointCodeStudioBlockParams p = b.getParamsAs(EntrypointCodeStudioBlockMeta.EntrypointCodeStudioBlockParams.class);
                        if (!p.useInWebapps) {
                            logger.info((Object)("Block " + b.type + "not used in webapps"));
                            continue;
                        }
                        info.availablePorts.add(p.exposedPort);
                    }
                    if (!b.type.startsWith("pycdstdioblk_") || !CodeStudioBlockRegistry.hasMeta(b)) continue;
                    CodeStudioBlockMeta blockMeta = CodeStudioBlockRegistry.getMeta(b);
                    PythonPluginCodeStudioBlockParams p = b.getParamsAs(PythonPluginCodeStudioBlockParams.class);
                    if (p.config.has("useInWebapps") && p.config.get("useInWebapps").isJsonPrimitive() && !p.config.getAsJsonPrimitive("useInWebapps").getAsBoolean()) {
                        logger.info((Object)("Block " + b.type + "not used in webapps"));
                        continue;
                    }
                    if (!p.config.has("port") || !p.config.get("port").isJsonPrimitive() || !p.config.getAsJsonPrimitive("port").isNumber()) continue;
                    CodeStudioMeta.ExposedCodeStudioPort exposed = new CodeStudioMeta.ExposedCodeStudioPort();
                    exposed.label = StringUtils.defaultIfBlank((String)blockMeta.getBlockType().label, (String)b.type);
                    exposed.port = p.config.getAsJsonPrimitive("port").getAsInt();
                    exposed.exposeHtml = true;
                    info.availablePorts.add(exposed);
                }
            }
        }
        info.canUpdate = this.permissionsService.hasCodeStudioTemplatePrivilege(authCtx, codeStudioTemplateId, Privileges.CodeStudioTemplatePrivilegeType.UPDATE);
        info.paramsHash = object.makeParamsHash();
        info.latestBuild = CodeStudioTemplatesService.getLatest(object);
        return info;
    }

    public InfoMessage.InfoMessages delete(AuthCtx authCtx, String templateId, boolean deleteRuntimes, boolean deleteImages) throws Exception {
        CodeStudioTemplate codeStudioTemplate;
        InfoMessage.InfoMessages ret = new InfoMessage.InfoMessages();
        try (Transaction t = this.transactionService.beginRead();){
            codeStudioTemplate = this.dao.getMandatoryUnsafe(templateId);
        }
        if (deleteRuntimes) {
            List<String> projectKeys;
            try (Transaction t = this.transactionService.beginRead();){
                projectKeys = this.projectsService.listProjectKeys();
            }
            Usages usages = this.listUsages_NT(authCtx, codeStudioTemplate, projectKeys, false);
            logger.info((Object)("Deleting Code Studios associated to Code Studio template : " + templateId));
            for (ProjectUsages projectUsage : usages.projects) {
                for (Usage usage : projectUsage.codeStudios) {
                    try {
                        RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);
                        try {
                            this.codeStudioObjectsService.delete(authCtx, projectUsage.projectKey, usage.id);
                            t.commit(String.format("Deleted Code Studio %s (%s)", usage.name, usage.id), 0L, MinimalRWTransaction.TransactionGitCommitPolicy.IF_AUTO);
                        }
                        finally {
                            if (t == null) continue;
                            t.close();
                        }
                    }
                    catch (Exception e) {
                        ret.withError((InfoMessage.MessageCode)CodeStudioCodes.ERR_CODE_STUDIO_DELETE_FAILED, "Couldn't delete Code Studio " + usage.name + " : " + ExceptionUtils.getMessageWithCauses((Throwable)e));
                    }
                }
            }
        }
        if (deleteImages && CodeStudioTemplatesService.getLatest(templateId) != null) {
            logger.info((Object)("Deleting images associated to Code Studio template : " + templateId));
            File temporary = CodeStudioTemplatesService.getBuildDir(templateId);
            if (temporary.exists()) {
                try {
                    DKUFileUtils.forceDelete((File)temporary);
                }
                catch (IOException e) {
                    ret.withError((InfoMessage.MessageCode)CodeStudioCodes.ERR_CODE_STUDIO_CONTAINER_IMAGE_DELETE_FAILED, "Couldn't delete build folder " + temporary.getName() + " : " + ExceptionUtils.getMessageWithCauses((Throwable)e));
                    logger.error((Object)("Couldn't delete build folder" + temporary.getAbsolutePath() + " for Code Studio template " + templateId + " : " + String.valueOf(e)));
                }
            }
            List<CodeStudioTemplateImagesHandler> deleters = CodeStudioTemplateImagesHandler.getHandlers(codeStudioTemplate);
            for (CodeStudioTemplateImagesHandler deleter : deleters) {
                try {
                    deleter.delete();
                }
                catch (Exception e) {
                    ret.withError((InfoMessage.MessageCode)CodeStudioCodes.ERR_CODE_STUDIO_CONTAINER_IMAGE_DELETE_FAILED, "Couldn't delete image " + deleter.imageName + " : " + ExceptionUtils.getMessageWithCauses((Throwable)e));
                    logger.error((Object)("Couldn't delete image" + deleter.imageName + " for Code Studio template " + templateId + " : " + String.valueOf(e)));
                }
            }
        }
        File builtFolder = CodeStudioTemplatesService.getCodeStudioTemplateImagesBuiltFolder(templateId);
        File importedResourcesDir = this.getImportedBlocksResourcesDir(templateId);
        File tplResourcesDir = CodeStudioTemplatesService.getTemplateResourcesDir(templateId).getParentFile();
        try {
            if (builtFolder.exists()) {
                DKUFileUtils.forceDelete((File)builtFolder);
            }
            if (importedResourcesDir.exists()) {
                DKUFileUtils.forceDelete((File)importedResourcesDir);
            }
            if (tplResourcesDir.exists()) {
                DKUFileUtils.forceDelete((File)tplResourcesDir);
            }
        }
        catch (IOException e) {
            ret.withError((InfoMessage.MessageCode)CodeStudioCodes.ERR_CODE_STUDIO_CONTAINER_IMAGE_DELETE_FAILED, "Couldn't delete intermediary folder : " + ExceptionUtils.getMessageWithCauses((Throwable)e));
            logger.error((Object)("Couldn't delete intermediary folder for Code Studio template " + templateId + " : " + String.valueOf(e)));
        }
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
            this.dao.delete(templateId);
            t.commit(String.format("Deleted Code Studio template %s (%s)", codeStudioTemplate.getLabel(), codeStudioTemplate.id), 0L, MinimalRWTransaction.TransactionGitCommitPolicy.IF_AUTO);
        }
        return ret;
    }

    private String getDefaultContainerExecConfName(AuthCtx authCtx) {
        List<String> availableContainers = ContainerExecUtils.getAllowedContainerNames(authCtx, Collections.singletonList(ContainerExecRuntimeConfig.Container.KUBERNETES), WorkloadType.USER_CODE);
        return availableContainers.isEmpty() ? null : availableContainers.get(0);
    }

    public CodeStudioTemplate create(AuthCtx authCtx, String type, String label) throws Exception {
        if (StringUtils.isBlank((String)label)) {
            throw new CodedException((InfoMessage.MessageCode)CodeStudioCodes.ERR_CODE_STUDIO_INCOMPLETE_TEMPLATE_CONFIG, "The Code Studio template must have a label");
        }
        if (StringUtils.isBlank((String)type)) {
            throw new CodedException((InfoMessage.MessageCode)CodeStudioCodes.ERR_CODE_STUDIO_INCOMPLETE_TEMPLATE_CONFIG, "The Code Studio template must have a type");
        }
        CodeStudioTemplate codeStudioTemplate = new CodeStudioTemplate();
        codeStudioTemplate.id = this.checkAndMakeIdFromLabel_T(label);
        codeStudioTemplate.label = label;
        codeStudioTemplate.type = type;
        codeStudioTemplate.owner = authCtx.getIdentifier();
        codeStudioTemplate.params = CodeStudioRegistry.getMeta(type).templateParamsClass().newInstance();
        codeStudioTemplate.params.newTemplateInitialization();
        codeStudioTemplate.isEditor = true;
        codeStudioTemplate.defaultPermission.use = true;
        codeStudioTemplate.allContainerConfs = true;
        codeStudioTemplate.defaultContainerConf = this.getDefaultContainerExecConfName(authCtx);
        this.handleCreationVersionTagOnObjectCreation(codeStudioTemplate);
        this.dao.save(codeStudioTemplate);
        return codeStudioTemplate;
    }

    private String checkAndMakeIdFromLabel_T(String label) throws IOException, CodedException {
        StringTransmogrifier st2 = new StringTransmogrifier();
        for (CodeStudioTemplate existing : this.dao.listUnsafe()) {
            if (existing.getLabel().equals(label)) {
                throw new CodedException((InfoMessage.MessageCode)CodeStudioCodes.ERR_CODE_STUDIO_INVALID_TEMPLATE_CONFIG, "The Code Studio label must be unique: " + label);
            }
            st2.addAlreadyTransmogrified(existing.id);
        }
        String slug = label.replaceAll("[^A-z0-9\\-_\\.]", "_");
        return st2.transmogrify(slug);
    }

    public CodeStudioTemplate save(CodeStudioTemplate codeStudioTemplate) throws Exception {
        CodeStudioTemplate existing = this.dao.getMandatory(codeStudioTemplate.id);
        this.checkUpdateAllowed(codeStudioTemplate, existing);
        this.handleCreationVersionTagOnObjectUpdate(codeStudioTemplate, existing);
        this.dao.save(codeStudioTemplate);
        return codeStudioTemplate;
    }

    public List<CodeStudioTemplate> massSave(List<String> codeStudioTemplateIds, Consumer<CodeStudioTemplate> modification) throws Exception {
        ArrayList ret = Lists.newArrayList();
        for (String codeStudioTemplateId : codeStudioTemplateIds) {
            CodeStudioTemplate codeStudioTemplate = this.dao.getMandatoryUnsafe(codeStudioTemplateId);
            CodeStudioTemplate modified = (CodeStudioTemplate)JSON.deepCopy((Object)codeStudioTemplate);
            modification.accept(modified);
            this.checkUpdateAllowed(modified, codeStudioTemplate);
            this.handleCreationVersionTagOnObjectUpdate(modified, codeStudioTemplate);
            this.dao.save(modified);
            ret.add(modified);
        }
        return ret;
    }

    private void checkUpdateAllowed(CodeStudioTemplate codeStudioTemplate, CodeStudioTemplate existing) throws CodedException, IOException {
        if (StringUtils.isBlank((String)codeStudioTemplate.getLabel())) {
            throw new CodedException((InfoMessage.MessageCode)CodeStudioCodes.ERR_CODE_STUDIO_INVALID_TEMPLATE_PROPERTY_CHANGE, "The Code Studio label cannot be empty");
        }
        if (!existing.getLabel().equals(codeStudioTemplate.getLabel())) {
            for (CodeStudioTemplate e : this.dao.listUnsafe()) {
                if (!e.getLabel().equals(codeStudioTemplate.getLabel())) continue;
                throw new CodedException((InfoMessage.MessageCode)CodeStudioCodes.ERR_CODE_STUDIO_INVALID_TEMPLATE_CONFIG, "The Code Studio label must be unique: " + codeStudioTemplate.getLabel());
            }
        }
        if (!StringUtils.equals((String)codeStudioTemplate.type, (String)existing.type)) {
            throw new CodedException((InfoMessage.MessageCode)CodeStudioCodes.ERR_CODE_STUDIO_INVALID_TEMPLATE_PROPERTY_CHANGE, "The Code Studio type cannot be changed");
        }
    }

    public void handleCreationVersionTagOnObjectCreation(CodeStudioTemplate to) {
        AuthCtx authCtx = TransactionContext.retrieveWrite().getUser();
        to.versionTag = new VersionTag(authCtx.getIdentifier());
        to.creationTag = new VersionTag(authCtx.getIdentifier());
    }

    public void handleCreationVersionTagOnObjectUpdate(CodeStudioTemplate to, CodeStudioTemplate preExisting) {
        AuthCtx authCtx = TransactionContext.retrieveWrite().getUser();
        to.versionTag = VersionTag.increment(preExisting.versionTag, authCtx.getIdentifier());
        to.creationTag = (VersionTag)JSON.deepCopy((Object)preExisting.creationTag);
    }

    public List<CodeStudioTemplate.CodeStudioTemplateType> listTypes(boolean all) {
        ArrayList ret = Lists.newArrayList();
        for (CodeStudioMeta meta : CodeStudioRegistry.getAllMeta()) {
            if (!all && !meta.isPublic()) continue;
            ret.add(meta.getTemplateType());
        }
        return ret;
    }

    public FutureResponse<CodeStudioTemplateBuildResults> startBuild(AuthCtx authCtx, String codeStudioTemplateId, boolean withNoCache) throws Exception {
        CodeStudioTemplate template = this.dao.getMandatory(codeStudioTemplateId);
        CodeStudioTemplateBuildThread ft = new CodeStudioTemplateBuildThread(authCtx, template, withNoCache);
        return this.futureService.runFuture(ft, 0L, new TypeToken<FutureResponse<CodeStudioTemplateBuildResults>>(){});
    }

    public FutureResponse<CodeStudioTemplateBuildResults> startMassBuild(AuthCtx authCtx, List<String> codeStudioTemplateIds) throws Exception {
        ArrayList templates = Lists.newArrayList();
        for (String codeStudioTemplateId : codeStudioTemplateIds) {
            templates.add(this.dao.getMandatory(codeStudioTemplateId));
        }
        CodeStudioTemplateMassBuildThread ft = new CodeStudioTemplateMassBuildThread(authCtx, templates);
        return this.futureService.runFuture(ft, 0L, new TypeToken<FutureResponse<CodeStudioTemplateBuildResults>>(){});
    }

    public static File getBuildDir(CodeStudioTemplate template) {
        return CodeStudioTemplatesService.getBuildDir(template.id);
    }

    public static File getBuildDir(CodeStudioTemplate template, String buildId) {
        return CodeStudioTemplatesService.getBuildDir(template.id, buildId);
    }

    public static File getBuildDir(String templateId) {
        return DKUFileUtils.getWithin((File)ApplicationConfigurator.getFile((String[])new String[]{"tmp", "code-studio-build"}), (String[])new String[]{templateId});
    }

    public static File getBuildDir(String templateId, String buildId) {
        return DKUFileUtils.getWithin((File)CodeStudioTemplatesService.getBuildDir(templateId), (String[])new String[]{buildId});
    }

    private void buildOneTemplate(AuthCtx authCtx, CodeStudioTemplate template, CodeStudioTemplateBuildResults ret, DKUtils.SmartLogTailBuilder smartLogTailBuilder, boolean withNoCache) throws IOException, Exception {
        CodeStudioMeta meta = CodeStudioRegistry.getMeta(template);
        String buildRef = "build-" + DKUDateUtils.isoFormatFileFriendlyLocalNow();
        File buildDir = new File(CodeStudioTemplatesService.getBuildDir(template), buildRef);
        DKUFileUtils.mkdirs((File)buildDir);
        File dockerBuildDir = new File(buildDir, "docker-build");
        DKUFileUtils.mkdirs((File)dockerBuildDir);
        File log = new File(buildDir, "build.log");
        buildLogAppender.setLogFile(log);
        DKUtils.startLogAppender((Appender)buildLogAppender);
        CodeStudioMeta.ImageBuildEnv buildEnv = new CodeStudioMeta.ImageBuildEnv();
        buildEnv.workingDir = buildDir.getAbsolutePath();
        buildEnv.buildDir = dockerBuildDir.getAbsolutePath();
        buildEnv.globalCodeEnvsExtraSettings = template.inheritGlobalCodeEnvsExtraSettings ? ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN().codeEnvs : template.codeEnvsExtraSettings;
        File tplResourcesFile = CodeStudioTemplatesService.getTemplateResourcesDir(template.id);
        if (tplResourcesFile.exists()) {
            long st2 = System.currentTimeMillis();
            DKUFileUtils.copyDirectory((File)tplResourcesFile, (File)new File(buildEnv.buildDir + "/template-resources"));
            long duration = System.currentTimeMillis() - st2;
            logger.info((Object)("Template resources copied in " + duration + " ms"));
        }
        CodeStudioMeta.ImageBuildSpec spec = meta.getBuildSpec(authCtx, template, buildEnv);
        spec.dockerfile = spec.dockerfile.replaceAll(TEMPLATE_RESOURCES_HOLDER, TEMPLATE_RESOURCES_SUBDIR);
        logger.info((Object)("Will build " + spec.dockerfile));
        List<CodeStudioTemplateImagesHandler> builders = CodeStudioTemplateImagesHandler.getHandlers(template);
        if (builders.isEmpty()) {
            throw new IllegalArgumentException("No configuration to build on has been selected");
        }
        int buildCount = 0;
        String defaultBaseImage = ContainerExecImagesHelper.getDefaultBaseImageTag(ContainerExecUtils.BaseImageType.EXEC);
        for (CodeStudioTemplateImagesHandler builder : builders) {
            try {
                String buildId = buildRef + "_" + buildCount++;
                logger.info((Object)("Start build on " + JSON.json((Object)builder.containerConfig)));
                long st3 = System.currentTimeMillis();
                String effectiveBaseImage = StringUtils.defaultIfBlank((String)builder.containerConfig.baseImage, (String)defaultBaseImage);
                logger.info((Object)("Build with " + effectiveBaseImage + " base image"));
                String dockerfile = spec.dockerfile.replaceFirst(CONTAINER_CONFIG_BASE_IMAGE_HOLDER, effectiveBaseImage);
                CodeStudioTemplateImagesHandler.CodeStudioTemplateBuildResult built = builder.build(buildId, dockerBuildDir, smartLogTailBuilder, log, dockerfile, withNoCache);
                long duration = System.currentTimeMillis() - st3;
                ret.builds.add(built);
                logger.info((Object)("Done build in " + duration + " ms"));
                CodeStudioTemplateImageBuilt imageBuilt = new CodeStudioTemplateImageBuilt();
                imageBuilt.buildId = buildId;
                imageBuilt.buildDuration = duration;
                imageBuilt.dssVersion = DKUApp.getDSSVersionTag();
                imageBuilt.builtBy = authCtx.getAssociatedDSSUserOrIdentifier();
                imageBuilt.paramsHash = template.makeParamsHash();
                imageBuilt.built = built;
                imageBuilt.builtForContainerExecRuntimeConfigs = builder.containerExecRuntimeConfigNames;
                CodeStudioTemplatesService.recordBuild(template, imageBuilt);
            }
            catch (Exception e) {
                String msg = "Failed to build images for " + template.id + " on docker host: " + StringUtils.defaultIfBlank((String)builder.containerConfig.dockerHost, (String)"localhost");
                logger.error((Object)msg, (Throwable)e);
                ret.messages.withError((InfoMessage.MessageCode)CodeStudioCodes.ERR_CODE_STUDIO_CONTAINER_IMAGE_BUILD_FAILED, msg + " : " + ExceptionUtils.getMessageWithCauses((Throwable)e));
            }
        }
    }

    public List<CodeStudioTemplateBuildLog> listLogs(String codeStudioTemplateId) throws IOException {
        CodeStudioTemplate template = this.dao.getMandatoryUnsafe(codeStudioTemplateId);
        File buildsDir = CodeStudioTemplatesService.getBuildDir(template);
        ArrayList ret = Lists.newArrayList();
        if (buildsDir.exists() && buildsDir.isDirectory()) {
            Pattern buildIdPattern = Pattern.compile("build\\-[0-9]{4}\\-[0-9]{2}\\-[0-9]{2}\\-[0-9]{2}\\-[0-9]{2}\\-[0-9]{2}\\-[0-9]{3}");
            List buildIds = Lists.newArrayList();
            for (File f : buildsDir.listFiles()) {
                if (!f.isDirectory() || !buildIdPattern.matcher(f.getName()).matches()) continue;
                buildIds.add(f.getName());
            }
            logger.info((Object)("Found " + buildIds.size() + " builds"));
            buildIds.sort(Comparator.reverseOrder());
            if (buildIds.size() > 50) {
                logger.info((Object)"Keeping 50 most recent builds");
                buildIds = buildIds.subList(0, 50);
            }
            for (String buildId : buildIds) {
                CodeStudioTemplateBuildLog log = new CodeStudioTemplateBuildLog();
                log.buildId = buildId;
                log.builtOn = CodeStudioTemplatesService.buildDateFromBuildId(log.buildId);
                File logFile = new File(new File(buildsDir, buildId), "build.log");
                log.logSize = logFile.exists() ? logFile.length() : 0L;
                ret.add(log);
            }
        }
        return ret;
    }

    public CodeStudioTemplateBuildLog getLogInfo(String codeStudioTemplateId, String buildId) throws IOException {
        File dockerBuildDir;
        CodeStudioTemplate template = this.dao.getMandatoryUnsafe(codeStudioTemplateId);
        File buildDir = CodeStudioTemplatesService.getBuildDir(template, buildId);
        CodeStudioTemplateBuildLog log = new CodeStudioTemplateBuildLog();
        log.buildId = buildId;
        log.builtOn = CodeStudioTemplatesService.buildDateFromBuildId(log.buildId);
        log.exists = buildDir.exists();
        File logFile = new File(buildDir, "build.log");
        if (logFile.exists()) {
            log.logSize = logFile.exists() ? logFile.length() : 0L;
            log.logTail = DKUtils.smartTailFile((File)logFile, (int)100);
        }
        if ((dockerBuildDir = new File(buildDir, "docker-build")).exists() && dockerBuildDir.isDirectory()) {
            File dockerfile = new File(dockerBuildDir, "Dockerfile");
            if (dockerfile.exists()) {
                log.dockerfile = DKUFileUtils.readFileToStringUTF8((File)dockerfile);
            }
            final String prefix = PathUtils.makeLeadingNoTrailing((String)dockerBuildDir.getAbsolutePath());
            Function<Path, FSPathOrDirectory> convert = new Function<Path, FSPathOrDirectory>(){

                @Override
                public FSPathOrDirectory apply(Path p) {
                    File f = p.toFile();
                    Object subpath = f.getAbsolutePath().substring(prefix.length());
                    if (!((String)subpath).startsWith("/")) {
                        subpath = "/" + (String)subpath;
                    }
                    return new FSPathOrDirectory((String)subpath, f.length(), f.lastModified(), f.isDirectory());
                }
            };
            try (Stream<Path> files = Files.walk(dockerBuildDir.toPath(), new FileVisitOption[0]);){
                log.contents = files.map(convert).collect(Collectors.toList());
            }
        }
        return log;
    }

    public void sendBuildDiagnostic(HttpServletResponse resp, String templateId, String buildId) throws IOException {
        File runDir = CodeStudioTemplatesService.getBuildDir(templateId, buildId);
        String id = "dss-build-diag-" + templateId + "-" + buildId + "/";
        if (runDir.exists()) {
            resp.setContentType("application/zip");
            resp.setHeader("Content-Disposition", "attachment; filename=\"" + id + ".zip\"");
            resp.setStatus(200);
            try (BufferedOutputStream bos = new BufferedOutputStream((OutputStream)resp.getOutputStream());){
                ZipUnzipDir.zipDirectoryToStream(runDir, bos);
            }
        } else {
            resp.setStatus(404);
            resp.getWriter().write("build dir not found");
        }
    }

    public List<CodeStudioBlock.CodeStudioBlockType> listBlockTypes() {
        ArrayList ret = Lists.newArrayList();
        for (CodeStudioBlockMeta meta : CodeStudioBlockRegistry.getAllMeta()) {
            ret.add(meta.getBlockType());
        }
        return ret;
    }

    public Usages listUsages_NT(AuthCtx authCtx, CodeStudioTemplate template, List<String> projectKeys, boolean withCurrentUses) {
        return this.computeUsageCounts(authCtx, projectKeys, Lists.newArrayList((Object[])new String[]{template.id}), withCurrentUses).get(0);
    }

    public List<Usages> massListUsages_NT(AuthCtx authCtx, List<CodeStudioTemplate> codeStudioTemplates, List<String> projectKeys, boolean withCurrentUses) {
        return this.computeUsageCounts(authCtx, projectKeys, codeStudioTemplates.stream().map(t -> t.id).collect(Collectors.toList()), withCurrentUses);
    }

    private List<Usages> computeUsageCounts(AuthCtx authCtx, List<String> projectKeys, List<String> codeStudioTemplateIds, boolean withCurrentUses) {
        Map<String, Usages> ret = codeStudioTemplateIds.stream().collect(Collectors.toMap(i -> i, i -> {
            Usages u = new Usages();
            u.codeStudioTemplateId = i;
            return u;
        }));
        for (String projectKey : projectKeys) {
            try {
                Transaction t = this.transactionService.beginRead();
                try {
                    HashMap projects = Maps.newHashMap();
                    for (CodeStudioObject codeStudio : this.codeStudioObjectsDAO.listUnsafe(projectKey)) {
                        CodeStudioRuntime.CodeStudioPersistedState state;
                        if (!ret.keySet().contains(codeStudio.templateId)) continue;
                        ProjectUsages project = projects.computeIfAbsent(codeStudio.templateId, k -> new ProjectUsages());
                        project.projectKey = projectKey;
                        Usage usage = new Usage();
                        usage.id = codeStudio.id;
                        usage.name = codeStudio.name;
                        usage.owner = codeStudio.owner;
                        if (codeStudio.creationTag != null) {
                            usage.createdOn = codeStudio.creationTag.getLastModifiedOn();
                            usage.createdBy = codeStudio.creationTag.getLastAuthor();
                        }
                        if ((state = this.runtimeManager.getRunningStateOrNull(authCtx, codeStudio)) == null) {
                            usage.running = false;
                            usage.runningSince = null;
                        } else {
                            usage.running = true;
                            usage.runningSince = state.lastStateChange;
                        }
                        if (withCurrentUses) {
                            usage.currentUses = this.codeStudioObjectsService.getCurrentUsage(projectKey, codeStudio.id);
                        }
                        project.codeStudios.add(usage);
                    }
                    boolean canReadProject = this.permissionsService.hasProjectPrivilege(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
                    for (Map.Entry e : projects.entrySet()) {
                        Usages usages = ret.get(e.getKey());
                        ProjectUsages project = (ProjectUsages)e.getValue();
                        int codeStudiosCount = project.codeStudios.size();
                        int codeStudiosRunningCount = (int)project.codeStudios.stream().filter(k -> k.running).count();
                        usages.totalCount += codeStudiosCount;
                        usages.totalRunningCount += codeStudiosRunningCount;
                        if (canReadProject) {
                            usages.projects.add(project);
                            continue;
                        }
                        ++usages.notAccessibleProjectCount;
                        usages.notAccessibleCount += codeStudiosCount;
                        usages.notAccessibleRunningCount += codeStudiosRunningCount;
                    }
                }
                finally {
                    if (t == null) continue;
                    t.close();
                }
            }
            catch (Exception e) {
                logger.error((Object)("Failed to list Code Studios of " + projectKey), (Throwable)e);
            }
        }
        return Lists.newArrayList(ret.values());
    }

    private File getImportedBlocksResourcesDir(String templateId) {
        return ApplicationConfigurator.getFile((String[])new String[]{"local", "static", "code-studio-templates", templateId});
    }

    private static File getCodeStudioTemplateImagesBuiltFile(String templateId) {
        return ApplicationConfigurator.getFile((String[])new String[]{"code-studio-templates", templateId, "images-built.json"});
    }

    private static File getCodeStudioTemplateImagesBuiltFolder(String templateId) {
        return ApplicationConfigurator.getFile((String[])new String[]{"code-studio-templates", templateId});
    }

    private static CodeStudioTemplateImagesBuilt getCodeStudioTemplateImagesBuilt(String templateId) throws IOException {
        File f = CodeStudioTemplatesService.getCodeStudioTemplateImagesBuiltFile(templateId);
        if (f.exists()) {
            return (CodeStudioTemplateImagesBuilt)JSON.parseFile((File)f, CodeStudioTemplateImagesBuilt.class);
        }
        return new CodeStudioTemplateImagesBuilt();
    }

    private static void setCodeStudioTemplateImagesBuilt(String templateId, CodeStudioTemplateImagesBuilt imagesBuilt) throws IOException {
        File f = CodeStudioTemplatesService.getCodeStudioTemplateImagesBuiltFile(templateId);
        DKUFileUtils.mkdirsParent((File)f);
        JSON.prettyToFile((Object)imagesBuilt, (File)f);
    }

    private static String getImagesBuiltLockName(String templateId) {
        return "com.dataiku.dip.codestudio." + templateId;
    }

    public static CodeStudioTemplateImageBuilt getLatest(CodeStudioTemplate template) throws IOException {
        return CodeStudioTemplatesService.getLatest(template.id);
    }

    public static CodeStudioTemplateImageBuilt getLatest(String templateId) throws IOException {
        String lockName = CodeStudioTemplatesService.getImagesBuiltLockName(templateId);
        try (AutoCloseableLock lock = NamedLock.acquire((String)lockName);){
            CodeStudioTemplateImagesBuilt imagesBuilt = CodeStudioTemplatesService.getCodeStudioTemplateImagesBuilt(templateId);
            CodeStudioTemplateImageBuilt codeStudioTemplateImageBuilt = imagesBuilt.images.stream().filter(i -> StringUtils.equals((String)imagesBuilt.latestBuildId, (String)i.buildId)).findFirst().orElse(null);
            return codeStudioTemplateImageBuilt;
        }
    }

    public static CodeStudioTemplateImageBuilt getLatest(CodeStudioTemplate template, String containerConfig) throws IOException {
        return CodeStudioTemplatesService.getLatest(template.id, containerConfig);
    }

    public static CodeStudioTemplateImageBuilt getLatest(String templateId, String containerConfig) throws IOException {
        String lockName = CodeStudioTemplatesService.getImagesBuiltLockName(templateId);
        try (AutoCloseableLock lock = NamedLock.acquire((String)lockName);){
            CodeStudioTemplateImagesBuilt imagesBuilt = CodeStudioTemplatesService.getCodeStudioTemplateImagesBuilt(templateId);
            CodeStudioTemplateImageBuilt codeStudioTemplateImageBuilt = imagesBuilt.images.stream().filter(i -> StringUtils.equals((String)imagesBuilt.latestBuildIdPerContainerConfig.getOrDefault(containerConfig, null), (String)i.buildId)).findFirst().orElse(null);
            return codeStudioTemplateImageBuilt;
        }
    }

    public static void recordBuild(CodeStudioTemplate template, CodeStudioTemplateImageBuilt image) throws IOException {
        String lockName = CodeStudioTemplatesService.getImagesBuiltLockName(template.id);
        try (AutoCloseableLock lock = NamedLock.acquire((String)lockName);){
            CodeStudioTemplateImagesBuilt imagesBuilt = CodeStudioTemplatesService.getCodeStudioTemplateImagesBuilt(template.id);
            imagesBuilt.images.add(image);
            imagesBuilt.latestBuildId = image.buildId;
            for (String containerConfigName : image.builtForContainerExecRuntimeConfigs) {
                imagesBuilt.latestBuildIdPerContainerConfig.put(containerConfigName, image.buildId);
            }
            CodeStudioTemplatesService.setCodeStudioTemplateImagesBuilt(template.id, imagesBuilt);
        }
    }

    public void exportTemplate(AuthCtx authCtx, HttpServletResponse resp, CodeStudioTemplate template) throws Exception {
        template = (CodeStudioTemplate)JSON.deepCopy((Object)template);
        String nameSlug = template.getLabel().replaceAll("[^a-zA-Z0-9\\-\\._]", "_");
        try (AutoDelete exportDir = DSSTempUtils.getTempFolder((String)"code-studio-template-export", (String)template.id);){
            File blocksResourcesDir = new File((File)exportDir, "resources");
            CodeStudioMeta.TemplateExportSpec exportSpec = this.gatherBlocksResources(authCtx, template, blocksResourcesDir);
            JSON.prettyToFile((Object)exportSpec, (File)new File((File)exportDir, "exportSpec.json"));
            File tplResourcesDir = CodeStudioTemplatesService.getTemplateResourcesDir(template.id);
            if (tplResourcesDir.exists()) {
                DKUFileUtils.copyDirectory((File)tplResourcesDir, (File)new File((File)exportDir, TEMPLATE_RESOURCES_SUBDIR));
            }
            this.cleanupObjectForExport(template);
            JSON.prettyToFile((Object)template, (File)new File((File)exportDir, "template.json"));
            CodeStudioTemplateExportManifest manifest = new CodeStudioTemplateExportManifest();
            manifest.dssVersion = ApplicationConfigurator.getDSSVersion().product_version;
            manifest.confVersion = ApplicationConfigurator.getDSSVersion().conf_version;
            manifest.exportUserInfo = new ExportedProject.ExportUserInfo();
            manifest.exportUserInfo.exportedBy = authCtx.getIdentifier();
            manifest.exportUserInfo.exportedOn = DKUDateUtils.isoFormatLocalNow();
            JSON.prettyToFile((Object)manifest, (File)new File((File)exportDir, "manifest.json"));
            resp.setContentType("application/zip");
            resp.setHeader("Content-Disposition", "attachment; filename=\"dss_code_studio_template_" + nameSlug + ".zip\"");
            resp.setStatus(200);
            try (BufferedOutputStream bos = new BufferedOutputStream((OutputStream)resp.getOutputStream());){
                ZipUnzipDir.zipDirectoryToStream((File)exportDir, bos);
            }
        }
    }

    private void cleanupObjectForExport(CodeStudioTemplate template) {
        template.permissions.clear();
        template.defaultPermission = null;
        template.owner = null;
        template.defaultContainerConf = null;
        template.allContainerConfs = true;
        template.allowContainerConfOverride = true;
        template.containerConfs.clear();
        template.id = null;
    }

    private CodeStudioMeta.TemplateExportSpec gatherBlocksResources(AuthCtx authCtx, CodeStudioTemplate template, File resourcesDir) throws Exception, IOException {
        VariablesContext vc = CodeStudioTemplatesService.getTemplateVariablesContext(template.id);
        CodeStudioMeta.TemplateExportSpec exportSpec = CodeStudioRegistry.getMeta(template).exportTemplate(authCtx, template);
        StringTransmogrifier st2 = new StringTransmogrifier();
        for (Map.Entry<String, CodeStudioMeta.TemplateExportResource> e : exportSpec.resourcesMap.entrySet()) {
            String configRealPath;
            String srcRealPath;
            String pathInsideConfig;
            File dst;
            CodeStudioMeta.TemplateExportResource resource = e.getValue();
            if (StringUtils.isBlank((String)resource.localPath)) {
                throw new IllegalArgumentException("Empty resource path for " + e.getKey());
            }
            String expandedLocalPath = vc.expand(resource.localPath);
            File src = new File(expandedLocalPath);
            if (!src.exists()) {
                throw new IllegalArgumentException("Resource for " + e.getKey() + " not found at expected path " + expandedLocalPath);
            }
            if (src.isFile()) {
                String fileName = src.getName();
                int dotPos = fileName.lastIndexOf(46);
                Object resourceName = dotPos > 0 ? st2.transmogrify(fileName.substring(0, dotPos)) + fileName.substring(dotPos) : st2.transmogrify(fileName);
                dst = new File(resourcesDir, (String)resourceName);
            } else if (src.isDirectory()) {
                String resourceName = st2.transmogrify(src.getName());
                dst = new File(resourcesDir, resourceName);
            } else {
                throw new IllegalArgumentException("Resource for " + e.getKey() + " at path " + expandedLocalPath + " is neither a file nor a directory");
            }
            File configFolder = ApplicationConfigurator.getFile((String)"config");
            if (DKUFileUtils.isWithin((File)configFolder, (File)src) && !Pattern.matches("^/?projects/[^/]+/lib/.*$", pathInsideConfig = (srcRealPath = src.toPath().toRealPath(LinkOption.NOFOLLOW_LINKS).toString()).substring((configRealPath = configFolder.toPath().toRealPath(LinkOption.NOFOLLOW_LINKS).toString()).length()))) {
                throw new IllegalArgumentException("Resource for " + e.getKey() + " is not in an allowed location");
            }
            DKUFileUtils.mkdirsParent((File)dst);
            if (src.isFile()) {
                FileUtils.copyFile((File)src, (File)dst);
            } else {
                DKUFileUtils.copyDirectory((File)src, (File)dst);
            }
            resource.exportedPath = dst.getName();
        }
        return exportSpec;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CodeStudioTemplateImportResult importTemplate(AuthCtx authCtx, File zipFile, String label, CodeStudioMeta.TemplateImportSpec importSpec) throws Exception {
        CodeStudioTemplateImportResult ret;
        block39: {
            ret = new CodeStudioTemplateImportResult();
            File importedBlocksTemplateResourcesDir = null;
            try (AutoDelete importDir = DSSTempUtils.getTempFolder((String)"code-studio-template-import", (String)("template-" + DKUDateUtils.isoFormatFileFriendlyLocalNow()));){
                logger.info((Object)"Unzipping template export");
                ZipUnzipDir.extractFolder(zipFile, (File)importDir);
                CodeStudioMeta.TemplateExportSpec exportSpec222 = (CodeStudioMeta.TemplateExportSpec)JSON.parseFile((File)new File((File)importDir, "exportSpec.json"), CodeStudioMeta.TemplateExportSpec.class);
                ret.codeEnvs = exportSpec222.usedCodeEnvRefs;
                CodeStudioTemplate template = (CodeStudioTemplate)JSON.parseFile((File)new File((File)importDir, "template.json"), CodeStudioTemplate.class);
                CodeStudioTemplateExportManifest manifest = (CodeStudioTemplateExportManifest)JSON.parseFile((File)new File((File)importDir, "manifest.json"), CodeStudioTemplateExportManifest.class);
                logger.info((Object)("Importing template exported by " + JSON.json((Object)manifest)));
                if (!StringUtils.equals((String)manifest.confVersion, (String)ApplicationConfigurator.getDSSVersion().conf_version)) {
                    logger.warn((Object)"Importing template from a different version of DSS");
                }
                if (StringUtils.isBlank((String)label)) {
                    label = template.getLabel();
                } else {
                    template.label = label;
                }
                if (StringUtils.isBlank((String)label)) {
                    ret.messages.withFatal((InfoMessage.MessageCode)CodeStudioCodes.ERR_CODE_STUDIO_INCOMPLETE_IMPORT_CONFIG, "No label defined for imported template");
                    CodeStudioTemplateImportResult codeStudioTemplateImportResult = ret;
                    return codeStudioTemplateImportResult;
                }
                try (Transaction t = this.transactionService.beginRead();){
                    template.id = this.checkAndMakeIdFromLabel_T(label);
                }
                template.tags.add("Imported");
                if (!exportSpec222.usedCodeEnvRefs.isEmpty()) {
                    List<CodeEnvModel.CodeEnvListItem> existingCodeEnvs = this.getExistingCodeEnvs();
                    for (CodeEnvModel.UsedCodeEnvRef usedCodeEnvRef : exportSpec222.usedCodeEnvRefs) {
                        String remapped = null;
                        for (ProjectRemappingSettings.CodeEnvRemapping codeEnvRemapping : importSpec.codeEnvs) {
                            if (!StringUtils.equals((String)codeEnvRemapping.source, (String)usedCodeEnvRef.envName)) continue;
                            remapped = codeEnvRemapping.target;
                        }
                        if (StringUtils.isNotBlank(remapped)) {
                            logger.info((Object)("Code env " + String.valueOf((Object)usedCodeEnvRef.envLang) + "." + usedCodeEnvRef.envName + " is remapped to " + remapped));
                            continue;
                        }
                        boolean found = false;
                        for (CodeEnvModel.CodeEnvListItem env : existingCodeEnvs) {
                            if (env.envLang != usedCodeEnvRef.envLang || !StringUtils.equals((String)env.envName, (String)usedCodeEnvRef.envName)) continue;
                            found = true;
                        }
                        if (found) continue;
                        ret.messages.withErrorV((InfoMessage.MessageCode)CodeStudioCodes.ERR_CODE_STUDIO_INCOMPLETE_IMPORT_CONFIG, "%s code env %s doesn't exist on instance, needs a remapping", new Object[]{usedCodeEnvRef.envLang, usedCodeEnvRef.envName});
                    }
                }
                template.allowContainerConfOverride = true;
                template.allContainerConfs = true;
                template.defaultContainerConf = this.getDefaultContainerExecConfName(authCtx);
                importedBlocksTemplateResourcesDir = new File(CodeStudioTemplatesService.getTemplateResourcesDir(template.id), IMPORTED_RESOURCES_SUBDIR);
                File importBlocksResourcesDir = new File((File)importDir, "resources");
                logger.info((Object)("Importing resources from " + importBlocksResourcesDir.getAbsolutePath() + " to " + importedBlocksTemplateResourcesDir.getAbsolutePath() + " with spec " + JSON.pretty((Object)exportSpec222)));
                for (Map.Entry entry : exportSpec222.resourcesMap.entrySet()) {
                    CodeStudioMeta.TemplateExportResource resource = (CodeStudioMeta.TemplateExportResource)entry.getValue();
                    File unzipped = new File(importBlocksResourcesDir, resource.exportedPath);
                    if (!unzipped.exists()) {
                        ret.messages.withFatal((InfoMessage.MessageCode)CodeStudioCodes.ERR_CODE_STUDIO_IMPORT, "Missing resource " + (String)entry.getKey() + " in zip");
                        continue;
                    }
                    File file = new File(importedBlocksTemplateResourcesDir, resource.exportedPath);
                    DKUFileUtils.mkdirsParent((File)file);
                    if (unzipped.isFile()) {
                        FileUtils.copyFile((File)unzipped, (File)file);
                    } else {
                        if (!unzipped.isDirectory()) throw new IllegalArgumentException("Imported resource is neither file nor directory");
                        DKUFileUtils.copyDirectory((File)unzipped, (File)file);
                    }
                    resource.localPath = String.format("${template.resources}/%s/%s", IMPORTED_RESOURCES_SUBDIR, resource.exportedPath);
                }
                logger.info((Object)"Setting resource paths in template");
                template = CodeStudioRegistry.getMeta(template).importTemplate(authCtx, template, exportSpec222, importSpec);
                template.owner = authCtx.getIdentifier();
                File importTemplateResourcesDir = new File((File)importDir, TEMPLATE_RESOURCES_SUBDIR);
                if (importTemplateResourcesDir.exists()) {
                    File file = CodeStudioTemplatesService.getTemplateResourcesDir(template.id);
                    DKUFileUtils.copyDirectory((File)importTemplateResourcesDir, (File)file);
                }
                ret.messages.summarize();
                if (ret.messages.error) break block39;
                logger.info((Object)"Saving new template");
                try (RWTransaction rWTransaction = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
                    this.handleCreationVersionTagOnObjectCreation(template);
                    this.dao.save(template);
                    rWTransaction.commit("Imported template " + template.id);
                }
                ret.templateId = template.id;
            }
            catch (Exception e) {
                if (importedBlocksTemplateResourcesDir != null && importedBlocksTemplateResourcesDir.exists()) {
                    try {
                        DKUFileUtils.forceDelete((File)importedBlocksTemplateResourcesDir);
                    }
                    catch (Exception e2) {
                        logger.error((Object)"Unable to cleanup partial import", (Throwable)e2);
                    }
                }
                logger.error((Object)"Failed to import Code Studio template", (Throwable)e);
                ret.messages.withFatal((InfoMessage.MessageCode)CodeStudioCodes.ERR_CODE_STUDIO_IMPORT, "Import failed with " + ExceptionUtils.getMessageWithCauses((Throwable)e));
            }
        }
        ret.messages.summarize();
        return ret;
    }

    private List<CodeEnvModel.CodeEnvListItem> getExistingCodeEnvs() throws IOException {
        switch (ApplicationConfigurator.getNodeType()) {
            case AUTOMATION: {
                return ((AutomationNodeCodeEnvsAccessService)SpringUtils.getBean(AutomationNodeCodeEnvsAccessService.class)).listCodeEnvs();
            }
            case DESIGN: {
                return ((DesignNodeCodeEnvsAccessService)SpringUtils.getBean(DesignNodeCodeEnvsAccessService.class)).listCodeEnvs();
            }
        }
        throw new Error("unreachable");
    }

    public CodeStudioTemplate prepareForPlugin(AuthCtx authCtx, String label, CodeStudioTemplate template, File resourceStageDir) throws Exception {
        template = (CodeStudioTemplate)JSON.deepCopy((Object)template);
        CodeStudioMeta.TemplateExportSpec exportSpec = this.gatherBlocksResources(authCtx, template, resourceStageDir);
        for (Map.Entry<String, CodeStudioMeta.TemplateExportResource> e : exportSpec.resourcesMap.entrySet()) {
            CodeStudioMeta.TemplateExportResource resource = e.getValue();
            resource.localPath = String.format("__%s__/python-code-studios/%s/%s", "DKU_CUSTOM_RESOURCE_FOLDER", label, resource.exportedPath);
        }
        CodeStudioMeta.TemplateImportSpec importSpec = new CodeStudioMeta.TemplateImportSpec();
        importSpec.importToPlugin = true;
        template = CodeStudioRegistry.getMeta(template).importTemplate(authCtx, template, exportSpec, importSpec);
        this.cleanupObjectForExport(template);
        return template;
    }

    public boolean canEditInCodeStudio() throws IOException {
        return this.dao.listUnsafe().stream().anyMatch(tmpl -> tmpl.isEditor);
    }

    public static RelFile getTemplateResourcesRelFile(String codeStudioTemplateId, boolean createIfNeeded) throws IOException {
        if (createIfNeeded) {
            DKUFileUtils.mkdirs((File)CodeStudioTemplatesService.getTemplateResourcesDir(codeStudioTemplateId));
        }
        return new RelFile(new String[]{"code_studio_templates", codeStudioTemplateId, TEMPLATE_RESOURCES_SUBDIR});
    }

    public static File getTemplateResourcesDir(String codeStudioTemplateId) throws IOException {
        return new File(PathUtils.concatLNT((String[])new String[]{ApplicationConfigurator.getBaseFolder(), "config", "code_studio_templates", codeStudioTemplateId, TEMPLATE_RESOURCES_SUBDIR}));
    }

    public static VariablesContext getTemplateVariablesContext(String codeStudioTemplateId) throws IOException {
        VariablesContext vc = ((VariablesService)SpringUtils.getBean(VariablesService.class)).getForGlobal();
        vc.add("template.resources", CodeStudioTemplatesService.getTemplateResourcesDir(codeStudioTemplateId).getAbsolutePath());
        return vc;
    }

    public static boolean isInTemplateResourcesDir(String filepath) {
        return filepath != null && filepath.startsWith("${template.resources}");
    }

    public static File getReadableFileOrThrow(String path, VariablesContext templateVariablesContext, String subject) throws FileNotFoundException {
        String expandedPath = templateVariablesContext.expand(path).trim();
        File file = new File(expandedPath);
        if (!file.exists()) {
            throw ErrorContext.ice((String)(subject + " " + expandedPath + " doesn't exist"));
        }
        if (!file.canRead()) {
            throw ErrorContext.ice((String)("Can't read " + subject + " " + expandedPath));
        }
        return file;
    }

    public static class CodeStudioTemplateImageBuilt {
        public String dssVersion;
        public String buildId;
        public String builtBy;
        public long buildDuration;
        public String paramsHash;
        public Set<String> builtForContainerExecRuntimeConfigs;
        public CodeStudioTemplateImagesHandler.CodeStudioTemplateBuildResult built;
    }

    public static class CodeStudioTemplateFullInfo {
        public CodeStudioTemplate codeStudioTemplate;
        public CodeStudioTemplate.CodeStudioTemplateType desc;
        public HeadWithVersioningInfo versioning = new HeadWithVersioningInfo();
        public boolean canUpdate;
        public List<CodeStudioMeta.ExposedCodeStudioPort> availablePorts = Lists.newArrayList();
        public String paramsHash;
        public CodeStudioTemplateImageBuilt latestBuild;
    }

    public static class Usages {
        public String codeStudioTemplateId;
        public boolean cannotCheckUsages;
        public int totalCount = 0;
        public int totalRunningCount = 0;
        public int notAccessibleCount = 0;
        public int notAccessibleRunningCount = 0;
        public int notAccessibleProjectCount = 0;
        public List<ProjectUsages> projects = Lists.newArrayList();
    }

    public static class ProjectUsages {
        public String projectKey;
        public List<Usage> codeStudios = Lists.newArrayList();
    }

    public static class Usage {
        public String id;
        public String name;
        public String owner;
        public String createdBy;
        public long createdOn;
        public boolean running;
        public Long runningSince;
        CodeStudioObjectsService.CodeStudioObjectUsage currentUses;
    }

    public class CodeStudioTemplateBuildThread
    extends SimpleFutureThread<CodeStudioTemplateBuildResults> {
        private final CodeStudioTemplate template;
        private final CodeStudioTemplate.CodeStudioTemplateType codeStudioTemplateType;
        private final DKUtils.SmartLogTailBuilder smartLogTailBuilder;
        private final boolean withNoCache;

        public CodeStudioTemplateBuildThread(AuthCtx authCtx, CodeStudioTemplate template, boolean withNoCache) {
            super(authCtx);
            this.template = template;
            this.withNoCache = withNoCache;
            CodeStudioMeta meta = CodeStudioRegistry.getMeta(template);
            this.codeStudioTemplateType = meta.getTemplateType();
            this.smartLogTailBuilder = new DKUtils.SmartLogTailBuilder();
        }

        @Override
        protected CodeStudioTemplateBuildResults compute() throws Exception {
            CodeStudioTemplateBuildResults ret = new CodeStudioTemplateBuildResults();
            try {
                CodeStudioTemplatesService.this.buildOneTemplate(this.owner, this.template, ret, this.smartLogTailBuilder, this.withNoCache);
            }
            catch (Exception e) {
                String msg = "Failed to build images for template " + this.template.id;
                logger.error((Object)msg, (Throwable)e);
                ret.messages.withFatal((InfoMessage.MessageCode)CodeStudioCodes.ERR_CODE_STUDIO_CONTAINER_IMAGE_BUILD_FAILED, msg + " : " + ExceptionUtils.getMessageWithCauses((Throwable)e));
            }
            ret.messages.summarize();
            ret.futureLog = this.smartLogTailBuilder.get();
            return ret;
        }

        public FuturePayload getPayload() {
            return FuturePayload.newSimple((String)"build_code_studio", (String)("Build Code Studio template " + this.codeStudioTemplateType.label));
        }

        public SmartLogTail getLog() {
            return this.smartLogTailBuilder.get();
        }
    }

    public class CodeStudioTemplateMassBuildThread
    extends SimpleFutureThread<CodeStudioTemplateBuildResults> {
        private final List<CodeStudioTemplate> templates;
        private final DKUtils.SmartLogTailBuilder smartLogTailBuilder;

        public CodeStudioTemplateMassBuildThread(AuthCtx authCtx, List<CodeStudioTemplate> templates) {
            super(authCtx);
            this.templates = templates;
            this.smartLogTailBuilder = new DKUtils.SmartLogTailBuilder();
        }

        @Override
        protected CodeStudioTemplateBuildResults compute() throws Exception {
            CodeStudioTemplateBuildResults ret = new CodeStudioTemplateBuildResults();
            for (CodeStudioTemplate template : this.templates) {
                try {
                    CodeStudioTemplatesService.this.buildOneTemplate(this.owner, template, ret, this.smartLogTailBuilder, false);
                }
                catch (Exception e) {
                    String msg = "Failed to build images for template " + template.id;
                    logger.error((Object)msg, (Throwable)e);
                    ret.messages.withFatal((InfoMessage.MessageCode)CodeStudioCodes.ERR_CODE_STUDIO_CONTAINER_IMAGE_BUILD_FAILED, msg + " : " + ExceptionUtils.getMessageWithCauses((Throwable)e));
                }
            }
            ret.messages.summarize();
            ret.futureLog = this.smartLogTailBuilder.get();
            return ret;
        }

        public FuturePayload getPayload() {
            return FuturePayload.newSimple((String)"mass_build_code_studio", (String)"Mass build Code Studio templates");
        }

        public SmartLogTail getLog() {
            return this.smartLogTailBuilder.get();
        }
    }

    public static class CodeStudioTemplateBuildResults {
        public InfoMessage.InfoMessages messages = new InfoMessage.InfoMessages();
        public List<CodeStudioTemplateImagesHandler.CodeStudioTemplateBuildResult> builds = Lists.newArrayList();
        public SmartLogTail futureLog;
    }

    public static class CodeStudioTemplateBuildLog {
        public String buildId;
        public long builtOn;
        public boolean exists;
        public long logSize;
        public SmartLogTail logTail;
        public String dockerfile;
        public List<FSPathOrDirectory> contents;
    }

    public static class CodeStudioTemplateImagesBuilt {
        public String latestBuildId;
        public Map<String, String> latestBuildIdPerContainerConfig = new HashMap<String, String>();
        public List<CodeStudioTemplateImageBuilt> images = Lists.newArrayList();
    }

    public static class CodeStudioTemplateExportManifest {
        public String dssVersion;
        public String confVersion;
        public ExportedProject.ExportUserInfo exportUserInfo;
        public String templateDataModelVersion = "1";
    }

    public static class CodeStudioTemplateImportResult {
        public InfoMessage.InfoMessages messages = new InfoMessage.InfoMessages();
        public String templateId;
        public List<CodeEnvModel.UsedCodeEnvRef> codeEnvs = Lists.newArrayList();
    }
}

