/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.connections;

import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.ElasticSearchConnection;
import com.dataiku.dip.connections.FSProviderizableConnection;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.sql.DB2SQLDialect;
import com.dataiku.dip.sql.DremioSQLDialect;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.Params;
import com.dataiku.dip.utils.PerfUtils;
import com.dataiku.dss.shadelib.org.apache.http.conn.ClientConnectionManager;
import com.dataiku.dss.shadelib.org.apache.http.conn.scheme.Scheme;
import com.dataiku.dss.shadelib.org.apache.http.conn.scheme.SchemeRegistry;
import com.dataiku.dss.shadelib.org.apache.http.conn.scheme.SchemeSocketFactory;
import com.dataiku.dss.shadelib.org.apache.http.conn.ssl.SSLSocketFactory;
import com.dataiku.dss.shadelib.org.apache.http.impl.client.DefaultHttpClient;
import com.dataiku.dss.shadelib.org.apache.http.impl.conn.SingleClientConnManager;
import com.dataiku.dss.shadelib.org.apache.http.params.HttpParams;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.lang.StringUtils;

public class ConnectionUtils {
    private static SchemeRegistry nonValidatingSchemeRegistry = null;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.sql.connection.utils");

    public static boolean isConnectionWritable(AuthCtx authCtx, String connectionName) throws DKUSecurityException {
        if (StringUtils.isNotBlank((String)connectionName)) {
            DSSConnection connection = ConnectionsDAO.get().getConnectionUncheckedException(authCtx, connectionName);
            return connection.allowWrite;
        }
        return true;
    }

    public static Params getParamsFromProperties(List<AbstractSQLConnection.CustomDatabaseProperty> properties) {
        HashMap<String, String> stringMap = new HashMap<String, String>();
        for (AbstractSQLConnection.CustomDatabaseProperty cdp : properties) {
            stringMap.put(cdp.name, cdp.value);
        }
        return new Params(stringMap);
    }

    public static Params getParamsFromProperties(FSProviderizableConnection conn) {
        return ConnectionUtils.getParamsFromProperties(conn.getDkuProperties());
    }

    public static Params getParamsFromProperties(AbstractSQLConnection conn) {
        return ConnectionUtils.getParamsFromProperties(conn.getDkuProperties());
    }

    public static Params getParamsFromProperties(ElasticSearchConnection conn) {
        return ConnectionUtils.getParamsFromProperties(conn.getDkuProperties());
    }

    public static String geDkuPropertyOrNull(DSSConnection conn, String name) {
        List<AbstractSQLConnection.CustomDatabaseProperty> properties = conn.getDkuProperties();
        for (AbstractSQLConnection.CustomDatabaseProperty property : properties) {
            if (!name.equals(property.name)) continue;
            return property.value;
        }
        return null;
    }

    public static void checkConnectionWritable(AuthCtx authCtx, String connectionName) throws DKUSecurityException {
        if (!ConnectionUtils.isConnectionWritable(authCtx, connectionName)) {
            throw new IllegalArgumentException("Cannot write on connection '" + connectionName + "'");
        }
    }

    public static boolean shouldPreferTruncateTable(AuthCtx authCtx, String connectionName) throws DKUSecurityException {
        if (StringUtils.isNotBlank((String)connectionName)) {
            AbstractSQLConnection connection = ConnectionsDAO.get().getConnectionNoExceptionAs(authCtx, connectionName, AbstractSQLConnection.class);
            return connection.shouldPreferTruncateTable();
        }
        return false;
    }

    public static boolean isSQLConnectionType(String type) {
        try {
            SQLConnectionType.valueOf(type.toUpperCase());
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static DefaultHttpClient newNonValidatingHttpClient() {
        return ConnectionUtils.newNonValidatingHttpClient(null);
    }

    public static DefaultHttpClient newNonValidatingHttpClient(HttpParams httpParams) {
        DefaultHttpClient client = new DefaultHttpClient((ClientConnectionManager)new SingleClientConnManager(ConnectionUtils.getNonValidatingSchemeRegistry()), httpParams);
        client.addRequestInterceptor(PerfUtils.MARK_HTTP_REQUEST_INTERCEPTOR);
        return client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SchemeRegistry getNonValidatingSchemeRegistry() {
        if (nonValidatingSchemeRegistry != null) return nonValidatingSchemeRegistry;
        Class<ConnectionUtils> clazz = ConnectionUtils.class;
        synchronized (ConnectionUtils.class) {
            SSLContext sslContext;
            if (nonValidatingSchemeRegistry != null) return nonValidatingSchemeRegistry;
            try {
                sslContext = SSLContext.getInstance("TLS");
                sslContext.init(null, new TrustManager[]{new X509TrustManager(){

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return null;
                    }

                    @Override
                    public void checkClientTrusted(X509Certificate[] certs, String authType) {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] certs, String authType) {
                    }
                }}, new SecureRandom());
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException("Couldn't create SSL Context", e);
            }
            catch (KeyManagementException e) {
                throw new RuntimeException("Couldn't initialize SSL Context", e);
            }
            SSLSocketFactory sf = new SSLSocketFactory(sslContext, SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
            Scheme httpsScheme = new Scheme("https", 443, (SchemeSocketFactory)sf);
            nonValidatingSchemeRegistry = new SchemeRegistry();
            nonValidatingSchemeRegistry.register(httpsScheme);
            // ** MonitorExit[var0] (shouldn't be in output)
            return nonValidatingSchemeRegistry;
        }
    }

    public static void actuallyCloseJdbcConnection(Connection connection, SQLDialect sqlDialect) throws SQLException {
        if (sqlDialect instanceof DremioSQLDialect) {
            try {
                connection.close();
            }
            catch (SQLException e) {
                logger.debug((Object)("Caught and ignored Dremio close exception: " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
            }
            return;
        }
        if (sqlDialect instanceof DB2SQLDialect) {
            try {
                connection.rollback();
            }
            catch (Exception e) {
                logger.warn((Object)"Failed to rollback", (Throwable)e);
            }
        }
        connection.close();
    }

    public static enum SQLConnectionType {
        MYSQL,
        POSTGRESQL,
        ALLOYDB,
        VERTICA,
        REDSHIFT,
        GREENPLUM,
        ORACLE,
        SQLSERVER,
        SYNAPSE,
        TERADATA,
        IMPALA,
        HIVESERVER2,
        NETEZZA,
        SAPHANA,
        BIGQUERY,
        SNOWFLAKE,
        H2,
        JDBC,
        SPARKLIVY,
        SPARK_SQL_DATABRICKS,
        ATHENA,
        TRINO,
        DENODO,
        TREASUREDATA,
        KDBPLUS,
        DATABRICKS,
        DATABRICKSLAKEBASE,
        FABRICWAREHOUSE,
        SQLITE;

    }
}

