/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.connections;

import com.dataiku.common.server.APIError;
import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.ProxySettings;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.ConnectionWithBasicCredential;
import com.dataiku.dip.connections.ConnectionWithEncryptedFields;
import com.dataiku.dip.connections.CredentialsRemoteFetchConfigurationProvider;
import com.dataiku.dip.connections.DkuConnectionDeserializer;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.VersionTag;
import com.dataiku.dip.dao.ConnectionMetadataDAO;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.DKUSecurityRuntimeException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.logging.MainLoggingConfigurator;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.security.model.ICredentialsService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.connections.ConnectionCodes;
import com.dataiku.dip.server.services.ConnectionsTestService;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.j2ts.annotations.UIModel;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;

@UIModel
public abstract class DSSConnection
implements CredentialsRemoteFetchConfigurationProvider.CredentialsRemoteFetcher {
    public static final String SECURE_CREDENTIALS_IN_SINGLE_USER_SECURITY = "security.hideConnectionsInSingleUserSecurity";
    public String name;
    public String type;
    public VersionTag creationTag;
    public String owner;
    public boolean allowWrite = true;
    public boolean allowManagedDatasets = true;
    public boolean allowManagedFolders = true;
    public boolean allowKnowledgeBanks = true;
    public boolean useGlobalProxy = true;
    public int maxActivities;
    public JsonObject customFields = new JsonObject();
    @JSON.FileTransient
    public ConnectionMetadataDAO.ConnectionMetadataWithState indexingMetadata;
    public CredentialsMode credentialsMode = CredentialsMode.GLOBAL;
    public String customBasicConnectionCredentialProviderClass;
    public List<AbstractSQLConnection.CustomDatabaseProperty> customBasicConnectionCredentialProviderParams = new ArrayList<AbstractSQLConnection.CustomDatabaseProperty>();
    public transient boolean forceLocalResolution;
    @JSON.FileTransient
    public JsonObject forceResolvedCredentials_forTests;
    public DataikuCloudConnectionAccessRestriction dataikuCloudAccessRestriction;
    public ConnectionUsableBy usableBy = ConnectionUsableBy.ALL;
    public List<String> allowedGroups = new ArrayList<String>();
    public DetailsReadability detailsReadability = new DetailsReadability();
    public String associatedAlationDatasource;
    public ConnectionIndexingSettings indexingSettings = new ConnectionIndexingSettings();
    private static DKULogger logger = DKULogger.getLogger((String)"dip.connection");

    public static void registerAdapter() {
        JSON.registerAdapter(DSSConnection.class, (Object)((Object)DkuConnectionDeserializer.INSTANCE));
    }

    public DSSConnection() {
        this.type = this.getType();
    }

    public <T> T getFullyResolvedCredentials_fsLike(ConnectionWithBasicCredential.CredentialResolutionContext ctx, Class<T> clazz) throws DKUSecurityException, IOException {
        try {
            return this.getFullyResolvedCredentials(ctx, clazz);
        }
        catch (SQLException e) {
            throw new IOException("Failed to get credentials", e);
        }
    }

    public <T> T getFullyResolvedCredentials_sqlLike(ConnectionWithBasicCredential.CredentialResolutionContext ctx, Class<T> clazz) throws DKUSecurityException, SQLException {
        try {
            return this.getFullyResolvedCredentials(ctx, clazz);
        }
        catch (IOException e) {
            throw new SQLException("Failed to get credentials", e);
        }
    }

    @Override
    public boolean forceLocalResolution() {
        return this.forceLocalResolution;
    }

    @Override
    public boolean mustResolveOnBackend() {
        for (AbstractSQLConnection.CustomDatabaseProperty p : this.getDkuProperties()) {
            if (!"force.resolveOnBackend".equals(p.name) || !"true".equalsIgnoreCase(p.value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean mustResolveOnDSSHost() {
        return false;
    }

    public <T> T getFullyResolvedCredentials(ConnectionWithBasicCredential.CredentialResolutionContext ctx, Class<T> clazz) throws DKUSecurityException, IOException, SQLException {
        if (this.forceResolvedCredentials_forTests != null) {
            return (T)JSON.parse((JsonElement)this.forceResolvedCredentials_forTests, clazz);
        }
        MainLoggingConfigurator.ProcessType rmiTo = CredentialsRemoteFetchConfigurationProvider.getCredentialsRemoteProvider(this);
        if (rmiTo != null) {
            String userString = ctx.authCtx == null ? "n/a" : ctx.authCtx.getIdentifier();
            logger.infoV("Fetching credentials of connection '%s' for user '%s' on %s from %s", new Object[]{this.name, userString, rmiTo, ApplicationConfigurator.getProcessType()});
            CredentialsRemoteFetchConfigurationProvider.CredentialsRemoteFetchInfo fetchInfo = new CredentialsRemoteFetchConfigurationProvider.CredentialsRemoteFetchInfo(rmiTo);
            try {
                T creds = CredentialsRemoteFetchConfigurationProvider.getFromRemote(fetchInfo, "/connections/get-fully-resolved-credentials", clazz, "projectKey", ctx.projectKey, "useTokenCache", ctx.useTokenCache, "name", this.name);
                logger.infoV("Fetched credentials of connection '%s' for user '%s'", new Object[]{this.name, userString});
                return creds;
            }
            catch (APIError.APIErrorException e) {
                if (e.getMessage().contains("does not have credentials")) {
                    throw new DKUSecurityRuntimeException("User '" + ctx.authCtx.getDSSUserForImpersonation() + "' does not have credentials for connection '" + this.name + "' to access " + this.type).withCode((InfoMessage.MessageCode)ConnectionCodes.ERR_CONNECTION_NO_CREDENTIALS).withPayload("connectionName", (Object)this.getNameForCredentials()).withPayload("user", (Object)ctx.authCtx.getDSSUserForImpersonation()).withPayload("sameUser", (Object)ctx.authCtx.isUserSameAsParent());
                }
                throw e;
            }
        }
        if (this instanceof ConnectionWithEncryptedFields) {
            ((ConnectionWithEncryptedFields)((Object)this)).decryptFields((PasswordEncryptionService)SpringUtils.getBean(PasswordEncryptionService.class));
        }
        return this.getFullyResolvedCredentials_internal(ctx, clazz);
    }

    public <X> X getFromRemote(MainLoggingConfigurator.ProcessType rmiTo, String callPath, Class<X> clazz, Object ... formData) throws IOException {
        Object[] formDataWithName = Arrays.copyOf(formData, formData.length + 2);
        formDataWithName[formData.length] = "name";
        formDataWithName[formData.length + 1] = this.name;
        return CredentialsRemoteFetchConfigurationProvider.getFromRemote(new CredentialsRemoteFetchConfigurationProvider.CredentialsRemoteFetchInfo(rmiTo), callPath, clazz, formDataWithName);
    }

    protected abstract <T> T getFullyResolvedCredentials_internal(ConnectionWithBasicCredential.CredentialResolutionContext var1, Class<T> var2) throws DKUSecurityException, IOException, SQLException;

    public abstract String getType();

    public abstract void expandParametersInPlaceAtDAOLevelUsingGlobalContextOnly(VariablesContext var1);

    public String getMainManagedDatasetType() {
        return this.getType();
    }

    public String getNameForCredentials() {
        return this.name;
    }

    public boolean isFSLike() {
        return false;
    }

    public boolean isFS() {
        return false;
    }

    public boolean isProperSQL() {
        return false;
    }

    @Nonnull
    public ProxySettings getProxySettings() {
        return this.useGlobalProxy ? ApplicationConfigurator.getProxySettings() : new ProxySettings();
    }

    public void checkConfiguration() throws CodedException, DKUSecurityException {
    }

    public boolean isFreelyUsableBy(AuthCtx authCtx) {
        if (authCtx == null) {
            return true;
        }
        if (this.owner != null && authCtx.getIdentifier().equals(this.owner)) {
            return true;
        }
        if (this.usableBy == ConnectionUsableBy.ALL) {
            return true;
        }
        if (this.usableBy == ConnectionUsableBy.ALLOWED) {
            if (authCtx.isAdmin()) {
                return true;
            }
            for (String allowedGroup : this.allowedGroups) {
                if (!authCtx.getGroupsIfRelevant().contains(allowedGroup)) continue;
                return true;
            }
            return false;
        }
        throw new Error("Invalid usableBy value: " + String.valueOf((Object)this.usableBy));
    }

    public boolean mayBeSavedAsPersonalConnectionByNonAdmin() {
        return true;
    }

    public boolean isADataStoringConnection() {
        return true;
    }

    public boolean detailsReadableBy(AuthCtx authCtx) {
        if (authCtx == null) {
            return true;
        }
        if (this.owner != null && authCtx.getIdentifier().equals(this.owner)) {
            return true;
        }
        if (authCtx.isAdmin()) {
            return true;
        }
        switch (this.detailsReadability.readableBy) {
            case NONE: {
                return false;
            }
            case ALL: {
                return true;
            }
            case ALLOWED: {
                for (String allowedGroup : this.detailsReadability.allowedGroups) {
                    if (!authCtx.getGroupsIfRelevant().contains(allowedGroup)) continue;
                    return true;
                }
                return false;
            }
        }
        throw new Error("Invalid readability value: " + String.valueOf((Object)this.detailsReadability.readableBy));
    }

    public void checkDetailsReadableBy(AuthCtx authCtx) throws DKUSecurityException {
        if (!this.detailsReadableBy(authCtx)) {
            throw new UnauthorizedException("You do not have access to the details of this connection", "connection-access-denied");
        }
    }

    public abstract ConnectionsTestService.ConnectionTestResult testConnection(AuthCtx var1, ConnectionsTestService var2) throws Exception;

    public abstract List<AbstractSQLConnection.CustomDatabaseProperty> getDkuProperties();

    public String toString() {
        return "DSSConnection{name='" + this.name + "', type='" + this.type + "'}";
    }

    public void prepareConnectionForProvider() throws IOException {
    }

    public static enum CredentialsMode {
        GLOBAL,
        PER_USER;

    }

    public static enum ConnectionUsableBy {
        ALL,
        ALLOWED;

    }

    public static class DetailsReadability {
        public DetailsReadableBy readableBy = DetailsReadableBy.NONE;
        public List<String> allowedGroups = new ArrayList<String>();
    }

    public static class ConnectionIndexingSettings {
        public boolean indexIndices;
        public boolean indexForeignKeys;
        public boolean indexSystemTables;
    }

    public static enum DetailsReadableBy {
        NONE,
        ALL,
        ALLOWED;

    }

    public static enum DataikuCloudConnectionAccessRestriction {
        NO_CHANGES;

    }

    public static abstract class DkuConnectionParams {
        public static AbstractSQLConnection.CustomDatabaseProperty getDkuProperty(String key, List<AbstractSQLConnection.CustomDatabaseProperty> props) {
            for (AbstractSQLConnection.CustomDatabaseProperty kv : props) {
                if (!StringUtils.equals((String)key, (String)kv.name)) continue;
                return kv;
            }
            return null;
        }
    }

    public static interface BasicConnectionCredentialProvider {
        public void setConnection(DSSConnection var1);

        public void setParams(List<AbstractSQLConnection.CustomDatabaseProperty> var1);

        public ICredentialsService.BasicCredential getCredential(AuthCtx var1) throws Exception;
    }
}

