/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.containers.exec;

import com.dataiku.common.server.SerializedError;
import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.DSSTempUtils;
import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.cluster.ContainerSettings;
import com.dataiku.dip.cluster.SparkSettings;
import com.dataiku.dip.containers.exec.ContainerExecCodes;
import com.dataiku.dip.containers.exec.ContainerExecImagesBuilder;
import com.dataiku.dip.containers.exec.ContainerExecImagesHelper;
import com.dataiku.dip.containers.exec.ContainerExecRuntimeConfig;
import com.dataiku.dip.containers.exec.ContainerExecUtils;
import com.dataiku.dip.containers.exec.ECRUtils;
import com.dataiku.dip.containers.exec.WorkloadType;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.spark.SparkExecutionConfig;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.utils.DKUDateUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.ExceptionUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class BaseImagesPusher {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.containers.imagebuilder");

    public ImagePushResult tagAndPushAll(DKUtils.SmartLogTailBuilder logTailBuilder) throws IOException {
        return this.tagAndPushForImageType(logTailBuilder, null);
    }

    public ImagePushResult tagAndPushForImageType(DKUtils.SmartLogTailBuilder logTailBuilder, ContainerExecUtils.BaseImageType imageType) throws IOException {
        ContainerSettings containerSettings = new ClusterSelector().selectGlobal().getContainerSettings();
        List<Object> configurations = Lists.newArrayList();
        configurations.addAll(containerSettings.listConfigsForWorkloadType(WorkloadType.USER_CODE));
        if (ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN().containerSettings.cdeEnabled) {
            String tag = ContainerExecImagesHelper.getCDEImages().getPluginBuiltTag();
            if (tag != null) {
                configurations.addAll(containerSettings.listConfigsForWorkloadType(WorkloadType.VISUAL_RECIPES).stream().map(c2 -> {
                    ContainerExecRuntimeConfig config = new ContainerExecRuntimeConfig(ContainerExecUtils.BaseImageType.CDE_PLUGINS, (ContainerExecRuntimeConfig)c2);
                    config.baseImage = tag;
                    return config;
                }).collect(Collectors.toList()));
            }
            configurations.addAll(containerSettings.listConfigsForWorkloadType(WorkloadType.VISUAL_RECIPES).stream().map(c2 -> {
                ContainerExecRuntimeConfig config = new ContainerExecRuntimeConfig(ContainerExecUtils.BaseImageType.CDE, (ContainerExecRuntimeConfig)c2);
                config.baseImage = containerSettings.cdeBaseImage;
                return config;
            }).collect(Collectors.toList()));
        }
        SparkSettings sparkSettings = new ClusterSelector().selectGlobal().getSparkSettings();
        for (SparkExecutionConfig conf : sparkSettings.executionConfigs) {
            if (!conf.kubernetesSettings.managedKubernetes || conf.hasConfKey("spark.kubernetes.container.image", "spark.kubernetes.executor.container.image", "spark.kubernetes.driver.container.image")) continue;
            configurations.add(conf.kubernetesSettings);
        }
        if (imageType != null) {
            configurations = configurations.stream().filter(c2 -> c2.baseImageType == imageType).collect(Collectors.toList());
        }
        ImagePushResult pushResult = new ImagePushResult();
        Map<ContainerExecUtils.ContainerBuildConfig, Collection<ContainerExecUtils.ContainerImagePush>> configMap = ContainerExecUtils.deduplicateContainerBuilds((Collection<ContainerExecUtils.ContainerBaseConfig>)configurations);
        for (Map.Entry<ContainerExecUtils.ContainerBuildConfig, Collection<ContainerExecUtils.ContainerImagePush>> configEntry : configMap.entrySet()) {
            ArrayList toPush = new ArrayList();
            for (ContainerExecUtils.ContainerImagePush push : configEntry.getValue()) {
                if (!StringUtils.isNotBlank((String)push.repositoryURL)) continue;
                toPush.add(push);
            }
            pushResult.states.addAll(this.tagAndPush(configEntry.getKey(), toPush, logTailBuilder, pushResult.messages));
        }
        ContainerExecImagesHelper.CDEImages cdeImages = ContainerExecImagesHelper.getCDEImages();
        CDEImagePostPushResult postProcessResult = BaseImagesPusher.postProcessCDEPluginsPush(cdeImages, configMap);
        ContainerExecImagesHelper.setCDEImages(cdeImages);
        if (postProcessResult != null) {
            for (ContainerExecUtils.ContainerBuildConfig config : postProcessResult.dockerConfigsToClean) {
                AutoDelete ad = DSSTempUtils.getTempFolder((String)"container-cde-plugin-image-delete", (String)"x");
                try {
                    ContainerExecImagesBuilder.deleteOldImages(config, postProcessResult.oldTag, new HashSet<String>(), (File)ad, logTailBuilder, null);
                }
                finally {
                    if (ad == null) continue;
                    ad.close();
                }
            }
            try (AutoDelete ad = DSSTempUtils.getTempFolder((String)"container-cde-plugin-image-delete", (String)"x");){
                ContainerExecImagesBuilder.deleteOldImages(null, postProcessResult.oldTag, postProcessResult.oldRepositories, (File)ad, logTailBuilder, null);
            }
        }
        return pushResult;
    }

    @VisibleForTesting
    static CDEImagePostPushResult postProcessCDEPluginsPush(ContainerExecImagesHelper.CDEImages cdeImages, Map<ContainerExecUtils.ContainerBuildConfig, Collection<ContainerExecUtils.ContainerImagePush>> configMap) {
        Optional<ContainerExecUtils.ContainerBuildConfig> cdePluginConfig = configMap.keySet().stream().filter(c2 -> c2.baseImageType == ContainerExecUtils.BaseImageType.CDE_PLUGINS).findAny();
        if (!cdePluginConfig.isPresent()) {
            return null;
        }
        String newTag = cdePluginConfig.get().baseImage;
        if (StringUtils.equals((String)cdeImages.getPluginPushedTag(), (String)newTag)) {
            return null;
        }
        String oldTag = cdeImages.getPluginPushedTag();
        if (cdeImages.cdePlugins == null) {
            cdeImages.cdePlugins = new ContainerExecImagesHelper.CDEPluginsImage();
        }
        cdeImages.cdePlugins.pushed = new ContainerExecImagesHelper.CDEImageDescription(newTag, DKUApp.getDSSVersion().product_version, DKUDateUtils.isoFormatUTCNow());
        HashSet<ContainerExecUtils.ContainerBuildConfig> dockerConfigsToClean = new HashSet<ContainerExecUtils.ContainerBuildConfig>();
        HashSet allRepositoryUrls = new HashSet();
        for (Map.Entry<ContainerExecUtils.ContainerBuildConfig, Collection<ContainerExecUtils.ContainerImagePush>> configEntry : configMap.entrySet()) {
            if (configEntry.getKey().baseImageType != ContainerExecUtils.BaseImageType.CDE_PLUGINS || !StringUtils.isNotBlank((String)oldTag)) continue;
            allRepositoryUrls.addAll(configEntry.getValue().stream().map(p -> p.repositoryURL).filter(url -> StringUtils.isNotBlank((String)url)).collect(Collectors.toSet()));
            ContainerExecUtils.ContainerBuildConfig config = configEntry.getKey();
            if (config.isImageBuiltLocally()) continue;
            dockerConfigsToClean.add(config);
        }
        HashSet<String> oldRepositories = new HashSet<String>();
        if (cdeImages.cdePlugins.repositoryUrls != null) {
            oldRepositories.addAll(cdeImages.cdePlugins.repositoryUrls);
        }
        cdeImages.cdePlugins.repositoryUrls = new ArrayList<String>(allRepositoryUrls);
        return new CDEImagePostPushResult(oldRepositories, dockerConfigsToClean, oldTag);
    }

    private List<ImagePushState> tagAndPush(ContainerExecUtils.ContainerBuildConfig pushConfig, Collection<ContainerExecUtils.ContainerImagePush> pushes, DKUtils.SmartLogTailBuilder logTailBuilder, InfoMessage.InfoMessages ret) throws IOException {
        String baseImage = pushConfig.baseImage;
        logger.infoV("tag and push Docker base image pusher requestedBaseImageTag=%s", new Object[]{baseImage});
        ArrayList<ImagePushState> result = new ArrayList<ImagePushState>();
        try (AutoDelete ad = DSSTempUtils.getTempFolder((String)"container-exec-base-image-push", (String)"x");){
            logTailBuilder.appendLine("Tagging and pushing base image " + baseImage);
            String baseImageTag = pushConfig.baseImageType != ContainerExecUtils.BaseImageType.CDE_PLUGINS ? ContainerExecImagesHelper.getBaseImageTag(baseImage, pushConfig.baseImageType) : baseImage;
            if (pushes.isEmpty()) {
                logger.info((Object)("Not pushing; no repository URLs set for " + baseImageTag));
                logTailBuilder.appendLine("Not pushing; no repository URLs set for " + baseImageTag);
            } else {
                logger.info((Object)("Actually pushing " + baseImageTag + " to " + pushes.size() + " repositories"));
                logTailBuilder.appendLine("Actually pushing " + baseImageTag + " to " + pushes.size() + " repositories");
            }
            for (ContainerExecUtils.ContainerImagePush push : pushes) {
                logTailBuilder.appendLine("Pushing docker tag to " + push.repositoryURL);
                String repoRef = push.repositoryURL + "/" + baseImageTag;
                try {
                    ProcessBuilder pb;
                    switch (push.prePushMode) {
                        case NONE: {
                            break;
                        }
                        case ECR: {
                            String region = ECRUtils.getRegionFromRepositoryURL(push.repositoryURL);
                            logTailBuilder.appendLine("EKS Pre-push script. Detected region: " + region);
                            pb = new ProcessBuilder(baseImageTag.split(":"));
                            pb.command().add(0, DKUApp.getInstallFile((String[])new String[]{"resources", "container-exec", "kubernetes", "aws-ecr-prepush.sh"}).getAbsolutePath());
                            pb.command().add(1, push.repositoryURL);
                            pb.command().add(2, region);
                            ContainerExecImagesBuilder.execDockerCommand(pushConfig, pb, (File)ad, logTailBuilder, null);
                            break;
                        }
                        case ACR: {
                            logTailBuilder.appendLine("ACR Pre-push script");
                            pb = new ProcessBuilder(baseImageTag.split(":"));
                            pb.command().add(0, DKUApp.getInstallFile((String[])new String[]{"resources", "container-exec", "kubernetes", "azure-acr-prepush.sh"}).getAbsolutePath());
                            pb.command().add(1, push.repositoryURL);
                            ContainerExecImagesBuilder.execDockerCommand(pushConfig, pb, (File)ad, logTailBuilder, null);
                            break;
                        }
                        case CUSTOM: {
                            if (!StringUtils.isNotBlank((String)push.prePushScript)) break;
                            logTailBuilder.appendLine("Custom Pre-push script, mode=" + String.valueOf((Object)push.prePushMode));
                            pb = new ProcessBuilder(baseImageTag.split(":"));
                            pb.command().add(0, push.prePushScript);
                            pb.command().add(1, push.repositoryURL);
                            ContainerExecImagesBuilder.execDockerCommand(pushConfig, pb, (File)ad, logTailBuilder, null);
                        }
                    }
                    pb = new ProcessBuilder("docker", "tag", baseImageTag, repoRef);
                    ContainerExecImagesBuilder.execDockerCommand(pushConfig, pb, (File)ad, logTailBuilder, null);
                    pb = new ProcessBuilder("docker", "push", repoRef);
                    ContainerExecImagesBuilder.execDockerCommand(pushConfig, pb, (File)ad, logTailBuilder, null);
                    ret.withInfo((InfoMessage.MessageCode)ContainerExecCodes.INFO_CONTAINER_IMAGE_PUSH_OK, "Successfully pushed " + baseImageTag + " to " + push.repositoryURL);
                    result.add(new ImagePushState(baseImageTag, pushConfig.dockerHost, push.repositoryURL, true, null));
                }
                catch (Exception ex) {
                    Object simpleError = ExceptionUtils.getMessageWithCauses((Throwable)ex);
                    List logTail = logTailBuilder.get().getLines();
                    if (!logTail.isEmpty()) {
                        simpleError = (String)simpleError + " - " + (String)logTail.get(logTail.size() - 1);
                    }
                    logTailBuilder.appendLine("Could not push docker image: " + String.valueOf(ex));
                    logger.warn((Object)("Could not push docker image: " + String.valueOf(ex)));
                    ret.withFatal((InfoMessage.MessageCode)ContainerExecCodes.ERR_CONTAINER_IMAGE_PUSH_FAILED, "Could not push " + baseImageTag + " to " + push.repositoryURL + ": " + (String)simpleError);
                    result.add(new ImagePushState(baseImageTag, pushConfig.dockerHost, repoRef, false, new SerializedError((Throwable)ex, !ApplicationConfigurator.hideErrorStacks(), !ApplicationConfigurator.hideErrorStacks(), !ApplicationConfigurator.hideLogTails())));
                }
            }
        }
        return result;
    }

    public static class ImagePushResult {
        public ArrayList<ImagePushState> states = new ArrayList();
        public InfoMessage.InfoMessages messages = new InfoMessage.InfoMessages();
    }

    static class CDEImagePostPushResult {
        Set<String> oldRepositories;
        Set<ContainerExecUtils.ContainerBuildConfig> dockerConfigsToClean;
        String oldTag;

        public CDEImagePostPushResult(Set<String> oldRepositories, Set<ContainerExecUtils.ContainerBuildConfig> dockerConfigsToClean, String tag) {
            this.oldRepositories = oldRepositories;
            this.dockerConfigsToClean = dockerConfigsToClean;
            this.oldTag = tag;
        }
    }

    public static class ImagePushState {
        final String baseImage;
        final String dockerHost;
        final String repositoryURL;
        final Boolean pushSucceeded;
        final SerializedError pushError;

        public ImagePushState(String baseImage, String dockerHost, String repositoryURL, Boolean pushSucceeded, SerializedError pushError) {
            this.baseImage = baseImage;
            this.dockerHost = dockerHost;
            this.repositoryURL = repositoryURL;
            this.pushSucceeded = pushSucceeded;
            this.pushError = pushError;
        }
    }
}

