/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.containers.exec;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.DSSTempUtils;
import com.dataiku.dip.code.CodeEnvCodes;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.code.CodeEnvResolutionService;
import com.dataiku.dip.containers.exec.BaseImageBuilder;
import com.dataiku.dip.containers.exec.ContainerExecImageTagFormat;
import com.dataiku.dip.containers.exec.ContainerExecRuntimeConfig;
import com.dataiku.dip.containers.exec.ContainerExecUtils;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.exceptions.CodedIOException;
import com.dataiku.dip.utils.DKUDateUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.PathUtils;
import com.dataiku.dss.shadelib.org.apache.commons.codec.binary.Hex;
import com.google.gson.annotations.SerializedName;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import org.apache.commons.lang.StringUtils;
import org.apache.directory.api.util.Strings;

public class ContainerExecImagesHelper {
    public static final String ENV_IMAGE_FILE = "container-exec.json";
    public static final int MAX_TAG_LENGTH = 128;
    public static final int MAX_CODE_ENV_NAME_LENGTH = 50;
    public static final String DKU_CONTAINER_EXEC_IMAGE_TAGGING_FORMAT = "dku.container.exec.image.tagging.format";
    public static final String DKU_CONTAINER_EXEC_IMAGE_TAGGING_MAX_CODE_ENV_NAME_LENGTH = "dku.container.exec.image.tagging.code-env-name-tag.max-length";
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.containerexec.imageshelper");

    private static File getImageVersionFile(CodeEnvModel.EnvLang lang, String envName, String envVersion) throws IOException {
        File descDir = CodeEnvResolutionService.getEnvDescDir(envName, lang, envVersion);
        if (!descDir.isDirectory()) {
            throw new CodedIOException((InfoMessage.MessageCode)(envVersion == null ? CodeEnvCodes.ERR_CODEENV_MISSING_ENV : CodeEnvCodes.ERR_CODEENV_MISSING_ENV_VERSION), "Can't find directory for env " + String.valueOf((Object)lang) + " " + envName + " version= " + envVersion + ". Maybe you need to rebuild the env.");
        }
        return new File(descDir, ENV_IMAGE_FILE);
    }

    private static String getImageKey(String dockerHost, String imageName) {
        return (StringUtils.isBlank((String)dockerHost) ? "" : dockerHost) + "|" + imageName;
    }

    public static synchronized void setLastBuiltImageForEnv(CodeEnvModel.EnvLang lang, String envName, String envVersion, String dockerHost, String imageName, String tag) throws IOException {
        File imageFile = ContainerExecImagesHelper.getImageVersionFile(lang, envName, envVersion);
        LastBuiltEnvImages lastBuiltEnvImages = imageFile.isFile() ? (LastBuiltEnvImages)JSON.parseFile((File)imageFile, LastBuiltEnvImages.class) : new LastBuiltEnvImages();
        lastBuiltEnvImages.versionPerBaseImage.put(ContainerExecImagesHelper.getImageKey(dockerHost, imageName), tag);
        JSON.prettyToFile((Object)lastBuiltEnvImages, (File)imageFile);
    }

    public static synchronized void unregisterImagesForEnv(CodeEnvModel.EnvLang lang, String envName) throws IOException {
        for (File f : CodeEnvResolutionService.getEnvDescDirs(envName, lang)) {
            if (!(f = new File(f, ENV_IMAGE_FILE)).isFile() || f.delete()) continue;
            logger.error((Object)("Could not delete image tag: " + f.getCanonicalPath()));
        }
    }

    public static boolean builtForContainerConf(ContainerExecRuntimeConfig config, String envName, CodeEnvModel.EnvLang envLang, String envVersion) {
        try {
            ContainerExecImagesHelper.getImageTagToUse(config.dockerHost, config.baseImage, config.baseImageType, envLang, envName, envVersion);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static String getImageVersionToUse(CodeEnvModel.EnvLang lang, String envName, String envVersion, String dockerHost, String imageName) throws IOException {
        String imageVersion = ContainerExecImagesHelper.getImageVersionToUseOrNull(lang, envName, envVersion, dockerHost, imageName);
        if (imageVersion == null) {
            throw new CodedIOException((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_CONTAINER_IMAGE_TAG_NOT_FOUND, "No recorded image tag for env " + String.valueOf((Object)lang) + " " + envName + " version= " + envVersion + ". Maybe you need to build Docker image");
        }
        return imageVersion;
    }

    private static String getImageVersionToUseOrNull(CodeEnvModel.EnvLang lang, String envName, String envVersion, String dockerHost, String imageName) throws IOException {
        File imageFile = ContainerExecImagesHelper.getImageVersionFile(lang, envName, envVersion);
        String imageVersion = null;
        if (imageFile.isFile()) {
            imageVersion = ((LastBuiltEnvImages)JSON.parseFile((File)imageFile, LastBuiltEnvImages.class)).versionPerBaseImage.get(ContainerExecImagesHelper.getImageKey(dockerHost, imageName));
        }
        return imageVersion;
    }

    public static String getImageTagToUse(String dockerHost, String requestedBaseImageTag, ContainerExecUtils.BaseImageType baseImageType, CodeEnvModel.EnvLang envLang, String envName, String envVersion) throws IOException {
        logger.infoV("Finding out which image to use for requestedBase=%s envLang=%s envName=%s envVersion=%s", new Object[]{requestedBaseImageTag, envLang, envName, envVersion});
        if (baseImageType == ContainerExecUtils.BaseImageType.CDE || baseImageType == ContainerExecUtils.BaseImageType.CDE_PLUGINS) {
            return ContainerExecImagesHelper.getCDEImageTag(requestedBaseImageTag);
        }
        if (envLang == null || envName == null) {
            logger.infoV("No env, using base", new Object[0]);
            return ContainerExecImagesHelper.getBaseImageTag(requestedBaseImageTag, baseImageType);
        }
        String tagName = ContainerExecImagesHelper.getImageTag(false, dockerHost, requestedBaseImageTag, baseImageType, envLang, envName, envVersion).getFullTag();
        logger.infoV("Will use %s", new Object[]{tagName});
        return tagName;
    }

    public static String getImageTagToUseOrNull(String dockerHost, String requestedBaseImageTag, ContainerExecUtils.BaseImageType baseImageType, CodeEnvModel.EnvLang envLang, String envName, String envVersion) throws IOException {
        logger.infoV("Checking if there is an image to use for requestedBase=%s envLang=%s envName=%s envVersion=%s", new Object[]{requestedBaseImageTag, envLang, envName, envVersion});
        if (baseImageType == ContainerExecUtils.BaseImageType.CDE || baseImageType == ContainerExecUtils.BaseImageType.CDE_PLUGINS) {
            return ContainerExecImagesHelper.getCDEImageTag(requestedBaseImageTag);
        }
        if (envLang == null || envName == null) {
            logger.infoV("No env, using base", new Object[0]);
            return ContainerExecImagesHelper.getBaseImageTag(requestedBaseImageTag, baseImageType);
        }
        ImageTagRef tagName = ContainerExecImagesHelper.getImageTag(false, dockerHost, requestedBaseImageTag, baseImageType, envLang, envName, envVersion);
        if (StringUtils.isBlank((String)tagName.tag)) {
            logger.infoV("No image version for %s", new Object[]{tagName.baseImage});
            return null;
        }
        logger.infoV("Will use %s", new Object[]{tagName.getFullTag()});
        return tagName.getFullTag();
    }

    public static String getCodeEnvName(CodeEnvModel.EnvLang lang, String envName) {
        String properEnvName = envName.toLowerCase().replaceAll("[^a-z0-9-_]", "_").replaceAll("[_-]{2,}", "_").replaceFirst("[_-]+$", "");
        switch (lang) {
            case PYTHON: {
                return "pyenv-" + properEnvName;
            }
            case R: {
                return "renv-" + properEnvName;
            }
        }
        return "";
    }

    public static String getDSSVersion() {
        return "dss-" + ApplicationConfigurator.getDSSVersion().product_version.toLowerCase(Locale.ENGLISH).replace('/', '_');
    }

    public static String getInstanceId() {
        return ApplicationConfigurator.getInstallId().toLowerCase(Locale.ENGLISH);
    }

    public static String getStaticId(ContainerExecUtils.BaseImageType baseImageType) {
        return "dku-" + baseImageType.name().toLowerCase() + "-base";
    }

    public static String getNewImageVersionToBuild() {
        return "r-" + DKUDateUtils.isoFormatFileFriendlyLocalNow();
    }

    public static List<String> getCodeEnvImageTags(String dockerHost, String requestedBaseImageTag, ContainerExecUtils.BaseImageType baseImageType, CodeEnvModel.EnvLang envLang, String envName, String envVersion) throws IOException {
        ArrayList<String> codeEnvImageFullTags = new ArrayList<String>();
        if (envLang == null || envName == null) {
            return codeEnvImageFullTags;
        }
        for (File f : CodeEnvResolutionService.getEnvDescDirs(envName, envLang)) {
            if (!(f = new File(f, ENV_IMAGE_FILE)).isFile()) continue;
            LastBuiltEnvImages lastBuiltEnvImages = (LastBuiltEnvImages)JSON.parseFile((File)f, LastBuiltEnvImages.class);
            ImageTagRef imageTag = ContainerExecImagesHelper.getImageTag(false, dockerHost, requestedBaseImageTag, baseImageType, envLang, envName, envVersion);
            imageTag.tag = lastBuiltEnvImages.versionPerBaseImage.get(ContainerExecImagesHelper.getImageKey(dockerHost, imageTag.baseImage));
            if (imageTag.tag == null) continue;
            codeEnvImageFullTags.add(imageTag.getFullTag());
        }
        return codeEnvImageFullTags;
    }

    public static ImageTagRef getImageTag(boolean isBuildingImage, @CheckForNull String dockerHost, @CheckForNull String requestedBaseImageTag, ContainerExecUtils.BaseImageType baseImageType, CodeEnvModel.EnvLang lang, String envName, String envVersion) throws IOException {
        Object imageVersion;
        ContainerExecImageTagFormat taggingFormat;
        String taggingFormatSerialised = DKUApp.getParams().getParam(DKU_CONTAINER_EXEC_IMAGE_TAGGING_FORMAT, ContainerExecImageTagFormat.IMAGE_VERSION_ONLY.name()).trim();
        try {
            taggingFormat = ContainerExecImageTagFormat.valueOf(taggingFormatSerialised);
        }
        catch (Exception e) {
            logger.warn((Object)("Unknown '" + taggingFormatSerialised + "' value behind property 'dku.container.exec.image.tagging.format'"), (Throwable)e);
            taggingFormat = ContainerExecImageTagFormat.IMAGE_VERSION_ONLY;
        }
        String staticId = ContainerExecImagesHelper.getStaticId(baseImageType);
        String instanceId = ContainerExecImagesHelper.getInstanceId();
        String dssVersion = ContainerExecImagesHelper.getDSSVersion();
        String codeEnvName = ContainerExecImagesHelper.getCodeEnvName(lang, envName);
        Object imageName = requestedBaseImageTag;
        if (StringUtils.isBlank((String)requestedBaseImageTag)) {
            switch (taggingFormat) {
                case CODE_ENV_AND_IMAGE_VERSION: {
                    imageName = staticId + "-" + instanceId + "-" + dssVersion;
                    break;
                }
                default: {
                    imageName = staticId + "-" + instanceId + "-" + dssVersion + "-" + codeEnvName;
                    break;
                }
            }
        } else {
            String[] baseImageChunks = requestedBaseImageTag.split(":");
            imageName = baseImageChunks[0];
            if (baseImageChunks.length == 2) {
                imageName = (String)imageName + "-" + baseImageChunks[1];
            } else if (baseImageChunks.length != 1) {
                throw new IllegalArgumentException("Multiple `:` in base image tag: " + requestedBaseImageTag);
            }
            switch (taggingFormat) {
                case CODE_ENV_AND_IMAGE_VERSION: {
                    break;
                }
                default: {
                    imageName = (String)imageName + "-" + codeEnvName;
                }
            }
        }
        if (isBuildingImage) {
            int maxCodeEnvNameTagLength = DKUApp.getParams().getIntParam(DKU_CONTAINER_EXEC_IMAGE_TAGGING_MAX_CODE_ENV_NAME_LENGTH, Integer.valueOf(50));
            switch (taggingFormat) {
                case CODE_ENV_AND_IMAGE_VERSION: {
                    Object finalCodeEnvName = codeEnvName;
                    if (codeEnvName.length() > maxCodeEnvNameTagLength) {
                        String truncatedPart = codeEnvName.substring(0, maxCodeEnvNameTagLength);
                        String hash = ContainerExecImagesHelper.generateHash(codeEnvName.substring(maxCodeEnvNameTagLength));
                        finalCodeEnvName = truncatedPart + "-" + hash;
                    }
                    imageVersion = (String)finalCodeEnvName + "-" + ContainerExecImagesHelper.getNewImageVersionToBuild();
                    break;
                }
                default: {
                    imageVersion = ContainerExecImagesHelper.getNewImageVersionToBuild();
                    break;
                }
            }
        } else {
            imageVersion = ContainerExecImagesHelper.getImageVersionToUse(lang, envName, envVersion, dockerHost, (String)imageName);
        }
        if (((String)imageVersion).length() > 128) {
            throw new IllegalArgumentException("Generated image version exceeds the 128-character limit");
        }
        return new ImageTagRef((String)imageName, (String)imageVersion);
    }

    public static String generateHash(String input) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] hashBytes = digest.digest(input.getBytes());
            return Hex.encodeHexString((byte[])Arrays.copyOf(hashBytes, 4));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Error generating hash", e);
        }
    }

    public static String getDefaultBaseImageTag(ContainerExecUtils.BaseImageType baseImageType) {
        return String.format("%s-%s:%s", ContainerExecImagesHelper.getStaticId(baseImageType), ContainerExecImagesHelper.getInstanceId(), ContainerExecImagesHelper.getDSSVersion());
    }

    public static LastBuiltImage getLastBuiltImage(ContainerExecUtils.BaseImageType baseImageType) {
        try {
            File lastBuildImagesFile = ApplicationConfigurator.getFile((String[])new String[]{"run", "built-base-images.json"});
            if (lastBuildImagesFile != null && lastBuildImagesFile.exists()) {
                logger.info((Object)"Found list of built images");
                LastBuiltImages images = (LastBuiltImages)JSON.parseFile((File)lastBuildImagesFile, LastBuiltImages.class);
                LastBuiltImage image = switch (baseImageType) {
                    case ContainerExecUtils.BaseImageType.EXEC -> images.images.get("container_exec");
                    case ContainerExecUtils.BaseImageType.SPARK -> images.images.get("spark");
                    case ContainerExecUtils.BaseImageType.CDE -> images.images.get("cde");
                    case ContainerExecUtils.BaseImageType.CDE_PLUGINS -> images.images.get("cde-plugins");
                    default -> null;
                };
                if (image != null && image.dssVersion != null) {
                    String dssVersion = DKUApp.getDSSVersion().product_version;
                    if (dssVersion != null) {
                        dssVersion = dssVersion.replace("/", "_").toLowerCase();
                    }
                    if (!StringUtils.equals((String)image.dssVersion, (String)dssVersion)) {
                        logger.warn((Object)("Image with tag " + image.tag + " was built for version " + image.dssVersion + " but dss version is " + dssVersion));
                    }
                }
                return image;
            }
        }
        catch (IOException e) {
            logger.warn((Object)("Unable to get last built image for " + String.valueOf((Object)baseImageType) + ", using default expected value"), (Throwable)e);
        }
        return null;
    }

    private static File getCDEImagesFile() {
        return ApplicationConfigurator.getFile((String[])new String[]{"run", "cde-images.json"});
    }

    public static CDEImages getCDEImages() {
        File lastBuildImagesFile = ContainerExecImagesHelper.getCDEImagesFile();
        if (lastBuildImagesFile != null && lastBuildImagesFile.exists()) {
            try {
                return (CDEImages)JSON.parseFile((File)lastBuildImagesFile, CDEImages.class);
            }
            catch (IOException e) {
                logger.error((Object)"Could not read cde images file", (Throwable)e);
            }
        }
        return new CDEImages();
    }

    public static void setCDEImages(CDEImages cdeImages) {
        File lastBuildImagesFile = ContainerExecImagesHelper.getCDEImagesFile();
        if (lastBuildImagesFile != null) {
            File tmpFile = DSSTempUtils.getTempFileNoCreate((String)"cde-images", (String)("ts_" + System.currentTimeMillis()));
            try {
                JSON.prettyToFile((Object)cdeImages, (File)tmpFile);
                Files.move(tmpFile.toPath(), lastBuildImagesFile.toPath(), StandardCopyOption.ATOMIC_MOVE);
            }
            catch (IOException e) {
                logger.error((Object)"Could not write cde images file", (Throwable)e);
            }
        }
    }

    public static BaseImageBuilder.BaseImageBuildOptions getLatestOptions(ContainerExecUtils.BaseImageType type) {
        LastBuiltImage image = ContainerExecImagesHelper.getLastBuiltImage(type);
        BaseImageBuilder.BaseImageBuildOptions options = image == null || image.options == null ? new BaseImageBuilder.BaseImageBuildOptions(type) : image.options.toBaseImageBuildOptions(type);
        return options;
    }

    public static String getBaseImageTag(String requestedBaseImageTag, ContainerExecUtils.BaseImageType baseImageType) {
        if (StringUtils.isBlank((String)requestedBaseImageTag)) {
            return ContainerExecImagesHelper.getDefaultBaseImageTag(baseImageType);
        }
        return requestedBaseImageTag;
    }

    public static String getCDEImageTag(String requestedBaseImageTag) {
        String tag = ContainerExecImagesHelper.getCDEImages().getPluginPushedTag();
        if (tag != null) {
            return tag;
        }
        if (StringUtils.isNotBlank((String)requestedBaseImageTag)) {
            return requestedBaseImageTag;
        }
        return ContainerExecImagesHelper.getDefaultBaseImageTag(ContainerExecUtils.BaseImageType.CDE);
    }

    public static String withRepositoryURL(String repositoryURL, String imageId) {
        if (StringUtils.isBlank((String)repositoryURL)) {
            return imageId;
        }
        return PathUtils.slashes((String)repositoryURL, (Boolean)false, (Boolean)true, (boolean)true, (String)"") + imageId;
    }

    private static class LastBuiltEnvImages {
        Map<String, String> versionPerBaseImage = new HashMap<String, String>();

        private LastBuiltEnvImages() {
        }
    }

    public static class ImageTagRef {
        public String baseImage;
        public String tag;

        public ImageTagRef(String baseImage, String tag) {
            this.baseImage = baseImage;
            this.tag = tag;
        }

        public String getFullTag() {
            return this.baseImage + ":" + this.tag;
        }

        public String toString() {
            return this.getFullTag();
        }
    }

    public static class LastBuiltImages {
        public Map<String, LastBuiltImage> images = new HashMap<String, LastBuiltImage>();
    }

    public static class LastBuiltImage {
        public String tag;
        public String dssVersion;
        public String datetime;
        public PythonBuildOptions options;

        public static class PythonBuildOptions {
            public BaseImageBuilder.BaseImageBuildOptions.BuildOptionStatus py36;
            public boolean py37;
            public boolean py38;
            public boolean r;
            public boolean py39;
            public boolean py310;
            public boolean py311;
            public boolean py312;
            public boolean py313;
            public boolean without_xgboost_gpu_support;
            public String distrib;
            public String build_from_image;
            public String system_packages;
            public String http_proxy;
            public String https_proxy;
            public String no_proxy;
            public String dockerfile_preprend;
            public String cran_mirror;
            public List<String> docker_build_opt;
            public String dockerfile_append;
            public String copy_to_buildenv;
            public boolean cuda;
            public String cuda_version;

            public BaseImageBuilder.BaseImageBuildOptions toBaseImageBuildOptions(ContainerExecUtils.BaseImageType imageType) {
                BaseImageBuilder.BaseImageBuildOptions options = new BaseImageBuilder.BaseImageBuildOptions(imageType);
                options.R = this.r;
                options.py36 = this.py36;
                options.py37 = this.py37;
                options.py38 = this.py38;
                options.py39 = this.py39;
                options.py310 = this.py310;
                options.py311 = this.py311;
                options.py312 = this.py312;
                options.py313 = this.py313;
                options.withoutXGBoostGpuSupport = this.without_xgboost_gpu_support;
                options.distrib = this.distrib;
                if (this.docker_build_opt != null) {
                    options.extraOptions = this.docker_build_opt.stream().map(opt -> "--docker-build-opt=" + opt).collect(Collectors.toList());
                }
                if (Strings.isNotEmpty((String)this.build_from_image)) {
                    options.extraOptions.add("--build-from-image=" + this.build_from_image);
                }
                if (Strings.isNotEmpty((String)this.system_packages)) {
                    options.extraOptions.add("--system-packages=" + this.system_packages);
                }
                if (Strings.isNotEmpty((String)this.https_proxy)) {
                    options.extraOptions.add("--https-proxy=" + this.https_proxy);
                }
                if (Strings.isNotEmpty((String)this.http_proxy)) {
                    options.extraOptions.add("--http-proxy=" + this.http_proxy);
                }
                if (Strings.isNotEmpty((String)this.no_proxy)) {
                    options.extraOptions.add("--no-proxy=" + this.no_proxy);
                }
                if (Strings.isNotEmpty((String)this.dockerfile_preprend)) {
                    options.extraOptions.add("--dockerfile-prepend=" + this.dockerfile_preprend);
                }
                if (Strings.isNotEmpty((String)this.cran_mirror)) {
                    options.extraOptions.add("--cran-mirror=" + this.cran_mirror);
                }
                if (Strings.isNotEmpty((String)this.dockerfile_append)) {
                    options.extraOptions.add("--dockerfile-append=" + this.dockerfile_append);
                }
                if (Strings.isNotEmpty((String)this.copy_to_buildenv)) {
                    options.extraOptions.add("--copy-to-buildenv=" + this.copy_to_buildenv);
                }
                if (this.cuda && Strings.isNotEmpty((String)this.cuda_version)) {
                    options.cudaVersion = this.cuda_version;
                }
                return options;
            }
        }
    }

    public static class CDEImages {
        public CDEBaseImage cde;
        @SerializedName(value="cde-plugins")
        public CDEPluginsImage cdePlugins;

        private String getPluginTag(CDEImageDescription image) {
            if (image != null) {
                if (!StringUtils.equals((String)image.dssVersion, (String)DKUApp.getDSSVersion().product_version)) {
                    logger.warn((Object)"The cde-plugins image was built for a previous version of dss, it cannot be used");
                    return null;
                }
                return image.tag;
            }
            return null;
        }

        public String getPluginPushedTag() {
            if (this.cdePlugins == null) {
                return null;
            }
            return this.getPluginTag(this.cdePlugins.pushed);
        }

        public String getPluginBuiltTag() {
            if (this.cdePlugins == null) {
                return null;
            }
            return this.getPluginTag(this.cdePlugins.built);
        }

        public boolean isBaseBuilt() {
            return this.cde != null && this.cde.built != null && this.cde.built.tag != null;
        }

        public boolean isPluginsBuilt() {
            return this.cdePlugins != null && this.cdePlugins.built != null && this.cdePlugins.built.tag != null;
        }
    }

    public static class CDEPluginsImage {
        public CDEImageDescription built;
        public CDEImageDescription pushed;
        public List<String> repositoryUrls;
    }

    public static class CDEBaseImage {
        public CDEImageDescription built;
    }

    public static class CDEImageDescription {
        public String tag;
        public String dssVersion;
        public String datetime;

        public CDEImageDescription(String tag, String dssVersion, String datetime) {
            this.tag = tag;
            this.dssVersion = dssVersion;
            this.datetime = datetime;
        }
    }
}

