/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.coremodel;

import com.dataiku.dip.coremodel.KeyValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;

public class KeyValueList<K, V>
extends ArrayList<KeyValue<K, V>> {
    public void add(K key, V value) {
        this.add(new KeyValue<K, V>(key, value));
    }

    @SafeVarargs
    public static <K, V> KeyValueList<K, V> of(KeyValue<K, V> ... kvs) {
        KeyValueList<K, V> result = new KeyValueList<K, V>();
        Collections.addAll(result, kvs);
        return result;
    }

    public static <K, V> KeyValueList<K, V> of(K key, V value) {
        KeyValueList<K, V> result = new KeyValueList<K, V>();
        result.add(key, value);
        return result;
    }

    public static <K, V> KeyValueList<K, V> of(K key1, V value1, K key2, V value2) {
        KeyValueList<K, V> result = new KeyValueList<K, V>();
        result.add(key1, value1);
        result.add(key2, value2);
        return result;
    }

    public static <K, V> KeyValueList<K, V> of(K key1, V value1, K key2, V value2, K key3, V value3) {
        KeyValueList<K, V> result = new KeyValueList<K, V>();
        result.add(key1, value1);
        result.add(key2, value2);
        result.add(key3, value3);
        return result;
    }

    public static <K, V> Optional<V> getOptional(KeyValueList<K, V> list, K key) {
        return list == null ? Optional.empty() : list.getOptional(key);
    }

    public static <K, V> V get(KeyValueList<K, V> list, K key) {
        return list == null ? null : list.getOptional(key).orElse(null);
    }

    public static <K, V> V getOrDefault(KeyValueList<K, V> list, K key, V defaultValue) {
        return list == null ? defaultValue : list.getOptional(key).orElse(defaultValue);
    }

    public V get(K key) {
        return this.getOptional(key).orElse(null);
    }

    public V getOrDefault(K key, V defaultValue) {
        return this.getOptional(key).orElse(defaultValue);
    }

    public Optional<V> getOptional(K key) {
        for (KeyValue kv : this) {
            if (!Objects.equals(kv.key, key)) continue;
            return Optional.of(kv.value);
        }
        return Optional.empty();
    }
}

