/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.analysis.ml.distributed.workers.WorkerInfos;
import com.dataiku.dip.analysis.ml.distributed.workers.WorkerService;
import com.dataiku.dip.autoconfig.ParamDesc;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.ConnectionWithAzureAuthCredentials;
import com.dataiku.dip.connections.ConnectionWithBasicCredential;
import com.dataiku.dip.connections.ConnectionWithGoogleAuthCredentials;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.FsConnection;
import com.dataiku.dip.connections.GoogleCredentialCache;
import com.dataiku.dip.connections.GoogleCredentialsBuilder;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.ObjectCompleteMetadata;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.custom.PluginSettingsResolver;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dao.RecipesDAO;
import com.dataiku.dip.dao.StreamingEndpointsDAO;
import com.dataiku.dip.dataflow.cde.CDEProcessUtils;
import com.dataiku.dip.dataflow.exec.CodeBasedRecipeDatasetInfoHelper;
import com.dataiku.dip.dataflow.streaming.DataframePreparationExecutor;
import com.dataiku.dip.dataflow.streaming.DataframePreparationRequest;
import com.dataiku.dip.dataflow.streaming.DatasetWritingService;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.fs.FSProviderConnectionFactory;
import com.dataiku.dip.datasets.fs.FSProviderFactory;
import com.dataiku.dip.datasets.fs.LocalFSProvider;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetHandler;
import com.dataiku.dip.datasets.sql.AbstractSQLQueryDatasetHandler;
import com.dataiku.dip.datasets.sql.AbstractSQLTableDatasetHandler;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.DSSInternalErrorException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.export.ZipUnzipDir;
import com.dataiku.dip.fs.FSBrowsePath;
import com.dataiku.dip.fs.FSProvider;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.input.stream.EnrichedInputStream;
import com.dataiku.dip.logging.MainLoggingConfigurator;
import com.dataiku.dip.managedfolder.KernelsManagedFolderService;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.managedfolder.ManagedFolderCodes;
import com.dataiku.dip.managedfolder.ManagedFolderHandler;
import com.dataiku.dip.meanings.IBasicMeaningsService;
import com.dataiku.dip.meanings.MeaningsDAO;
import com.dataiku.dip.mec.AbstractModelEvaluation;
import com.dataiku.dip.mec.EvaluationSamplingService;
import com.dataiku.dip.mec.KernelsModelEvaluationStoresService;
import com.dataiku.dip.mec.ModelEvaluationStore;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitionFactory;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.partitioning.PartitioningUtils;
import com.dataiku.dip.plugins.IPluginsRegistryService;
import com.dataiku.dip.plugins.PluginConfigUtils;
import com.dataiku.dip.recipes.shaker.ShakerStandaloneResourceCollector;
import com.dataiku.dip.remoterun.RemoteRunsRegistry;
import com.dataiku.dip.rpc.TicketBasedIntercomAPIClient;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.impersonation.IImpersonationResolverService;
import com.dataiku.dip.security.model.PluginCredentialRequestService;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.security.tickets.FixedTicketService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.controllers.PluginsController;
import com.dataiku.dip.server.datasets.DatasetAccessService;
import com.dataiku.dip.server.datasets.DatasetReadAPIUtils;
import com.dataiku.dip.server.intercom.t.PermissionsIntercomController;
import com.dataiku.dip.server.services.DatasetStreamService;
import com.dataiku.dip.server.services.KernelGeneralSettingsService;
import com.dataiku.dip.server.services.ProjectsDAO;
import com.dataiku.dip.server.services.SQLQueryStreamService;
import com.dataiku.dip.server.services.SingleWriteTransactionTransactionService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.shaker.server.ShakerStreamService;
import com.dataiku.dip.spark.SparkJobExecEnv;
import com.dataiku.dip.streaming.endpoints.KernelStreamingEndpointService;
import com.dataiku.dip.streaming.endpoints.StreamingEndpointSimplePusher;
import com.dataiku.dip.streaming.endpoints.StreamingEndpointSimplePusherFactory;
import com.dataiku.dip.streaming.endpoints.model.StreamingEndpoint;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dip.variables.VariablesService;
import com.dataiku.dss.shadelib.org.apache.commons.compress.utils.IOUtils;
import com.dataiku.dss.shadelib.org.apache.http.HttpEntity;
import com.dataiku.dss.shadelibazure.com.azure.core.credential.AccessToken;
import com.dataiku.dss.shadelibazure.com.azure.core.credential.TokenRequestContext;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractJobKernelSession {
    @Autowired
    protected DatasetsDAO datasetsDAO;
    @Autowired
    private StreamingEndpointsDAO streamingEndpointsDAO;
    @Autowired
    private KernelStreamingEndpointService kernelStreamingEndpointService;
    @Autowired
    protected RecipesDAO recipesDAO;
    @Autowired
    private DatasetAccessService datasetAccessService;
    @Autowired
    protected DatasetWritingService datasetWritingService;
    @Autowired
    protected GeneralSettingsDAO generalSettingsDAO;
    @Autowired
    protected IBasicMeaningsService basicMeaningsService;
    @Autowired
    private KernelGeneralSettingsService kernelGeneralSettingsService;
    @Autowired
    private VariablesService variablesService;
    @Autowired
    private KernelsManagedFolderService kernelsManagedFolderService;
    @Autowired
    private MeaningsDAO meaningsDAO;
    @Autowired
    private IPluginsRegistryService pluginsRegistry;
    @Autowired
    private KernelsModelEvaluationStoresService kernelsModelEvaluationStoresService;
    @Autowired
    private EvaluationSamplingService evaluationSamplingService;
    @Autowired
    private WorkerService workerService;
    @Autowired
    private ShakerStreamService shakerSreamService;
    @Autowired
    private DatasetStreamService datasetStreamService;
    @Autowired
    private SQLQueryStreamService sqlQueryStreamService;
    @Autowired
    private ProjectsDAO projectsDAO;
    @Autowired
    private ConnectionsDAO connectionsDAO;
    @Autowired
    private PasswordEncryptionService cryptoService;
    @Autowired
    private IImpersonationResolverService impersonationResolverService;
    @Autowired
    protected SingleWriteTransactionTransactionService singleWTxService;
    private APITicketService.Ticket ticket;
    protected final AuthCtx authCtx;
    protected FixedTicketService ticketService;
    protected RWTransaction t;
    private final Set<String> cachedGrants = new HashSet<String>();
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.job.slave");

    public AbstractJobKernelSession(String jobTicketSecret, AuthCtx initiatorAuthCtx, String jobTicketDescription) throws IOException {
        this.ticketService = new FixedTicketService(initiatorAuthCtx, jobTicketSecret, jobTicketDescription);
        SpringUtils.getInstance().registerSingletonBean(APITicketService.class, (Object)this.ticketService);
        this.ticket = this.ticketService.getSingleTicket();
        this.authCtx = this.ticket.getViaAuthCtx();
    }

    public AuthCtx getAuthCtx() {
        return this.authCtx;
    }

    public void initWriteSession(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.datasetWritingService.initSession(this.t.getUser(), req, resp);
    }

    public void pushData(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.datasetWritingService.pushDataAtOnce(this.t.getUser(), req, resp);
    }

    public void waitSession(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.datasetWritingService.waitSession(this.t.getUser(), req, resp);
    }

    public void pushDataContinuous(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        this.datasetWritingService.pushDataContinuous(this.t.getUser(), req, resp);
    }

    public void checkpointContinuous(HttpServletRequest req) throws Exception {
        this.datasetWritingService.checkpointContinuous(this.t.getUser(), req);
    }

    public String getContinuousState(HttpServletRequest req) throws Exception {
        return this.datasetWritingService.getContinuousState(this.t.getUser(), req);
    }

    public void closeContinuous(HttpServletRequest req) throws Exception {
        this.datasetWritingService.closeContinuous(this.t.getUser(), req);
    }

    public DataframePreparationExecutor.LinkInfo initPreparationSession(DataframePreparationRequest request) throws Exception {
        TransactionContext.attach((TransactionRef)this.t);
        try {
            this.checkProjectPrivilege(request.contextProjectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        finally {
            TransactionContext.detach((TransactionRef)this.t);
        }
        return new DataframePreparationExecutor().initSession(this.authCtx, request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readData(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        Dataset dataset;
        String projectKey = req.getParameter("projectKey");
        String datasetName = req.getParameter("datasetName");
        String format = req.getParameter("format");
        String formatParams = req.getParameter("formatParams");
        String sampling = req.getParameter("sampling");
        String columns = req.getParameter("columns");
        String partitions = req.getParameter("partitions");
        String filterExpression = req.getParameter("filter");
        String readSessionId = req.getParameter("readSessionId");
        DatasetLocUtils.DatasetLoc loc = new DatasetLocUtils.DatasetLoc(projectKey, datasetName);
        this.checkDatasetReadPrivilege(loc, Privileges.DatasetLevelPrivilegeType.READ_DATA);
        TransactionContext.attach((TransactionRef)this.t);
        try {
            dataset = this.datasetAccessService.getMandatory(projectKey, datasetName);
        }
        finally {
            TransactionContext.detach((TransactionRef)this.t);
        }
        this.datasetStreamService.doStream(resp, this.authCtx, dataset, format, DatasetReadAPIUtils.formatParamsFromString(formatParams), DatasetReadAPIUtils.columnsListFromString(columns), partitions, filterExpression, DatasetReadAPIUtils.samplingParamFromString(sampling), readSessionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readPreparedData(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        String fullDatasetName = req.getParameter("fullDatasetName");
        String requestedOutputSchema = req.getParameter("requestedOutputSchema");
        String script = req.getParameter("script");
        String partitions = req.getParameter("partitions");
        String sampling = req.getParameter("sampling");
        String contextProjectKey = req.getParameter("contextProjectKey");
        String readSessionId = req.getParameter("readSessionId");
        DatasetLocUtils.DatasetLoc ds = DatasetLocUtils.resolveFull(fullDatasetName);
        Dataset dataset = null;
        TransactionContext.attach((TransactionRef)this.t);
        try {
            this.checkDatasetReadPrivilege(ds, Privileges.DatasetLevelPrivilegeType.READ_DATA);
            dataset = this.datasetAccessService.getMandatory(ds.getProjectKey(), ds.getName());
        }
        finally {
            TransactionContext.detach((TransactionRef)this.t);
        }
        this.datasetStreamService.streamPreparedDataset(resp, fullDatasetName, script, requestedOutputSchema, partitions, sampling, ds, dataset, this.authCtx, contextProjectKey, readSessionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readData2(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        Dataset dataset;
        String projectKey = req.getParameter("projectKey");
        String datasetName = req.getParameter("datasetName");
        String settings = req.getParameter("settings");
        DatasetLocUtils.DatasetLoc loc = new DatasetLocUtils.DatasetLoc(projectKey, datasetName);
        this.checkDatasetReadPrivilege(loc, Privileges.DatasetLevelPrivilegeType.READ_DATA);
        DatasetReadAPIUtils.DatasetStreamingRequestSettings reqSettings = (DatasetReadAPIUtils.DatasetStreamingRequestSettings)JSON.parse((String)settings, DatasetReadAPIUtils.DatasetStreamingRequestSettings.class);
        TransactionContext.attach((TransactionRef)this.t);
        try {
            dataset = this.datasetAccessService.getMandatory(projectKey, datasetName);
        }
        finally {
            TransactionContext.detach((TransactionRef)this.t);
        }
        this.datasetStreamService.doStream(resp, this.authCtx, dataset, reqSettings.format, reqSettings.formatParams, reqSettings.columns, reqSettings.partitions, reqSettings.filterExpression, reqSettings.sampling, reqSettings.readSessionId);
    }

    public void verifyDatasetRead(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        String readSessionId = req.getParameter("readSessionId");
        this.datasetStreamService.verifyRead(readSessionId);
        resp.setStatus(200);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SerializedDataset readConfig(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        String projectKey = req.getParameter("projectKey");
        String datasetName = req.getParameter("datasetName");
        DatasetLocUtils.DatasetLoc loc = new DatasetLocUtils.DatasetLoc(projectKey, datasetName);
        this.checkDatasetReadPrivilege(loc, Privileges.DatasetLevelPrivilegeType.READ_DATA);
        TransactionContext.attach((TransactionRef)this.t);
        try {
            SerializedDataset serializedDataset = (SerializedDataset)this.datasetsDAO.getMandatoryUnsafe(projectKey, datasetName);
            return serializedDataset;
        }
        finally {
            TransactionContext.detach((TransactionRef)this.t);
        }
    }

    public MeaningsDAO.MeaningsList listMeanings() throws IOException {
        MeaningsDAO.MeaningsList list = new MeaningsDAO.MeaningsList();
        TransactionContext.attach((TransactionRef)this.t);
        try {
            list.meanings.addAll(this.meaningsDAO.listUnsafe());
        }
        finally {
            TransactionContext.detach((TransactionRef)this.t);
        }
        return list;
    }

    public List<SerializedDataset> listDatasets(String projectKey) throws Exception {
        this.checkProjectPrivilege(projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        TransactionContext.attach((TransactionRef)this.t);
        try {
            List<SerializedDataset> list = this.datasetsDAO.listUnsafe(projectKey);
            return list;
        }
        finally {
            TransactionContext.detach((TransactionRef)this.t);
        }
    }

    /*
     * Exception decompiling
     */
    public List<String> listAccessibleProjectKeys() throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public SerializedProject getProject(String projectKey) throws Exception {
        TransactionContext.attach((TransactionRef)this.t);
        try {
            logger.info((Object)("Get project " + projectKey));
            this.checkProjectPrivilege(projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            SerializedProject serializedProject = this.projectsDAO.getMandatoryUnsafe(projectKey);
            return serializedProject;
        }
        finally {
            TransactionContext.detach((TransactionRef)this.t);
        }
    }

    public PluginsController.LibFolders getPluginLibFolder(String pluginId) {
        return new PluginsController.LibFolders(this.pluginsRegistry, pluginId);
    }

    public PluginSettingsResolver.ResolvedSettings getPluginSettings(String projectKey, List<ParamDesc> params, JsonObject elementConfig, String pluginId) throws Exception {
        PluginSettingsResolver.ResolvedSettings pluginSettings = new PluginSettingsResolver(this.authCtx, projectKey).getPluginSettings(params, elementConfig, pluginId);
        if (pluginSettings.pluginConfig != null && !pluginSettings.pluginConfig.entrySet().isEmpty()) {
            this.checkPluginPrivilege(pluginId, Privileges.PluginLevelPrivilegeType.ADMIN);
        }
        return pluginSettings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkPluginPrivilege(String pluginId, Privileges.PluginLevelPrivilegeType privilege) throws Exception {
        String grant = "plugin::" + privilege.toString() + "::" + pluginId;
        AbstractJobKernelSession abstractJobKernelSession = this;
        synchronized (abstractJobKernelSession) {
            if (this.cachedGrants.contains(grant)) {
                logger.info((Object)("Using cached grant: " + grant));
                return;
            }
        }
        logger.info((Object)("Trying to obtain grant: " + grant));
        APITicketService apiTicketService = (APITicketService)SpringUtils.getBean(APITicketService.class);
        try (APITicketService.TicketUsage tu = apiTicketService.getAndUseSingleTicket();
             TicketBasedIntercomAPIClient apiClient = AbstractJobKernelSession.backendIntercomAPIClient(tu);){
            PermissionsIntercomController.PermissionCheckResult result = (PermissionsIntercomController.PermissionCheckResult)apiClient.postFormToJSON("/dip/api/tintercom/permissions/has-plugin-privilege", PermissionsIntercomController.PermissionCheckResult.class, new Object[]{"pluginId", pluginId, "privilege", privilege.toString()});
            if (!result.ok) {
                throw new UnauthorizedException("Action on plugin forbidden", "plugin-action-denied");
            }
        }
        AbstractJobKernelSession abstractJobKernelSession2 = this;
        synchronized (abstractJobKernelSession2) {
            this.cachedGrants.add(grant);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSchema(String fullDatasetName, String schemaData, String dropAndRecreateStr, String origin) throws Exception {
        this.checkDatasetPrivilege(fullDatasetName, Privileges.DatasetLevelPrivilegeType.WRITE_SCHEMA);
        logger.info((Object)("Setting schema of dataset " + fullDatasetName));
        TransactionContext.attach((TransactionRef)this.t);
        try {
            boolean dropAndRecreate = StringUtils.isBlank((String)dropAndRecreateStr) ? false : Boolean.parseBoolean(dropAndRecreateStr);
            DatasetLocUtils.DatasetLoc loc = DatasetLocUtils.resolveFull(fullDatasetName);
            Schema parsed = (Schema)JSON.parse((String)schemaData, Schema.class);
            this.datasetWritingService.writeDatasetSchema(this.t.getUser(), loc, parsed, dropAndRecreate, origin);
            AbstractJobKernelSession.propagateSchemaToJekOrBackend(fullDatasetName, parsed);
        }
        finally {
            TransactionContext.detach((TransactionRef)this.t);
        }
    }

    public Schema getStreamingEndpointSchema(String streamingEndpointFullId) throws Exception {
        logger.info((Object)("Reading schema of streaming endpoint " + streamingEndpointFullId));
        TransactionContext.attach((TransactionRef)this.t);
        try {
            Schema schema = ((StreamingEndpoint)this.streamingEndpointsDAO.getMandatory((AnyLoc)AnyLoc.resolveFull((String)streamingEndpointFullId))).schema;
            return schema;
        }
        finally {
            TransactionContext.detach((TransactionRef)this.t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStreamingEndpointSchema(String streamingEndpointFullId, String schemaData) throws Exception {
        logger.info((Object)("Setting schema of streaming endpoint " + streamingEndpointFullId));
        TransactionContext.attach((TransactionRef)this.t);
        try {
            DatasetLocUtils.DatasetLoc loc = DatasetLocUtils.resolveFull(streamingEndpointFullId);
            Schema parsed = (Schema)JSON.parse((String)schemaData, Schema.class);
            this.datasetWritingService.writeStreamingEndpointSchema(this.t.getUser(), loc, parsed);
            AbstractJobKernelSession.propagateStreamingEndpointSchemaToBackend(streamingEndpointFullId, parsed);
        }
        finally {
            TransactionContext.detach((TransactionRef)this.t);
        }
    }

    public List<String> listManagedFolderPartitions(String projectKey, String lookup) throws Exception {
        this.checkProjectPrivilege(projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        TransactionContext.attach((TransactionRef)this.t);
        try {
            ArrayList<String> arrayList;
            block10: {
                ManagedFolder box = this.kernelsManagedFolderService.lookupMandatoryUnsafe(projectKey, lookup);
                ManagedFolderHandler handler = (ManagedFolderHandler)box.buildHandler(this.authCtx);
                try {
                    ArrayList<String> list = new ArrayList<String>();
                    for (Partition p : PartitioningUtils.sort(handler.listPartitions(), true)) {
                        list.add(p.id());
                    }
                    arrayList = list;
                    if (handler == null) break block10;
                }
                catch (Throwable throwable) {
                    if (handler != null) {
                        try {
                            handler.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                handler.close();
            }
            return arrayList;
        }
        finally {
            TransactionContext.detach((TransactionRef)this.t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearManagedFolderPartition(String projectKey, String lookup, String partition) throws Exception {
        block11: {
            this.checkProjectPrivilege(projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            TransactionContext.attach((TransactionRef)this.t);
            try {
                ManagedFolder box = this.kernelsManagedFolderService.lookupMandatoryUnsafe(projectKey, lookup);
                try (ManagedFolderHandler handler = (ManagedFolderHandler)box.buildHandler(this.authCtx);){
                    if (StringUtils.isBlank((String)partition)) {
                        handler.clear();
                        break block11;
                    }
                    if (box.isPartitioned()) {
                        Partition p = PartitionFactory.fromIdentifier(box.getPartitioningSchema(), partition);
                        handler.clearPartitions(Lists.newArrayList((Object[])new Partition[]{p}));
                        break block11;
                    }
                    throw ErrorContext.iae((String)"Can not specify a partition to delete on a non-partitioned folder");
                }
            }
            finally {
                TransactionContext.detach((TransactionRef)this.t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearManagedFolderPath(String projectKey, String lookup, String path) throws Exception {
        this.checkProjectPrivilege(projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
        TransactionContext.attach((TransactionRef)this.t);
        try {
            ManagedFolder box = this.kernelsManagedFolderService.lookupMandatoryUnsafe(projectKey, lookup);
            try (ManagedFolderHandler handler = (ManagedFolderHandler)box.buildHandler(this.authCtx);){
                handler.delete(path);
            }
        }
        finally {
            TransactionContext.detach((TransactionRef)this.t);
        }
    }

    public FSBrowsePath getManagedFolderPathDetails(String projectKey, String lookup, String path) throws Exception {
        this.checkProjectPrivilege(projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        TransactionContext.attach((TransactionRef)this.t);
        try {
            FSBrowsePath fSBrowsePath;
            block9: {
                ManagedFolder mf = this.kernelsManagedFolderService.lookupMandatoryUnsafe(projectKey, lookup);
                ManagedFolderHandler handler = (ManagedFolderHandler)mf.buildHandler(this.authCtx);
                try {
                    fSBrowsePath = handler.browse(path);
                    if (handler == null) break block9;
                }
                catch (Throwable throwable) {
                    if (handler != null) {
                        try {
                            handler.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                handler.close();
            }
            return fSBrowsePath;
        }
        finally {
            TransactionContext.detach((TransactionRef)this.t);
        }
    }

    public CodeBasedRecipeDatasetInfoHelper.LocationInfo getManagedFolderPathInfo(String projectKey, String lookup, String path) throws Exception {
        this.checkProjectPrivilege(projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        TransactionContext.attach((TransactionRef)this.t);
        try {
            CodeBasedRecipeDatasetInfoHelper.LocationInfo locationInfo;
            block9: {
                ManagedFolder mf = this.kernelsManagedFolderService.lookupMandatoryUnsafe(projectKey, lookup);
                ManagedFolderHandler handler = (ManagedFolderHandler)mf.buildHandler(this.authCtx);
                try {
                    locationInfo = CodeBasedRecipeDatasetInfoHelper.LocationInfo.makeInfoFromFSPath(CodeBasedRecipeDatasetInfoHelper.LocationInfoType.MANAGEDFOLDER, handler.getFile(path), "path", path, "projectKey", mf.projectKey, "id", mf.id, "name", mf.name, "absolutePath", handler.getAbsolutePath(path));
                    if (handler == null) break block9;
                }
                catch (Throwable throwable) {
                    if (handler != null) {
                        try {
                            handler.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                handler.close();
            }
            return locationInfo;
        }
        finally {
            TransactionContext.detach((TransactionRef)this.t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadManagedFolderPath(HttpServletResponse resp, String projectKey, String lookup, String path) throws Exception {
        ManagedFolderHandler handler;
        this.checkProjectPrivilege(projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        TransactionContext.attach((TransactionRef)this.t);
        try {
            ManagedFolder mf = this.kernelsManagedFolderService.lookupMandatoryUnsafe(projectKey, lookup);
            handler = (ManagedFolderHandler)mf.buildHandler(this.authCtx);
        }
        finally {
            TransactionContext.detach((TransactionRef)this.t);
        }
        try {
            EnrichedInputStream eis = handler.getInputStream(path);
            this.kernelsManagedFolderService.sendFileAsUrl(resp, eis);
        }
        finally {
            handler.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uploadManagedFolderPath(String projectKey, String lookup, String path, InputStream is) throws Exception {
        ManagedFolderHandler handler;
        this.checkProjectPrivilege(projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
        TransactionContext.attach((TransactionRef)this.t);
        try {
            ManagedFolder mf = this.kernelsManagedFolderService.lookupMandatoryUnsafe(projectKey, lookup);
            handler = (ManagedFolderHandler)mf.buildHandler(this.authCtx);
        }
        finally {
            TransactionContext.detach((TransactionRef)this.t);
        }
        try (OutputStream os = handler.getOutputStream(path);){
            IOUtils.copy((InputStream)is, (OutputStream)os);
        }
        finally {
            handler.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearDatasetData(String projectKey, String datasetName) throws Exception {
        AnyLoc datasetLoc = DatasetLocUtils.DatasetLoc.resolveSmart(projectKey, datasetName);
        this.checkDatasetPrivilege(datasetLoc.getFullName(), Privileges.DatasetLevelPrivilegeType.WRITE_DATA);
        logger.info((Object)("Clear dataset " + datasetLoc.getFullName()));
        TransactionContext.attach((TransactionRef)this.t);
        try {
            Dataset dataset = this.datasetAccessService.getMandatory(projectKey, datasetName);
            try (DatasetHandler dh = DatasetHandlerFactory.build(this.authCtx, dataset);){
                dh.clearAllDataAndStructure();
            }
        }
        finally {
            TransactionContext.detach((TransactionRef)this.t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearDatasetPartition(String projectKey, String datasetName, String partition) throws Exception {
        AnyLoc datasetLoc = DatasetLocUtils.DatasetLoc.resolveSmart(projectKey, datasetName);
        this.checkDatasetPrivilege(datasetLoc.getFullName(), Privileges.DatasetLevelPrivilegeType.WRITE_DATA);
        logger.info((Object)("Clear dataset " + datasetLoc.getFullName()));
        TransactionContext.attach((TransactionRef)this.t);
        try {
            Dataset dataset = this.datasetAccessService.getMandatory(projectKey, datasetName);
            try (DatasetHandler dh = DatasetHandlerFactory.build(this.authCtx, dataset);){
                Partition p = PartitionFactory.fromIdentifier(dataset.getPartitioningSchema(), partition);
                dh.clearPartitions(Lists.newArrayList((Object[])new Partition[]{p}));
            }
        }
        finally {
            TransactionContext.detach((TransactionRef)this.t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareSqlTableForWrite(String projectKey, String datasetName, String partition, String writeMode, InfoMessage.InfoMessages messages) throws Exception {
        AnyLoc datasetLoc = DatasetLocUtils.DatasetLoc.resolveSmart(projectKey, datasetName);
        this.checkDatasetPrivilege(datasetLoc.getFullName(), Privileges.DatasetLevelPrivilegeType.WRITE_DATA);
        logger.info((Object)("Prepare SQL table for write " + datasetLoc.getFullName()));
        TransactionContext.attach((TransactionRef)this.t);
        try {
            Dataset dataset = this.datasetAccessService.getMandatory(projectKey, datasetName);
            try (DatasetHandler datasetHandler = DatasetHandlerFactory.build(this.authCtx, dataset);){
                if (datasetHandler instanceof AbstractSQLTableDatasetHandler) {
                    PartitioningScheme partitioningSchema = dataset.getPartitioningSchema();
                    Partition targetPartition = partitioningSchema.isPartitioned() ? PartitionFactory.fromIdentifier(partitioningSchema, partition) : null;
                    ((AbstractSQLTableDatasetHandler)datasetHandler).prepareSqlTableForWrite(this.authCtx, targetPartition, Output.WriteMode.valueOf((String)writeMode), messages);
                } else {
                    logger.warnV("Dataset %s not a SQL-table based dataset", new Object[]{datasetName});
                }
            }
        }
        finally {
            TransactionContext.detach((TransactionRef)this.t);
        }
    }

    public String expandSQLQueryForPartition(String projectKey, String datasetName, String partition) throws Exception {
        AnyLoc datasetLoc = DatasetLocUtils.DatasetLoc.resolveSmart(projectKey, datasetName);
        this.checkDatasetPrivilege(datasetLoc.getFullName(), Privileges.DatasetLevelPrivilegeType.READ_DATA);
        logger.info((Object)("Expanding SQL query for partition " + datasetLoc.getFullName() + ": " + partition));
        TransactionContext.attach((TransactionRef)this.t);
        try {
            Dataset dataset = this.datasetAccessService.getMandatory(projectKey, datasetName);
            try (DatasetHandler datasetHandler = DatasetHandlerFactory.build(this.authCtx, dataset);){
                if (datasetHandler instanceof AbstractSQLQueryDatasetHandler) {
                    Partition p = PartitionFactory.fromIdentifier(dataset.getPartitioningSchema(), partition);
                    String string = ((AbstractSQLQueryDatasetHandler)datasetHandler).expandQueryForPartition(p);
                    return string;
                }
                throw new IllegalArgumentException(String.format("Dataset %s not a SQL-query based dataset", datasetName));
            }
        }
        finally {
            TransactionContext.detach((TransactionRef)this.t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StreamingEndpoint getStreamingEndpointConfig(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        String projectKey = req.getParameter("projectKey");
        String endpointName = req.getParameter("name");
        AnyLoc loc = new AnyLoc(projectKey, endpointName);
        this.checkDatasetReadPrivilege(loc, Privileges.DatasetLevelPrivilegeType.READ_DATA);
        TransactionContext.attach((TransactionRef)this.t);
        try {
            StreamingEndpoint streamingEndpoint = (StreamingEndpoint)this.streamingEndpointsDAO.getMandatoryUnsafe(projectKey, endpointName);
            return streamingEndpoint;
        }
        finally {
            TransactionContext.detach((TransactionRef)this.t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Schema getSchema(String fullDatasetName) throws Exception {
        this.checkDatasetReadPrivilege(fullDatasetName, Privileges.DatasetLevelPrivilegeType.READ_SCHEMA);
        logger.info((Object)("Reading schema of dataset " + fullDatasetName));
        TransactionContext.attach((TransactionRef)this.t);
        try {
            SerializedDataset dataset = (SerializedDataset)this.datasetsDAO.getMandatory(DatasetLocUtils.resolveFull(fullDatasetName));
            Schema schema = dataset.getSchema();
            return schema;
        }
        finally {
            TransactionContext.detach((TransactionRef)this.t);
        }
    }

    public SerializedDataset getDatasetSettings(String fullDatasetName) throws Exception {
        this.checkDatasetReadPrivilege(fullDatasetName, Privileges.DatasetLevelPrivilegeType.READ_SCHEMA);
        logger.info((Object)("Reading settings of dataset " + fullDatasetName));
        TransactionContext.attach((TransactionRef)this.t);
        try {
            SerializedDataset serializedDataset = (SerializedDataset)this.datasetsDAO.getMandatoryUnsafe(DatasetLocUtils.resolveFull(fullDatasetName));
            return serializedDataset;
        }
        finally {
            TransactionContext.detach((TransactionRef)this.t);
        }
    }

    public List<String> listPartitions(String fullDatasetName) throws Exception {
        this.checkDatasetReadPrivilege(fullDatasetName, Privileges.DatasetLevelPrivilegeType.READ_DATA);
        logger.info((Object)("Listing partitions of dataset " + fullDatasetName));
        TransactionContext.attach((TransactionRef)this.t);
        try {
            ArrayList<String> arrayList;
            block10: {
                Dataset dataset = this.datasetAccessService.getMandatory(DatasetLocUtils.resolveFull(fullDatasetName));
                DatasetHandler dh = DatasetHandlerFactory.build(this.authCtx, dataset);
                try {
                    ArrayList<String> list = new ArrayList<String>();
                    for (Partition p : PartitioningUtils.sort(dh.listPartitions(), true)) {
                        list.add(p.id());
                    }
                    arrayList = list;
                    if (dh == null) break block10;
                }
                catch (Throwable throwable) {
                    if (dh != null) {
                        try {
                            dh.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                dh.close();
            }
            return arrayList;
        }
        finally {
            TransactionContext.detach((TransactionRef)this.t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CodeBasedRecipeDatasetInfoHelper.LocationInfo getLocationInfo(String projectKey, String datasetName, boolean sensitiveInfo) throws Exception {
        Dataset dataset;
        this.checkDatasetReadPrivilege(new DatasetLocUtils.DatasetLoc(projectKey, datasetName), Privileges.DatasetLevelPrivilegeType.READ_METADATA);
        logger.info((Object)("Getting location info of dataset " + datasetName + " in project " + projectKey));
        TransactionContext.attach((TransactionRef)this.t);
        try {
            dataset = this.datasetAccessService.getOrNull(projectKey, datasetName);
        }
        finally {
            TransactionContext.detach((TransactionRef)this.t);
        }
        return new CodeBasedRecipeDatasetInfoHelper().getDatasetLocationInfo_NT(this.authCtx, dataset, sensitiveInfo);
    }

    public KernelGeneralSettingsService.FeatureConfig getDSSSettings() throws IOException {
        logger.info((Object)"Getting feature config");
        TransactionContext.attach((TransactionRef)this.t);
        try {
            KernelGeneralSettingsService.FeatureConfig featureConfig = this.kernelGeneralSettingsService.getFeatureConfig();
            return featureConfig;
        }
        finally {
            TransactionContext.detach((TransactionRef)this.t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getResolvedProjectVariables(String projectKey, boolean typed) throws Exception {
        this.checkProjectPrivilege(projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        logger.info((Object)("Getting resolved variables for project " + projectKey));
        TransactionContext.attach((TransactionRef)this.t);
        try {
            Object o = null;
            o = typed ? this.variablesService.getForProject(projectKey).getAllVariablesTyped() : this.variablesService.getForProject(projectKey).getAllVariables();
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("getResolvedProjectVariables, result is: " + JSON.json((Object)o)));
            }
            Object object = o;
            return object;
        }
        finally {
            TransactionContext.detach((TransactionRef)this.t);
        }
    }

    public Object getContextProjectVariables(String projectKey) throws Exception {
        this.checkProjectPrivilege(projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        logger.info((Object)("Getting resolved variables for project " + projectKey));
        TransactionContext.attach((TransactionRef)this.t);
        try {
            VariablesContext variablesContext = this.variablesService.getForProject(projectKey);
            return variablesContext;
        }
        finally {
            TransactionContext.detach((TransactionRef)this.t);
        }
    }

    public VariablesService.ProjectVariables getUnresolvedProjectVariables(String projectKey) throws Exception {
        this.checkProjectPrivilege(projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        logger.info((Object)("Getting variables for project " + projectKey));
        TransactionContext.attach((TransactionRef)this.t);
        try {
            VariablesService.ProjectVariables projectVariables = VariablesService.readLocalUnresolvedProjectVariables(projectKey, (Transaction)this.t);
            return projectVariables;
        }
        finally {
            TransactionContext.detach((TransactionRef)this.t);
        }
    }

    public void setProjectVariables(String projectKey, VariablesService.ProjectVariables pv) throws Exception {
        this.checkProjectPrivilege(projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
        logger.info((Object)("Setting variables for project " + projectKey));
        TransactionContext.attach((TransactionRef)this.t);
        try {
            VariablesService.writeLocalProjectVariables(projectKey, this.t, pv, false);
            AbstractJobKernelSession.propagateProjectVariablesToBackend(projectKey, pv);
        }
        finally {
            TransactionContext.detach((TransactionRef)this.t);
        }
    }

    public String getManagedFolderAccess(String projectKey, String lookup, boolean ignoreFlow) throws Exception {
        this.checkProjectPrivilege(projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        logger.info((Object)("Getting access for managed folder" + lookup + " in " + projectKey + " (ignore flow=" + ignoreFlow + ")"));
        TransactionContext.attach((TransactionRef)this.t);
        try {
            ManagedFolder mf = this.kernelsManagedFolderService.lookupMandatoryUnsafe(projectKey, lookup);
            try (ManagedFolderHandler fh = (ManagedFolderHandler)mf.buildHandler(this.authCtx);){
                FSProvider provider;
                if (ignoreFlow && this.impersonationResolverService.isEnabled()) {
                    fh.grantFullACLs();
                }
                if ((provider = fh.getProvider()) instanceof LocalFSProvider) {
                    String string = ((LocalFSProvider)provider).getRoot();
                    return string;
                }
                throw new CodedException((InfoMessage.MessageCode)ManagedFolderCodes.ERR_FOLDER_INVALID_CONFIG, "Direct access is only available for folders on a filesystem connection");
            }
        }
        finally {
            TransactionContext.detach((TransactionRef)this.t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CodeBasedRecipeDatasetInfoHelper.LocationInfo getManagedFolderInfo(String projectKey, String lookup, boolean sensitiveInfo) throws Exception {
        ManagedFolder mf;
        this.checkProjectPrivilege(projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        logger.info((Object)("Getting infos for managed folder" + lookup + " in " + projectKey));
        TransactionContext.attach((TransactionRef)this.t);
        try {
            mf = this.kernelsManagedFolderService.lookupMandatoryUnsafe(projectKey, lookup);
        }
        finally {
            TransactionContext.detach((TransactionRef)this.t);
        }
        return CodeBasedRecipeDatasetInfoHelper.getManagedFolderLocationInfo_NT(this.authCtx, mf, sensitiveInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CodeBasedRecipeDatasetInfoHelper.LocationInfo getStreamingEndpointInfo(String projectKey, String id, boolean sensitiveInfo) throws Exception {
        StreamingEndpoint se;
        this.checkProjectPrivilege(projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        logger.info((Object)("Getting infos for streaming endpoint" + id + " in " + projectKey));
        TransactionContext.attach((TransactionRef)this.t);
        try {
            se = (StreamingEndpoint)this.streamingEndpointsDAO.getMandatoryUnsafe(projectKey, id);
        }
        finally {
            TransactionContext.detach((TransactionRef)this.t);
        }
        return new CodeBasedRecipeDatasetInfoHelper().getStreamingEndpointLocationInfo_NT(this.authCtx, se, sensitiveInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CodeBasedRecipeDatasetInfoHelper.LocationInfo getManagedFolderPartitionInfo(String projectKey, String lookup, String partition) throws Exception {
        ManagedFolder mf;
        this.checkProjectPrivilege(projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        logger.info((Object)("Getting infos for managed folder" + lookup + " in " + projectKey));
        TransactionContext.attach((TransactionRef)this.t);
        try {
            mf = this.kernelsManagedFolderService.lookupMandatoryUnsafe(projectKey, lookup);
        }
        finally {
            TransactionContext.detach((TransactionRef)this.t);
        }
        return this.kernelsManagedFolderService.getPartitionPaths_NT(this.authCtx, mf, partition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CodeBasedRecipeDatasetInfoHelper.LocationInfo getModelEvaluationStoreInfo(String projectKey, String lookup, boolean sensitiveInfo) throws Exception {
        ModelEvaluationStore mes;
        this.checkProjectPrivilege(projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        logger.info((Object)("Getting infos for model evaluation store " + lookup + " in " + projectKey));
        TransactionContext.attach((TransactionRef)this.t);
        try {
            mes = this.kernelsModelEvaluationStoresService.lookupMandatoryUnsafe(projectKey, lookup);
        }
        finally {
            TransactionContext.detach((TransactionRef)this.t);
        }
        return CodeBasedRecipeDatasetInfoHelper.getModelEvaluationStoreLocationInfo_NT(mes, sensitiveInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CodeBasedRecipeDatasetInfoHelper.DatasetFilesInfo getFilesInfo(String projectKey, String datasetName, List<String> partitions) throws Exception {
        this.checkDatasetReadPrivilege(new DatasetLocUtils.DatasetLoc(projectKey, datasetName), Privileges.DatasetLevelPrivilegeType.READ_METADATA);
        logger.info((Object)("Getting location info of dataset " + datasetName + " in project " + projectKey));
        TransactionContext.attach((TransactionRef)this.t);
        try {
            Dataset dataset = this.datasetAccessService.getOrNull(projectKey, datasetName);
            CodeBasedRecipeDatasetInfoHelper.DatasetFilesInfo datasetFilesInfo = CodeBasedRecipeDatasetInfoHelper.getDatasetFilesInfo(this.authCtx, dataset, partitions);
            return datasetFilesInfo;
        }
        finally {
            TransactionContext.detach((TransactionRef)this.t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectCompleteMetadata getMetadata(String fullDatasetName) throws Exception {
        this.checkDatasetReadPrivilege(fullDatasetName, Privileges.DatasetLevelPrivilegeType.READ_METADATA);
        logger.info((Object)("Reading metadata of dataset " + fullDatasetName));
        TransactionContext.attach((TransactionRef)this.t);
        try {
            Dataset dataset = this.datasetAccessService.getMandatory(DatasetLocUtils.resolveFull(fullDatasetName));
            ObjectCompleteMetadata objectCompleteMetadata = DatasetInspector.getMetadata(dataset);
            return objectCompleteMetadata;
        }
        finally {
            TransactionContext.detach((TransactionRef)this.t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMetadata(String fullDatasetName, String metadata) throws Exception {
        this.checkDatasetPrivilege(fullDatasetName, Privileges.DatasetLevelPrivilegeType.WRITE_METADATA);
        logger.info((Object)("Setting metadata of dataset " + fullDatasetName));
        TransactionContext.attach((TransactionRef)this.t);
        try {
            DatasetLocUtils.DatasetLoc loc = DatasetLocUtils.resolveFull(fullDatasetName);
            ObjectCompleteMetadata parsed = (ObjectCompleteMetadata)JSON.parse((String)metadata, ObjectCompleteMetadata.class);
            this.datasetWritingService.writeDatasetMetadata(this.t.getUser(), loc, parsed);
            this.propagateMetadataToBackend(fullDatasetName, parsed);
        }
        finally {
            TransactionContext.detach((TransactionRef)this.t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AbstractModelEvaluation> getModelEvaluationStoreRuns(String projectKey, String id) throws Exception {
        this.checkProjectPrivilege(projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        logger.info((Object)("List runs for model evaluation store " + projectKey + "." + id));
        TransactionContext.attach((TransactionRef)this.t);
        try {
            ModelEvaluationStore mes = this.kernelsModelEvaluationStoresService.getMandatoryUnsafe(projectKey, id);
            List<AbstractModelEvaluation> list = this.kernelsModelEvaluationStoresService.listEvaluations(mes);
            return list;
        }
        finally {
            TransactionContext.detach((TransactionRef)this.t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Schema getModelEvaluationStoreSampleSchema(String projectKey, String id, String evaluationId) throws Exception {
        this.checkProjectPrivilege(projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        logger.info((Object)("List runs for model evaluation store " + projectKey + "." + id));
        TransactionContext.attach((TransactionRef)this.t);
        try {
            ModelEvaluationStore mes = this.kernelsModelEvaluationStoresService.getMandatoryUnsafe(projectKey, id);
            Schema schema = this.evaluationSamplingService.getSampleSchema(mes, evaluationId);
            return schema;
        }
        finally {
            TransactionContext.detach((TransactionRef)this.t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getModelEvaluationStoreSample(String projectKey, String id, String evaluationId, String script, String requestedOutputSchema, String contextProjectKey, HttpServletResponse resp) throws Exception {
        this.checkProjectPrivilege(projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        logger.info((Object)("Getting sample for model evaluation store " + projectKey + "." + id + " evaluationId=" + evaluationId));
        TransactionContext.attach((TransactionRef)this.t);
        try {
            this.evaluationSamplingService.streamSample(this.getAuthCtx(), projectKey, new DatasetLocUtils.DatasetLoc(projectKey, id), evaluationId, script, requestedOutputSchema, contextProjectKey, resp);
        }
        finally {
            TransactionContext.detach((TransactionRef)this.t);
        }
    }

    public boolean authenticates(String receivedApiKey) {
        if (StringUtils.isBlank((String)receivedApiKey)) {
            return false;
        }
        if (this.ticket == null) {
            return false;
        }
        return receivedApiKey.equals(this.ticket.getSecret());
    }

    public RWTransaction getTransactionRef() {
        return this.t;
    }

    public void close() {
        if (this.ticket != null) {
            try {
                this.ticketService.close();
                SpringUtils.getInstance().unregisterSingletonBean(APITicketService.class);
            }
            catch (Exception ex) {
                logger.warn((Object)"Failed to unregister the API ticket service");
            }
            this.ticketService = null;
            this.ticket = null;
        }
        if (this.t != null) {
            this.t.close();
            this.t = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkDatasetPrivilege(String datasetFullName, Privileges.DatasetLevelPrivilegeType privilege) throws Exception {
        String grant = "dataset::" + privilege.toString() + "::" + datasetFullName;
        AbstractJobKernelSession abstractJobKernelSession = this;
        synchronized (abstractJobKernelSession) {
            if (this.cachedGrants.contains(grant)) {
                logger.info((Object)("Using cached grant: " + grant));
                return;
            }
        }
        logger.info((Object)("Trying to obtain grant: " + grant));
        APITicketService apiTicketService = (APITicketService)SpringUtils.getBean(APITicketService.class);
        try (APITicketService.TicketUsage tu = apiTicketService.getAndUseSingleTicket();
             TicketBasedIntercomAPIClient apiClient = AbstractJobKernelSession.backendIntercomAPIClient(tu);){
            apiClient.postFormToJSON("/dip/api/tintercom/permissions/check-dataset-privilege", Void.class, new Object[]{"datasetFullName", datasetFullName, "privilege", privilege.toString()});
        }
        AbstractJobKernelSession abstractJobKernelSession2 = this;
        synchronized (abstractJobKernelSession2) {
            this.cachedGrants.add(grant);
        }
    }

    protected void checkDatasetReadPrivilege(AnyLoc loc, Privileges.DatasetLevelPrivilegeType privilege) throws Exception {
        this.checkDatasetReadPrivilege(loc.getFullName(), privilege);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkDatasetReadPrivilege(String datasetFullName, Privileges.DatasetLevelPrivilegeType privilege) throws Exception {
        String grant = "datasetread::" + privilege.toString() + "::" + datasetFullName;
        AbstractJobKernelSession abstractJobKernelSession = this;
        synchronized (abstractJobKernelSession) {
            if (this.cachedGrants.contains(grant)) {
                logger.info((Object)("Using cached grant: " + grant));
                return;
            }
        }
        logger.info((Object)("Trying to obtain grant: " + grant));
        APITicketService apiTicketService = (APITicketService)SpringUtils.getBean(APITicketService.class);
        try (APITicketService.TicketUsage tu = apiTicketService.getAndUseSingleTicket();
             TicketBasedIntercomAPIClient apiClient = AbstractJobKernelSession.backendIntercomAPIClient(tu);){
            apiClient.postFormToJSON("/dip/api/tintercom/permissions/check-dataset-read-privilege", Void.class, new Object[]{"datasetFullName", datasetFullName, "privilege", privilege.toString()});
        }
        AbstractJobKernelSession abstractJobKernelSession2 = this;
        synchronized (abstractJobKernelSession2) {
            this.cachedGrants.add(grant);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkTaggableObjectReadUsePrivilege(TaggableObjectsService.TaggableObjectRef taggableObjectRef, String contextProjectKey) throws Exception {
        String grant = "objectreaduse::" + taggableObjectRef.getLoc().getFullName() + "::" + contextProjectKey;
        AbstractJobKernelSession abstractJobKernelSession = this;
        synchronized (abstractJobKernelSession) {
            if (this.cachedGrants.contains(grant)) {
                logger.info((Object)("Using cached grant: " + grant));
                return;
            }
        }
        logger.info((Object)("Trying to obtain grant: " + grant));
        APITicketService apiTicketService = (APITicketService)SpringUtils.getBean(APITicketService.class);
        try (APITicketService.TicketUsage tu = apiTicketService.getAndUseSingleTicket();
             TicketBasedIntercomAPIClient apiClient = AbstractJobKernelSession.backendIntercomAPIClient(tu);){
            apiClient.postFormToJSON("/dip/api/tintercom/permissions/check-taggable-object-read-use-privilege", Void.class, new Object[]{"taggableObjectRef", taggableObjectRef, "contextProjectKey", contextProjectKey});
        }
        AbstractJobKernelSession abstractJobKernelSession2 = this;
        synchronized (abstractJobKernelSession2) {
            this.cachedGrants.add(grant);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkProjectPrivilege(String projectKey, Privileges.ProjectLevelPrivilegeType privilege) throws Exception {
        String grant = "project::" + privilege.toString() + "::" + projectKey;
        AbstractJobKernelSession abstractJobKernelSession = this;
        synchronized (abstractJobKernelSession) {
            if (this.cachedGrants.contains(grant)) {
                logger.info((Object)("Using cached grant: " + grant));
                return;
            }
        }
        logger.info((Object)("Trying to obtain grant: " + grant));
        APITicketService apiTicketService = (APITicketService)SpringUtils.getBean(APITicketService.class);
        try (APITicketService.TicketUsage tu = apiTicketService.getAndUseSingleTicket();
             TicketBasedIntercomAPIClient apiClient = AbstractJobKernelSession.backendIntercomAPIClient(tu);){
            apiClient.postFormToJSON("/dip/api/tintercom/permissions/check-project-privilege", Void.class, new Object[]{"projectKey", projectKey, "privilege", privilege.toString()});
        }
        AbstractJobKernelSession abstractJobKernelSession2 = this;
        synchronized (abstractJobKernelSession2) {
            this.cachedGrants.add(grant);
        }
    }

    private static void propagateProjectVariablesToBackend(String projectKey, VariablesService.ProjectVariables pv) throws Exception {
        logger.info((Object)"Propagating new project variables to backend");
        APITicketService apiTicketService = (APITicketService)SpringUtils.getBean(APITicketService.class);
        try (APITicketService.TicketUsage tu = apiTicketService.getAndUseSingleTicket();
             TicketBasedIntercomAPIClient apiClient = AbstractJobKernelSession.backendIntercomAPIClient(tu);){
            HttpEntity entity = JSON.toHttpEntity((Object)pv);
            String url = "/dip/api/tintercom/variables/set-for-project?projectKey=" + projectKey;
            apiClient.postAnyToJSON(url, Void.class, entity);
        }
    }

    public static void propagateSchemaToJekOrBackend(String fullName, Schema newSchema) throws Exception {
        APITicketService ticketService = (APITicketService)SpringUtils.getBean(APITicketService.class);
        try (APITicketService.TicketUsage tu = ticketService.getAndUseSingleTicket();){
            String url;
            Supplier<TicketBasedIntercomAPIClient> apiClientSupplier;
            if (ApplicationConfigurator.getProcessType() == MainLoggingConfigurator.ProcessType.CDE) {
                logger.info((Object)("Propagating new schema of " + fullName + " to jek"));
                apiClientSupplier = () -> CDEProcessUtils.newIntercomAPIClient();
                url = "/tintercom/datasets/set-schema";
            } else {
                logger.info((Object)("Propagating new schema of " + fullName + " to backend"));
                apiClientSupplier = () -> AbstractJobKernelSession.backendIntercomAPIClient(tu);
                url = "/dip/api/tintercom/datasets/set-schema";
            }
            try (TicketBasedIntercomAPIClient apiClient = apiClientSupplier.get();){
                apiClient.postFormToJSON(url, Void.class, new Object[]{"fullDatasetName", fullName, "schemaData", JSON.json((Object)newSchema), "dropAndCreate", "false"});
            }
        }
    }

    private void propagateMetadataToBackend(String fullName, ObjectCompleteMetadata newMeta) throws Exception {
        try (APITicketService.TicketUsage tu = this.ticketService.getAndUseSingleTicket();
             TicketBasedIntercomAPIClient apiClient = AbstractJobKernelSession.backendIntercomAPIClient(tu);){
            apiClient.postFormToStringV("/dip/api/tintercom/datasets/write-metadata", new Object[]{"fullDatasetName", fullName, "metadata", JSON.json((Object)newMeta)});
        }
    }

    public static void propagateStreamingEndpointSchemaToBackend(String fullName, Schema newSchema) throws Exception {
        logger.info((Object)("Propagating new schema of " + fullName + " to backend"));
        APITicketService ticketService = (APITicketService)SpringUtils.getBean(APITicketService.class);
        try (APITicketService.TicketUsage tu = ticketService.getAndUseSingleTicket();
             TicketBasedIntercomAPIClient apiClient = AbstractJobKernelSession.backendIntercomAPIClient(tu);){
            apiClient.postFormToJSON("/dip/api/tintercom/streaming-endpoints/set-schema", Void.class, new Object[]{"streamingEndpointFullId", fullName, "schemaData", JSON.json((Object)newSchema)});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void streamEndpointToHttp(String projectKey, String name, KernelStreamingEndpointService.StreamingEndpointStreamingRequestSettings settings, HttpServletResponse resp) throws IOException, Exception {
        StreamingEndpointSimplePusher driver;
        StreamingEndpoint se;
        TransactionContext.attach((TransactionRef)this.t);
        try {
            se = (StreamingEndpoint)this.streamingEndpointsDAO.getMandatoryUnsafe(projectKey, name);
            driver = new StreamingEndpointSimplePusherFactory().build(this.authCtx, se, false);
        }
        finally {
            TransactionContext.detach((TransactionRef)this.t);
        }
        this.kernelStreamingEndpointService.streamEndpointToHttp(resp, settings, se, driver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void collectShakerResources(HttpServletResponse resp, String projectKey, String recipeName) throws IOException {
        TransactionContext.attach((TransactionRef)this.t);
        try {
            ShakerStandaloneResourceCollector collector = new ShakerStandaloneResourceCollector(this.authCtx, projectKey, recipeName);
            try (AutoDelete tmpDir = collector.collectResources();){
                resp.setContentType("application/zip");
                resp.setHeader("Content-Disposition", "attachment; filename=\"" + recipeName + ".zip\"");
                resp.setStatus(200);
                ZipUnzipDir.zipDirectoryToStream((File)tmpDir, new BufferedOutputStream((OutputStream)resp.getOutputStream()));
            }
            catch (Exception e) {
                logger.error((Object)"Failed to gather resources for shaker", (Throwable)e);
                resp.setStatus(204);
                resp.getWriter().write("Failed to gather resources for shaker: " + ExceptionUtils.getMessageWithCauses((Throwable)e));
            }
        }
        finally {
            TransactionContext.detach((TransactionRef)this.t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLQueryStreamService.SQLStreamingSessionInfo startStreamingSQLQuery(String connectionOrDatasetName, boolean findConnectionFromDataset, String projectKey, String dbType, String query, String preQueries, String postQueries, String scriptSteps, String scriptInputSchema, String scriptOutputSchema, String scriptReportLocation, String extraConf, AbstractSQLDatasetHandler.ReadTemporalMode datetimenotzReadMode, AbstractSQLDatasetHandler.ReadTemporalMode dateonlyReadMode) throws Exception {
        AbstractSQLConnection connection;
        TransactionContext.attach((TransactionRef)this.t);
        try {
            connection = this.sqlQueryStreamService.getConnectionForStreaming(this.authCtx, connectionOrDatasetName, findConnectionFromDataset, dbType, this.datasetsDAO);
        }
        finally {
            TransactionContext.detach((TransactionRef)this.t);
        }
        try (APITicketService.TicketUsage tu = this.ticketService.getAndUseSingleTicket();
             TicketBasedIntercomAPIClient apiClient = TicketBasedIntercomAPIClient.forLocalHost(tu.getTicket().getSecret());){
            apiClient.postFormToJSON("/dip/api/tintercom/permissions/check-sql-connection-direct-use-policy-hook", Void.class, new Object[]{"projectKey", projectKey, "connection", connection.name});
        }
        catch (DKUSecurityException | IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DKUSecurityException("Could not close ticket usage for permission check call", (Throwable)e);
        }
        return this.sqlQueryStreamService.startStreamingSQLQuery(connection, query, preQueries, postQueries, extraConf, scriptSteps, scriptInputSchema, scriptOutputSchema, scriptReportLocation, this.authCtx, datetimenotzReadMode, dateonlyReadMode, projectKey);
    }

    public void streamSQLQuery(HttpServletResponse resp, String queryId, String format, String formatParams) throws Exception {
        DatasetReadAPIUtils.FormatDef formatDef = DatasetReadAPIUtils.getFormatDef(format, DatasetReadAPIUtils.formatParamsFromString(formatParams));
        this.sqlQueryStreamService.streamSQLQuery(resp, this.authCtx, queryId, formatDef);
    }

    public void verifySQLQuery(String queryId) throws Exception {
        this.sqlQueryStreamService.verifySQLQuery(queryId);
    }

    public WorkerInfos requestWorker(String workerPoolId, String workerId) throws IOException, DKUSecurityException, CodedException {
        return this.workerService.getWorkerPool(this.authCtx, workerPoolId).requestWorker(workerId);
    }

    public void releaseWorker(String workerPoolId, String workerId) throws DKUSecurityException {
        this.workerService.getWorkerPool(this.authCtx, workerPoolId).releaseWorker(workerId);
    }

    private static TicketBasedIntercomAPIClient backendIntercomAPIClient(APITicketService.TicketUsage tu) {
        int backendPort = Integer.parseInt(System.getenv("DKU_BACKEND_PORT"));
        return new TicketBasedIntercomAPIClient("http://127.0.0.1:" + backendPort, null, tu.getTicket().getSecret());
    }

    public void ensureCDEOrigin(String executionId, String executionSecretId) {
        RemoteRunsRegistry.Execution execution = RemoteRunsRegistry.get(executionId);
        if (StringUtils.isBlank((String)executionId)) {
            throw new DSSInternalErrorException("Missing execution context");
        }
        if (execution.type != RemoteRunsRegistry.ExecutionType.CDE) {
            throw new SecurityException("Wrong execution context type: " + String.valueOf((Object)execution.type));
        }
        if (!StringUtils.equals((String)executionSecretId, (String)execution.secretId)) {
            throw new SecurityException("Wrong execution secret id");
        }
    }

    protected FSProvider getFSProvider(String connectionName, String executionId, String executionSecretId, String rootPath) throws IOException, CodedException, DKUSecurityException {
        DSSConnection connection;
        this.ensureCDEOrigin(executionId, executionSecretId);
        FSProviderConnectionFactory connectionFactory = new FSProviderConnectionFactory();
        if (StringUtils.isBlank((String)connectionName)) {
            connection = new FsConnection();
            connection.params.root = "/";
        } else {
            connection = connectionFactory.getConnectionForProvider("Filesystem", this.authCtx, connectionName, "remote access");
        }
        logger.info((Object)("Create provider for remote access with path " + rootPath));
        if (rootPath != null && rootPath.contains("${dip.home}")) {
            rootPath = rootPath.replace("${dip.home}", ApplicationConfigurator.getFile((String[])new String[0]).getAbsolutePath());
        } else if (rootPath != null && rootPath.contains("${dku.install.dir.plugins}")) {
            rootPath = rootPath.replace("${dku.install.dir.plugins}", ApplicationConfigurator.getPreInstalledPluginsFolder().getAbsolutePath());
        }
        return FSProviderFactory.getProvider("Filesystem", this.authCtx, null, null, rootPath, connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getPluginFullyResolvedCredentials(String executionId, String executionSecretId, String name, String label, PluginCredentialRequestService.PluginCredentialRequestInfo credentialRequestInfo) throws IOException, DKUSecurityException {
        this.ensureCDEOrigin(executionId, executionSecretId);
        TransactionContext.attach((TransactionRef)this.t);
        try {
            PluginConfigUtils.SerializablePluginParamCredentials serializablePluginParamCredentials = PluginConfigUtils.getFullyResolvedCredentials(this.authCtx, name, label, credentialRequestInfo);
            return serializablePluginParamCredentials;
        }
        finally {
            TransactionContext.detach((TransactionRef)this.t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getFullyResolvedCredentials(String connectionName, String projectKey, String executionId, String executionSecretId, boolean useTokenCache) throws IOException, DKUSecurityException, SQLException {
        TransactionContext.attach((TransactionRef)this.t);
        try {
            DSSConnection conn = this.connectionsDAO.getMandatoryConnection(this.authCtx, connectionName);
            if (StringUtils.isNotBlank((String)executionId)) {
                this.ensureCDEOrigin(executionId, executionSecretId);
            } else if (!conn.detailsReadableBy(this.authCtx) && !SparkJobExecEnv.allowInsecureAccessToConnection()) {
                throw new DKUSecurityException("Not allowed to access connection " + connectionName);
            }
            Object object = conn.getFullyResolvedCredentials(new ConnectionWithBasicCredential.CredentialResolutionContext(this.authCtx, projectKey).withUseTokenCache(useTokenCache), Object.class);
            return object;
        }
        finally {
            TransactionContext.detach((TransactionRef)this.t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GoogleCredentialsBuilder.SerializableGoogleCredentials getDefaultGoogleCredentials(String executionId, String executionSecretId, String credentialType) throws IOException {
        this.ensureCDEOrigin(executionId, executionSecretId);
        TransactionContext.attach((TransactionRef)this.t);
        try {
            GoogleCredentialsBuilder.SerializableGoogleCredentials serializableGoogleCredentials = GoogleCredentialsBuilder.getSerializableCredentialFromEnvironment(credentialType);
            return serializableGoogleCredentials;
        }
        finally {
            TransactionContext.detach((TransactionRef)this.t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GoogleCredentialsBuilder.SerializableGoogleCredentials getFileGoogleCredentials(String executionId, String executionSecretId, String path, String credentialType) throws IOException {
        this.ensureCDEOrigin(executionId, executionSecretId);
        TransactionContext.attach((TransactionRef)this.t);
        try {
            GoogleCredentialsBuilder.SerializableGoogleCredentials serializableGoogleCredentials = GoogleCredentialsBuilder.getSerializableCredentialFromPath(path, credentialType);
            return serializableGoogleCredentials;
        }
        finally {
            TransactionContext.detach((TransactionRef)this.t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getPrivateKeyLastModified(String connectionName, String executionId, String executionSecretId) throws IOException, DKUSecurityException {
        TransactionContext.attach((TransactionRef)this.t);
        try {
            File currentKey;
            DSSConnection conn = this.connectionsDAO.getMandatoryConnection(this.authCtx, connectionName);
            if (StringUtils.isNotBlank((String)executionId)) {
                this.ensureCDEOrigin(executionId, executionSecretId);
            } else if (!conn.detailsReadableBy(this.authCtx) && !SparkJobExecEnv.allowInsecureAccessToConnection()) {
                throw new DKUSecurityException("Not allowed to access connection " + connectionName);
            }
            String currentKeyPath = ((ConnectionWithGoogleAuthCredentials)((Object)conn)).getPrivateKeyPathOrNull();
            long lastModified = StringUtils.isBlank((String)currentKeyPath) ? 0L : ((currentKey = new File(currentKeyPath)).exists() ? currentKey.lastModified() : 0L);
            long l = lastModified;
            return l;
        }
        finally {
            TransactionContext.detach((TransactionRef)this.t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GoogleCredentialCache.RawTokenResponse refreshGoogleCredentialAccessToken(String connectionName, String executionId, String executionSecretId) throws IOException, DKUSecurityException {
        TransactionContext.attach((TransactionRef)this.t);
        try {
            if (StringUtils.isNotBlank((String)executionId)) {
                this.ensureCDEOrigin(executionId, executionSecretId);
            } else {
                if (StringUtils.isBlank((String)connectionName)) {
                    throw new DKUSecurityException("Not allowed to get default credentials without referring connection");
                }
                DSSConnection conn = this.connectionsDAO.getMandatoryConnection(this.authCtx, connectionName);
                if (!conn.detailsReadableBy(this.authCtx) && !SparkJobExecEnv.allowInsecureAccessToConnection()) {
                    throw new DKUSecurityException("Not allowed to access connection " + connectionName);
                }
            }
            GoogleCredentialCache.RawTokenResponse rawTokenResponse = GoogleCredentialCache.getTokenFromMetadataServer();
            return rawTokenResponse;
        }
        finally {
            TransactionContext.detach((TransactionRef)this.t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionWithAzureAuthCredentials.SerializableAzureAuthCredentials refreshAzureCredentialAccessToken(String connectionName, String executionId, String executionSecretId, String claims, List<String> scopes, String tenantId) throws IOException, DKUSecurityException {
        TransactionContext.attach((TransactionRef)this.t);
        try {
            DSSConnection conn = this.connectionsDAO.getMandatoryConnection(this.authCtx, connectionName);
            if (StringUtils.isNotBlank((String)executionId)) {
                this.ensureCDEOrigin(executionId, executionSecretId);
            } else if (!conn.detailsReadableBy(this.authCtx) && !SparkJobExecEnv.allowInsecureAccessToConnection()) {
                throw new DKUSecurityException("Not allowed to access connection " + connectionName);
            }
            TokenRequestContext requestCtx = new TokenRequestContext();
            requestCtx.setClaims(claims);
            requestCtx.setScopes(scopes);
            requestCtx.setTenantId(tenantId);
            AccessToken accessToken = ConnectionWithAzureAuthCredentials.getDefaultAzureCredential(conn.getProxySettings()).getTokenSync(requestCtx);
            ConnectionWithAzureAuthCredentials.SerializableAzureAuthCredentials serializableAzureAuthCredentials = ConnectionWithAzureAuthCredentials.SerializableAzureAuthCredentials.fromEnvironmentToken(accessToken);
            return serializableAzureAuthCredentials;
        }
        finally {
            TransactionContext.detach((TransactionRef)this.t);
        }
    }
}

