/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.cde;

import com.dataiku.dip.rpc.TicketBasedIntercomAPIClient;
import com.dataiku.dip.security.rpc.EncryptedRPC;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class CDEProcessUtils {
    private static String serverUrl;
    private static String apiTicket;
    private static String serverCert;
    private static String executionSecretId;
    private static final Logger logger;

    public static void setupFromEnvironmentVariables() {
        apiTicket = System.getenv("DKU_API_TICKET");
        executionSecretId = System.getenv("DKU_EXECUTION_SECRET_ID");
        String serverProtocol = System.getenv("DKU_SERVER_PROTOCOL");
        String serverHost = System.getenv("DKU_SERVER_HOST");
        String serverPort = System.getenv("DKU_SERVER_PORT");
        serverCert = StringUtils.defaultIfBlank((String)System.getenv("DKU_SERVER_CERT"), (String)"NA");
        if ("NA".equals(serverCert)) {
            serverCert = null;
        } else if (EncryptedRPC.isEncodedTextB64(serverCert)) {
            serverCert = EncryptedRPC.decodePEMCertificateTextB64(serverCert);
        }
        serverUrl = String.format("%s://%s:%s/kernel", serverProtocol, serverHost, serverPort);
        logger.info((Object)("Connect to DSS at " + serverUrl));
    }

    public static String getAPITicket() {
        return apiTicket;
    }

    public static TicketBasedIntercomAPIClient newIntercomAPIClient() {
        return new TicketBasedIntercomAPIClient(serverUrl, serverCert, apiTicket, executionSecretId);
    }

    static {
        logger = Logger.getLogger((String)"dku.cde.utils");
    }
}

