/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.autofeaturegeneration;

import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.exec.autofeaturegeneration.AutoFeatureGenerationRecipeCreator;
import com.dataiku.dip.dataflow.exec.autofeaturegeneration.AutoFeatureGenerationRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.autofeaturegeneration.AutoFeatureGenerationRecipeRunner;
import com.dataiku.dip.dataflow.exec.autofeaturegeneration.AutoFeatureGenerationRecipeSchemaComputer;
import com.dataiku.dip.dataflow.exec.autofeaturegeneration.AutoFeatureGenerationRecipeStatusComputer;
import com.dataiku.dip.dataflow.pipeline.AutoFeatureGenerationRecipePipelineHelper;
import com.dataiku.dip.dataflow.pipeline.RecipePipelineHelper;
import com.dataiku.dip.recipes.AbstractSparkRecipeParams;
import com.dataiku.dip.recipes.NoParams;
import com.dataiku.dip.recipes.RecipeDesc;
import com.dataiku.dip.recipes.RecipeMeta;
import com.dataiku.dip.recipes.RecipeParams;
import com.dataiku.dip.recipes.RecipeRunner;
import com.dataiku.dip.recipes.RecipeSchemaComputer;
import com.dataiku.dip.recipes.common.RecipeCreator;
import com.dataiku.dip.recipes.common.RecipeStatusComputer;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.spark.SparkOverrideConfig;
import com.dataiku.dip.utils.JSON;
import java.io.IOException;
import org.apache.log4j.Logger;

public class AutoFeatureGenerationRecipeMeta
extends RecipeMeta {
    public static final AutoFeatureGenerationRecipeMeta META = new AutoFeatureGenerationRecipeMeta();
    private static Logger logger = Logger.getLogger((String)"dku.recipes.autofeaturegeneration");

    @Override
    public Class<? extends RecipeParams> paramsClass() {
        return NoParams.class;
    }

    @Override
    public String getType() {
        return "generate_features";
    }

    @Override
    public RecipeRunner buildRunner(JobActivity activity) {
        return new AutoFeatureGenerationRecipeRunner(activity);
    }

    @Override
    public RecipeMeta.OutputSchemaComputability getOutputSchemasComputability() {
        return RecipeMeta.OutputSchemaComputability.RELIABLE_STATIC;
    }

    @Override
    public RecipeSchemaComputer buildSchemaComputer(AuthCtx authCtx, JobActivity activity) {
        return new AutoFeatureGenerationRecipeSchemaComputer(authCtx, activity);
    }

    @Override
    public RecipeCreator buildCreator(AuthCtx authCtx) {
        return new AutoFeatureGenerationRecipeCreator(authCtx, this);
    }

    @Override
    public RecipeStatusComputer buildStatusComputer(SerializedRecipe recipe, String payload) {
        return new AutoFeatureGenerationRecipeStatusComputer(recipe, payload);
    }

    private static boolean isSparkEnabled() {
        try {
            return ((GeneralSettingsDAO)SpringUtils.getBean(GeneralSettingsDAO.class)).getUnsafeAutoTXN().sparkSettings.sparkEnabled;
        }
        catch (IOException e) {
            logger.warn((Object)"Unable to check if spark is enabled", (Throwable)e);
            return false;
        }
    }

    @Override
    public RecipeDesc getRecipeDesc() {
        RecipeDesc desc = RecipeDesc.newSisoDesc("feature generation", null);
        RecipeDesc.IORoleDef mainInput = desc.inputRoles.get(0);
        mainInput.arity = RecipeDesc.IOArity.NARY;
        mainInput.withEditable(true, false);
        mainInput.description = "Input datasets can be added/removed from the settings tab";
        boolean isSparkEnabled = AutoFeatureGenerationRecipeMeta.isSparkEnabled();
        for (RecipeDesc.IORoleDef input : desc.inputRoles) {
            input.mustHaveSchema = true;
            input.mustNotBePartitioned = true;
            if (isSparkEnabled) continue;
            input.mustBeSQL = true;
        }
        for (RecipeDesc.IORoleDef output : desc.outputRoles) {
            output.mustNotBePartitioned = true;
        }
        return desc;
    }

    @Override
    public RecipeMeta.RecipeCategoryFlags getCategoryFlags() {
        return new RecipeMeta.RecipeCategoryFlags().withVisualSQL();
    }

    @Override
    public boolean hasJsonPayload() {
        return true;
    }

    @Override
    public SparkOverrideConfig getSparkConf(SerializedRecipe sr, String payload) {
        AutoFeatureGenerationRecipePayloadParams params = (AutoFeatureGenerationRecipePayloadParams)JSON.parse((String)payload, AutoFeatureGenerationRecipePayloadParams.class);
        return params.engineParams.sparkSQL.sparkConfig;
    }

    @Override
    public String setSparkConf(SerializedRecipe sr, String payload, SparkOverrideConfig config) {
        AutoFeatureGenerationRecipePayloadParams params = (AutoFeatureGenerationRecipePayloadParams)JSON.parse((String)payload, AutoFeatureGenerationRecipePayloadParams.class);
        params.engineParams.sparkSQL.sparkConfig = config;
        return JSON.pretty((Object)params);
    }

    @Override
    public String setEngine(SerializedRecipe sr, String payload, String engine) {
        AutoFeatureGenerationRecipePayloadParams params = (AutoFeatureGenerationRecipePayloadParams)JSON.parse((String)payload, AutoFeatureGenerationRecipePayloadParams.class);
        params.engineType = engine;
        return JSON.pretty((Object)params);
    }

    @Override
    public String setSparkEngine(SerializedRecipe sr, String payload, AbstractSparkRecipeParams.SparkExecutionEngine executionEngine) {
        AutoFeatureGenerationRecipePayloadParams params = (AutoFeatureGenerationRecipePayloadParams)JSON.parse((String)payload, AutoFeatureGenerationRecipePayloadParams.class);
        params.engineParams.sparkSQL.executionEngine = executionEngine;
        return JSON.pretty((Object)params);
    }

    @Override
    public RecipePipelineHelper buildPipelineHelper(SerializedRecipe recipe, String payload, RecipePipelineHelper.PipelineType pipelineType, AuthCtx authCtx, JobActivity jobActivity) {
        return new AutoFeatureGenerationRecipePipelineHelper(authCtx, recipe, payload, pipelineType, jobActivity);
    }
}

