/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.geojoin;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.exec.ComputedColumnUtils;
import com.dataiku.dip.dataflow.exec.MultiEngineRecipeRunner;
import com.dataiku.dip.dataflow.exec.filter.FilterDescUtils;
import com.dataiku.dip.dataflow.exec.geojoin.GeoJoinQueryGenerator;
import com.dataiku.dip.dataflow.exec.geojoin.GeoJoinRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.geojoin.GeoJoinRecipeSchemaComputer;
import com.dataiku.dip.dataflow.exec.join.JoinRecipeHelper;
import com.dataiku.dip.dataflow.exec.joinlike.JoinInputDescBase;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.DatasetUtils;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.recipes.ServiceUtils;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dip.variables.VariablesService;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class GeoJoinRecipeHelper {
    static DKULogger logger = DKULogger.getLogger((String)"dku.recipes.geojoin");
    @Autowired
    protected DatasetsDAO datasetsDAO;
    @Autowired
    protected VariablesService variablesService;
    @Autowired
    protected TransactionService transactionService;
    Map<String, SQLUtils.SQLTable> sqlTablesMap;
    Map<String, Dataset> datasetsMap;
    Map<String, SchemaColumn> virtualColumnsMap;

    public GeoJoinRecipeHelper() {
        SpringUtils.getInstance().autowire((Object)this);
    }

    private void expandParams(GeoJoinRecipePayloadParams params, String projectKey) {
        VariablesContext vc = this.variablesService.getForProject(projectKey);
        for (JoinInputDescBase vi : params.virtualInputs) {
            FilterDescUtils.expand(vi.preFilter, vc);
            if (vi.computedColumns == null) continue;
            ComputedColumnUtils.expand(vc, vi.computedColumns);
        }
        FilterDescUtils.expand(params.postFilter, vc);
    }

    public String generateSQL(AuthCtx authCtx, JobActivity activity, SQLDialect dialect, GeoJoinRecipePayloadParams params, boolean lowerCaseColumnsNames) throws Exception {
        Partition part;
        Dataset outputDS;
        HashMap<String, PartitioningScheme> sourcePartitionSchemes = new HashMap<String, PartitioningScheme>();
        HashMap<String, List<Partition>> sourcePartitions = new HashMap<String, List<Partition>>();
        PartitioningScheme targetPartitionScheme = null;
        if (MultiEngineRecipeRunner.shouldSpecifySourcePartitionInWhereClause(dialect, params.engineParams)) {
            for (FlowDataset fdSource : activity.getSubgraph().getSourceDatasets()) {
                Dataset source = fdSource.getMandatory(this.datasetsDAO);
                List<Partition> parts = activity.getSubgraph().getSourcePartitions(fdSource);
                if (parts == null || parts.isEmpty() || parts.get(0).isAll() || parts.get(0).isNP() || !source.getPartitioningSchema().isPartitioned()) continue;
                sourcePartitionSchemes.put(source.getFullName(), source.getPartitioningSchema());
                sourcePartitions.put(source.getFullName(), parts);
            }
        }
        if (DatasetInspector.arePartitioningColumnsMandatoryInSchema(outputDS = activity.getSubgraph().getSingleTargetDataset().getMandatory(this.datasetsDAO)) && (part = activity.getSubgraph().getTargetPartition(activity.getSubgraph().getSingleTargetDataset())) != null && !part.isNP() && !part.isAll() && outputDS.getPartitioningSchema().isPartitioned()) {
            targetPartitionScheme = outputDS.getPartitioningSchema();
        }
        return this.generateSQL(authCtx, activity, dialect, params, lowerCaseColumnsNames, sourcePartitionSchemes, sourcePartitions, outputDS, targetPartitionScheme);
    }

    public String generateSQLIgnorePartitioning(AuthCtx authCtx, JobActivity activity, SQLDialect dialect, GeoJoinRecipePayloadParams params, boolean lowerCaseColumnsNames) throws Exception {
        return this.generateSQL(authCtx, activity, dialect, params, lowerCaseColumnsNames, null, null, null, null);
    }

    public String generateSQLIgnorePartitioning_NT(AuthCtx authCtx, JobActivity activity, SQLDialect dialect, GeoJoinRecipePayloadParams params, boolean lowerCaseColumnsNames) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            String string = this.generateSQL(authCtx, activity, dialect, params, lowerCaseColumnsNames, null, null, null, null);
            return string;
        }
    }

    public String generateSQL(AuthCtx authCtx, JobActivity activity, SQLDialect dialect, GeoJoinRecipePayloadParams params, boolean lowerCaseColumnsNames, Map<String, PartitioningScheme> sourcePartitionSchemes, Map<String, List<Partition>> sourcePartitions, Dataset target, PartitioningScheme targetPartitionScheme) throws Exception {
        Schema outputSchema = this.inferOutputSchema(authCtx, activity, params);
        target = target == null ? new Dataset().withSchema(outputSchema) : ((Dataset)JSON.deepCopy((Object)target)).withSchema(outputSchema);
        this.initAliases(params, lowerCaseColumnsNames);
        GeoJoinQueryGenerator sqlGenerator = new GeoJoinQueryGenerator(params, this.datasetsMap, this.sqlTablesMap, target);
        sqlGenerator.setPartitioning(sourcePartitionSchemes, sourcePartitions, targetPartitionScheme);
        return sqlGenerator.generateSQL(dialect);
    }

    @VisibleForTesting
    protected Schema inferOutputSchema(AuthCtx authCtx, JobActivity activity, GeoJoinRecipePayloadParams params) throws Exception {
        GeoJoinRecipeSchemaComputer schemaComputer = new GeoJoinRecipeSchemaComputer(authCtx, activity);
        schemaComputer.setParams(params);
        return schemaComputer.getSchema();
    }

    protected void initAliases(GeoJoinRecipePayloadParams params, boolean lowerCase) {
        JoinRecipeHelper.unicizeTableAliases(params);
        JoinRecipeHelper.computeColumnAliases(params, lowerCase);
    }

    public void initInputDatasets(JobActivity activity, GeoJoinRecipePayloadParams params, SQLDialect dialect, boolean caseInsensitive) throws IOException {
        Preconditions.checkNotNull((Object)params, (Object)"No params");
        Preconditions.checkNotNull((Object)params.virtualInputs, (Object)"No inputs");
        this.sqlTablesMap = new HashMap<String, SQLUtils.SQLTable>();
        this.datasetsMap = new HashMap<String, Dataset>();
        for (JoinInputDescBase vi : params.virtualInputs) {
            Dataset source = ServiceUtils.getDataset(activity, this.datasetsDAO, vi.name);
            logger.trace((Object)("Register dataset " + vi.name + " : " + JSON.json((Object)source)));
            this.datasetsMap.put(vi.name, source);
            SQLUtils.SQLTable table = DatasetUtils.getResolvedTableWithSparkSQLFallback(source, dialect, params.engineParams);
            this.sqlTablesMap.put(vi.name, table);
        }
        params.resolveSelectedColumns(this.datasetsMap, caseInsensitive);
    }

    public GeoJoinRecipePayloadParams loadParams(String payload, SerializedRecipe sr) {
        GeoJoinRecipePayloadParams params = (GeoJoinRecipePayloadParams)JSON.parse((String)payload, GeoJoinRecipePayloadParams.class);
        Preconditions.checkNotNull((Object)params, (Object)"Empty parameters");
        this.expandParams(params, sr.projectKey);
        return JoinRecipeHelper.resolveDatasetNames(params, sr);
    }
}

