/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.join;

import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.containers.exec.ContainerExecRuntimeConfig;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.JobAuthCtxService;
import com.dataiku.dip.dataflow.cde.ContainerizedDSSEngineAble;
import com.dataiku.dip.dataflow.exec.MultiEngineRecipeRunner;
import com.dataiku.dip.dataflow.exec.VisualSQLRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.filter.FilterDesc;
import com.dataiku.dip.dataflow.exec.filter.FilterDescUtils;
import com.dataiku.dip.dataflow.exec.h2.H2DB;
import com.dataiku.dip.dataflow.exec.h2.H2RecipeRunner;
import com.dataiku.dip.dataflow.exec.join.ContainerizedJoinExecutor;
import com.dataiku.dip.dataflow.exec.join.JoinRecipeHelper;
import com.dataiku.dip.dataflow.exec.join.JoinRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.join.JoinRecipeStatusComputer;
import com.dataiku.dip.dataflow.exec.joinlike.JoinOutputRole;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.datasets.StreamableDatasetSelection;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.recipes.consistency.CDECompatibilityCheckerService;
import com.dataiku.dip.recipes.visualsql.VisualSQLRecipesBaseService;
import com.dataiku.dip.sql.H2V2SQLDialect;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.DKULogger;
import com.google.common.collect.Lists;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class JoinRecipeSingleOutputRunner
extends MultiEngineRecipeRunner
implements ContainerizedDSSEngineAble {
    @Autowired
    private JobAuthCtxService authCtxService;
    @Autowired
    private CDECompatibilityCheckerService cdeCompatibilityCheckerService;
    private JoinRecipeHelper joinHelper = new JoinRecipeHelper();
    private JoinRecipePayloadParams params;
    private JoinOutputRole role;
    private boolean isRunningInContainer;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.recipe.join");

    public JoinRecipeSingleOutputRunner(JobActivity activity, JoinOutputRole role) {
        super(activity);
        this.role = role;
    }

    public JobActivity getActivity() {
        return this.activity;
    }

    @Override
    public void setIsRunningInContainer() {
        this.isRunningInContainer = true;
    }

    @Override
    public void setPayload(String payload) {
        logger.info((Object)("SET PAYLOAD: " + payload));
        this.payload = payload;
        this.params = this.joinHelper.loadParams(payload, this.recipe.getModel());
    }

    @Override
    protected void initBuiltinExecutor(VisualSQLRecipesBaseService.SQLBasedEngineStatus engine) throws Exception {
        ContainerExecRuntimeConfig containerConfig = this.cdeCompatibilityCheckerService.getContainerConfig(this.isRunningInContainer, this.authCtxService.getAuthCtx(), this.activity.warnContext, this.params.engineParams.containerSelection, this.recipe.getModel(), this.payload);
        if (containerConfig != null) {
            logger.info((Object)"Run in container");
            ContainerizedJoinExecutor containerizedRunner = new ContainerizedJoinExecutor(this.recipe, this.role, this.activity, containerConfig);
            containerizedRunner.init(this.activity, Output.WriteMode.APPEND);
            this.executor = containerizedRunner;
        } else {
            logger.info((Object)"Using H2 implementation");
            List<FlowDataset> sources = this.activity.getSubgraph().getSourceDatasets();
            ArrayList<StreamableDatasetSelection> preSelections = new ArrayList<StreamableDatasetSelection>();
            for (FlowDataset fdSource : sources) {
                Dataset source = fdSource.getMandatory(this.datasetsDAO);
                StreamableDatasetSelection preSelection = StreamableDatasetSelection.full();
                if (source.getPartitioningSchema().isPartitioned()) {
                    preSelection.withSelectedPartitions(this.activity.getSubgraph().getSourcePartitions(fdSource));
                }
                ArrayList filters = Lists.newArrayList();
                for (JoinRecipePayloadParams.InputDesc td : this.params.virtualInputs) {
                    DatasetLocUtils.DatasetLoc loc = DatasetLocUtils.resolveSmart(this.recipe.getProjectKey(), td.name);
                    if (!loc.equals(source.getLoc())) continue;
                    if (FilterDescUtils.willFilter(td.preFilter)) {
                        filters.add(td.preFilter);
                        continue;
                    }
                    logger.infoV("Cannot perform the prefilter trimming for the dataset \"%s\" because one of the virtual input for this dataset does not have any prefilter defined", new Object[]{source.getName()});
                    filters.clear();
                    break;
                }
                preSelection.filter = FilterDesc.orFilter((FilterDesc[])filters.toArray(new FilterDesc[0]));
                preSelections.add(preSelection);
            }
            FilterDesc postFilter = null;
            if (FilterDescUtils.willFilter(this.params.postFilter)) {
                postFilter = this.params.postFilter;
            }
            final H2V2SQLDialect dialect = new H2V2SQLDialect();
            this.joinHelper.initInputDatasets(this.activity, this.params, true, dialect, false);
            this.joinHelper.sanitizeColumnNormalization(this.params);
            final JoinRecipeHelper.SimpleIndexes indexes = this.joinHelper.getAndPrepareIndexes(this.params);
            H2RecipeRunner h2runner = new H2RecipeRunner(this.activity, this.datasetsDAO, preSelections, postFilter){

                @Override
                protected void onPreQuery(H2DB dth, SQLConnectionProvider.SQLConnectionData connData, SQLConnectionProvider.SQLConnectionWrapper conn, JobActivity activity) throws Exception {
                    for (JoinRecipeHelper.SimpleIndexDef sid : indexes.definitions) {
                        Statement st2 = dth.getConn().createStatement();
                        try {
                            if (sid.columns.isEmpty()) {
                                logger.info((Object)("Skipping index for " + sid.table.getTable() + " (0 columns)"));
                                continue;
                            }
                            logger.info((Object)("Creating index on " + sid.table.getTable() + " / " + StringUtils.join(sid.columns, (String)",")));
                            ArrayList<String> quoted = new ArrayList<String>();
                            for (String column : sid.columns) {
                                quoted.add(dth.getConnData().getDialect().quoteIdentifier(column));
                            }
                            String sql = "CREATE INDEX ON " + dth.getConnData().getDialect().getQuotedTableFullName(sid.table) + " (" + StringUtils.join(quoted, (String)",") + ")";
                            logger.info((Object)("  Executing SQL: " + sql));
                            st2.execute(sql);
                        }
                        finally {
                            if (st2 == null) continue;
                            st2.close();
                        }
                    }
                    conn.commit();
                }

                @Override
                protected String getSql(H2DB dth, JobActivity activity) throws Exception {
                    return JoinRecipeSingleOutputRunner.this.joinHelper.generateSQL(JoinRecipeSingleOutputRunner.this.authCtxService.getAuthCtx(), activity, dialect, JoinRecipeSingleOutputRunner.this.params, false, JoinRecipeSingleOutputRunner.this.role);
                }
            };
            ArrayList virtualColumnsForAllInputs = Lists.newArrayList();
            for (int i = 0; i < sources.size(); ++i) {
                ArrayList columnsForSource = Lists.newArrayList();
                for (JoinRecipeHelper.SimpleVirtualColumn virtualColumn : indexes.virtualColumns) {
                    if (virtualColumn.datasetIndex != i) continue;
                    columnsForSource.add(virtualColumn);
                }
                virtualColumnsForAllInputs.add(columnsForSource);
            }
            h2runner.setVirtualColumns(virtualColumnsForAllInputs);
            h2runner.init();
            this.executor = h2runner;
        }
    }

    @Override
    public String generateSQL(SQLDialect dialect) throws Exception {
        VisualSQLRecipesBaseService.SQLBasedEngineStatus selectedEngine = new JoinRecipeStatusComputer(this.recipe.getModel(), this.payload).fastStatusIgnorePartitions(this.authCtxService.getAuthCtx()).getSelectedSQLBasedEngine();
        boolean mustLowerCaseColumnsNames = this.visualRecipesBaseService.mustLowerCaseColumnsNames((VisualSQLRecipePayloadParams)this.params, selectedEngine);
        boolean caseInsensitive = mustLowerCaseColumnsNames || dialect != null && dialect.hasCaseInsensitiveColumns();
        this.joinHelper.initInputDatasets(this.activity, this.params, false, dialect, caseInsensitive);
        return this.joinHelper.generateSQL(this.authCtxService.getAuthCtx(), this.activity, dialect, this.params, mustLowerCaseColumnsNames, this.role);
    }
}

