/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.sync;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.connections.AzureConnection;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.connections.SQLServerConnection;
import com.dataiku.dip.connections.SynapseConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.dataflow.exec.FSSubgraphHelper;
import com.dataiku.dip.dataflow.exec.FlowRunnable;
import com.dataiku.dip.dataflow.exec.SISORecipeExecutor;
import com.dataiku.dip.dataflow.exec.sync.AutoFastPathConnector;
import com.dataiku.dip.dataflow.exec.sync.AzureBlobToSynapseWithCopy;
import com.dataiku.dip.dataflow.exec.sync.AzureBlobToSynapseWithPolybase;
import com.dataiku.dip.dataflow.exec.sync.CloudBlobSupport;
import com.dataiku.dip.dataflow.exec.sync.FastPathDatasetTypeStraightener;
import com.dataiku.dip.dataflow.exec.sync.SyncRecipeParams;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.datasets.fs.AzureBlobDatasetHandler;
import com.dataiku.dip.datasets.sql.AbstractSQLTableDatasetHandler;
import com.dataiku.dip.datasets.sql.BuiltinSQLDatasets;
import com.dataiku.dip.datasets.sql.SQLCodes;
import com.dataiku.dip.exceptions.CodedSQLException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.fs.FSPath;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.partitioning.DimensionValue;
import com.dataiku.dip.partitioning.FilePartitioner;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.recipes.common.RecipeEngineStatus;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.SynapseSQLDialect;
import com.dataiku.dip.sql.queries.ExpressionUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.warnings.WarningsContext;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class AzureBlobToSynapse
extends SISORecipeExecutor
implements AutoFastPathConnector {
    @Autowired
    private PasswordEncryptionService symetricCryptoService;
    private final SynapseLoadSQLBuilder sqlBuilder;
    private final SyncRecipeParams.LoadToSynapseParams loadParams;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.recipes.sync.azureblobtosynapse");

    public AzureBlobToSynapse(SyncRecipeParams.LoadToSynapseParams loadParams) {
        this.loadParams = loadParams == null ? AzureBlobToSynapse.makeDefaultLoadParams() : loadParams;
        this.sqlBuilder = this.loadParams.usePolybase ? new AzureBlobToSynapseWithPolybase() : new AzureBlobToSynapseWithCopy();
    }

    static boolean isSynapseDialect(SQLDialect dialect) {
        return dialect instanceof SynapseSQLDialect;
    }

    private static SyncRecipeParams.LoadToSynapseParams makeDefaultLoadParams() {
        SyncRecipeParams.LoadToSynapseParams loadParams = new SyncRecipeParams.LoadToSynapseParams();
        loadParams.usePolybase = ApplicationConfigurator.getParams().getBoolParam("dip.loadToSynapse.usePolybase", false);
        return loadParams;
    }

    public Dataset getInputDS() {
        return this.inputDS;
    }

    public Dataset getOutputDS() {
        return this.outputDS;
    }

    public Partition getOutputPartition() {
        return this.outputPartition;
    }

    public AuthCtx getAuthCtx() {
        return this.authCtx;
    }

    public String getContextProjectKey() {
        return this.contextProjectKey;
    }

    public static void setCompatible(DatasetHandler.DatasetMeta<?, ?> databaseMeta, AuthCtx authCtx, Dataset inputDS, Dataset outputDS, RecipeEngineStatus status, SyncRecipeParams.LoadToSynapseParams loadParams) throws IOException, DKUSecurityException {
        DatasetHandler.DatasetMeta<?, ?> outputMeta = DatasetHandlerFactory.getMeta(outputDS);
        status.isSelectable = true;
        try {
            if (!new FastPathDatasetTypeStraightener().isEquivalentTo(inputDS, "Azure")) {
                throw new AzureBlobToSynapseImpossibleException("Input dataset is not in Azure Blob Storage");
            }
            if (databaseMeta == BuiltinSQLDatasets.FABRIC_WAREHOUSE_META && outputMeta != databaseMeta) {
                throw new AzureBlobToSynapseImpossibleException("Output dataset is not a Fabric Warehouse dataset");
            }
            if (databaseMeta == BuiltinSQLDatasets.SYNAPSE_META && outputMeta != BuiltinSQLDatasets.SYNAPSE_META && outputMeta != BuiltinSQLDatasets.SQLSERVER_META) {
                throw new AzureBlobToSynapseImpossibleException("Output dataset is not a Synapse or SQL Server Warehouse dataset");
            }
            if (outputMeta == BuiltinSQLDatasets.SQLSERVER_META && !AzureBlobToSynapse.isAzureDWH(outputDS)) {
                throw new AzureBlobToSynapseImpossibleException("Output dataset is not a SQL Server Warehouse dataset");
            }
            AzureBlobToSynapse.getCopyMode(authCtx, inputDS, outputDS, loadParams);
        }
        catch (AzureBlobToSynapseImpossibleException e) {
            status.markAsNonSelectable(e.getMessage(), RecipeEngineStatus.WarningLevel.ERROR);
        }
    }

    @Override
    public void initForAutoFastPath(AuthCtx authCtx, WarningsContext warnContext, Dataset cloudDataset, Partition cloudPartition, Dataset synapseDataset, Output.WriteMode writeMode) throws Exception {
        this.outputDS = synapseDataset;
        this.inputDS = cloudDataset;
        this.contextProjectKey = synapseDataset.getProjectKey();
        this.inputPartitions = Lists.newArrayList((Object[])new Partition[]{cloudPartition});
        this.outputPartition = cloudPartition;
        this.writeMode = writeMode;
        this.authCtx = authCtx;
        this.warnContext = warnContext;
        this.clearOutputPartitionsIfNeeded();
    }

    @Override
    public void run() throws Exception {
        try (AbstractSQLTableDatasetHandler vti = (AbstractSQLTableDatasetHandler)DatasetHandlerFactory.build(this.authCtx, this.outputDS);
             AzureBlobDatasetHandler abdh = (AzureBlobDatasetHandler)new FastPathDatasetTypeStraightener().getDatasetHandler(this.authCtx, this.inputDS);){
            FilePartitioner.ResolvedFilesFilterResult filterResult = FSSubgraphHelper.getInputFiles(this.inputPartitions, abdh);
            SQLConnectionProvider.SQLConnectionData connData = vti.getConnectionData();
            SQLUtils.SQLTable table = vti.getResolvedTable();
            AzureConnection azure = abdh.getConnection();
            CloudBlobSupport.CopyMode copyMode = AzureBlobToSynapse.getCopyMode(this.authCtx, this.inputDS, this.outputDS, this.loadParams);
            AzureBlobDatasetHandler.HDFSInterface hdfsInterface = copyMode.type == CloudBlobSupport.CopyModeType.CSV ? AzureBlobDatasetHandler.HDFSInterface.WASB : AzureBlobDatasetHandler.HDFSInterface.ABFS;
            logger.info((Object)("Setting HDFS interface of input to " + String.valueOf((Object)hdfsInterface) + " because format is " + String.valueOf((Object)copyMode.type)));
            String rootPath = abdh.getFullyQualifiedRootPath(hdfsInterface);
            boolean isSingleFile = abdh.isSingleFile();
            this.prepareOutputTable(vti, connData);
            ArrayList<CloudBlobSupport.LocationToLoad> storageLocations = new ArrayList<CloudBlobSupport.LocationToLoad>();
            int maxFiles = ApplicationConfigurator.getParams().getIntParam("dku.azure.copyInto.maxFilesPerCopy", Integer.valueOf(50));
            for (FSPath path : filterResult.getAllPaths()) {
                Object fullPath = isSingleFile || "/".equals(path.path()) || "".equals(path.path()) ? rootPath : rootPath + path.path();
                CloudBlobSupport.LocationToLoad azureBlobStorageLocation = CloudBlobSupport.getAzureBlobStorageLocation((String)fullPath);
                if (this.sqlBuilder.canLoadMultipleFiles()) {
                    storageLocations.add(azureBlobStorageLocation);
                    if (storageLocations.size() < maxFiles) continue;
                    this.executeCopy(vti, connData, table, azure, storageLocations, copyMode);
                    storageLocations.clear();
                    continue;
                }
                this.executeCopy(vti, connData, table, azure, azureBlobStorageLocation, copyMode);
            }
            if (!storageLocations.isEmpty()) {
                this.executeCopy(vti, connData, table, azure, storageLocations, copyMode);
            }
        }
    }

    private void prepareOutputTable(AbstractSQLTableDatasetHandler vti, SQLConnectionProvider.SQLConnectionData connData) throws SQLException, DKUSecurityException, Exception {
        SQLDialect dialect = connData.getDialect();
        SQLConnectionProvider.SQLConnectionWrapper conn = vti.newConnection();
        try {
            logger.info((Object)("Setup Synapse output partition : " + this.outputPartition.id()));
            InfoMessage.InfoMessages messages = new InfoMessage.InfoMessages();
            dialect.dropIfNeededAndCreateTableOrPartition(this.authCtx, connData, conn, this.outputDS, this.outputPartition, this.writeMode, messages);
            if (!messages.isEmpty()) {
                this.warnContext.addWarning(WarningsContext.WarningType.SQL_CREATE_QUERY_WARNING, messages.report("\n"), logger);
            }
            conn.commit();
            conn.close();
        }
        catch (Exception e) {
            logger.error((Object)"Azure Synapse load table setup failed", (Throwable)e);
            SQLUtils.unsafeRollbackAndClose(conn);
            throw e;
        }
    }

    @Override
    public List<FlowRunnable> getRunnables() {
        return Collections.emptyList();
    }

    public SQLCommand buildLoadFromTempTable(SQLDialect dialect, SQLUtils.SQLTable table, String temporaryTableName, CloudBlobSupport.CopyMode copyMode) {
        String quotedTableFullName = dialect.getQuotedTableFullName(table);
        Set inputColumnNames = this.inputDS.getSchema().columns.stream().map(SchemaColumn::getName).collect(Collectors.toSet());
        ArrayList<Object> selectClauseFields = new ArrayList<Object>();
        ArrayList<String> targetColumnFields = new ArrayList<String>();
        for (SchemaColumn col : this.outputDS.getSchema().columns) {
            String quotedColumnName = dialect.quoteIdentifier(col.getName());
            targetColumnFields.add(quotedColumnName);
            if (this.outputPartition != null && this.outputPartition.getDimensionValues().containsKey(col.getName())) {
                DimensionValue dimensionValue = (DimensionValue)this.outputPartition.getDimensionValues().get(col.getName());
                String dimensionSQLValue = ExpressionUtils.getStringForDimensionValue(dimensionValue, col.getType());
                if (col.getType() == Type.DATE) {
                    selectClauseFields.add(dialect.quoteDate(dimensionSQLValue) + " as " + quotedColumnName);
                    continue;
                }
                if (col.getType() == Type.DATEONLY) {
                    selectClauseFields.add(dialect.quoteDateOnly(dimensionSQLValue) + " as " + quotedColumnName);
                    continue;
                }
                if (col.getType() == Type.DATETIMENOTZ) {
                    selectClauseFields.add(dialect.quoteDatetimeNoTz(dimensionSQLValue) + " as " + quotedColumnName);
                    continue;
                }
                selectClauseFields.add(dialect.quoteString(dimensionSQLValue) + " as " + quotedColumnName);
                continue;
            }
            if (inputColumnNames.contains(col.getName())) {
                if (col.getType() == Type.DATE) {
                    if (AzureBlobToSynapse.isSynapseDialect(dialect) && copyMode.type == CloudBlobSupport.CopyModeType.PARQUET && "date_day".equalsIgnoreCase(col.originalType)) {
                        String exprDate = String.format("DATEADD(DAY, %s, CAST('1970-01-01' AS DATE))", quotedColumnName);
                        String exprTimestamp = String.format("TODATETIMEOFFSET(%s, 0)", exprDate);
                        selectClauseFields.add(exprTimestamp + " AS " + quotedColumnName);
                        continue;
                    }
                    selectClauseFields.add(quotedColumnName);
                    continue;
                }
                if (col.getType() == Type.DATEONLY) {
                    if (AzureBlobToSynapse.isSynapseDialect(dialect) && copyMode.type == CloudBlobSupport.CopyModeType.PARQUET) {
                        String expr = String.format("DATEADD(DAY, %s, CAST('1970-01-01' AS DATE))", quotedColumnName);
                        selectClauseFields.add(expr + " AS " + quotedColumnName);
                        continue;
                    }
                    selectClauseFields.add(quotedColumnName);
                    continue;
                }
                selectClauseFields.add(quotedColumnName);
                continue;
            }
            throw new IllegalStateException("Missing column: " + col.getName() + " in input dataset");
        }
        String targetColumns = Joiner.on((String)", ").join(targetColumnFields);
        String selectClause = Joiner.on((String)", ").join(selectClauseFields);
        return new SQLCommand(String.format("INSERT INTO %s ( %s ) SELECT %s FROM %s", quotedTableFullName, targetColumns, selectClause, temporaryTableName), null, null);
    }

    private void executeCopy(AbstractSQLTableDatasetHandler vti, SQLConnectionProvider.SQLConnectionData connData, SQLUtils.SQLTable table, AzureConnection azure, CloudBlobSupport.LocationToLoad azureBlobStorageLocation, CloudBlobSupport.CopyMode copyMode) throws Exception {
        SQLDialect dialect = connData.getDialect();
        this.sqlBuilder.setUseManagedIdentity(((SynapseConnection)connData.getConnection()).useManagedIdentityForFastPath());
        SQLCommandList sqlSequence = this.sqlBuilder.buildSqlSequence(azure, copyMode, dialect, azureBlobStorageLocation, table, this);
        this.connectToDatabase(vti, connData, dialect, sqlSequence, copyMode);
    }

    private void executeCopy(AbstractSQLTableDatasetHandler vti, SQLConnectionProvider.SQLConnectionData connData, SQLUtils.SQLTable table, AzureConnection azure, List<CloudBlobSupport.LocationToLoad> azureBlobStorageLocations, CloudBlobSupport.CopyMode copyMode) throws Exception {
        SQLDialect dialect = connData.getDialect();
        this.sqlBuilder.setUseManagedIdentity(((SynapseConnection)connData.getConnection()).useManagedIdentityForFastPath());
        SQLCommandList sqlSequence = this.sqlBuilder.buildSqlSequence(azure, copyMode, dialect, azureBlobStorageLocations, table, this);
        this.connectToDatabase(vti, connData, dialect, sqlSequence, copyMode);
    }

    private void connectToDatabase(AbstractSQLTableDatasetHandler vti, SQLConnectionProvider.SQLConnectionData connData, SQLDialect dialect, SQLCommandList sqlSequence, CloudBlobSupport.CopyMode copyMode) throws Exception {
        SQLConnectionProvider.SQLConnectionWrapper conn = vti.newConnection();
        boolean initialAutocommitMode = "Synapse".equals(connData.getConnection().type) || "FabricWarehouse".equals(connData.getConnection().type) || connData.getConnection().getParams().autocommitMode;
        try {
            SQLUtils.executePreWriteStatements(connData, conn, this.outputDS);
            try (Statement statement = conn.createStatement();){
                if (!initialAutocommitMode) {
                    logger.info((Object)"Setting auto commit off");
                    statement.execute("SET IMPLICIT_TRANSACTIONS OFF; COMMIT TRANSACTION;");
                }
                LinkedList<SQLCommand> teardownSequence = new LinkedList<SQLCommand>();
                try {
                    for (SQLCommand sqlCommand : sqlSequence) {
                        this.executeStatement(statement, sqlCommand);
                        if (!StringUtils.isNotBlank((String)sqlCommand.teardownSql)) continue;
                        teardownSequence.addLast(sqlCommand);
                    }
                }
                catch (Exception e) {
                    logger.error((Object)"Copy from external table to target table failed", (Throwable)e);
                    throw this.inspectErrorForDelimiterIssues(e, copyMode);
                }
                finally {
                    while (!teardownSequence.isEmpty()) {
                        SQLCommand sqlCommand = (SQLCommand)teardownSequence.pollLast();
                        this.executeTeardownStatement(statement, sqlCommand);
                    }
                    if (!initialAutocommitMode) {
                        logger.info((Object)"Setting auto commit back on");
                        statement.execute("SET IMPLICIT_TRANSACTIONS ON;");
                    }
                }
            }
            catch (Exception e) {
                logger.error((Object)"Azure Synapse statement failed", (Throwable)e);
                throw e;
            }
            logger.info((Object)"Committing Azure Synapse transaction");
            SQLUtils.executePostWriteStatements(connData, conn, this.outputDS);
            conn.commit();
            conn.close();
        }
        catch (Exception e) {
            logger.error((Object)"Azure Synapse load failed", (Throwable)e);
            SQLUtils.unsafeRollbackAndClose(conn);
            throw e;
        }
    }

    private Exception inspectErrorForDelimiterIssues(Exception e, CloudBlobSupport.CopyMode copyMode) throws Exception {
        if (copyMode.type == CloudBlobSupport.CopyModeType.CSV) {
            if (!copyMode.useQuoting && ExceptionUtils.hasCauseWithMessageRe((Throwable)e, (String)".*HadoopExecutionException.*Too many columns in the line.*")) {
                return new CodedSQLException(SQLCodes.ERR_SYNAPSE_CSV_DELIMITER, "CSV field separator present in the data, quoting is needed", (Throwable)e);
            }
            if (copyMode.useQuoting && ExceptionUtils.hasCauseWithMessageRe((Throwable)e, (String)".*HadoopExecutionException.*Could not find a delimiter after string delimiter.*")) {
                return new CodedSQLException(SQLCodes.ERR_SYNAPSE_CSV_DELIMITER, "CSV quoting character present in the data, use a different quoting character", (Throwable)e);
            }
            if (copyMode.useQuoting && ExceptionUtils.hasCauseWithMessageRe((Throwable)e, (String)".*HadoopExecutionException.*No closing string delimiter.*")) {
                return new CodedSQLException(SQLCodes.ERR_SYNAPSE_CSV_DELIMITER, "Newline characters present in the data, can't load from CSV", (Throwable)e);
            }
            if (copyMode.useQuoting && ExceptionUtils.hasCauseWithMessageRe((Throwable)e, (String)"Not able to validate external location.*\\(409\\) Conflict")) {
                return new CodedSQLException(SQLCodes.ERR_SYNAPSE_CSV_ABFS_NO_HIERARCHICAL_NAMESPACE, "ABFS interface cannot be used because hierarchical namespaces is not enabled on storage account, use WASB", (Throwable)e);
            }
        }
        return e;
    }

    private void executeStatement(Statement statement, SQLCommand sqlCommand) throws SQLException {
        logger.info((Object)("sequence Executing SQL: " + StringUtils.defaultIfBlank((String)sqlCommand.sqlForLog, (String)sqlCommand.sql)));
        statement.execute(sqlCommand.sql);
    }

    private void executeTeardownStatement(Statement statement, SQLCommand sqlCommand) throws SQLException {
        logger.info((Object)("sequence Executing SQL: " + sqlCommand.teardownSql));
        statement.execute(sqlCommand.teardownSql);
    }

    private static boolean isAzureDWH(Dataset outputDS) {
        try {
            ConnectionsDAO connectionsDAO = (ConnectionsDAO)SpringUtils.getBean(ConnectionsDAO.class);
            DSSConnection conn = connectionsDAO.getConnection(DSSAuthCtx.newNone(), outputDS.getParams().getConnection());
            return AzureBlobToSynapse.isAzureDWH(conn);
        }
        catch (Exception e) {
            logger.info((Object)"Output dataset is not in Azure SQL Server Data Warehouse", (Throwable)e);
            return false;
        }
    }

    private static boolean isAzureDWH(DSSConnection connection) {
        if (!(connection instanceof SQLServerConnection)) {
            return false;
        }
        SQLServerConnection sqlConnection = (SQLServerConnection)connection;
        return sqlConnection.getParams() != null && sqlConnection.getParams().azureDWH;
    }

    private static CloudBlobSupport.CopyMode getCopyMode(AuthCtx authCtx, Dataset inputDS, Dataset outputDS, SyncRecipeParams.LoadToSynapseParams loadParams) throws IOException, DKUSecurityException {
        AzureConnection azure = (AzureConnection)new FastPathDatasetTypeStraightener().getMandatoryConnectionUnsafeUnexpanded(authCtx, inputDS, "Azure");
        if (StringUtils.isBlank((String)azure.params.storageAccount)) {
            throw new AzureBlobToSynapseImpossibleException("Missing storage account name on Azure Blob Storage");
        }
        switch (azure.params.authType) {
            case OAUTH2_APP: {
                if (azure.credentialsMode != DSSConnection.CredentialsMode.GLOBAL) {
                    throw new AzureBlobToSynapseImpossibleException("OAuth2 is not supported in mode " + String.valueOf((Object)azure.credentialsMode));
                }
                if (StringUtils.isBlank((String)azure.params.appId)) {
                    throw new AzureBlobToSynapseImpossibleException("Missing app id  for Oauth2 on Azure Blob Storage");
                }
                if (StringUtils.isBlank((String)azure.params.appSecret)) {
                    throw new AzureBlobToSynapseImpossibleException("Missing app secret for Oauth2 on Azure Blob Storage (the OAuth2 Client can't be public)");
                }
                if (!StringUtils.isBlank((String)azure.params.tokenEndpoint) || !StringUtils.isBlank((String)azure.params.tenantId)) break;
                throw new AzureBlobToSynapseImpossibleException("Missing token endpoint for Oauth2 on Azure Blob Storage");
            }
            case SHARED_KEY: {
                if (!StringUtils.isBlank((String)azure.params.accessKey)) break;
                throw new AzureBlobToSynapseImpossibleException("Missing access key for shared access on Azure Blob Storage");
            }
            default: {
                throw new AzureBlobToSynapseImpossibleException("Authentication on Azure Blob Storage not supported: " + String.valueOf((Object)azure.params.authType));
            }
        }
        if ("csv".equals(inputDS.getFormatType())) {
            return CloudBlobSupport.getCsvToSynapse(inputDS, outputDS);
        }
        if ("parquet".equals(inputDS.getFormatType())) {
            if (azure.params.authType == AzureConnection.AuthType.OAUTH2_APP && loadParams.usePolybase) {
                throw new AzureBlobToSynapseImpossibleException("OAuth2 for Parquet is not supported with polybase");
            }
            return CloudBlobSupport.getParquetToSynapse(inputDS);
        }
        if ("orcfile".equals(inputDS.getFormatType())) {
            if (azure.params.authType == AzureConnection.AuthType.OAUTH2_APP && loadParams.usePolybase) {
                throw new AzureBlobToSynapseImpossibleException("OAuth2 for ORC is not supported with polybase");
            }
            return CloudBlobSupport.getOrcToSynapse(inputDS);
        }
        throw new AzureBlobToSynapseImpossibleException("Input file format not supported: " + inputDS.getFormatType());
    }

    public static abstract class SynapseLoadSQLBuilder {
        protected boolean useManagedIdentity;

        abstract SQLCommandList buildSqlSequence(AzureConnection var1, CloudBlobSupport.CopyMode var2, SQLDialect var3, CloudBlobSupport.LocationToLoad var4, SQLUtils.SQLTable var5, AzureBlobToSynapse var6) throws DKUSecurityException, IOException;

        abstract SQLCommandList buildSqlSequence(AzureConnection var1, CloudBlobSupport.CopyMode var2, SQLDialect var3, List<CloudBlobSupport.LocationToLoad> var4, SQLUtils.SQLTable var5, AzureBlobToSynapse var6) throws DKUSecurityException, IOException;

        public void setUseManagedIdentity(boolean useManagedIdentity) {
            this.useManagedIdentity = useManagedIdentity;
        }

        abstract boolean canLoadMultipleFiles();
    }

    public static class AzureBlobToSynapseImpossibleException
    extends CloudBlobSupport.CloudBlobToSQLImpossibleException {
        private static final long serialVersionUID = 1L;

        AzureBlobToSynapseImpossibleException(String message) {
            super(message);
        }
    }

    protected static class SQLCommand {
        public final String sql;
        public final String sqlForLog;
        public final String teardownSql;

        public SQLCommand(String sql, String sqlForLog, String teardownSql) {
            this.sql = sql;
            this.sqlForLog = sqlForLog;
            this.teardownSql = teardownSql;
        }
    }

    protected static class SQLCommandList
    extends ArrayList<SQLCommand> {
        private static final long serialVersionUID = 1L;

        protected SQLCommandList() {
        }
    }
}

