/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.sync;

import com.dataiku.dip.connections.AzureConnection;
import com.dataiku.dip.connections.ConnectionWithAzureAuthCredentials;
import com.dataiku.dip.connections.ConnectionWithBasicCredential;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.dataflow.exec.sync.AzureBlobToSynapse;
import com.dataiku.dip.dataflow.exec.sync.CloudBlobSupport;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.input.formats.hive.orcfile.ORCFileFormatConfig;
import com.dataiku.dip.input.formats.parquet.ParquetFormatConfig;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKULogger;
import com.google.common.base.Joiner;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;

public class AzureBlobToSynapseWithPolybase
extends AzureBlobToSynapse.SynapseLoadSQLBuilder {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.recipes.sync.azureblobtosynapse.polybase");

    @Override
    boolean canLoadMultipleFiles() {
        return false;
    }

    @Override
    AzureBlobToSynapse.SQLCommandList buildSqlSequence(AzureConnection azure, CloudBlobSupport.CopyMode copyMode, SQLDialect dialect, List<CloudBlobSupport.LocationToLoad> azureBlobStorageLocations, SQLUtils.SQLTable table, AzureBlobToSynapse loader) throws DKUSecurityException, IOException {
        throw new UnsupportedOperationException("Polybase does not support multiple files loading.");
    }

    @Override
    public AzureBlobToSynapse.SQLCommandList buildSqlSequence(AzureConnection azure, CloudBlobSupport.CopyMode copyMode, SQLDialect dialect, CloudBlobSupport.LocationToLoad azureBlobStorageLocation, SQLUtils.SQLTable table, AzureBlobToSynapse loader) throws DKUSecurityException, IOException {
        String uniqueId = SecretKeyGenerator.generateSmall();
        Dataset inputDS = loader.getInputDS();
        AzureBlobToSynapse.SQLCommandList sqlSequence = new AzureBlobToSynapse.SQLCommandList();
        String dataCredentialsName = String.format("DKU_DSS_CRED_%s", uniqueId);
        if (this.useManagedIdentity) {
            sqlSequence.add(new AzureBlobToSynapse.SQLCommand(String.format("CREATE DATABASE SCOPED CREDENTIAL %s WITH IDENTITY = 'Managed Identity';", dataCredentialsName), String.format("CREATE DATABASE SCOPED CREDENTIAL %s WITH IDENTITY = 'Managed Identity';", dataCredentialsName), String.format("DROP DATABASE SCOPED CREDENTIAL [%s]", dataCredentialsName)));
        } else {
            ConnectionWithAzureAuthCredentials.SerializableAzureAuthCredentials creds = azure.getFullyResolvedCredentials_fsLike(new ConnectionWithBasicCredential.CredentialResolutionContext(loader.getAuthCtx(), loader.getContextProjectKey()), ConnectionWithAzureAuthCredentials.SerializableAzureAuthCredentials.class);
            if (creds.authType == ConnectionWithAzureAuthCredentials.AuthType.KEY) {
                sqlSequence.add(new AzureBlobToSynapse.SQLCommand(String.format("CREATE DATABASE SCOPED CREDENTIAL %s WITH IDENTITY = '%s', SECRET = '%s';", dataCredentialsName, azure.params.storageAccount, creds.key), String.format("CREATE DATABASE SCOPED CREDENTIAL %s WITH IDENTITY = '%s', SECRET = '********';", dataCredentialsName, azure.params.storageAccount), String.format("DROP DATABASE SCOPED CREDENTIAL [%s]", dataCredentialsName)));
            } else if (creds.authType == ConnectionWithAzureAuthCredentials.AuthType.OAUTH2_APP) {
                String appIdentity = String.format("%s@%s", creds.oauth2AppId, creds.oauth2AuthEndpoint);
                sqlSequence.add(new AzureBlobToSynapse.SQLCommand(String.format("CREATE DATABASE SCOPED CREDENTIAL %s WITH IDENTITY = '%s', SECRET = '%s';", dataCredentialsName, appIdentity, creds.oauth2AppSecret), String.format("CREATE DATABASE SCOPED CREDENTIAL %s WITH IDENTITY = '%s', SECRET = '********';", dataCredentialsName, appIdentity), String.format("DROP DATABASE SCOPED CREDENTIAL [%s]", dataCredentialsName)));
            } else {
                throw new IllegalArgumentException("Invalid authType " + String.valueOf((Object)creds.authType));
            }
        }
        String scheme = azure.getHDFSScheme();
        if (scheme == null) {
            logger.warn((Object)"Invalid HDFS interface, it cannot be None, so assuming wasbs");
            scheme = "wasbs";
        }
        String dataSourceName = String.format("DKU_DSS_AST_%s", uniqueId);
        sqlSequence.add(new AzureBlobToSynapse.SQLCommand(String.format("CREATE EXTERNAL DATA SOURCE %s WITH (        TYPE = HADOOP,        LOCATION ='%s://%s@%s.blob.core.windows.net',        CREDENTIAL = %s );", dataSourceName, scheme, azureBlobStorageLocation.container, azureBlobStorageLocation.storageAccount, dataCredentialsName), null, String.format("DROP EXTERNAL DATA SOURCE [%s]", dataSourceName)));
        String dataFormatName = String.format("DKU_DSS_TFF_%s", uniqueId);
        switch (copyMode.type) {
            case CSV: {
                String stringDelimiter = "";
                if (copyMode.useQuoting) {
                    logger.info((Object)"Will use string_delimiter in temporary file format");
                    stringDelimiter = String.format("         STRING_DELIMITER = '0x%02x',", copyMode.quote);
                } else {
                    logger.info((Object)"Use string_delimiter in temporary file format has been suppressed");
                }
                Object skippedFirstRows = "";
                if (copyMode.ignoreHeader > 0) {
                    skippedFirstRows = "         FIRST_ROW = " + (copyMode.ignoreHeader + 1) + ",";
                }
                sqlSequence.add(new AzureBlobToSynapse.SQLCommand(String.format("CREATE EXTERNAL FILE FORMAT %s WITH (       FORMAT_TYPE = DELIMITEDTEXT,        FORMAT_OPTIONS (         FIELD_TERMINATOR ='%c', %s%s         USE_TYPE_DEFAULT = FALSE        ),        DATA_COMPRESSION = 'org.apache.hadoop.io.compress.GzipCodec' );", dataFormatName, Character.valueOf(copyMode.delimiter), stringDelimiter, skippedFirstRows), null, String.format("DROP EXTERNAL FILE FORMAT [%s]", dataFormatName)));
                break;
            }
            case PARQUET: {
                String compression = "";
                if (copyMode.parquetCompressionMethod == ParquetFormatConfig.CompressionMethod.SNAPPY) {
                    compression = ",        DATA_COMPRESSION = 'org.apache.hadoop.io.compress.SnappyCodec' ";
                } else if (copyMode.parquetCompressionMethod == ParquetFormatConfig.CompressionMethod.GZIP) {
                    compression = ",        DATA_COMPRESSION = 'org.apache.hadoop.io.compress.DefaultCodec' ";
                }
                sqlSequence.add(new AzureBlobToSynapse.SQLCommand(String.format("CREATE EXTERNAL FILE FORMAT %s WITH (       FORMAT_TYPE = PARQUET%s);", dataFormatName, compression), null, String.format("DROP EXTERNAL FILE FORMAT [%s]", dataFormatName)));
                break;
            }
            case ORC: {
                String compression = "";
                if (copyMode.orcCompressionMethod == ORCFileFormatConfig.CompressionMethod.SNAPPY) {
                    compression = ",        DATA_COMPRESSION = 'org.apache.hadoop.io.compress.SnappyCodec' ";
                } else if (copyMode.orcCompressionMethod == ORCFileFormatConfig.CompressionMethod.ZLIB) {
                    compression = ",        DATA_COMPRESSION = 'org.apache.hadoop.io.compress.DefaultCodec' ";
                }
                sqlSequence.add(new AzureBlobToSynapse.SQLCommand(String.format("CREATE EXTERNAL FILE FORMAT %s WITH (       FORMAT_TYPE = ORC%s);", dataFormatName, compression), null, String.format("DROP EXTERNAL FILE FORMAT [%s]", dataFormatName)));
            }
        }
        String temporaryTableName = String.format("[dbo].[DKU_DSS_TMP_%s]", uniqueId);
        ArrayList<CallSite> temporaryTableColumnFields = new ArrayList<CallSite>();
        for (SchemaColumn col : inputDS.getSchema().columns) {
            if (col.getType().isTemporal()) {
                col = new SchemaColumn(col.getName(), Type.STRING).withMaxLength(100);
            } else if (!col.getType().isPrimitive() || col.getType().isGeo()) {
                col = new SchemaColumn(col.getName(), Type.STRING).withMaxLength(100);
            }
            temporaryTableColumnFields.add((CallSite)((Object)(dialect.quoteIdentifier(col.getName()) + " " + dialect.getSQLType((SchemaColumn)col, (Dataset)inputDS).sqlDecl)));
        }
        String temporaryTableColumns = Joiner.on((String)", ").join(temporaryTableColumnFields);
        sqlSequence.add(new AzureBlobToSynapse.SQLCommand(String.format("CREATE EXTERNAL TABLE %s ( %s )WITH (LOCATION='%s',        DATA_SOURCE = %s,        FILE_FORMAT = %s);", temporaryTableName, temporaryTableColumns, azureBlobStorageLocation.pathInContainer, dataSourceName, dataFormatName), null, String.format("DROP EXTERNAL TABLE %s", temporaryTableName)));
        sqlSequence.add(loader.buildLoadFromTempTable(dialect, table, temporaryTableName, copyMode));
        return sqlSequence;
    }
}

