/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.vstack;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.dataflow.exec.QueryGenerationUtils;
import com.dataiku.dip.dataflow.exec.vstack.VStackRecipePayloadParams;
import com.dataiku.dip.datasets.DatasetUtils;
import com.dataiku.dip.datasets.SchemaUtils;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.sql.HiveSQLDialect;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.queries.CombinedSelectQueryBuilder;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.sql.queries.ExpressionUtils;
import com.dataiku.dip.sql.queries.QueryAst;
import com.dataiku.dip.sql.queries.QueryUtils;
import com.dataiku.dip.sql.queries.SelectQueryBuilder;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class VStackQueryGenerator {
    private static ExpressionBuilder.ExpressionBuilderFactory ef = new ExpressionBuilder.ExpressionBuilderFactory();
    private VStackRecipePayloadParams params;
    private Map<String, Dataset> sources;
    private Dataset outputDataset;
    private Map<String, PartitioningScheme> sourcePartitionSchemes;
    private Map<String, List<Partition>> sourcePartitions;
    private PartitioningScheme targetPartitionScheme;
    static DKULogger logger = DKULogger.getLogger((String)"dku.sql.union");

    public VStackQueryGenerator(VStackRecipePayloadParams params, Map<String, Dataset> sources, Dataset outputDataset) {
        this.params = params;
        this.sources = sources;
        this.outputDataset = outputDataset;
    }

    public void setPartitioning(Map<String, PartitioningScheme> sourcePartitionSchemes, Map<String, List<Partition>> sourcePartitions, PartitioningScheme targetPartitionScheme) {
        this.sourcePartitionSchemes = sourcePartitionSchemes;
        this.sourcePartitions = sourcePartitions;
        this.targetPartitionScheme = targetPartitionScheme;
    }

    public String generateSQL(SQLDialect dialect) throws IOException {
        CombinedSelectQueryBuilder union = this.generateCombinedQueries(dialect);
        if (dialect instanceof HiveSQLDialect && !((HiveSQLDialect)dialect).supportsTopLevelUnion()) {
            SelectQueryBuilder qb = new SelectQueryBuilder();
            qb.comment("Hive does not support top-level unions");
            qb.from(union, "wrapped");
            return qb.toSQL(dialect);
        }
        return union.toSQL(dialect);
    }

    private CombinedSelectQueryBuilder generateCombinedQueries(SQLDialect dialect) throws IOException {
        boolean deduplicate = this.params.postFilter != null && this.params.postFilter.distinct;
        CombinedSelectQueryBuilder union = CombinedSelectQueryBuilder.newUnion(deduplicate);
        for (VStackRecipePayloadParams.InputDesc inputDesc : this.params.virtualInputs) {
            if (!this.sources.containsKey(inputDesc.name)) {
                throw ErrorContext.iaef((String)"Dataset '%s' is not in the recipe sources. Has %s", (Object)inputDesc.name, (Object[])new Object[]{this.sources.keySet().toString()});
            }
            Dataset source = this.sources.get(inputDesc.name);
            Schema inputSchema = source.getSchema();
            SQLUtils.SQLTable table = DatasetUtils.getResolvedTableWithSparkSQLFallback(source, dialect, this.params.engineParams);
            List<String> columnsMatch = inputDesc.columnsMatch;
            Schema outputSchema = this.outputDataset.getSchema();
            SelectQueryBuilder subQuery = this.params.addOriginColumn ? this.generateSubQuery(table, source, inputSchema, outputSchema, true, this.params.originColumnName, inputDesc.originLabel, columnsMatch, dialect) : this.generateSubQuery(table, source, inputSchema, outputSchema, false, null, null, columnsMatch, dialect);
            if (this.targetPartitionScheme != null) {
                for (String col : this.targetPartitionScheme.getDimensionNames()) {
                    if (outputSchema.getColumn(col) != null) continue;
                    SchemaColumn sc = outputSchema.getColumnOrDefault(col, Type.STRING);
                    subQuery.select(ef.dstPartitionId(sc, this.targetPartitionScheme.getDimension(col)), col);
                }
            }
            QueryGenerationUtils.preFilter(subQuery, inputDesc.preFilter, dialect, source, false);
            if (this.params.postFilter != null) {
                if (this.params.addOriginColumn && dialect.needSubQueryForConstantInWhereClause()) {
                    subQuery = this.generateIntermediateSubQuery(subQuery);
                }
                QueryGenerationUtils.preFilter(subQuery, this.params.postFilter, dialect, source, false);
            }
            if (this.sourcePartitions != null && this.sourcePartitions.get(inputDesc.name) != null && table.isTrueTable()) {
                ExpressionBuilder partitionFilterExpression = ExpressionUtils.getPartitionFilterClause(this.sourcePartitionSchemes.get(inputDesc.name), this.sources.get(inputDesc.name), this.sourcePartitions.get(inputDesc.name), dialect);
                subQuery.where(partitionFilterExpression);
            }
            subQuery = QueryGenerationUtils.applyInsertIntoCasts(subQuery, dialect, this.outputDataset);
            union.add(subQuery);
        }
        return union;
    }

    private SelectQueryBuilder generateIntermediateSubQuery(SelectQueryBuilder subQuery) {
        SelectQueryBuilder query = new SelectQueryBuilder();
        subQuery.getSelectedNames().forEach(query::select);
        query.from(subQuery, "tableWithOriginal");
        return query;
    }

    private ExpressionBuilder recast(ExpressionBuilder col, Type targetType, Dataset source, @Nullable SchemaColumn sc, SQLDialect dialect) {
        switch (targetType) {
            case TINYINT: 
            case SMALLINT: 
            case INT: {
                return col.castToInt();
            }
            case BIGINT: {
                return col.castToBigint();
            }
            case FLOAT: {
                return col.castToFloat();
            }
            case BOOLEAN: {
                return col.castToBoolean();
            }
            case DATE: {
                if (source.isManaged() || sc == null || !sc.getType().isTemporal() || sc.getType() == Type.DATE) {
                    logger.info((Object)"Column is not temporal or the dataset is managed, casting to date");
                    return col.castToDate();
                }
                SchemaColumn adjustedSc = new SchemaColumn(sc).withType(Type.DATE).withTimestampNoTzAsDate(true);
                ExpressionBuilder adjusted = ExpressionUtils.getAdjustedColumn(col, adjustedSc, source, dialect);
                if (adjusted == col) {
                    logger.info((Object)"Column was not adjusted as expected, casting to date");
                    return col.castToDate();
                }
                return adjusted;
            }
            case DATETIMENOTZ: {
                return col.castToDatetimeNoTz();
            }
            case STRING: {
                return col.castToString(dialect.getDefaultVarcharLen());
            }
        }
        return col;
    }

    private SelectQueryBuilder generateSubQuery(SQLUtils.SQLTable sourceTable, Dataset source, Schema inputSchema, Schema outputSchema, boolean addOriginColumn, String originColumnName, String originValue, List<String> columnsMatch, SQLDialect dialect) {
        SelectQueryBuilder query = new SelectQueryBuilder();
        List inputSchemaColumns = inputSchema.columns;
        Map<String, SchemaColumn> index = SchemaUtils.indexColumns(inputSchema);
        int columnNumber = 0;
        for (SchemaColumn sc : outputSchema.columns) {
            boolean columnExist;
            String colName = sc.getName();
            boolean bl = columnExist = index.get(colName) != null;
            if (addOriginColumn && colName.equals(originColumnName)) {
                query.select(ef.cst(originValue), originColumnName);
            } else if (this.targetPartitionScheme != null && this.targetPartitionScheme.getDimension(colName) != null) {
                query.select(ef.dstPartitionId(sc, this.targetPartitionScheme.getDimension(colName)), colName);
            } else if (this.params.mode == VStackRecipePayloadParams.SchemaMergeMode.FROM_INDEX) {
                if (columnNumber < this.params.selectedColumnsIndexes.size()) {
                    int targetColumnNumber = this.params.selectedColumnsIndexes.get(columnNumber);
                    if (targetColumnNumber >= 0 && targetColumnNumber < inputSchemaColumns.size()) {
                        SchemaColumn originColumn = (SchemaColumn)inputSchemaColumns.get(targetColumnNumber);
                        String originName = originColumn.getName();
                        Type originType = originColumn.getType();
                        ExpressionBuilder col = ExpressionUtils.getAdjustedColumn(ef.col(originName), colName, source, dialect);
                        if (this.wasCastedToDate(col)) {
                            originType = Type.DATE;
                        }
                        if (!originType.equals((Object)sc.getType())) {
                            col = this.recast(col, sc.getType(), source, originColumn, dialect);
                        }
                        query.select(col, colName);
                    } else if (columnExist) {
                        col = ExpressionUtils.getAdjustedColumn(ef.col(colName), colName, source, dialect);
                        query.select(col, colName);
                    } else {
                        query.select(ef.nullValue(sc.getType(), sc.getMaxLength()), colName);
                    }
                } else if (columnExist) {
                    ExpressionBuilder col = ExpressionUtils.getAdjustedColumn(ef.col(colName), colName, source, dialect);
                    query.select(col, colName);
                } else {
                    query.select(ef.nullValue(sc.getType(), sc.getMaxLength()), colName);
                }
            } else if (this.params.mode == VStackRecipePayloadParams.SchemaMergeMode.REMAP) {
                String originName = null;
                SchemaColumn originSc = null;
                if (columnNumber < columnsMatch.size() && (originName = columnsMatch.get(columnNumber)) != null) {
                    originSc = index.get(originName);
                }
                if (originName != null) {
                    Type originType = originSc != null ? originSc.getType() : null;
                    ExpressionBuilder col = ExpressionUtils.getAdjustedColumn(ef.col(originName), originName, source, dialect);
                    if (this.wasCastedToDate(col)) {
                        originType = Type.DATE;
                    }
                    if (originType != null && !sc.getType().equals((Object)originType)) {
                        col = this.recast(col, sc.getType(), source, originSc, dialect);
                    }
                    query.select(col, colName);
                } else if (columnExist) {
                    col = ExpressionUtils.getAdjustedColumn(ef.col(colName), colName, source, dialect);
                    query.select(col, colName);
                } else {
                    query.select(ef.nullValue(sc.getType(), sc.getMaxLength()), colName);
                }
            } else if (columnExist) {
                ExpressionBuilder col = ExpressionUtils.getAdjustedColumn(ef.col(colName), colName, source, dialect);
                query.select(col, colName);
            } else {
                query.select(ef.nullValue(sc.getType(), sc.getMaxLength()), colName);
            }
            ++columnNumber;
        }
        query.from(sourceTable, null);
        return query;
    }

    private boolean wasCastedToDate(ExpressionBuilder col) {
        if (col.expr instanceof QueryAst.OperatorExpr) {
            QueryUtils.OperatorType op = ((QueryAst.OperatorExpr)col.expr).op;
            return op == QueryUtils.OperatorType.FROM_TIMEZONE || op == QueryUtils.OperatorType.FROM_TIMEZONE_NTZ;
        }
        return false;
    }
}

