/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.pdep;

import com.dataiku.dip.coremodel.Partitionable;
import com.dataiku.dip.dataflow.pdep.DimensionDependencyEvaluator;
import com.dataiku.dip.partitioning.Dimension;
import com.dataiku.dip.partitioning.DimensionValue;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.security.AuthCtx;
import com.google.common.collect.Lists;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class AllAvailableEvaluator
extends DimensionDependencyEvaluator {
    private final Partitionable dataset;
    private final AuthCtx authCtx;
    private static Logger logger = Logger.getLogger((String)"dku.pdep");

    public AllAvailableEvaluator(AuthCtx authCtx, Partitionable dataset, boolean doWarn) {
        this.authCtx = authCtx;
        this.dataset = dataset;
        if (doWarn) {
            logger.warn((Object)"The configured partition dependency value is not compatible with the redispatch option. Using \u201call available\u201d as fallback.");
        }
    }

    @Override
    public List<DimensionValue> getDependent(DimensionValue target, Dimension srcDim, Map<String, List<Partition>> datasetPartitionCache) throws Exception {
        List<Partition> partitions = this.getPartitionList(this.dataset, this.authCtx, datasetPartitionCache);
        HashSet<DimensionValue> ret = new HashSet<DimensionValue>();
        for (Partition p : partitions) {
            ret.add((DimensionValue)p.getDimensionValues().get(srcDim.getName()));
        }
        return Lists.newArrayList(ret);
    }

    @Override
    public List<DimensionValue> getDependent(DimensionValue target, Dimension srcDim) throws Exception {
        return this.getDependent(target, srcDim, null);
    }
}

