/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.pdep;

import com.dataiku.dip.coremodel.Partitionable;
import com.dataiku.dip.datasets.PartitionableHandler;
import com.dataiku.dip.partitioning.Dimension;
import com.dataiku.dip.partitioning.DimensionValue;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.security.AuthCtx;
import java.util.List;
import java.util.Map;

public abstract class DimensionDependencyEvaluator {
    public List<DimensionValue> getDependent(DimensionValue target, Dimension srcDim, Map<String, List<Partition>> datasetPartitionCache) throws Exception {
        return this.getDependent(target, srcDim);
    }

    public abstract List<DimensionValue> getDependent(DimensionValue var1, Dimension var2) throws Exception;

    protected List<Partition> getPartitionList(Partitionable dataset, AuthCtx authCtx, Map<String, List<Partition>> datasetPartitionCache) throws Exception {
        List<Partition> partitions;
        if (datasetPartitionCache != null && datasetPartitionCache.containsKey(dataset.getFullName())) {
            partitions = datasetPartitionCache.get(dataset.getFullName());
        } else {
            try (PartitionableHandler handler = dataset.buildHandler(authCtx);){
                partitions = handler.listPartitions();
                if (datasetPartitionCache != null) {
                    datasetPartitionCache.put(dataset.getFullName(), partitions);
                }
            }
        }
        return partitions;
    }
}

