/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datalayer.window;

import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.sort.RowValueAccessorFactory;
import javax.annotation.Nonnull;

public abstract class WindowAggregation {
    protected final Column column;
    protected final Column result;
    protected final RowValueAccessorFactory.ValueReader valueReader;
    protected final RowValueAccessorFactory.ValueWriter valueWriter;
    private final SchemaColumn schemaResult;

    public WindowAggregation(Column column, Column result, @Nonnull SchemaColumn schemaColumn, SchemaColumn schemaResult) {
        this.column = column;
        this.result = result;
        this.schemaResult = schemaResult;
        this.valueReader = column != null ? RowValueAccessorFactory.getReader(schemaColumn, column) : null;
        this.valueWriter = RowValueAccessorFactory.getWriter(schemaResult, result);
    }

    public abstract boolean needsReset();

    public abstract void reset();

    public void expand(Row row) {
        this.expandInternal(this.valueReader.read(row));
    }

    public void shrink(Row row) {
        this.shrinkInternal(this.valueReader.read(row));
    }

    public void produceValue(Row row) {
        Object value = this.produceValueInternal();
        if (value != null) {
            this.valueWriter.write(row, value);
        }
    }

    public abstract void expandInternal(Object var1);

    public abstract void shrinkInternal(Object var1);

    public abstract Object produceValueInternal();

    public SchemaColumn getSchemaResult() {
        return this.schemaResult;
    }
}

