/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets;

import com.dataiku.dip.classpathfix.DKUDoubles;
import com.dataiku.dip.classpathfix.DKUInts;
import com.dataiku.dip.classpathfix.DKULongs;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.i18n.TranslationService;
import com.dataiku.dip.shaker.types.Boolean;
import com.dataiku.dip.shaker.types.Date;
import com.dataiku.dip.shaker.types.DateOnly;
import com.dataiku.dip.shaker.types.DatetimeNoTz;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.warnings.RecordContext;
import com.dataiku.dip.warnings.WarningsContext;
import org.apache.commons.lang.StringUtils;

public class StorageTypeVerifier {
    private Date dateMeaning = new Date();
    private DateOnly dateOnlyMeaning = new DateOnly();
    private DatetimeNoTz datetimeNoTzMeaning = new DatetimeNoTz();
    private static Boolean booleanMeaning = new Boolean();
    private static DKULogger logger = DKULogger.getLogger((String)"dku.datasets.storage.types");

    private WarningsContext.WarningType isOKTimestamp(String value, boolean output) {
        if (this.dateMeaning.validates(value)) {
            return null;
        }
        return output ? WarningsContext.WarningType.OUTPUT_DATA_BAD_DATE : WarningsContext.WarningType.INPUT_DATA_BAD_DATE;
    }

    private WarningsContext.WarningType isOKDateOnly(String value, boolean output) {
        if (this.dateOnlyMeaning.validates(value)) {
            return null;
        }
        return output ? WarningsContext.WarningType.OUTPUT_DATA_BAD_DATE : WarningsContext.WarningType.INPUT_DATA_BAD_DATE;
    }

    private WarningsContext.WarningType isOKDatetimeNoTz(String value, boolean output) {
        if (this.datetimeNoTzMeaning.validates(value)) {
            return null;
        }
        return output ? WarningsContext.WarningType.OUTPUT_DATA_BAD_DATE : WarningsContext.WarningType.INPUT_DATA_BAD_DATE;
    }

    private static WarningsContext.WarningType isOKInt(String value, Type type, boolean output) {
        switch (type) {
            case TINYINT: {
                Integer i = DKUInts.tryParse((String)value);
                if (i == null) {
                    return output ? WarningsContext.WarningType.OUTPUT_DATA_BAD_INT : WarningsContext.WarningType.INPUT_DATA_BAD_INT;
                }
                if (i > 127 || i < -128) {
                    return output ? WarningsContext.WarningType.OUTPUT_DATA_INT_OOR : WarningsContext.WarningType.INPUT_DATA_INT_OOR;
                }
                return null;
            }
            case SMALLINT: {
                Integer i = DKUInts.tryParse((String)value);
                if (i == null) {
                    return output ? WarningsContext.WarningType.OUTPUT_DATA_BAD_INT : WarningsContext.WarningType.INPUT_DATA_BAD_INT;
                }
                if (i > Short.MAX_VALUE || i < Short.MIN_VALUE) {
                    return output ? WarningsContext.WarningType.OUTPUT_DATA_INT_OOR : WarningsContext.WarningType.INPUT_DATA_INT_OOR;
                }
                return null;
            }
            case INT: {
                Integer i = DKUInts.tryParse((String)value);
                if (i == null) {
                    return output ? WarningsContext.WarningType.OUTPUT_DATA_BAD_INT : WarningsContext.WarningType.INPUT_DATA_BAD_INT;
                }
                return null;
            }
            case BIGINT: {
                Long i = DKULongs.tryParse((String)value);
                if (i == null) {
                    return output ? WarningsContext.WarningType.OUTPUT_DATA_BAD_INT : WarningsContext.WarningType.INPUT_DATA_BAD_INT;
                }
                return null;
            }
        }
        throw new Error("unreachable");
    }

    private static WarningsContext.WarningType isOKDouble(String value, boolean output) {
        if (!DKUDoubles.isWellFormattedDouble((String)value)) {
            return output ? WarningsContext.WarningType.OUTPUT_DATA_BAD_FLOAT : WarningsContext.WarningType.INPUT_DATA_BAD_FLOAT;
        }
        return null;
    }

    private static WarningsContext.WarningType isOKBoolean(String value, boolean output) {
        if (booleanMeaning.validates(value)) {
            return null;
        }
        return output ? WarningsContext.WarningType.OUTPUT_DATA_BAD_BOOLEAN : WarningsContext.WarningType.INPUT_DATA_BAD_BOOLEAN;
    }

    public static String buildWarningMessage(String value, SchemaColumn column, WarningsContext wc, RecordContext rc) {
        Object ctx = "";
        if (rc != null && rc.getFileNoNull() != null) {
            ctx = (String)ctx + "file=" + rc.getFileNoNull() + " line=" + rc.getLineNoNull() + " ";
        }
        ctx = (String)ctx + "column=" + column.getName() + " type=" + String.valueOf(column.getType()) + " val=" + value;
        return ctx;
    }

    public static String normalize(String value, SchemaColumn column) {
        if (value == null || value.length() == 0) {
            return value;
        }
        if (column.getType() == Type.BOOLEAN) {
            return "" + booleanMeaning.parse(value);
        }
        if (column.getType().isTemporal()) {
            return value;
        }
        return value;
    }

    public String verify(String value, SchemaColumn column, DataTypeMismatchBehavior behav, WarningsContext wc, RecordContext rc) {
        return this.verify(value, column, behav, wc, rc, false);
    }

    public String verify(String value, SchemaColumn column, DataTypeMismatchBehavior behav, WarningsContext wc, RecordContext rc, boolean output) {
        if (behav == null) {
            return value;
        }
        if (behav == DataTypeMismatchBehavior.IGNORE_SILENT) {
            return value;
        }
        if (StringUtils.isBlank((String)value)) {
            return null;
        }
        WarningsContext.WarningType wt = null;
        switch (column.getType()) {
            case TINYINT: 
            case SMALLINT: 
            case INT: 
            case BIGINT: {
                wt = StorageTypeVerifier.isOKInt(value, column.getType(), output);
                break;
            }
            case DOUBLE: 
            case FLOAT: {
                wt = StorageTypeVerifier.isOKDouble(value, output);
                break;
            }
            case DATE: {
                wt = this.isOKTimestamp(value, output);
                break;
            }
            case DATETIMENOTZ: {
                wt = this.isOKDatetimeNoTz(value, output);
                break;
            }
            case DATEONLY: {
                wt = this.isOKDateOnly(value, output);
                break;
            }
            case BOOLEAN: {
                wt = StorageTypeVerifier.isOKBoolean(value, output);
                break;
            }
            case GEOMETRY: 
            case GEOPOINT: {
                break;
            }
            case ARRAY: 
            case MAP: 
            case OBJECT: {
                break;
            }
        }
        if (wt == null) {
            return value;
        }
        String ctx = StorageTypeVerifier.buildWarningMessage(value, column, wc, rc);
        switch (behav) {
            case DISCARD_SILENT: {
                return null;
            }
            case DISCARD_WARNING: {
                wc.addWarning(wt, ctx, logger);
                return null;
            }
            case IGNORE_WARNING: {
                wc.addWarning(wt, ctx, logger);
                return value;
            }
            case ERROR: {
                throw ErrorContext.iae((String)("Data verify error: warning=" + String.valueOf(wt) + " " + ctx));
            }
            case IGNORE_SILENT: {
                throw new Error("unreachable");
            }
        }
        throw new Error("unreachable");
    }

    public static enum DataTypeMismatchBehavior {
        IGNORE_SILENT,
        DISCARD_SILENT,
        IGNORE_WARNING,
        DISCARD_WARNING,
        ERROR;


        public static String[] valueNames() {
            return new String[]{"IGNORE_SILENT", "DISCARD_SILENT", "IGNORE_WARNING", "DISCARD_WARNING", "ERROR"};
        }

        public static String[] labels() {
            return new String[]{"Ignore (leave bad data)", "Discard bad data", "Ignore and emit warning", "Discard and emit warning", "Fail"};
        }

        public static String[] labels(TranslationService translationService, String lang) {
            if (translationService == null) {
                return DataTypeMismatchBehavior.labels();
            }
            return new String[]{translationService.translate(lang, "STORAGE_TYPE_VERIFIER.LABELS.IGNORE_SILENT", "Ignore (leave bad data)", new Object[0]), translationService.translate(lang, "STORAGE_TYPE_VERIFIER.LABELS.DISCARD_SILENT", "Discard bad data", new Object[0]), translationService.translate(lang, "STORAGE_TYPE_VERIFIER.LABELS.IGNORE_WARNING", "Ignore and emit warning", new Object[0]), translationService.translate(lang, "STORAGE_TYPE_VERIFIER.LABELS.DISCARD_WARNING", "Discard and emit warning", new Object[0]), translationService.translate(lang, "STORAGE_TYPE_VERIFIER.LABELS.ERROR", "Fail", new Object[0])};
        }
    }
}

