/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.dynamodb;

import com.dataiku.dip.connections.ConnectionWithBasicCredential;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.DynamoDBConnection;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.aws.AWSClientBrokerService;
import com.dataiku.dip.security.model.ICredentialsService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.connections.ConnectionCodes;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.auth.credentials.AwsCredentials;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.awscore.client.builder.AwsClientBuilder;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.regions.Region;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.dynamodb.DynamoDbClientBuilder;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.dynamodb.model.ListTablesRequest;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.lang.StringUtils;

public class DynamoDBConnectionWrapper
implements Closeable {
    public final DynamoDBConnection connection;
    public final DynamoDbClient client;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.dynamodb");

    public static DynamoDBConnectionWrapper get(AuthCtx authCtx, String connectionName) throws IOException, DKUSecurityException, CodedException {
        ConnectionsDAO connectionsDAO = (ConnectionsDAO)SpringUtils.getBean(ConnectionsDAO.class);
        DynamoDBConnection conn = connectionsDAO.getMandatoryConnectionAs(authCtx, connectionName, DynamoDBConnection.class);
        return new DynamoDBConnectionWrapper(authCtx, conn);
    }

    public DynamoDBConnectionWrapper(AuthCtx authCtx, DynamoDBConnection conn) throws IOException, DKUSecurityException, CodedException {
        this.connection = conn;
        this.client = this.buildClient(authCtx, conn);
    }

    @Override
    public void close() throws IOException {
        this.client.close();
    }

    public void testConnection() {
        this.client.listTables((ListTablesRequest)ListTablesRequest.builder().limit(Integer.valueOf(1)).build());
    }

    private DynamoDbClient buildClient(AuthCtx authCtx, DynamoDBConnection conn) throws DKUSecurityException, IOException, CodedException {
        AWSClientBrokerService awsClientBrokerService = (AWSClientBrokerService)SpringUtils.getBean(AWSClientBrokerService.class);
        DynamoDbClientBuilder dynamoDbClientBuilder = awsClientBrokerService.createDynamoDbClientBuilder();
        switch (conn.params.mode) {
            case WEBSERVICE: {
                return this.buildWebServiceClient(authCtx, conn, conn.params.regionOrEndpoint, dynamoDbClientBuilder);
            }
            case LOCAL: {
                return this.buildLocalClient(authCtx, conn, dynamoDbClientBuilder);
            }
        }
        throw new IllegalStateException("Unexpected DynamoDB connection mode: " + String.valueOf((Object)conn.params.mode));
    }

    private DynamoDbClient buildWebServiceClient(AuthCtx authCtx, DynamoDBConnection conn, String regionOrEndpoint, DynamoDbClientBuilder dynamoDbClientBuilder) throws DKUSecurityException, IOException, CodedException {
        if (!conn.params.useDefaultCredentials) {
            StaticCredentialsProvider credentialsProvider = StaticCredentialsProvider.create((AwsCredentials)this.getBasicAWSCredentials(authCtx, conn));
            dynamoDbClientBuilder.credentialsProvider((AwsCredentialsProvider)credentialsProvider);
        }
        try {
            AWSClientBrokerService.setRegionOrEndpoint((String)regionOrEndpoint, (AwsClientBuilder)dynamoDbClientBuilder);
        }
        catch (Exception e) {
            throw new CodedException((InfoMessage.MessageCode)ConnectionCodes.ERR_CONNECTION_DYNAMODB_INVALID_CONFIG, "Error setting up client. Invalid endpoint or region: " + regionOrEndpoint, (Throwable)e);
        }
        return (DynamoDbClient)dynamoDbClientBuilder.build();
    }

    private DynamoDbClient buildLocalClient(AuthCtx authCtx, DynamoDBConnection conn, DynamoDbClientBuilder dynamoDbClientBuilder) throws DKUSecurityException, IOException, CodedException {
        URI endpoint;
        try {
            endpoint = new URI("http://" + conn.params.hostname + ":" + conn.params.port);
        }
        catch (URISyntaxException e) {
            throw new CodedException((InfoMessage.MessageCode)ConnectionCodes.ERR_CONNECTION_DYNAMODB_INVALID_CONFIG, "Error setting up client. Invalid endpoint: http://" + conn.params.hostname + ":" + conn.params.port, (Throwable)e);
        }
        if (!conn.params.useDefaultCredentials) {
            dynamoDbClientBuilder.credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)this.getBasicAWSCredentials(authCtx, conn)));
        }
        return (DynamoDbClient)((DynamoDbClientBuilder)((DynamoDbClientBuilder)dynamoDbClientBuilder.endpointOverride(endpoint)).region(Region.EU_WEST_3)).build();
    }

    private AwsBasicCredentials getBasicAWSCredentials(AuthCtx authCtx, DynamoDBConnection conn) throws DKUSecurityException, IOException {
        ICredentialsService.BasicCredential cred = conn.getFullyResolvedCredentials_fsLike(new ConnectionWithBasicCredential.CredentialResolutionContext(authCtx, null), ICredentialsService.BasicCredential.class);
        DynamoDBConnectionWrapper.checkNotBlank(cred.user, "missing access key for connection %s", conn.name);
        DynamoDBConnectionWrapper.checkNotBlank(cred.password, "missing secret key for connection %s", conn.name);
        return AwsBasicCredentials.create((String)cred.user, (String)cred.password);
    }

    private static void checkNotBlank(String str, String err, String arg) {
        if (StringUtils.isBlank((String)str)) {
            throw ErrorContext.iaef((String)err, (Object)arg, (Object[])new Object[0]);
        }
    }
}

