/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.dynamodb;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datasets.DatasetCodes;
import com.dataiku.dip.datasets.dynamodb.DynamoDBConnectionWrapper;
import com.dataiku.dip.datasets.dynamodb.DynamoDBDatasetHandler;
import com.dataiku.dip.datasets.dynamodb.DynamoDBDatasetInputHandler;
import com.dataiku.dip.datasets.dynamodb.DynamoDBOutput;
import com.dataiku.dip.datasets.dynamodb.DynamoDBTypeConverter;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.input.InputSplit;
import com.dataiku.dip.input.InputSplitProgressListener;
import com.dataiku.dip.input.filter.FilterResultWithSplits;
import com.dataiku.dip.input.filter.InputFilter;
import com.dataiku.dip.input.formats.ExtractionLimit;
import com.dataiku.dip.input.row.RowSequenceInputSplit;
import com.dataiku.dip.input.row.RowsInputSplit;
import com.dataiku.dip.partitioning.Dimension;
import com.dataiku.dip.partitioning.DimensionValue;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitionFactory;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.warnings.WarningsContext;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.dynamodb.model.AttributeDefinition;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.dynamodb.model.BatchWriteItemRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.dynamodb.model.DescribeTableResponse;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.dynamodb.model.DynamoDbException;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.dynamodb.model.KeySchemaElement;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.dynamodb.model.QueryRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.dynamodb.model.QueryResponse;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.dynamodb.model.ScanRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.dynamodb.model.ScanResponse;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.dynamodb.model.TableDescription;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.dynamodb.model.WriteRequest;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class PartitionedDynamoDBDatasetInputHandler
extends DynamoDBDatasetInputHandler {
    protected List<Partition> explicitPartitionsList;
    protected String column;
    protected PartitioningScheme scheme;

    public PartitionedDynamoDBDatasetInputHandler(DynamoDBDatasetHandler datasetHandler) {
        this.datasetHandler = datasetHandler;
        this.column = datasetHandler.config.partitioningColumn;
        this.scheme = datasetHandler.getDataset().getPartitioningSchema();
        assert (this.scheme.getSingleDimension().getName().equals(this.column));
        String explicitPartitionSpec = datasetHandler.config.explicitPartitionsList;
        if (StringUtils.isNotBlank((String)explicitPartitionSpec)) {
            this.explicitPartitionsList = PartitionFactory.fromPartitionSpec(this.scheme, explicitPartitionSpec);
        }
    }

    @Override
    public void createManaged() throws Exception {
        try (DynamoDBConnectionWrapper dynamoConn = this.datasetHandler.getNewConnection();){
            logger.info((Object)("Creating table: " + this.datasetHandler.config.table + " with partitioning on " + this.column));
            DynamoDBOutput.DynamoDBOutputWriter.createTable(dynamoConn, this.datasetHandler.config.table);
            String attributeType = new DynamoDBTypeConverter().toDynamoType(this.datasetHandler.getDataset().getSchema().getColumn(this.column).getType());
            DynamoDBOutput.DynamoDBOutputWriter.createIndexForPartitioning(dynamoConn, this.column, this.datasetHandler.config.table, attributeType);
        }
    }

    private String attributeValueToPartitionValue(AttributeValue value) throws CodedException {
        if (value.s() != null) {
            return value.s();
        }
        if (value.n() != null) {
            return value.n();
        }
        throw new CodedException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_PARTITIONING_CONFIG, "Attribute value type of '" + String.valueOf(value.type()) + "' not supported for partitioning column");
    }

    @Override
    public List<Partition> listPartitions() throws Exception {
        ArrayList<Partition> arrayList;
        block11: {
            if (this.explicitPartitionsList != null) {
                return this.explicitPartitionsList;
            }
            Dimension dimension = this.scheme.getSingleDimension();
            ArrayList<Partition> result = new ArrayList<Partition>();
            DynamoDBConnectionWrapper dynamoConn = this.datasetHandler.getNewConnection();
            try {
                ScanRequest scanRequest = (ScanRequest)ScanRequest.builder().tableName(this.datasetHandler.config.table).projectionExpression("#S").expressionAttributeNames(Map.of("#S", this.column)).build();
                for (ScanResponse scanResponse : dynamoConn.client.scanPaginator(scanRequest)) {
                    for (Map item : scanResponse.items()) {
                        Partition part = new Partition(this.scheme);
                        Iterator iterator = item.values().iterator();
                        if (!iterator.hasNext()) continue;
                        String v = this.attributeValueToPartitionValue((AttributeValue)iterator.next());
                        DimensionValue value = dimension.getValueFromId(v);
                        part.setDimensionValue(this.column, value);
                        if (result.contains(part)) continue;
                        result.add(part);
                    }
                }
                arrayList = result;
                if (dynamoConn == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (dynamoConn != null) {
                        try {
                            dynamoConn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    logger.warn((Object)("Error while listing partitions : " + String.valueOf(e)));
                    return result;
                }
            }
            dynamoConn.close();
        }
        return arrayList;
    }

    @Override
    public void updateIndex() throws Exception {
        try (DynamoDBConnectionWrapper dynamoConn = this.datasetHandler.getNewConnection();){
            this.deleteAllGlobalSecondaryIndexes(dynamoConn, this.datasetHandler.config.table);
            if (StringUtils.isNotBlank((String)this.column)) {
                String attributeType = this.setGSIAttributeType();
                DynamoDBOutput.DynamoDBOutputWriter.createIndexForPartitioning(dynamoConn, this.column, this.datasetHandler.config.table, attributeType);
            }
        }
        catch (DynamoDbException e) {
            logger.warn((Object)("Error while creating global secondary index : " + this.column + "Index " + String.valueOf((Object)e)));
        }
    }

    private Partition getSamplePartition() throws Exception {
        if (this.explicitPartitionsList != null) {
            return this.explicitPartitionsList.size() == 0 ? null : this.explicitPartitionsList.get(0);
        }
        Dimension dimension = this.scheme.getSingleDimension();
        try (DynamoDBConnectionWrapper dynamoConn = this.datasetHandler.getNewConnection();){
            logger.info((Object)("Looking up sample partition value for table " + this.datasetHandler.config.table + " with partitioning column " + this.column));
            ScanRequest scanRequest = (ScanRequest)ScanRequest.builder().tableName(this.datasetHandler.config.table).projectionExpression("#S").expressionAttributeNames(Map.of("#S", this.column)).limit(Integer.valueOf(10)).build();
            ScanResponse scanResponse = dynamoConn.client.scan(scanRequest);
            Iterator iterator = scanResponse.items().iterator();
            Map item = new HashMap();
            while (iterator.hasNext() && item.isEmpty()) {
                item = (Map)iterator.next();
            }
            if (item == null || !item.containsKey(this.column)) {
                Partition partition = null;
                return partition;
            }
            String v = this.attributeValueToPartitionValue((AttributeValue)item.values().iterator().next());
            Partition part = new Partition(this.scheme);
            DimensionValue value = dimension.getValueFromId(v);
            part.setDimensionValue(this.column, value);
            Partition partition = part;
            return partition;
        }
    }

    @Override
    public RowsInputSplit getPartitionSplit(Partition partition) throws Exception {
        return new PartitionSplit(partition);
    }

    private String setGSIAttributeType() throws IOException, DKUSecurityException, CodedException {
        try (DynamoDBConnectionWrapper dynamoConn = this.datasetHandler.getNewConnection();){
            ScanRequest scanRequest = (ScanRequest)ScanRequest.builder().tableName(this.datasetHandler.config.table).projectionExpression("#S").expressionAttributeNames(Map.of("#S", this.column)).limit(Integer.valueOf(10)).build();
            ScanResponse scanResponse = dynamoConn.client.scan(scanRequest);
            Iterator iterator = scanResponse.items().iterator();
            Map item = new HashMap();
            while (iterator.hasNext() && item.isEmpty()) {
                item = (Map)iterator.next();
            }
            if (item.containsKey(this.column)) {
                throw new IllegalArgumentException("Unknown partitioning column : " + this.column);
            }
            AttributeValue.Type type = ((AttributeValue)item.get(this.column)).type();
            if (type == AttributeValue.Type.N || type == AttributeValue.Type.S) {
                String string = type.toString();
                return string;
            }
            throw new CodedException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_PARTITIONING_CONFIG, "This partitioning column type is not supported for partitioning: " + String.valueOf(type));
        }
    }

    private String setValueType(List<AttributeDefinition> attributes) {
        String valueType = "";
        for (AttributeDefinition a : attributes) {
            if (!a.attributeName().equals(this.column)) continue;
            valueType = a.attributeTypeAsString();
            break;
        }
        return valueType;
    }

    private Map<String, AttributeValue> getAttributeValueMap(String valueType, String s) {
        if (valueType.equals("N")) {
            return Map.of(":val", AttributeValue.fromN((String)s));
        }
        return Map.of(":val", AttributeValue.fromS((String)s));
    }

    @Override
    public FilterResultWithSplits getFilterSplits(InputFilter filter) throws Exception {
        assert (filter != null);
        FilterResultWithSplits result = new FilterResultWithSplits();
        if (!filter.hasPartitionsFiltering()) {
            for (Partition partition : this.listPartitions()) {
                result.withMatchingPartition(partition).withSplit((InputSplit)this.getPartitionSplit(partition));
            }
        } else {
            for (Partition partition : filter.getPartitionsClause()) {
                result.withMatchingPartition(partition).withSplit((InputSplit)this.getPartitionSplit(partition));
            }
        }
        return result;
    }

    @Override
    public RowsInputSplit getSingleSplit() throws Exception {
        ArrayList<RowsInputSplit> splits = new ArrayList<RowsInputSplit>();
        for (Partition part : this.listPartitions()) {
            RowsInputSplit split = this.getPartitionSplit(part);
            splits.add(split);
        }
        return new RowSequenceInputSplit(splits);
    }

    @Override
    public RowsInputSplit getSampleSplit() throws Exception {
        Partition part = this.getSamplePartition();
        return part == null ? null : this.getPartitionSplit(part);
    }

    @Override
    public long computePartitionRecords(Partition partition) throws Exception {
        try (DynamoDBConnectionWrapper dynamoConn = this.datasetHandler.getNewConnection();){
            TableDescription tableDescription = dynamoConn.client.describeTable(builder -> builder.tableName(this.datasetHandler.config.table)).table();
            List attributes = tableDescription.attributeDefinitions();
            String valueType = this.setValueType(attributes);
            logger.info((Object)("Querying column " + this.column + " with value : " + ((DimensionValue)partition.getDimensionValues().get(this.column)).id()));
            QueryRequest queryRequest = this.prepareQueryRequestForPartition(valueType, partition);
            queryRequest = (QueryRequest)queryRequest.toBuilder().select("COUNT").build();
            long result = dynamoConn.client.queryPaginator(queryRequest).stream().mapToLong(QueryResponse::count).sum();
            logger.info((Object)("partition=" + ((DimensionValue)partition.getDimensionValues().get(this.column)).id() + " count=" + result));
            long l = result;
            return l;
        }
    }

    @Override
    public void clearPartitions(List<Partition> partitions) throws Exception {
        if (partitions.size() == 0) {
            return;
        }
        try (DynamoDBConnectionWrapper dynamoConn = this.datasetHandler.getNewConnection();){
            TableDescription tableDescription = dynamoConn.client.describeTable(builder -> builder.tableName(this.datasetHandler.config.table)).table();
            List attributes = tableDescription.attributeDefinitions();
            String valueType = this.setValueType(attributes);
            logger.info((Object)("Deleting partitions for table " + this.datasetHandler.config.table));
            String partitionKey = ((KeySchemaElement)tableDescription.keySchema().get(0)).attributeName();
            String sortKey = null;
            if (tableDescription.keySchema().size() > 1) {
                sortKey = ((KeySchemaElement)tableDescription.keySchema().get(1)).attributeName();
            }
            ArrayList<WriteRequest> deleteRequests = new ArrayList<WriteRequest>();
            for (Partition p : partitions) {
                QueryRequest queryRequest = this.prepareQueryRequestForPartition(valueType, p);
                for (QueryResponse queryResponse : dynamoConn.client.queryPaginator(queryRequest)) {
                    for (Map item : queryResponse.items()) {
                        Map<String, AttributeValue> keyToDelete = sortKey != null ? Map.of(partitionKey, (AttributeValue)item.get(partitionKey), sortKey, (AttributeValue)item.get(sortKey)) : Map.of(partitionKey, (AttributeValue)item.get(partitionKey));
                        deleteRequests.add((WriteRequest)WriteRequest.builder().deleteRequest(builder -> builder.key(keyToDelete)).build());
                        if ((long)deleteRequests.size() < 25L) continue;
                        BatchWriteItemRequest batchWriteItemRequest = (BatchWriteItemRequest)BatchWriteItemRequest.builder().requestItems(Map.of(this.datasetHandler.config.table, deleteRequests)).build();
                        dynamoConn.client.batchWriteItem(batchWriteItemRequest);
                        deleteRequests.clear();
                    }
                }
            }
            if (!deleteRequests.isEmpty()) {
                BatchWriteItemRequest batchWriteItemRequest = (BatchWriteItemRequest)BatchWriteItemRequest.builder().requestItems(Map.of(this.datasetHandler.config.table, deleteRequests)).build();
                dynamoConn.client.batchWriteItem(batchWriteItemRequest);
            }
        }
        catch (Exception e) {
            logger.warn((Object)("Error while clearing partition : " + String.valueOf(e)));
        }
    }

    private QueryRequest prepareQueryRequestForPartition(String valueType, Partition partition) {
        return (QueryRequest)QueryRequest.builder().tableName(this.datasetHandler.config.table).indexName(this.column + "Index").keyConditionExpression("#S = :val").expressionAttributeNames(Map.of("#S", this.column)).expressionAttributeValues(this.getAttributeValueMap(valueType, ((DimensionValue)partition.getDimensionValues().get(this.column)).id())).build();
    }

    class PartitionSplit
    extends RowsInputSplit {
        Partition partition;

        PartitionSplit(Partition partition) {
            this.partition = partition;
        }

        @Override
        public long push(ProcessorOutput out, ColumnFactory cf, RowFactory rf, ExtractionLimit limit, InputSplitProgressListener listener, WarningsContext warningsContext) throws Exception {
            DescribeTableResponse describeResponse;
            try (DynamoDBConnectionWrapper dynamoConn = PartitionedDynamoDBDatasetInputHandler.this.datasetHandler.getNewConnection();){
                describeResponse = dynamoConn.client.describeTable(builder -> builder.tableName(PartitionedDynamoDBDatasetInputHandler.this.datasetHandler.config.table));
            }
            List attributes = describeResponse.table().attributeDefinitions();
            String valueType = PartitionedDynamoDBDatasetInputHandler.this.setValueType(attributes);
            if (StringUtils.isBlank((String)valueType)) {
                throw new CodedException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_PARTITIONING_CONFIG, "The index " + PartitionedDynamoDBDatasetInputHandler.this.column + "Index doesn't exist : either partitioning column doesn't exist or column type is not supported for partitioning");
            }
            QueryRequest queryRequest = PartitionedDynamoDBDatasetInputHandler.this.prepareQueryRequestForPartition(valueType, this.partition);
            return PartitionedDynamoDBDatasetInputHandler.this.executePush(queryRequest, out, cf, rf, limit, listener, warningsContext);
        }

        public String getDesc() {
            return "DynamoDB partition " + this.partition.id();
        }
    }
}

