/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.fs;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.FsConnection;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.datasets.FSProviderCodes;
import com.dataiku.dip.datasets.fs.ACLAware;
import com.dataiku.dip.datasets.fs.AbstractFSEnumerationResult;
import com.dataiku.dip.datasets.fs.ChrootUtils;
import com.dataiku.dip.datasets.fs.FSDatasetUtils;
import com.dataiku.dip.datasets.fs.FSLikeFSProvider;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.CodedIOException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.fs.FSBrowsePath;
import com.dataiku.dip.fs.FSEnumerationResult;
import com.dataiku.dip.fs.FSEnumerationSettings;
import com.dataiku.dip.fs.FSPath;
import com.dataiku.dip.fs.FSPathOrDirectory;
import com.dataiku.dip.fs.FSProvider;
import com.dataiku.dip.fs.PathToURIConverter;
import com.dataiku.dip.input.stream.AutoEnrichedInputStream;
import com.dataiku.dip.input.stream.EnrichedInputStream;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.impersonation.FilesystemACLUtils;
import com.dataiku.dip.security.impersonation.ImpersonationResolverService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.connections.ConnectionCodes;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.PathUtils;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class LocalFSProvider
extends FSLikeFSProvider
implements ACLAware,
PathToURIConverter {
    public static final int MAX_RECURSION_DEPTH = 20;
    private final FsConnection connection;
    private final File root;
    private static final boolean WINDOWS = DKUtils.isOsWindows();
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.fs.local");

    public LocalFSProvider(DSSConnection connection, String rootPath) throws IOException, DKUSecurityException, CodedException {
        assert (connection instanceof FsConnection);
        this.connection = (FsConnection)connection;
        rootPath = StringUtils.trimToEmpty((String)rootPath);
        this.root = LocalFSProvider.buildRoot(this.connection.params.root, rootPath);
        if (this.connection.params.root == null) {
            throw new CodedException((InfoMessage.MessageCode)ConnectionCodes.ERR_CONNECTION_INVALID_CONFIG, String.format("Please set \"%s\" connection's root path in the settings.", this.connection.name));
        }
        if (!DKUFileUtils.isWithinOrSame((File)new File(this.connection.params.root), (File)this.root)) {
            throw new DKUSecurityException("Cannot access '" + rootPath + "' outside the connection root directory").withCode((InfoMessage.MessageCode)FSProviderCodes.ERR_FSPROVIDER_FSLIKE_REACH_OUT_OF_ROOT);
        }
    }

    @Override
    public String getConnectionRootWithinURIAuthority() {
        return StringUtils.defaultIfEmpty((String)this.connection.params.root, (String)"");
    }

    @Override
    public String getRoot() {
        return this.root.getAbsolutePath();
    }

    public Map<String, String> getAccessInfo(boolean withSensitiveInfo) {
        HashMap ret = Maps.newHashMap();
        ret.put("root", this.root.getAbsolutePath());
        return ret;
    }

    public void makeEmpty(String path) throws IOException, DKUSecurityException {
        File file = this.makeFile(path);
        this.checkPathStaysInsideRoot(path, file);
        if (file.exists() && !file.isDirectory()) {
            new FileOutputStream(file).close();
        } else {
            if (file.exists()) {
                DKUFileUtils.forceDelete((File)file);
            }
            DKUFileUtils.mkdirs((File)file);
        }
    }

    public void ensureDirectory(String path) throws IOException, DKUSecurityException {
        File file = this.makeFile(path);
        this.checkPathStaysInsideRoot(path, file);
        if (file.exists() && !file.isDirectory()) {
            throw new IOException("Cannot make directory, '" + path + "' is a file");
        }
        DKUFileUtils.mkdirs((File)file);
    }

    public static LocalFSProvider makeFSProviderOnRoot(String path) throws IOException, DKUSecurityException, CodedException {
        FsConnection connection = new FsConnection();
        connection.params.root = path;
        return new LocalFSProvider(connection, "");
    }

    public FSBrowsePath browse(String prefix, FSProvider.FSBrowseStrategy strategy) throws IOException, DKUSecurityException {
        String path = this.makePath(prefix);
        File file = "/".equals(path) ? this.root : new File(this.root, path);
        this.checkPathStaysInsideRoot(path, file);
        FSBrowsePath ret = FSBrowsePath.makeRoot((String)path, (boolean)false);
        ret.exists = false;
        if (!file.exists()) {
            return ret;
        }
        if (file.isDirectory() && (strategy == FSProvider.FSBrowseStrategy.FILE_OR_DIRECTORY || strategy == FSProvider.FSBrowseStrategy.DIRECTORY)) {
            ret.exists = true;
            ret.directory = true;
            File[] subFiles = file.listFiles();
            if (subFiles == null) {
                logger.error((Object)("Can't list: " + file.getAbsolutePath()));
            } else {
                int enumerationLimit = DKUApp.getParams().getIntParam("dku.fsproviders.enumerationLimit", Integer.valueOf(1000000));
                for (File f : subFiles) {
                    if (!LocalFSProvider.isValidChunk(f.getName())) continue;
                    if (ret.children.size() + 1 > enumerationLimit) {
                        throw new CodedIOException((InfoMessage.MessageCode)FSProviderCodes.ERR_FSPROVIDER_TOO_MANY_FILES, String.format("There are too many files in this local file system location (> %d). Enumeration aborted.", enumerationLimit));
                    }
                    ret.children.add(FSBrowsePath.makeChild((FSBrowsePath)ret, (String)f.getName(), (boolean)f.isDirectory(), (long)f.length(), (long)f.lastModified()));
                }
            }
        } else if (!(file.isDirectory() || strategy != FSProvider.FSBrowseStrategy.FILE_OR_DIRECTORY && strategy != FSProvider.FSBrowseStrategy.FILE)) {
            ret.exists = true;
            ret.directory = false;
            ret.size = file.length();
            ret.lastModified = file.lastModified();
        }
        logger.debug((Object)("Browse done, have " + ret.children.size() + " sub-items"));
        return ret;
    }

    public FSEnumerationResult enumerateRecursive(String path, FSEnumerationSettings enumerationSettings) {
        String prefix = this.makePath(path);
        try {
            List<FSPath> paths = this.enumerateFilesystem(prefix, enumerationSettings);
            if (paths == null) {
                return LocalFSEnumerationResult.fromNonExistingPrefix();
            }
            return LocalFSEnumerationResult.fromPaths(enumerationSettings.filter(paths));
        }
        catch (Exception e) {
            return LocalFSEnumerationResult.fromError(e);
        }
    }

    public FSPathOrDirectory stat(String prefix) throws IOException, DKUSecurityException {
        String path = this.makePath(prefix);
        File file = this.makeFile(path);
        this.checkPathStaysInsideRoot(path, file);
        if (!file.exists()) {
            logger.warn((Object)("File does not exist: " + file.getAbsolutePath()));
            return null;
        }
        if (file.isDirectory()) {
            return new FSPathOrDirectory(path, 0L, file.lastModified(), file.isDirectory());
        }
        return new FSPathOrDirectory(path, file.length(), file.lastModified(), file.isDirectory());
    }

    public EnrichedInputStream read(String path) throws IOException, DKUSecurityException {
        File file = this.makeFile(path);
        this.checkPathStaysInsideRoot(path, file);
        return new FileEnrichedInputStream(file, path, file.getName(), file.getAbsolutePath());
    }

    public OutputStream write(String path) throws IOException, DKUSecurityException {
        this.checkConnectionWritability();
        File file = this.makeFile(path);
        this.checkPathStaysInsideRoot(path, file);
        DKUFileUtils.mkdirsParent((File)file);
        return new FileOutputStream(file);
    }

    public void deleteRecursive(String path) throws IOException, DKUSecurityException {
        this.checkConnectionWritability();
        File file = this.makeFile(path);
        this.checkPathStaysInsideRoot(path, file);
        String baseFolder = ApplicationConfigurator.getBaseFolderF().getCanonicalPath();
        if (baseFolder.startsWith(file.getCanonicalPath())) {
            throw new IOException("Safety guard against self-deletion");
        }
        if (file.exists()) {
            DKUFileUtils.forceDelete((File)file);
        }
    }

    private void rename(String from, String to) throws IOException, DKUSecurityException {
        this.checkConnectionWritability();
        File src = this.makeFile(from);
        File dst = this.makeFile(to);
        this.checkPathStaysInsideRoot(from, src);
        this.checkPathStaysInsideRoot(to, dst);
        if (dst.exists()) {
            FSDatasetUtils.raiseDestPathAlreadyExistsError(dst.getAbsolutePath(), dst.isDirectory());
        }
        this.ensureDirectory(PathUtils.getParent((String)to));
        if (!src.renameTo(dst)) {
            throw new IOException("Could not rename " + src.getAbsolutePath() + " to " + dst.getAbsolutePath());
        }
    }

    public void moveDirectory(String from, String to) throws IOException, DKUSecurityException {
        this.rename(from, to);
    }

    public void moveFile(String from, String to) throws IOException, DKUSecurityException {
        this.rename(from, to);
    }

    public void close() {
    }

    private List<FSPath> enumerateFilesystem(String path, FSEnumerationSettings settings) throws IOException, DKUSecurityException {
        String prefix = this.makePath(path);
        logger.debug((Object)("Enumerating local filesystem prefix=" + prefix));
        ArrayList<FSPath> ret = new ArrayList<FSPath>();
        File actualRoot = this.makeFile(prefix);
        this.checkPathStaysInsideRoot(prefix, actualRoot);
        if (!actualRoot.exists()) {
            return null;
        }
        if (actualRoot.isFile()) {
            ret.add(new FSPath(prefix, actualRoot.length(), actualRoot.lastModified()));
        } else if (!settings.selectionRules.excludesPrefix(prefix.substring(1))) {
            assert (actualRoot.isDirectory());
            LocalFSProvider.enumerateRec(actualRoot, prefix, ret, 0L, 0, settings);
        }
        logger.debugV("Enumeration done nb_paths=%s size=%s", new Object[]{ret.size(), FSPath.totalSize(ret)});
        return ret;
    }

    private static long enumerateRec(File cur, String relPath, List<FSPath> list, long previousTotalSize, int depth, FSEnumerationSettings settings) throws IOException {
        long totalSize = previousTotalSize;
        if (depth > 20) {
            throw new RuntimeException("Directory depth is too high (>20)");
        }
        ArrayList<File> ret = new ArrayList<File>();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(cur.toPath());){
            for (Path entry : stream) {
                ret.add(entry.toFile());
            }
        }
        catch (IOException e) {
            if (depth == 0) {
                throw new CodedIOException((InfoMessage.MessageCode)FSProviderCodes.ERR_FSPROVIDER_LOCAL_LIST_FAILED, "Failed to list filesystem root", (Throwable)e);
            }
            logger.error((Object)("Can't list:" + cur.getAbsolutePath()), (Throwable)e);
            return totalSize;
        }
        int enumerationLimit = DKUApp.getParams().getIntParam("dku.fsproviders.enumerationLimit", Integer.valueOf(1000000));
        for (File f : ret) {
            BasicFileAttributeView basicView = Files.getFileAttributeView(f.toPath(), BasicFileAttributeView.class, new LinkOption[0]);
            BasicFileAttributes basicAttribs = basicView.readAttributes();
            Object path = relPath + "/" + f.getName();
            path = PathUtils.slashes((String)path, (Boolean)true, (Boolean)false, (boolean)true, (String)"");
            if (basicAttribs.isRegularFile()) {
                if (LocalFSProvider.shouldSkipFile(settings, f, (String)path)) continue;
                if (list.size() + 1 > enumerationLimit) {
                    throw new CodedIOException((InfoMessage.MessageCode)FSProviderCodes.ERR_FSPROVIDER_TOO_MANY_FILES, String.format("There are too many files in this local file system location (> %d). Enumeration aborted.", enumerationLimit));
                }
                long l = basicAttribs.size();
                list.add(new FSPath((String)path, l, basicAttribs.lastModifiedTime().toMillis()));
                totalSize += l;
            } else if (basicAttribs.isDirectory() && !settings.selectionRules.excludesPrefix(((String)path).substring(1))) {
                totalSize = LocalFSProvider.enumerateRec(f, (String)path, list, totalSize, depth + 1, settings);
            }
            if (!settings.shouldStopEnumeration(list, totalSize)) continue;
            break;
        }
        return totalSize;
    }

    private static boolean shouldSkipFile(FSEnumerationSettings settings, File f, String path) {
        if (FSDatasetUtils.isBadFile(f.getName(), settings.showHiddenFiles) || FSDatasetUtils.isBadPath(path) || !settings.selectionRules.includes(path.substring(1))) {
            return true;
        }
        return settings.firstNonEmpty && f.length() == 0L;
    }

    private String makePath(String path) {
        if (path == null) {
            return "/";
        }
        if (WINDOWS) {
            Path fullPath = Paths.get(path, new String[0]);
            Path relativePath = fullPath.isAbsolute() ? this.root.toPath().relativize(fullPath) : fullPath;
            String canonicalPath = PathUtils.canonical((String)relativePath.toString().replaceAll("\\\\", "/"));
            return PathUtils.makeLeadingNoTrailing((String)canonicalPath);
        }
        return PathUtils.makeLeadingNoTrailing((String)PathUtils.canonical((String)path));
    }

    private void checkPathStaysInsideRoot(String path, File file) throws IOException, DKUSecurityException {
        if (!DKUFileUtils.isWithinOrSame((File)this.root, (File)file)) {
            throw new DKUSecurityException("Cannot access '" + path + "' outside the root directory").withCode((InfoMessage.MessageCode)FSProviderCodes.ERR_FSPROVIDER_FSLIKE_REACH_OUT_OF_ROOT);
        }
    }

    private File makeFile(String prefix) {
        String path = this.makePath(prefix);
        return path.isEmpty() || "/".equals(path) ? this.root : new File(this.root, path.substring(1));
    }

    static boolean isValidChunk(String chunk) {
        return !chunk.isEmpty() && !".".equals(chunk) && (WINDOWS || !chunk.startsWith("."));
    }

    @Override
    public void grantFullACLs(AuthCtx authCtx, String projectKey) throws IOException, InterruptedException, DKUSecurityException {
        ImpersonationResolverService impersonationService = (ImpersonationResolverService)SpringUtils.getBean(ImpersonationResolverService.class);
        if (impersonationService.isEnabled()) {
            logger.info((Object)"Making folder contents writable to user");
            if (this.root.isDirectory()) {
                FilesystemACLUtils.grantFSFullACLs(authCtx, projectKey, this.root);
            }
        }
    }

    @Override
    public void grantReadACLs(AuthCtx authCtx, String projectKey) throws DKUSecurityException, IOException, InterruptedException {
        ImpersonationResolverService impersonationService = (ImpersonationResolverService)SpringUtils.getBean(ImpersonationResolverService.class);
        if (impersonationService.isEnabled()) {
            logger.info((Object)"Making folder contents accessible to user");
            if (this.root.isDirectory()) {
                FilesystemACLUtils.grantFSReadACLs(authCtx, projectKey, this.root);
            }
        }
    }

    @Override
    public void tightenAccess(AuthCtx authCtx) throws IOException, InterruptedException {
        ImpersonationResolverService impersonationService = (ImpersonationResolverService)SpringUtils.getBean(ImpersonationResolverService.class);
        if (impersonationService.isEnabled()) {
            logger.info((Object)"Making folder contents belong solely to DSS");
            if (this.root.isDirectory()) {
                FilesystemACLUtils.restrictRwxToDSSUnconditionally(this.root);
            }
        }
    }

    private void checkConnectionWritability() {
        if (!this.connection.allowWrite) {
            throw new IllegalArgumentException("Cannot write on connection " + this.connection.name);
        }
    }

    public void setLastModified(String path, long lastModified) throws IOException, DKUSecurityException {
        File file = this.makeFile(path);
        this.checkPathStaysInsideRoot(path, file);
        if (!file.setLastModified(lastModified)) {
            throw new IOException("Cannot set the modification time");
        }
    }

    public String convertPathToURI(String prefix) {
        String path = this.makePath(prefix);
        File file = this.makeFile(path);
        return file.toURI().toString();
    }

    private static File buildRoot(String connectionRoot, String path) {
        if (WINDOWS) {
            if (LocalFSProvider.isRoot(connectionRoot)) {
                if (LocalFSProvider.isRoot(path)) {
                    return Paths.get("", new String[0]).toAbsolutePath().getRoot().toFile();
                }
                return Paths.get(path, new String[0]).toAbsolutePath().normalize().toFile();
            }
            if (LocalFSProvider.isRoot(path)) {
                return Paths.get(connectionRoot, new String[0]).toAbsolutePath().normalize().toFile();
            }
            Path p = Paths.get(path, new String[0]);
            if (p.isAbsolute()) {
                return p.normalize().toFile();
            }
            File connectionRootFile = Paths.get(connectionRoot, new String[0]).toAbsolutePath().normalize().toFile();
            return Paths.get(connectionRootFile.getAbsolutePath(), path).toAbsolutePath().normalize().toFile();
        }
        return new File(ChrootUtils.getChrootedPath(connectionRoot, path, false));
    }

    private static boolean isRoot(String path) {
        return path == null || path.isEmpty() || path.equals("/");
    }

    static class LocalFSEnumerationResult
    extends AbstractFSEnumerationResult {
        public LocalFSEnumerationResult() {
        }

        public LocalFSEnumerationResult(List<FSPath> paths) {
            super(paths);
        }

        public LocalFSEnumerationResult(Throwable error) {
            super(error);
        }

        private static LocalFSEnumerationResult fromError(Throwable error) {
            return new LocalFSEnumerationResult(error);
        }

        private static LocalFSEnumerationResult fromPaths(List<FSPath> paths) {
            return new LocalFSEnumerationResult(paths);
        }

        private static LocalFSEnumerationResult fromNonExistingPrefix() {
            return new LocalFSEnumerationResult();
        }
    }

    public static class FileEnrichedInputStream
    extends AutoEnrichedInputStream {
        File file;

        public FileEnrichedInputStream(File file, String pathWithinProvider, String filename, String desc) {
            super(file.length(), pathWithinProvider, filename, desc, file::lastModified);
            this.file = file;
        }

        public File getFile() {
            return this.file;
        }

        protected InputStream getBasicInputStream() throws IOException {
            return new FileInputStream(this.file);
        }

        protected InputStream getBasicHeadInputStream(long size) throws IOException {
            return new FileInputStream(this.file);
        }
    }
}

