/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.jobsdb;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.InternalDatasetTestHandler;
import com.dataiku.dip.datasets.jobsdb.JobsdbDatasetHandler;
import com.dataiku.dip.datasets.jobsdb.JobsdbDatasetParams;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.services.ReadOnlyJobsInternalDB;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class JobsdbDatasetTestHandler
extends InternalDatasetTestHandler {
    @Autowired
    private ReadOnlyJobsInternalDB jobsDatabaseAccessService;
    private static Logger logger = Logger.getLogger((String)"dku.datasets.metrics.test");

    public JobsdbDatasetTestHandler(JobsdbDatasetHandler datasetHandler) {
        super(datasetHandler);
    }

    @Override
    protected Schema getSchema() {
        Dataset dataset = this.datasetHandler.getDataset();
        JobsdbDatasetParams params = dataset.getParamsAs(JobsdbDatasetParams.class);
        return JobsdbDatasetHandler.getSchema(params.scope, params.view);
    }

    @Override
    protected void checkAuthorization(AuthCtx auth) {
        Dataset dataset = this.datasetHandler.getDataset();
        JobsdbDatasetParams params = dataset.getParamsAs(JobsdbDatasetParams.class);
        if (!auth.isAdmin() && params.scope == JobsdbDatasetParams.RetrievalScope.INSTANCE) {
            throw new SecurityException("You may not test a metrics dataset with INSTANCE scope");
        }
    }

    @Override
    protected boolean canGetTablePreview(DatasetHandler.DatasetParams params) {
        JobsdbDatasetParams jobsDatasetParams = (JobsdbDatasetParams)params;
        return jobsDatasetParams.scope != JobsdbDatasetParams.RetrievalScope.SINGLE_OBJECT || StringUtils.isNotBlank((String)jobsDatasetParams.smartName);
    }

    @Override
    public MetricsDatasetTestResult test(AuthCtx liu) throws IOException, DKUSecurityException, CodedException {
        MetricsDatasetTestResult ret;
        block7: {
            JobsdbDatasetParams params = (JobsdbDatasetParams)this.datasetHandler.getDataset().getParams();
            ret = new MetricsDatasetTestResult();
            super.readTablePreview(liu, ret);
            if (this.canGetTablePreview(params)) {
                try {
                    if (params.scope == JobsdbDatasetParams.RetrievalScope.SINGLE_OBJECT) {
                        if (params.view == JobsdbDatasetParams.View.METRICS_HISTORY || params.view == JobsdbDatasetParams.View.METRICS_LAST) {
                            ret.knownIds = this.jobsDatabaseAccessService.getMetricIdsList(((JobsdbDatasetHandler)this.datasetHandler).resolveObjectForMetrics());
                            ret.knownDisplayNames = null;
                        }
                        if (params.view == JobsdbDatasetParams.View.CHECKS_HISTORY || params.view == JobsdbDatasetParams.View.CHECKS_LAST) {
                            Map<String, String> idsAndDisplayNames = this.jobsDatabaseAccessService.getCheckIdsAndDisplayNames(((JobsdbDatasetHandler)this.datasetHandler).resolveObjectForMetrics());
                            ret.knownIds = new ArrayList<String>();
                            ret.knownDisplayNames = new ArrayList<String>();
                            idsAndDisplayNames.forEach((id, displayName) -> {
                                ret.knownIds.add((String)id);
                                ret.knownDisplayNames.add((String)displayName);
                            });
                        }
                        break block7;
                    }
                    ret.knownIds = null;
                    ret.knownDisplayNames = null;
                }
                catch (Exception e) {
                    logger.error((Object)"Failed to list ids", (Throwable)e);
                    ret.listIdsErrorMsg = e.getMessage();
                }
            } else {
                ret.previewErrorMsg = "Please select an object to get metrics for";
            }
        }
        return ret;
    }

    public static class MetricsDatasetTestResult
    extends InternalDatasetTestHandler.InternalTestResult {
        public List<String> knownIds;
        public List<String> knownDisplayNames;
        public String listIdsErrorMsg;
    }
}

