/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.streamwrite;

import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.fs.AbstractFSDatasetHandler;
import com.dataiku.dip.datasets.sql.AbstractSQLTableDatasetHandler;
import com.dataiku.dip.datasets.streamwrite.MultiPartitionsFSBasedStreamWriter;
import com.dataiku.dip.datasets.streamwrite.MultiPartitionsSQLBasedStreamWriter;
import com.dataiku.dip.datasets.streamwrite.MultiPartitionsStreamWriter;
import com.dataiku.dip.datasets.streamwrite.SQLBasedStreamWriter;
import com.dataiku.dip.datasets.streamwrite.StreamWritableDatasetHandler;
import com.dataiku.dip.datasets.streamwrite.StreamWriter;
import com.dataiku.dip.datasets.streamwrite.UnpartitionedFSBasedStreamWriter;
import com.dataiku.dip.datasets.streamwrite.UnpartitionedSQLBasedStreamWriter;
import com.dataiku.dip.datasets.streamwrite.UnpartitionedStreamWriter;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.security.AuthCtx;

public class StreamWriterFactory {
    public static StreamWriter build(AuthCtx authCtx, DatasetHandler datasetHandler, String sourceId, int splitId) throws Exception {
        if (datasetHandler instanceof StreamWritableDatasetHandler) {
            return ((StreamWritableDatasetHandler)((Object)datasetHandler)).buildStreamOutput(sourceId, splitId);
        }
        PartitioningScheme scheme = datasetHandler.getDataset().getPartitioningSchema();
        if (scheme == null || !scheme.isPartitioned()) {
            if (StreamWriterFactory.canFSBased(datasetHandler)) {
                return new UnpartitionedFSBasedStreamWriter(authCtx, (AbstractFSDatasetHandler)datasetHandler, sourceId, splitId);
            }
            if (StreamWriterFactory.canSQLBased(datasetHandler)) {
                return new UnpartitionedSQLBasedStreamWriter(authCtx, (AbstractSQLTableDatasetHandler)datasetHandler, sourceId, splitId);
            }
            return new UnpartitionedStreamWriter(authCtx, datasetHandler, sourceId, splitId);
        }
        if (scheme.isSingleDimension() && scheme.getSingleTimeDimension() != null) {
            if (StreamWriterFactory.canFSBased(datasetHandler)) {
                return new MultiPartitionsFSBasedStreamWriter(authCtx, (AbstractFSDatasetHandler)datasetHandler, sourceId, splitId);
            }
            if (StreamWriterFactory.canSQLBased(datasetHandler)) {
                return new MultiPartitionsSQLBasedStreamWriter(authCtx, (AbstractSQLTableDatasetHandler)datasetHandler, sourceId, splitId);
            }
            return new MultiPartitionsStreamWriter(authCtx, datasetHandler, sourceId, splitId);
        }
        throw new UnsupportedOperationException("Cannot stream to dataset with discrete partition dimensions");
    }

    private static boolean canFSBased(DatasetHandler dh) {
        return dh instanceof AbstractFSDatasetHandler;
    }

    private static boolean canSQLBased(DatasetHandler dh) throws DKUSecurityException {
        return dh instanceof AbstractSQLTableDatasetHandler && SQLBasedStreamWriter.hasStreamStateWriteQuery((AbstractSQLTableDatasetHandler)dh);
    }
}

