/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.eda.compute.engine;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.eda.EdaErrorCodes;
import com.dataiku.dip.eda.compute.computations.Computation;
import com.dataiku.dip.eda.compute.engine.ComputationResultSession;
import com.dataiku.dip.eda.compute.engine.ComputationRunner;
import com.dataiku.dip.exceptions.CodedException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class LazyRunner
implements ComputationRunner {
    private Callable<ComputationRunner> builder;
    private ComputationRunner runner;
    private Future<ComputationRunner> futureRunner;
    private State state;
    private ExecutorService executor = Executors.newSingleThreadExecutor();

    public LazyRunner(Callable<ComputationRunner> builder) {
        this.builder = builder;
        this.state = State.INIT;
    }

    @Override
    public ComputationResultSession computeAndOpenSession(Computation computation) throws Exception {
        return this.getOrBuildRunner().computeAndOpenSession(computation);
    }

    @Override
    public synchronized boolean isAlive() {
        switch (this.state) {
            case INIT: 
            case BUILDING: {
                return true;
            }
            case READY: {
                return this.runner.isAlive();
            }
        }
        return false;
    }

    @Override
    public synchronized void close() throws Exception {
        switch (this.state) {
            case INIT: 
            case BUILDING: {
                this.state = State.DEAD;
                break;
            }
            case READY: {
                ComputationRunner runnerCopy = this.runner;
                this.state = State.DEAD;
                this.runner = null;
                runnerCopy.close();
                break;
            }
        }
        this.executor.shutdownNow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ComputationRunner getOrBuildRunner() throws Exception {
        LazyRunner lazyRunner = this;
        synchronized (lazyRunner) {
            if (this.state == State.INIT) {
                this.futureRunner = this.executor.submit(this.builder);
                this.state = State.BUILDING;
            } else {
                if (this.state == State.READY) {
                    return this.runner;
                }
                if (this.state == State.DEAD) {
                    throw new CodedException((InfoMessage.MessageCode)EdaErrorCodes.ERR_EDA_COMPUTE_KERNEL_FAILURE, "EDA kernel is dead");
                }
            }
        }
        try {
            ComputationRunner builtRunner = this.futureRunner.get();
            LazyRunner lazyRunner2 = this;
            synchronized (lazyRunner2) {
                if (this.state == State.BUILDING) {
                    this.state = State.READY;
                    this.runner = builtRunner;
                }
                if (this.state == State.READY) {
                    return this.runner;
                }
                throw new CodedException((InfoMessage.MessageCode)EdaErrorCodes.ERR_EDA_COMPUTE_KERNEL_FAILURE, "EDA kernel is dead");
            }
        }
        catch (InterruptedException | ExecutionException e) {
            LazyRunner lazyRunner3 = this;
            synchronized (lazyRunner3) {
                this.state = State.DEAD;
                this.runner = null;
                this.executor.shutdownNow();
            }
            throw e;
        }
    }

    public String toString() {
        return super.toString() + " with builder " + String.valueOf(this.builder) + " and runner " + String.valueOf(this.runner) + " in state " + String.valueOf((Object)this.state);
    }

    private static enum State {
        INIT,
        BUILDING,
        READY,
        DEAD;

    }
}

