/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.eda.worksheets.cards;

import com.dataiku.dip.eda.compute.computations.common.GroupedComputation;
import com.dataiku.dip.eda.compute.computations.multivariate.FetchValues;
import com.dataiku.dip.eda.compute.filtering.Filter;
import com.dataiku.dip.eda.compute.filtering.NotFilter;
import com.dataiku.dip.eda.compute.grouping.CrossGrouping;
import com.dataiku.dip.eda.compute.grouping.Grouping;
import com.dataiku.dip.eda.compute.grouping.GroupingResult;
import com.dataiku.dip.eda.compute.grouping.SubsampledGrouping;
import com.dataiku.dip.eda.compute.grouping.SubsetGrouping;
import com.dataiku.dip.eda.compute.grouping.UnionGrouping;
import com.dataiku.dip.eda.worksheets.cards.CardResult;
import com.dataiku.dip.eda.worksheets.cards.MultivariateCard;
import com.dataiku.dip.eda.worksheets.cards.common.AbstractCompiledCard;
import com.dataiku.dip.eda.worksheets.cards.common.CardWithColorBy;
import com.dataiku.dip.eda.worksheets.cards.common.CardWithHighlight;
import com.dataiku.dip.eda.worksheets.cards.common.CompiledCard;
import com.dataiku.dip.eda.worksheets.cards.common.GroupingHelpers;
import com.dataiku.dip.eda.worksheets.cards.common.Series;
import com.dataiku.dip.eda.worksheets.models.SplitBySpec;
import com.dataiku.dip.eda.worksheets.models.Variable;
import com.dataiku.dip.utils.ImmutableValueObject;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class ParallelCoordinatesPlotCard
extends MultivariateCard
implements CardWithHighlight,
CardWithColorBy {
    public static final String TYPE = "parallel_coordinates_plot";
    public int maxNumberOfPoints = 10000;
    @Nullable
    public Filter highlightFilter;
    @Nullable
    public SplitBySpec colorBy;

    public ParallelCoordinatesPlotCard(List<Variable> columns) {
        this.columns = columns;
    }

    private ParallelCoordinatesPlotCard() {
    }

    @Override
    public void setColorBy(SplitBySpec colorBy) {
        this.colorBy = colorBy;
    }

    @Override
    public void setHighlightFilter(Filter filter) {
        this.highlightFilter = filter;
    }

    @Override
    protected CompiledCard compileNoSplitNoFilter() {
        return new AbstractCompiledCard<GroupedComputation, GroupedComputation.GroupedComputationResult>(){

            @Override
            public GroupedComputation getComputationPlan() {
                Grouping highlightGrouping = ParallelCoordinatesPlotCard.this.highlightFilter == null ? SubsetGrouping.all() : new UnionGrouping(new SubsetGrouping(ParallelCoordinatesPlotCard.this.highlightFilter), new SubsetGrouping(new NotFilter(ParallelCoordinatesPlotCard.this.highlightFilter)));
                Grouping groupByGrouping = ParallelCoordinatesPlotCard.this.colorBy == null ? SubsetGrouping.all() : ParallelCoordinatesPlotCard.this.colorBy.asGrouping();
                return new GroupedComputation(new GroupedComputation(new GroupedComputation(new FetchValues(ParallelCoordinatesPlotCard.this.getColumnNames()), new CrossGrouping(highlightGrouping, groupByGrouping)), new SubsampledGrouping(ParallelCoordinatesPlotCard.this.maxNumberOfPoints)), GroupingHelpers.groupOverNotMissingNumericalColumns(ParallelCoordinatesPlotCard.this.columns));
            }

            @Override
            protected CardResult buildFromFullyAvailableResult(GroupedComputation.GroupedComputationResult result) {
                GroupedComputation.GroupedComputationResult subsetGroupResult = result.results.get(0).asGrouped();
                GroupedComputation.GroupedComputationResult subsampleGroupResult = subsetGroupResult.results.get(0).asGrouped();
                GroupingResult highlightGroups = subsampleGroupResult.groups.asCross().groups.get(0);
                GroupingResult groupByGroups = subsampleGroupResult.groups.asCross().groups.get(1);
                ParallelCoordinatesPlotCardResult cardResult = new ParallelCoordinatesPlotCardResult();
                cardResult.groups.addAll(groupByGroups.listFilters());
                for (int highlightIndex = 0; highlightIndex < highlightGroups.size(); ++highlightIndex) {
                    for (int groupIndex = 0; groupIndex < groupByGroups.size(); ++groupIndex) {
                        int computationIndex = highlightIndex * groupByGroups.size() + groupIndex;
                        FetchValues.FetchValuesResult fetchResult = subsampleGroupResult.results.get(computationIndex).as(FetchValues.FetchValuesResult.class);
                        ParallelCoordinates coordinates = new ParallelCoordinates();
                        coordinates.groupIndex = groupIndex;
                        coordinates.isHighlighted = highlightGroups.size() > 1 && highlightIndex == 0;
                        coordinates.columnSeries = fetchResult.series.stream().map(Series::new).collect(Collectors.toList());
                        cardResult.parallelCoordinates.add(coordinates);
                    }
                }
                return cardResult;
            }
        };
    }

    public static class ParallelCoordinatesPlotCardResult
    extends CardResult {
        List<Filter> groups = new ArrayList<Filter>();
        List<ParallelCoordinates> parallelCoordinates = new ArrayList<ParallelCoordinates>();
    }

    public static class ParallelCoordinates
    extends ImmutableValueObject {
        public boolean isHighlighted;
        public int groupIndex;
        public List<Series> columnSeries;
    }
}

