/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.eda.worksheets.cards.univariate_header;

import com.dataiku.dip.eda.compute.computations.Computation;
import com.dataiku.dip.eda.compute.computations.common.DummyComputation;
import com.dataiku.dip.eda.compute.computations.common.MultiComputation;
import com.dataiku.dip.eda.compute.filtering.Filter;
import com.dataiku.dip.eda.worksheets.cards.CardResult;
import com.dataiku.dip.eda.worksheets.cards.UnivariateCard;
import com.dataiku.dip.eda.worksheets.cards.common.AbstractCompiledCard;
import com.dataiku.dip.eda.worksheets.cards.common.CardWithHighlight;
import com.dataiku.dip.eda.worksheets.cards.common.CompiledCard;
import com.dataiku.dip.eda.worksheets.cards.fragments.BoxPlotFragment;
import com.dataiku.dip.eda.worksheets.cards.fragments.NumericalHistogramFragment;
import com.dataiku.dip.eda.worksheets.models.BinningMode;
import com.dataiku.dip.utils.JSON;
import javax.annotation.Nullable;

public class NumericalHistogramCard
extends UnivariateCard
implements CardWithHighlight {
    public static final String TYPE = "numerical_histogram";
    boolean showBoxPlot = true;
    boolean showHistogram = true;
    @Nullable
    Filter highlightFilter;
    BinningMode binningMode = BinningMode.AUTO;
    int nbBins = 25;
    double[] customBinningBoundaries = new double[0];

    @Override
    public void setHighlightFilter(Filter filter) {
        this.highlightFilter = filter;
    }

    public boolean isBoxPlotOnly() {
        return !this.showHistogram && this.showBoxPlot;
    }

    public NumericalHistogramCard withShowBoxPlot(boolean showBoxplot) {
        if (this.showBoxPlot == showBoxplot) {
            return this;
        }
        NumericalHistogramCard copy = (NumericalHistogramCard)JSON.deepCopy((Object)this);
        copy.showBoxPlot = showBoxplot;
        return copy;
    }

    public NumericalHistogramCard withShowHistogram(boolean showHistogram) {
        if (this.showHistogram == showHistogram) {
            return this;
        }
        NumericalHistogramCard copy = (NumericalHistogramCard)JSON.deepCopy((Object)this);
        copy.showHistogram = showHistogram;
        return copy;
    }

    @Override
    protected CompiledCard compileNoSplitNoFilter() {
        return new AbstractCompiledCard<MultiComputation, MultiComputation.MultiComputationResult>(){

            @Override
            public MultiComputation getComputationPlan() {
                Computation boxPlotComputation = new DummyComputation();
                if (NumericalHistogramCard.this.showBoxPlot) {
                    boxPlotComputation = BoxPlotFragment.getComputationPlan(NumericalHistogramCard.this.column.name);
                }
                Computation histogram = new DummyComputation();
                if (NumericalHistogramCard.this.showHistogram) {
                    histogram = NumericalHistogramFragment.getPlan(NumericalHistogramCard.this.column, NumericalHistogramCard.this.binningMode, NumericalHistogramCard.this.nbBins, NumericalHistogramCard.this.customBinningBoundaries, NumericalHistogramCard.this.highlightFilter);
                }
                return new MultiComputation(boxPlotComputation, histogram);
            }

            @Override
            protected CardResult buildFromFullyAvailableResult(MultiComputation.MultiComputationResult result) {
                BoxPlotFragment boxPlot = null;
                if (NumericalHistogramCard.this.showBoxPlot) {
                    boxPlot = BoxPlotFragment.build(result.get(0));
                }
                NumericalHistogramFragment histogram = null;
                if (NumericalHistogramCard.this.showHistogram) {
                    histogram = NumericalHistogramFragment.buildResult(result.get(1));
                }
                return new NumericalHistogramCardResult(histogram, boxPlot);
            }
        };
    }

    public static class NumericalHistogramCardResult
    extends CardResult {
        @Nullable
        public NumericalHistogramFragment histogram;
        @Nullable
        public BoxPlotFragment boxPlot;

        public NumericalHistogramCardResult(NumericalHistogramFragment histogram, BoxPlotFragment boxPlot) {
            this.histogram = histogram;
            this.boxPlot = boxPlot;
        }

        private NumericalHistogramCardResult() {
        }
    }
}

