/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.eda.worksheets.queries;

import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.eda.EdaErrorCodes;
import com.dataiku.dip.eda.compute.computations.ComputationResult;
import com.dataiku.dip.eda.compute.computations.common.GroupedComputation;
import com.dataiku.dip.eda.compute.computations.univariate.MatchTimeStep;
import com.dataiku.dip.eda.compute.engine.ComputationRunner;
import com.dataiku.dip.eda.worksheets.cards.TimeSeriesCard;
import com.dataiku.dip.eda.worksheets.queries.InteractiveQuery;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;

public class CheckTimeStepRegularity
extends InteractiveQuery {
    public static final String TYPE = "check_time_step_regularity";
    public String column;
    public List<TimeSeriesCard.TimeSeriesIdentifier> seriesIdentifiers = Collections.emptyList();

    @Override
    public CheckTimeStepRegularityResult run(Schema schema, ComputationRunner runner) throws Exception {
        GroupedComputation computation = new GroupedComputation(new GroupedComputation(new MatchTimeStep(this.column), TimeSeriesCard.getSeriesIdGrouping(this.seriesIdentifiers)), TimeSeriesCard.getSeriesIdValuesSubset(this.seriesIdentifiers));
        ComputationResult result = runner.compute(computation);
        CheckTimeStepRegularityResult queryResult = new CheckTimeStepRegularityResult();
        if (result.isAtLeastPartiallyFailed()) {
            queryResult.error_code = result.getFirstFailedResult().code;
            queryResult.error_message = result.getFirstFailedResult().message;
        }
        queryResult.warnings = new ArrayList<String>(new HashSet<String>(result.collectWarnings()));
        GroupedComputation.GroupedComputationResult subsetResult = result.asGrouped();
        GroupedComputation.GroupedComputationResult bySeries = subsetResult.results.get(0).asGrouped();
        if (!this.seriesIdentifiers.isEmpty() && bySeries.results.isEmpty()) {
            queryResult.error_code = EdaErrorCodes.ERR_EDA_COMPUTE_NO_DATA;
            queryResult.error_message = "The intersect of the series identifiers is empty. Consider updating the series identifier configuration to allow more values.";
        }
        return queryResult;
    }

    public static class CheckTimeStepRegularityResult
    extends InteractiveQuery.InteractiveQueryResult {
        List<String> warnings;
        @Nullable
        EdaErrorCodes error_code;
        @Nullable
        String error_message;
    }
}

