/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.exposition;

import com.dataiku.dip.autoconfig.ParamDesc;
import com.dataiku.dip.containers.exec.ContainerExecRuntimeConfig;
import com.dataiku.dip.containers.exec.KubernetesExecUtils;
import com.dataiku.dip.coremodel.DkuComponentMetadata;
import com.dataiku.dip.exposition.AbstractIngressExposition;
import com.dataiku.dip.exposition.Exposables;
import com.dataiku.dip.exposition.ExposedEndpointConsumer;
import com.dataiku.dip.exposition.Exposition;
import com.dataiku.dip.exposition.ExpositionDesc;
import com.dataiku.dip.exposition.ExpositionHandler;
import com.dataiku.dip.exposition.ExpositionMeta;
import com.dataiku.dip.exposition.ExpositionParams;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.variables.VariablesContext;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class IngressExposition {
    public static final ExpositionMeta META = new ExpositionMeta(){

        @Override
        public String getType() {
            return "ingress";
        }

        @Override
        public Class<? extends ExpositionParams> getParamsClass() {
            return IngressExpositionParams.class;
        }

        @Override
        public ExpositionDesc getDesc(ExpositionMeta.ExpositionUsageContext usageContext) {
            ExpositionDesc desc = AbstractIngressExposition.getDesc();
            ParamDesc servicePath = new ParamDesc();
            servicePath.type = ParamDesc.Type.STRING;
            servicePath.name = "servicePath";
            servicePath.label = "Service path";
            servicePath.description = "URL subpath for the service, to discriminate between services exposed on the ingress. If empty, only one service can be used on the ingress.";
            ParamDesc port = AbstractIngressExposition.getPortParamDesc();
            ParamDesc scheme = AbstractIngressExposition.getSchemeParamDesc();
            ParamDesc forcedUrl = AbstractIngressExposition.getForcedUrlParamDesc();
            ParamDesc extraHosts = AbstractIngressExposition.getExtraHostsParamDesc();
            ParamDesc hostForDSS = AbstractIngressExposition.getHostForDSS();
            return desc.withType(this.getType()).withMeta(new DkuComponentMetadata("Ingress", "Ingress on a NodePort service", null, null)).withParam(1.getIngressClassNameParamDesc()).withParam(servicePath).withParam(scheme).withParam(port).withParam(forcedUrl).withParam(extraHosts).withParam(hostForDSS);
        }

        @Override
        public ExpositionHandler buildHandler(AuthCtx authCtx, String projectKey, ContainerExecRuntimeConfig containerConfig, Exposition exposition, ExposedEndpointConsumer endpointConsumer) {
            IngressExpositionParams params = exposition.getParamsAs(IngressExpositionParams.class);
            return new IngressExpositionHandler(authCtx, projectKey, containerConfig, params, endpointConsumer);
        }

        @Override
        public long getMaxStartWait(AuthCtx authCtx) {
            return 600000L;
        }

        @Override
        public boolean handles(ContainerExecRuntimeConfig containerConfig) {
            return containerConfig.type == ContainerExecRuntimeConfig.Container.KUBERNETES;
        }

        @Override
        public boolean handles(ContainerExecRuntimeConfig.Container containerType) {
            return containerType == ContainerExecRuntimeConfig.Container.KUBERNETES;
        }

        @Override
        public boolean handles(Exposables.ExposableKind kind) {
            return kind == Exposables.ExposableKind.WEBAPP || kind == Exposables.ExposableKind.API_DEPLOYER;
        }

        @Override
        public void expandParametersInPlace(VariablesContext vc, Exposition exposition) {
            IngressExpositionParams params = exposition.getParamsAs(IngressExpositionParams.class);
            params.expandParametersInPlace(vc);
            if (StringUtils.isNotBlank((String)params.servicePath)) {
                params.servicePath = vc.expandAllowUnresolved(params.servicePath);
            }
        }

        public static ParamDesc getIngressClassNameParamDesc() {
            ParamDesc ingressClassName = new ParamDesc();
            ingressClassName.type = ParamDesc.Type.STRING;
            ingressClassName.name = "ingressClassName";
            ingressClassName.label = "Ingress class name";
            ingressClassName.description = "Use this parameter to select an ingress with ingressClassName rather than with the kubernetes.io/ingress.class annotation";
            return ingressClassName;
        }
    };

    private static class IngressExpositionHandler
    extends AbstractIngressExposition.AbstractIngressExpositionHandler<IngressExpositionParams> {
        IngressExpositionHandler(AuthCtx authCtx, String projectKey, ContainerExecRuntimeConfig containerConfig, IngressExpositionParams params, ExposedEndpointConsumer endpointConsumer) {
            super(authCtx, projectKey, containerConfig, params, endpointConsumer);
        }

        @Override
        protected String expositionType() {
            return META.getType();
        }

        @Override
        protected List<String> getExtra(Map<String, String> serviceAnnotations, Map<String, String> ingressAnnotations) {
            return null;
        }

        @Override
        protected String getIngressClassNameSpec() {
            if (StringUtils.isNotBlank((String)((IngressExpositionParams)this.params).ingressClassName)) {
                return "ingressClassName: " + ((IngressExpositionParams)this.params).ingressClassName;
            }
            return null;
        }

        @Override
        protected String getServicePath() {
            Object servicePath = StringUtils.defaultIfBlank((String)((IngressExpositionParams)this.params).servicePath, (String)"");
            if (!((String)servicePath).startsWith("/")) {
                servicePath = "/" + (String)servicePath;
            }
            if (!((String)servicePath).endsWith("/") && !((String)servicePath).endsWith("*")) {
                servicePath = (String)servicePath + "/";
            }
            return servicePath;
        }

        @Override
        protected String getPublicServicePath() {
            String servicePath = StringUtils.defaultIfBlank((String)((IngressExpositionParams)this.params).servicePath, (String)"");
            if (servicePath.endsWith("*")) {
                servicePath = servicePath.substring(0, servicePath.length() - 1);
            }
            if (servicePath.startsWith("/")) {
                servicePath = servicePath.substring(1);
            }
            if (servicePath.endsWith("/")) {
                servicePath = servicePath.substring(0, servicePath.length() - 1);
            }
            return servicePath;
        }

        @Override
        protected List<String> getIngressTLS(List<KubernetesExecUtils.IngressTLS> tls) throws IOException {
            return null;
        }
    }

    public static class IngressExpositionParams
    extends AbstractIngressExposition.AbstractIngressExpositionParams {
        public String servicePath = null;
        public String ingressClassName;
    }
}

